/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI.Code;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.RepairRule;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.CachedInstanceCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.FactoryCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.GlobalCenter;
import games.strategy.triplea.ai.Dynamix_AI.DMatches;
import games.strategy.triplea.ai.Dynamix_AI.DSettings;
import games.strategy.triplea.ai.Dynamix_AI.DSorting;
import games.strategy.triplea.ai.Dynamix_AI.DUtils;
import games.strategy.triplea.ai.Dynamix_AI.Dynamix_AI;
import games.strategy.triplea.ai.Dynamix_AI.Group.PurchaseGroup;
import games.strategy.triplea.ai.Dynamix_AI.Others.NCM_TargetCalculator;
import games.strategy.triplea.ai.Dynamix_AI.Others.NCM_Task;
import games.strategy.triplea.ai.Dynamix_AI.Others.Purchase_UnitPlacementLocationSorter;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.remote.IPurchaseDelegate;
import games.strategy.triplea.oddsCalculator.ta.AggregateResults;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.SwingUtilities;

public class Purchase {
    public static void purchase(Dynamix_AI ai, boolean purchaseForBid, int PUsToSpend, IPurchaseDelegate purchaser, GameData data, PlayerID player) {
        if (DSettings.LoadSettings().AIC_disableAllUnitPurchasesAndPlacements) {
            final String message = ai.getName() + " is skipping it's purchase phase, as instructed.";
            DUtils.Log(Level.FINE, message, new Object[0]);
            Runnable runner = new Runnable(){

                public void run() {
                    CachedInstanceCenter.CachedDelegateBridge.getHistoryWriter().startEvent(message);
                }
            };
            try {
                SwingUtilities.invokeAndWait(runner);
            }
            catch (InterruptedException ex) {
            }
            catch (InvocationTargetException ex) {
                // empty catch block
            }
            Dynamix_AI.Pause();
            return;
        }
        if (!purchaseForBid && DSettings.LoadSettings().EnableResourceCollectionMultiplier && DSettings.LoadSettings().ResourceCollectionMultiplyPercent != 100) {
            int PUsCollectedLastTurn;
            int PUChange;
            if (GlobalCenter.PUsAtEndOfLastTurn == 0) {
                GlobalCenter.PUsAtEndOfLastTurn = DUtils.GetTotalProductionOfTerritoriesInList(DUtils.ToList(data.getMap().getTerritoriesOwnedBy(player)));
            }
            if ((PUChange = (int)((float)(PUsCollectedLastTurn = player.getResources().getQuantity(GlobalCenter.GetPUResource()) - GlobalCenter.PUsAtEndOfLastTurn) * DUtils.ToFloat(DSettings.LoadSettings().ResourceCollectionMultiplyPercent)) - PUsCollectedLastTurn) > 0) {
                int newPUs = player.getResources().getQuantity(GlobalCenter.GetPUResource()) + PUChange;
                final String message = ai.getName() + " use an RCM cheat, and increase their PUs from " + player.getResources().getQuantity(GlobalCenter.GetPUResource()) + " to " + newPUs;
                DUtils.Log(Level.FINE, message, new Object[0]);
                Runnable runner = new Runnable(){

                    public void run() {
                        CachedInstanceCenter.CachedDelegateBridge.getHistoryWriter().startEvent(message);
                    }
                };
                try {
                    SwingUtilities.invokeAndWait(runner);
                }
                catch (InterruptedException ex) {
                }
                catch (InvocationTargetException ex) {
                    // empty catch block
                }
                Change change = ChangeFactory.changeResourcesChange(player, GlobalCenter.GetPUResource(), PUChange);
                CachedInstanceCenter.CachedDelegateBridge.addChange(change);
                PUsToSpend = newPUs;
                Dynamix_AI.Pause();
            }
        }
        if (!ai.canWePurchaseOrRepair(purchaseForBid)) {
            return;
        }
        if (purchaseForBid) {
            if (DUtils.CanPlayerPlaceAnywhere(data, player) && PUsToSpend == 0) {
                DUtils.Log(Level.FINE, "  On this map, 'Place-Anywhere' countries can't get bid's, so skipping phase.", new Object[0]);
                return;
            }
            DUtils.Log(Level.FINE, "  Purchasing bid factory repairs.", new Object[0]);
            PUsToSpend -= Purchase.purchaseFactoryRepairs(ai, purchaseForBid, PUsToSpend, purchaser, data, player);
            Territory ourCap = TerritoryAttachment.getCapital(player, data);
            if (DMatches.territoryIsNotIsolated(data).match(ourCap)) {
                FactoryCenter.get((GameData)data, (PlayerID)player).ChosenFactoryTerritories.add(ourCap);
                DUtils.Log(Level.FINE, "  Purchasing bid units and going to place them all on: {0}", ourCap);
                int cost = Purchase.purchaseFactoryUnits(ourCap, ai, purchaseForBid, PUsToSpend, purchaser, data, player);
                if (cost != 0) {
                    PUsToSpend -= cost;
                }
                Dynamix_AI.Pause();
            } else {
                Iterator<Territory> i$ = Match.getMatches(data.getMap().getTerritories(), DMatches.territoryIsNotIsolated(data)).iterator();
                if (i$.hasNext()) {
                    Territory ter = i$.next();
                    FactoryCenter.get((GameData)data, (PlayerID)player).ChosenFactoryTerritories.add(ter);
                    DUtils.Log(Level.FINE, "  Purchasing bid units and going to place them all on: {0}", ter);
                    int cost = Purchase.purchaseFactoryUnits(ter, ai, purchaseForBid, PUsToSpend, purchaser, data, player);
                    if (cost != 0) {
                        PUsToSpend -= cost;
                    }
                    Dynamix_AI.Pause();
                }
            }
        } else {
            Territory factoryTer;
            int cost;
            if (DUtils.CanPlayerPlaceAnywhere(data, player) && PUsToSpend == 0) {
                DUtils.Log(Level.FINE, "  On this map, 'Place-Anywhere' countries can't purchase their units(engine does it for them), so skipping phase.", new Object[0]);
                return;
            }
            int origR = player.getResources().getQuantity(data.getResourceList().getResource("PUs"));
            Purchase.calculateFactoriesToBuildOn(ai, purchaseForBid, data, player);
            DUtils.Log(Level.FINE, "  Factories to build on calculated. Ters with the factories: {0}", FactoryCenter.get((GameData)data, (PlayerID)player).ChosenFactoryTerritories);
            PUsToSpend -= Purchase.purchaseFactoryRepairs(ai, purchaseForBid, PUsToSpend, purchaser, data, player);
            DUtils.Log(Level.FINE, "  Beginning purchases for factories phase.", new Object[0]);
            Iterator<Territory> i$ = FactoryCenter.get((GameData)data, (PlayerID)player).ChosenFactoryTerritories.iterator();
            while (i$.hasNext() && (cost = Purchase.purchaseFactoryUnits(factoryTer = i$.next(), ai, purchaseForBid, PUsToSpend, purchaser, data, player)) != 0) {
                PUsToSpend -= cost;
                Dynamix_AI.Pause();
            }
            float percentageOfInitialPUsNeededForFactoryPurchase = DUtils.ToFloat(DSettings.LoadSettings().AA_resourcePercentageThatMustExistForFactoryBuy);
            if (PUsToSpend > (int)((float)origR * percentageOfInitialPUsNeededForFactoryPurchase)) {
                DUtils.Log(Level.FINE, "  We used less than " + DSettings.LoadSettings().AA_resourcePercentageThatMustExistForFactoryBuy + "% our money in purchases, so attempting to purchase a new factory.", new Object[0]);
                Unit factory = null;
                int factoryCost = 0;
                for (ProductionRule rule : player.getProductionFrontier().getRules()) {
                    if (!UnitAttachment.get((UnitType)rule.getResults().keySet().toArray()[0]).getIsFactory()) continue;
                    factory = ((UnitType)rule.getResults().keySet().toArray()[0]).create(player);
                    factoryCost = rule.getCosts().getInt(data.getResourceList().getResource("PUs"));
                    break;
                }
                if (factory != null && factoryCost <= PUsToSpend) {
                    boolean foundSafeBuildTer = false;
                    for (Territory ter : data.getMap().getTerritoriesOwnedBy(player)) {
                        ArrayList<Unit> defenders;
                        List<Unit> attackers;
                        AggregateResults results;
                        if (ter.isWater() || ter.getUnits().someMatch(Matches.UnitIsFactory) || !((results = DUtils.GetBattleResults(attackers = DUtils.GetSPNNEnemyWithLUnitsThatCanReach(data, ter, player, Matches.TerritoryIsLandOrWater), defenders = new ArrayList<Unit>(ter.getUnits().getUnits()), ter, data, 250, true)).getAttackerWinPercent() < (double)0.1f) && !attackers.isEmpty()) continue;
                        foundSafeBuildTer = true;
                    }
                    if (foundSafeBuildTer) {
                        PurchaseGroup factoryPG = new PurchaseGroup(factory, purchaser, data, player);
                        factoryPG.Purchase();
                        FactoryCenter.get((GameData)data, (PlayerID)player).FactoryPurchaseGroups.add(factoryPG);
                        Dynamix_AI.Pause();
                        DUtils.Log(Level.FINE, "    Factory purchased, location not yet determined.", new Object[0]);
                    }
                }
            }
        }
    }

    public static int purchaseFactoryRepairs(Dynamix_AI ai, boolean purchaseForBid, int PUsToSpend, IPurchaseDelegate purchaser, GameData data, PlayerID player) {
        int origPUs = PUsToSpend;
        if (player.getRepairFrontier() != null) {
            Territory ourCap = TerritoryAttachment.getCapital(player, data);
            List<Territory> ourTers = new ArrayList<Territory>(data.getMap().getTerritoriesOwnedBy(player));
            ourTers = DSorting.SortTerritoriesByLandThenNoCondDistance_A(ourTers, data, ourCap);
            List<RepairRule> rrules = player.getRepairFrontier().getRules();
            HashMap<Unit, IntegerMap<RepairRule>> factoryRepairs = new HashMap<Unit, IntegerMap<RepairRule>>();
            int totalRepairCosts = 0;
            boolean madeRepairs = false;
            int maxPUsWeWantToSpendOnRepairs = origPUs / 2;
            boolean bombingDoneOnTerritories = Properties.getSBRAffectsUnitProduction(data);
            boolean bombingDoneOnUnitsDirectly = Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(data);
            for (RepairRule rrule : rrules) {
                for (Territory fixTerr : ourTers) {
                    if (!Matches.territoryHasOwnedFactory(data, player).match(fixTerr)) continue;
                    TerritoryAttachment ta = TerritoryAttachment.get(fixTerr);
                    if (bombingDoneOnTerritories) {
                        int repairAmount = ta.getProduction() - ta.getUnitProduction();
                        repairAmount = Math.min(repairAmount, origPUs / 4);
                        repairAmount = Math.min(repairAmount, maxPUsWeWantToSpendOnRepairs - totalRepairCosts);
                        if ((repairAmount = Math.min(repairAmount, PUsToSpend)) <= 0) continue;
                        DUtils.Log(Level.FINER, "    Purchasing repairs for a territory. Territory: {0} Repair Amount: {1}", fixTerr.getName(), repairAmount);
                        IntegerMap<RepairRule> repairMap = new IntegerMap<RepairRule>();
                        repairMap.add(rrule, repairAmount);
                        factoryRepairs.put(Match.getMatches(fixTerr.getUnits().getUnits(), Matches.UnitIsFactoryOrCanBeDamaged).iterator().next(), repairMap);
                        madeRepairs = true;
                        PUsToSpend -= repairAmount;
                        totalRepairCosts += repairAmount;
                        continue;
                    }
                    if (!bombingDoneOnUnitsDirectly) continue;
                    for (Unit unitToFix : Match.getMatches(fixTerr.getUnits().getUnits(), Matches.UnitIsFactoryOrCanBeDamaged)) {
                        if (unitToFix == null || !unitToFix.getType().equals(rrule.getResults().keySet().iterator().next())) continue;
                        int repairAmount = TripleAUnit.getHowMuchCanUnitProduce(unitToFix, fixTerr, player, data, false, false) - TripleAUnit.getHowMuchCanUnitProduce(unitToFix, fixTerr, player, data, true, false);
                        repairAmount = Math.min(repairAmount, origPUs / 4);
                        repairAmount = Math.min(repairAmount, maxPUsWeWantToSpendOnRepairs - totalRepairCosts);
                        if ((repairAmount = Math.min(repairAmount, PUsToSpend)) <= 0) continue;
                        DUtils.Log(Level.FINER, "    Purchasing repairs for a unit. Territory: {0} Unit: {1} Repair Amount: {2}", fixTerr.getName(), unitToFix, repairAmount);
                        IntegerMap<RepairRule> repairMap = new IntegerMap<RepairRule>();
                        repairMap.add(rrule, repairAmount);
                        factoryRepairs.put(unitToFix, repairMap);
                        madeRepairs = true;
                        PUsToSpend -= repairAmount;
                        totalRepairCosts += repairAmount;
                    }
                }
            }
            if (madeRepairs) {
                purchaser.purchaseRepair(factoryRepairs);
                Dynamix_AI.Pause();
                return totalRepairCosts;
            }
        }
        return 0;
    }

    public static void calculateFactoriesToBuildOn(Dynamix_AI ai, boolean purchaseForBid, GameData data, PlayerID player) {
        List<Territory> sortedLocations = Purchase_UnitPlacementLocationSorter.CalculateAndSortUnitPlacementLocations(ai, purchaseForBid, data, player);
        FactoryCenter.get((GameData)data, (PlayerID)player).ChosenFactoryTerritories = sortedLocations;
    }

    public static int purchaseFactoryUnits(Territory ter, Dynamix_AI ai, boolean purchaseForBid, int PUsToSpend, IPurchaseDelegate purchaser, GameData data, PlayerID player) {
        PurchaseGroup bestPurchaseGroup;
        DUtils.Log(Level.FINER, "    Purchasing units for territory. Ter: {0}", ter);
        int result = 0;
        if (!ter.isWater() && ter.getOwner().getName().equals(player.getName()) && ter.getUnits().someMatch(Matches.UnitIsFactory) && !ter.getUnits().someMatch(Matches.UnitIsAAforBombingThisUnitOnly) && TerritoryAttachment.get(ter) != null && DUtils.GetCheckedUnitProduction(ter) > 0) {
            PurchaseGroup aaPG;
            int cost;
            Unit aa = null;
            for (ProductionRule rule : player.getProductionFrontier().getRules()) {
                if (!Matches.UnitTypeIsAAforBombingThisUnitOnly.match((UnitType)rule.getResults().keySet().toArray()[0])) continue;
                aa = ((UnitType)rule.getResults().keySet().toArray()[0]).create(player);
                break;
            }
            if (aa != null && (cost = (aaPG = new PurchaseGroup(aa, purchaser, data, player)).GetCost()) > 0 && PUsToSpend - cost >= 0) {
                aaPG.Purchase();
                result += cost;
                PUsToSpend -= cost;
                FactoryCenter.get((GameData)data, (PlayerID)player).ChosenAAPlaceTerritories.add(ter);
            }
        }
        if ((bestPurchaseGroup = Purchase.CalculateBestPurchaseGroup(ter, data, player, purchaser, PUsToSpend, purchaseForBid)) == null) {
            return result;
        }
        int testCost = bestPurchaseGroup.GetCost();
        if (testCost < 1) {
            return result;
        }
        int maxPurchaseCost = PUsToSpend;
        int maxPurchaseCount = DUtils.GetCheckedUnitProduction(ter);
        if (FactoryCenter.get((GameData)data, (PlayerID)player).ChosenAAPlaceTerritories.contains(ter)) {
            --maxPurchaseCount;
        }
        if (purchaseForBid) {
            maxPurchaseCount = Integer.MAX_VALUE;
        }
        if (DUtils.CanPlayerPlaceAnywhere(data, player)) {
            maxPurchaseCount = Integer.MAX_VALUE;
        }
        bestPurchaseGroup.ApplyMaxValues(maxPurchaseCost, maxPurchaseCount);
        int cost = bestPurchaseGroup.GetCost();
        if (PUsToSpend - cost >= 0) {
            bestPurchaseGroup.Purchase();
            FactoryCenter.get((GameData)data, (PlayerID)player).TurnTerritoryPurchaseGroups.put(ter, bestPurchaseGroup);
            result += cost;
        }
        return result;
    }

    private static PurchaseGroup CalculateBestPurchaseGroup(Territory ter, GameData data, PlayerID player, IPurchaseDelegate purchaser, float PUsLeftToSpend, boolean purchaseForBid) {
        Unit unit;
        Territory ncmTarget = NCM_TargetCalculator.CalculateNCMTargetForTerritory(data, player, ter, DUtils.ToList(ter.getUnits().getUnits()), new ArrayList<NCM_Task>());
        if (ncmTarget == null) {
            if (data.getMap().getNeighbors(ter, DUtils.CompMatchAnd(Matches.TerritoryIsWater, Matches.territoryHasUnitsThatMatch(Matches.unitIsEnemyOf(data, player)).invert())).size() > 0) {
                return new PurchaseGroup(Collections.singleton(DUtils.GetRandomUnitForPlayerMatching(player, DUtils.CompMatchAnd(Matches.UnitIsNotAA, Matches.UnitIsFactoryOrIsInfrastructure.invert(), Matches.UnitHasMaxBuildRestrictions.invert()))), purchaser, data, player);
            }
            return new PurchaseGroup(Collections.singleton(DUtils.GetRandomUnitForPlayerMatching(player, DUtils.CompMatchAnd(Matches.UnitIsLand, Matches.UnitIsNotAA, Matches.UnitIsFactoryOrIsInfrastructure.invert(), Matches.UnitHasMaxBuildRestrictions.invert()))), purchaser, data, player);
        }
        Integer productionSpaceLeft = DUtils.GetCheckedUnitProduction(ter);
        if (FactoryCenter.get((GameData)data, (PlayerID)player).ChosenAAPlaceTerritories.contains(ter)) {
            Integer n = productionSpaceLeft;
            Integer n2 = productionSpaceLeft = Integer.valueOf(productionSpaceLeft - 1);
        }
        if (purchaseForBid) {
            productionSpaceLeft = Integer.MAX_VALUE;
        }
        if (DUtils.CanPlayerPlaceAnywhere(data, player)) {
            productionSpaceLeft = Integer.MAX_VALUE;
        }
        if (productionSpaceLeft <= 0) {
            return null;
        }
        HashSet<Unit> unitsOnTheWay = new HashSet<Unit>();
        List<Route> routes = DUtils.GetXClosestSimiliarLengthLandRoutesBetweenTers(data, 5, ter, ncmTarget);
        for (Route route : routes) {
            for (Territory rTer : route.getTerritories()) {
                List<Unit> ourUnits = Match.getMatches(rTer.getUnits().getUnits(), Matches.unitIsOwnedBy(player));
                unitsOnTheWay.addAll(ourUnits);
            }
        }
        ArrayList<Unit> allUnits = new ArrayList<Unit>();
        List<ProductionRule> rules = player.getProductionFrontier().getRules();
        for (ProductionRule rule : rules) {
            UnitType ut = (UnitType)rule.getResults().keySet().toArray()[0];
            unit = ut.create(player);
            allUnits.add(unit);
        }
        ArrayList<Unit> defendUnits = new ArrayList<Unit>(ncmTarget.getUnits().getUnits());
        ArrayList<Unit> unitsToBuy = new ArrayList<Unit>();
        for (int i = 0; i < Math.min(productionSpaceLeft, DSettings.LoadSettings().AA_maxUnitTypesForPurchaseMix); ++i) {
            unit = DUtils.CalculateUnitThatWillHelpWinAttackOnArmyTheMostPerPU(ncmTarget, data, player, unitsOnTheWay, allUnits, defendUnits, Matches.UnitHasEnoughMovement(1), DSettings.LoadSettings().CA_Purchase_determinesUnitThatWouldHelpTargetInvasionMost);
            if (unit == null) {
                DUtils.Log(Level.FINER, "        No units found to select for purchasing!", new Object[0]);
                return null;
            }
            int cost = DUtils.GetTUVOfUnit(unit = unit.getType().create(player), GlobalCenter.GetPUResource());
            if (PUsLeftToSpend - (float)cost < 0.0f) break;
            PUsLeftToSpend -= (float)cost;
            if (unit == null) {
                --i;
                continue;
            }
            unitsToBuy.add(unit);
            unitsOnTheWay.add(unit);
            if (unitsToBuy.size() >= productionSpaceLeft || DSettings.LoadSettings().AllowCalcingDecrease && Dynamix_AI.GetTimeTillNextScheduledActionDisplay() == 0L) break;
        }
        if (unitsToBuy.isEmpty()) {
            return null;
        }
        return new PurchaseGroup(unitsToBuy, purchaser, data, player);
    }
}

