/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.Properties;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.GlobalCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.StatusCenter;
import games.strategy.triplea.ai.Dynamix_AI.DUtils;
import games.strategy.triplea.ai.Dynamix_AI.Group.UnitGroup;
import games.strategy.triplea.ai.Dynamix_AI.Others.TerritoryStatus;
import games.strategy.triplea.attatchments.RulesAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.Match;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DMatches {
    public static final Match<UnitGroup> UnitGroupIsSeaOrAir = new Match<UnitGroup>(){

        @Override
        public boolean match(UnitGroup unitGroup) {
            UnitAttachment ua = UnitAttachment.get(unitGroup.GetFirstUnit().getType());
            return ua.getIsSea() || ua.getIsAir();
        }
    };
    public static final Match<UnitGroup> UnitGroupIsLand = new Match<UnitGroup>(){

        @Override
        public boolean match(UnitGroup unitGroup) {
            UnitAttachment ua = UnitAttachment.get(unitGroup.GetFirstUnit().getType());
            return !ua.getIsSea();
        }
    };
    public static final Match<Unit> UnitIsMoveableType = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            UnitAttachment ua = UnitAttachment.get(unit.getUnitType());
            return ua.getMovement(unit.getOwner()) > 0;
        }
    };
    public static Match<Unit> UnitIsCombatMoveMoveableType = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            UnitAttachment ua = UnitAttachment.get(unit.getUnitType());
            return ua.getMovement(unit.getOwner()) > 0 && !ua.getCanNotMoveDuringCombatMove();
        }
    };
    public static final Match<Unit> UnitCanAttack = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            UnitAttachment ua = UnitAttachment.get(unit.getUnitType());
            return !ua.getIsFactory();
        }
    };
    public static final Match<Unit> UnitCanDefend = new Match<Unit>(){

        @Override
        public boolean match(Unit unit) {
            UnitAttachment ua = UnitAttachment.get(unit.getUnitType());
            return !ua.getIsFactory();
        }
    };
    public static final Match<Territory> TerritoryIsLandAndPassable = new CompositeMatchAnd<Territory>(Matches.TerritoryIsLand, Matches.TerritoryIsNotImpassable);
    public static final Match<Territory> territoryIsCapital = new Match<Territory>(){

        @Override
        public boolean match(Territory ter) {
            TerritoryAttachment ta = TerritoryAttachment.get(ter);
            return ta != null && ta.isCapital();
        }
    };
    public static final Match<TerritoryStatus> TS_WasAttacked = new Match<TerritoryStatus>(){

        @Override
        public boolean match(TerritoryStatus ts) {
            return ts.WasAttacked();
        }
    };
    public static final Match<TerritoryStatus> TS_WasAttacked_LandGrab = new Match<TerritoryStatus>(){

        @Override
        public boolean match(TerritoryStatus ts) {
            return ts.WasAttacked_LandGrab;
        }
    };
    public static final Match<TerritoryStatus> TS_WasAttacked_Stabalize = new Match<TerritoryStatus>(){

        @Override
        public boolean match(TerritoryStatus ts) {
            return ts.WasAttacked_Stabalize;
        }
    };
    public static final Match<TerritoryStatus> TS_WasAttacked_Offensive = new Match<TerritoryStatus>(){

        @Override
        public boolean match(TerritoryStatus ts) {
            return ts.WasAttacked_Offensive;
        }
    };
    public static final Match<TerritoryStatus> TS_WasAttacked_Trade = new Match<TerritoryStatus>(){

        @Override
        public boolean match(TerritoryStatus ts) {
            return ts.WasAttacked_Trade;
        }
    };
    public static final Match<TerritoryStatus> TS_WasReinforced = new Match<TerritoryStatus>(){

        @Override
        public boolean match(TerritoryStatus ts) {
            return ts.WasReinforced();
        }
    };
    public static final Match<TerritoryStatus> TS_WasReinforced_Block = new Match<TerritoryStatus>(){

        @Override
        public boolean match(TerritoryStatus ts) {
            return ts.WasReinforced_Block;
        }
    };
    public static final Match<TerritoryStatus> TS_WasReinforced_Stabalize = new Match<TerritoryStatus>(){

        @Override
        public boolean match(TerritoryStatus ts) {
            return ts.WasReinforced_Stabalize;
        }
    };
    public static final Match<TerritoryStatus> TS_WasReinforced_Frontline = new Match<TerritoryStatus>(){

        @Override
        public boolean match(TerritoryStatus ts) {
            return ts.WasReinforced_Frontline;
        }
    };
    public static final Match<TerritoryStatus> TS_WasRetreatedFrom = new Match<TerritoryStatus>(){

        @Override
        public boolean match(TerritoryStatus ts) {
            return ts.WasRetreatedFrom;
        }
    };

    public static Match<UnitGroup> UnitGroupCanReach_Some(final Territory target) {
        return new Match<UnitGroup>(){

            @Override
            public boolean match(UnitGroup ug) {
                Route ncmRoute = ug.GetNCMRoute(target);
                if (ncmRoute == null) {
                    return false;
                }
                return Match.someMatch(ug.GetUnits(), Matches.UnitHasEnoughMovement(ncmRoute.getLength()));
            }
        };
    }

    public static Match<UnitGroup> UnitGroupCanReach_All(final Territory target) {
        return new Match<UnitGroup>(){

            @Override
            public boolean match(UnitGroup ug) {
                Route ncmRoute = ug.GetNCMRoute(target);
                if (ncmRoute == null) {
                    return false;
                }
                return Match.allMatch(ug.GetUnits(), Matches.UnitHasEnoughMovement(ncmRoute.getLength()));
            }
        };
    }

    public static Match<UnitGroup> UnitGroupHasEnoughMovement_Some(final int minMovement) {
        return new Match<UnitGroup>(){

            @Override
            public boolean match(UnitGroup ug) {
                return Match.someMatch(ug.GetUnits(), Matches.UnitHasEnoughMovement(minMovement));
            }
        };
    }

    public static Match<UnitGroup> UnitGroupHasEnoughMovement_All(final int minMovement) {
        return new Match<UnitGroup>(){

            @Override
            public boolean match(UnitGroup ug) {
                return Match.allMatch(ug.GetUnits(), Matches.UnitHasEnoughMovement(minMovement));
            }
        };
    }

    public static Match<UnitGroup> UnitGroupUnitsMatchX_All(final Match<Unit> match) {
        return new Match<UnitGroup>(){

            @Override
            public boolean match(UnitGroup ug) {
                return Match.allMatch(ug.GetUnits(), match);
            }
        };
    }

    public static Match<Unit> unitIs(final Unit u1) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u2) {
                return u1 == u2;
            }
        };
    }

    public static Match<Unit> unitIsNotInList(final List<Unit> list) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit ter) {
                return !list.contains(ter);
            }
        };
    }

    public static Match<Unit> unitIsInList(final List<Unit> list) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit ter) {
                return list.contains(ter);
            }
        };
    }

    public static Match<Unit> unitIsNNEnemyOf(final GameData data, final PlayerID player) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                if (u.getOwner().isNull()) {
                    return false;
                }
                return !data.getRelationshipTracker().isAllied(u.getOwner(), player);
            }
        };
    }

    public static Match<Territory> terIsFriendlyEmptyAndWithoutEnemyNeighbors(final GameData data, final PlayerID player) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                if (!DMatches.territoryIsOwnedByXOrAlly(data, player).match(ter)) {
                    return false;
                }
                if (Matches.territoryHasUnitsThatMatch(Matches.unitHasDefenseThatIsMoreThanOrEqualTo(1)).match(ter)) {
                    return false;
                }
                return data.getMap().getNeighbors(ter, DMatches.territoryIsOwnedByNNEnemy(data, player)).size() <= 0;
            }
        };
    }

    public static Match<Territory> TerritoryHasVulnerabilityEqualToOrMoreThan(final GameData data, final PlayerID player, final float minVulnerability, final int runCount) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                return DUtils.GetVulnerabilityOfArmy(data, player, ter, DUtils.ToList(ter.getUnits().getUnits()), runCount) >= minVulnerability;
            }
        };
    }

    public static Match<Territory> TerritoryHasSurvivalChanceEqualToOrMoreThan(final GameData data, final PlayerID player, final float minSurvivalChance, final int runCount) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                return DUtils.GetSurvivalChanceOfArmy(data, player, ter, DUtils.ToList(ter.getUnits().getUnits()), runCount) >= minSurvivalChance;
            }
        };
    }

    public static Match<Territory> territoryIsInList(final List<Territory> list) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                return list.contains(ter);
            }
        };
    }

    public static Match<Territory> territoryIsNotInList(final List<Territory> list) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                return !list.contains(ter);
            }
        };
    }

    public static Match<Territory> territoryIsWithinXLMovesOfATerInList(final List<Territory> list, final int maxJumpDist, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory territory) {
                for (Territory ter : list) {
                    if (!DUtils.CanWeGetFromXToY_ByPassableLand(data, ter, territory) || DUtils.GetJumpsFromXToY_PassableLand(data, ter, territory) > maxJumpDist) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Match<Territory> territoryIsOwnedByEnemy(final GameData data, final PlayerID player) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return (!t.isWater() || !t.getOwner().isNull()) && data.getRelationshipTracker().isAtWar(player, t.getOwner());
            }
        };
    }

    public static Match<Territory> territoryIsOwnedByNNEnemy(final GameData data, final PlayerID player) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return !t.getOwner().isNull() && data.getRelationshipTracker().isAtWar(player, t.getOwner());
            }
        };
    }

    public static Match<Territory> territoryIsOwnedBy(final PlayerID player) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return t.getOwner().getName().equals(player.getName());
            }
        };
    }

    public static Match<Territory> territoryIsLandAndPassableTo(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                if (Matches.TerritoryIsImpassable.match(ter)) {
                    return false;
                }
                if (!Properties.getMovementByTerritoryRestricted(data)) {
                    return true;
                }
                RulesAttachment ra = (RulesAttachment)player.getAttachment("rulesAttatchment");
                if (ra == null || ra.getMovementRestrictionTerritories() == null) {
                    return true;
                }
                String movementRestrictionType = ra.getMovementRestrictionType();
                Set<Territory> listedTerritories = ra.getListedTerritories(ra.getMovementRestrictionTerritories());
                return movementRestrictionType.equals("allowed") == listedTerritories.contains(ter);
            }
        };
    }

    public static Match<Territory> territoryIsWaterAndPassableTo(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                if (!ter.isWater()) {
                    return false;
                }
                return !Matches.territoryHasNonAllowedCanal(player, null, data).match(ter);
            }
        };
    }

    public static Match<Territory> territoryIsLandAndOwnedBy(final PlayerID player) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                return !ter.isWater() && player.equals(ter.getOwner());
            }
        };
    }

    public static Match<Territory> territoryIsOwnedByXOrAlly(final GameData data, final PlayerID player) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return data.getRelationshipTracker().isAllied(player, t.getOwner());
            }
        };
    }

    public static Match<Territory> territoryMatchesDMatch(final GameData data, final PlayerID player, final Match<TerritoryStatus> DMatch) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                return DMatch.match(StatusCenter.get(data, player).GetStatusOfTerritory(ter));
            }
        };
    }

    public static Match<Territory> territoryHasNNEnemyLandUnits(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return t.getUnits().someMatch(DUtils.CompMatchAnd(DMatches.unitIsNNEnemyOf(data, player), Matches.UnitIsLand));
            }
        };
    }

    public static Match<Territory> territoryContainsMultipleAlliances(final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                PlayerID lastPlayer = null;
                for (Unit unit : t.getUnits()) {
                    if (lastPlayer == null) {
                        lastPlayer = unit.getOwner();
                    }
                    if (data.getRelationshipTracker().isAllied(lastPlayer, unit.getOwner())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Match<Territory> territoryIsCapitalAndOwnedBy(GameData data, PlayerID player) {
        return DUtils.CompMatchAnd(territoryIsCapital, Matches.isTerritoryOwnedBy(player));
    }

    public static Match<Territory> territoryIsCapitalAndOwnedByEnemy(GameData data, PlayerID player) {
        return DUtils.CompMatchAnd(territoryIsCapital, Matches.isTerritoryEnemy(player, data));
    }

    public static Match<Territory> territoryCanHaveUnitsPlacedOnIt(final GameData data, final PlayerID player) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                if (ter.isWater()) {
                    return false;
                }
                if (!ter.getOwner().equals(player)) {
                    return false;
                }
                if (TerritoryAttachment.get(ter) == null || TerritoryAttachment.get(ter).getIsImpassible()) {
                    return false;
                }
                if (ter.getUnits().someMatch(Matches.UnitIsFactory)) {
                    return true;
                }
                return DUtils.CanPlayerPlaceAnywhere(data, player);
            }
        };
    }

    public static Match<Territory> territoryIsIsolated(GameData data) {
        return DMatches.territoryIsNotIsolated(data).invert();
    }

    public static Match<Territory> territoryIsNotIsolated(final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                return !data.getMap().getNeighbors(ter).isEmpty();
            }
        };
    }

    public static Match<Territory> territoryIsOnSmallIsland(GameData data) {
        return DMatches.territoryIsNotOnSmallIsland(data).invert();
    }

    public static Match<Territory> territoryIsNotOnSmallIsland(final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                if (data.getMap().getNeighbors(ter, Matches.TerritoryIsLand).isEmpty()) {
                    return false;
                }
                List<Territory> nearbyTersOnContinent = DUtils.GetTerritoriesWithinXDistanceOfYMatchingZAndHavingRouteMatchingA(data, ter, 2, Matches.TerritoryIsLand, Matches.TerritoryIsLand);
                nearbyTersOnContinent.remove(ter);
                nearbyTersOnContinent.removeAll(data.getMap().getNeighbors(ter));
                return !nearbyTersOnContinent.isEmpty();
            }
        };
    }

    public static Match<Territory> territoryHasRouteMatchingXToTerritoryMatchingY(final GameData data, final Match<Territory> routeMatch, final Match<Territory> targetMatch) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                List<Territory> tersMatchingYWithRouteMatchingX = DUtils.GetTerritoriesWithinXDistanceOfYMatchingZAndHavingRouteMatchingA(data, ter, Integer.MAX_VALUE, targetMatch, routeMatch);
                return !tersMatchingYWithRouteMatchingX.isEmpty();
            }
        };
    }

    public static Match<Territory> territoryHasUnitsMatchingXThatCanReach(PlayerID player, final GameData data, final Match<Territory> terMatch, final Match<Unit> unitMatch) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return DUtils.GetNUnitsMatchingXThatCanReach(data, t, terMatch, unitMatch, 1).size() >= 1;
            }
        };
    }

    public static Match<Territory> territoryHasNNEnemyUnitsThatCanReach(final PlayerID player, final GameData data, final Match<Territory> terMatch) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory t) {
                return DUtils.GetNNNEnemyUnitsThatCanReach(data, t, player, terMatch, 1).size() >= 1;
            }
        };
    }

    public static Match<Territory> territoryIsConsideredSafeToNCMInto(final PlayerID player, final GameData data) {
        return new Match<Territory>(){

            @Override
            public boolean match(Territory ter) {
                boolean hasAttackers;
                if (ter.isWater()) {
                    return false;
                }
                if (StatusCenter.get((GameData)data, (PlayerID)player).GetStatusOfTerritory((Territory)ter).WasRetreatedFrom) {
                    return false;
                }
                boolean bl = hasAttackers = DUtils.GetNNNEnemyLUnitsThatCanReach(data, ter, GlobalCenter.CurrentPlayer, Matches.TerritoryIsLand, 1).size() >= 1;
                return !hasAttackers || DUtils.CompMatchOr(TS_WasReinforced_Frontline, TS_WasReinforced_Stabalize).match(StatusCenter.get(data, GlobalCenter.CurrentPlayer).GetStatusOfTerritory(ter));
            }
        };
    }
}

