/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.net.GUID;
import games.strategy.triplea.ai.AbstractAI;
import games.strategy.triplea.ai.Dynamix_AI.Code.DoCombatMove;
import games.strategy.triplea.ai.Dynamix_AI.Code.DoNonCombatMove;
import games.strategy.triplea.ai.Dynamix_AI.Code.Place;
import games.strategy.triplea.ai.Dynamix_AI.Code.Purchase;
import games.strategy.triplea.ai.Dynamix_AI.Code.SelectCasualties;
import games.strategy.triplea.ai.Dynamix_AI.Code.Tech;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.CachedCalculationCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.CachedInstanceCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.FactoryCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.GlobalCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.KnowledgeCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.ReconsiderSignalCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.StatusCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.StrategyCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.TacticalCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.ThreatInvalidationCenter;
import games.strategy.triplea.ai.Dynamix_AI.DOddsCalculator;
import games.strategy.triplea.ai.Dynamix_AI.DSettings;
import games.strategy.triplea.ai.Dynamix_AI.DUtils;
import games.strategy.triplea.ai.Dynamix_AI.Group.UnitGroup;
import games.strategy.triplea.ai.Dynamix_AI.Others.Battle_RetreatTerCalculator;
import games.strategy.triplea.ai.Dynamix_AI.Others.PhaseType;
import games.strategy.triplea.ai.Dynamix_AI.UI.UI;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.dataObjects.BattleListing;
import games.strategy.triplea.delegate.dataObjects.CasualtyDetails;
import games.strategy.triplea.delegate.dataObjects.CasualtyList;
import games.strategy.triplea.delegate.remote.IAbstractPlaceDelegate;
import games.strategy.triplea.delegate.remote.IBattleDelegate;
import games.strategy.triplea.delegate.remote.IMoveDelegate;
import games.strategy.triplea.delegate.remote.IPurchaseDelegate;
import games.strategy.triplea.delegate.remote.ITechDelegate;
import games.strategy.triplea.oddsCalculator.ta.AggregateResults;
import games.strategy.triplea.oddsCalculator.ta.BattleResults;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.triplea.ui.TripleAFrame;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dynamix_AI
extends AbstractAI
implements IGamePlayer,
ITripleaPlayer {
    private static final Logger s_logger = Logger.getLogger(Dynamix_AI.class.getName());
    private static List<Dynamix_AI> s_dAIInstances = new ArrayList<Dynamix_AI>();
    private static long s_lastActionDisplayTime = new Date().getTime();
    int m_moveLastType = -1;
    Territory m_battleTer = null;

    public static Logger GetStaticLogger() {
        return s_logger;
    }

    public Dynamix_AI(String name, String type) {
        super(name, type);
    }

    public static void ClearAIInstancesMemory() {
        DUtils.Log(Level.FINE, "Clearing static Dynamix_AI instances.", new Object[0]);
        s_dAIInstances.clear();
    }

    public static void AddDynamixAIIntoAIInstancesMemory(Dynamix_AI ai) {
        DUtils.Log(Level.FINE, "Adding Dynamix_AI named {0} to static instances.", ai.getName());
        s_dAIInstances.add(ai);
    }

    public static List<Dynamix_AI> GetDynamixAIInstancesMemory() {
        return s_dAIInstances;
    }

    public static void clearCachedGameDataAll() {
        CachedInstanceCenter.clearCachedDelegatesAndData();
        UI.clearCachedInstances();
        Dynamix_AI.clearStaticInstances();
    }

    public static void clearStaticInstances() {
        GlobalCenter.clearStaticInstances();
        FactoryCenter.ClearStaticInstances();
        KnowledgeCenter.ClearStaticInstances();
        TacticalCenter.ClearStaticInstances();
        StatusCenter.ClearStaticInstances();
        ThreatInvalidationCenter.ClearStaticInstances();
        ReconsiderSignalCenter.ClearStaticInstances();
        StrategyCenter.ClearStaticInstances();
        UnitGroup.ClearBufferedMoves();
        DOddsCalculator.clearCachedStaticData();
        CachedCalculationCenter.clearCachedStaticData();
        UnitGroup.clearCachedInstances();
    }

    public static void Initialize(TripleAFrame frame) {
        UI.Initialize(frame);
        DUtils.Log(Level.FINE, "Initializing Dynamix_AI...", new Object[0]);
        Dynamix_AI.clearStaticInstances();
        GlobalCenter.Initialize(CachedInstanceCenter.CachedGameData);
        CachedInstanceCenter.CachedBattleTracker = DelegateFinder.battleDelegate(CachedInstanceCenter.CachedGameData).getBattleTracker();
    }

    public static void ShowSettingsWindow() {
        DUtils.Log(Level.FINE, "Showing Dynamix_AI settings window.", new Object[0]);
        UI.ShowSettingsWindow();
    }

    @Override
    public void pause() {
        Dynamix_AI.Pause();
    }

    public static void Pause() {
        try {
            long pauseTime = Dynamix_AI.GetTimeTillNextScheduledActionDisplay();
            if (pauseTime == -1L) {
                return;
            }
            Thread.sleep(pauseTime);
            s_lastActionDisplayTime = new Date().getTime();
        }
        catch (InterruptedException ex) {
            DUtils.Log(Level.SEVERE, "InterruptedException occured while trying to perform AI pausing. Exception: {0}", ex);
        }
    }

    public static long GetTimeTillNextScheduledActionDisplay() {
        if (!DUtils.ToList(DUtils.ToArray(new Object[]{PhaseType.Purchase, PhaseType.Combat_Move, PhaseType.Non_Combat_Move, PhaseType.Place})).contains((Object)GlobalCenter.CurrentPhaseType)) {
            return -1L;
        }
        long timeSince = new Date().getTime() - s_lastActionDisplayTime;
        long wantedActionLength = 0L;
        switch (GlobalCenter.CurrentPhaseType) {
            case Purchase: {
                wantedActionLength = DSettings.LoadSettings().PurchaseWait_AL;
                break;
            }
            case Combat_Move: {
                wantedActionLength = DSettings.LoadSettings().CombatMoveWait_AL;
                break;
            }
            case Non_Combat_Move: {
                wantedActionLength = DSettings.LoadSettings().NonCombatMoveWait_AL;
                break;
            }
            case Place: {
                wantedActionLength = DSettings.LoadSettings().PlacementWait_AL;
            }
        }
        int timeTill = (int)(wantedActionLength - timeSince);
        timeTill = Math.max(timeTill, 0);
        return timeTill;
    }

    private void NotifyGameRound(GameData data) {
        if (GlobalCenter.GameRound != data.getSequence().getRound()) {
            GlobalCenter.GameRound = data.getSequence().getRound();
            UI.NotifyStartOfRound(GlobalCenter.GameRound);
            DUtils.Log(Level.FINE, "-----Start of game round notification sent out. Round {0}-----", GlobalCenter.GameRound);
            TacticalCenter.NotifyStartOfRound();
            FactoryCenter.NotifyStartOfRound();
            StatusCenter.NotifyStartOfRound();
            ThreatInvalidationCenter.NotifyStartOfRound();
            ReconsiderSignalCenter.NotifyStartOfRound();
            StrategyCenter.NotifyStartOfRound();
            GlobalCenter.CurrentPlayer = PlayerID.NULL_PLAYERID;
        }
    }

    private void NotifyPlayer(PlayerID player) {
        if (GlobalCenter.FirstDynamixPlayer == null) {
            GlobalCenter.FirstDynamixPlayer = player;
        }
        if (GlobalCenter.CurrentPlayer != player) {
            GlobalCenter.CurrentPlayer = player;
            DUtils.Log(Level.FINE, "-----Start of player's turn notification sent out. Player: {0}-----", player.getName());
            DOddsCalculator.SetGameData(this.getGameData());
            GlobalCenter.CurrentPhaseType = PhaseType.Unknown;
        }
    }

    private void NotifyPhaseType(PhaseType phaseType) {
        if (GlobalCenter.FirstDynamixPhase == null) {
            GlobalCenter.FirstDynamixPhase = phaseType;
        }
        if (GlobalCenter.CurrentPhaseType != phaseType) {
            GlobalCenter.CurrentPhaseType = phaseType;
            DUtils.Log(Level.FINE, "-----Start of phase notification sent out. Phase: {0}-----", new Object[]{phaseType});
        }
    }

    @Override
    protected void place(boolean bid, IAbstractPlaceDelegate placeDelegate, GameData data, PlayerID player) {
        this.NotifyGameRound(data);
        this.NotifyPlayer(player);
        this.NotifyPhaseType(PhaseType.Place);
        Place.place(this, bid, placeDelegate, data, player);
        if (bid) {
            FactoryCenter.NotifyStartOfRound();
        }
    }

    @Override
    protected void move(boolean nonCombat, IMoveDelegate moveDel, GameData data, PlayerID player) {
        UnitGroup.movesCount = 0;
        if (!nonCombat) {
            this.NotifyGameRound(data);
            this.NotifyPlayer(player);
            this.NotifyPhaseType(PhaseType.Combat_Move);
            ThreatInvalidationCenter.get(data, player).ClearInvalidatedThreats();
            DoCombatMove.doCombatMove(this, data, moveDel, player);
            TacticalCenter.get((GameData)data, (PlayerID)player).AllDelegateUnitGroups.clear();
            TacticalCenter.get(data, player).ClearFrozenUnits();
            TacticalCenter.get(data, player).ClearStartOfTurnUnitLocations();
            this.pause();
        } else {
            this.NotifyGameRound(data);
            this.NotifyPlayer(player);
            this.NotifyPhaseType(PhaseType.Non_Combat_Move);
            ThreatInvalidationCenter.get(data, player).ClearInvalidatedThreats();
            DoNonCombatMove.doNonCombatMove(this, data, moveDel, player);
            TacticalCenter.get((GameData)data, (PlayerID)player).AllDelegateUnitGroups.clear();
            TacticalCenter.get(data, player).ClearFrozenUnits();
            TacticalCenter.get(data, player).ClearStartOfTurnUnitLocations();
            this.pause();
        }
        this.m_moveLastType = this.m_moveLastType == -1 ? 1 : (this.m_moveLastType == 0 ? 1 : 0);
    }

    @Override
    protected void tech(ITechDelegate techDelegate, GameData data, PlayerID player) {
        this.NotifyGameRound(data);
        this.NotifyPlayer(player);
        this.NotifyPhaseType(PhaseType.Tech);
        Tech.tech(this, techDelegate, data, player);
    }

    @Override
    protected void purchase(boolean purchaseForBid, int PUsToSpend, IPurchaseDelegate purchaser, GameData data, PlayerID player) {
        this.NotifyGameRound(data);
        this.NotifyPlayer(player);
        this.NotifyPhaseType(PhaseType.Purchase);
        Purchase.purchase(this, purchaseForBid, PUsToSpend, purchaser, data, player);
    }

    @Override
    protected void battle(IBattleDelegate battleDelegate, GameData data, PlayerID player) {
        BattleListing listing;
        this.NotifyGameRound(data);
        this.NotifyPlayer(player);
        this.NotifyPhaseType(PhaseType.Battle);
        while (!(listing = battleDelegate.getBattles()).getBattles().isEmpty() || !listing.getStrategicRaids().isEmpty()) {
            for (Territory current : listing.getStrategicRaids()) {
                String error = battleDelegate.fightBattle(current, true);
            }
            for (Territory current : listing.getBattles()) {
                this.setBattleInfo(current);
                String error = battleDelegate.fightBattle(current, false);
            }
            this.setBattleInfo(null);
        }
    }

    private void setBattleInfo(Territory bTerr) {
        this.m_battleTer = bTerr;
    }

    private Territory getBattleTerritory() {
        return this.m_battleTer;
    }

    @Override
    public HashMap<Territory, Collection<Unit>> scrambleUnitsQuery(Territory scrambleTo, Map<Territory, Tuple<Collection<Unit>, Collection<Unit>>> possibleScramblers) {
        return null;
    }

    @Override
    public Territory retreatQuery(GUID battleID, boolean submerge, Collection<Territory> possibleTerritories, String message) {
        DUtils.Log(Level.FINE, "Retreat query starting. Battle Ter: {0} Possible retreat locations: {1}", this.getBattleTerritory(), possibleTerritories);
        GameData data = this.getPlayerBridge().getGameData();
        PlayerID player = GlobalCenter.CurrentPlayer;
        Territory battleTer = this.getBattleTerritory();
        if (battleTer == null || possibleTerritories.isEmpty()) {
            return null;
        }
        List<Unit> attackers = battleTer.getUnits().getMatches(Matches.unitIsOwnedBy(this.getID()));
        List<Unit> defenders = battleTer.getUnits().getMatches(Matches.unitIsEnemyOf(data, this.getID()));
        AggregateResults simulatedAttack = DUtils.GetBattleResults(attackers, defenders, battleTer, data, DSettings.LoadSettings().CA_Retreat_determinesIfAIShouldRetreat, true);
        float chanceNeededToContinue = 0.6f;
        if (TacticalCenter.get((GameData)data, (PlayerID)this.getID()).BattleRetreatChanceAssignments.containsKey(battleTer)) {
            DUtils.Log(Level.FINER, "Found specific battle retreat chance assignment for territory '{0}'. Retreat Chance: {1}", battleTer, TacticalCenter.get((GameData)data, (PlayerID)player).BattleRetreatChanceAssignments.get(battleTer));
            chanceNeededToContinue = TacticalCenter.get((GameData)data, (PlayerID)this.getID()).BattleRetreatChanceAssignments.get(battleTer).floatValue();
            if (simulatedAttack.getAttackerWinPercent() < (double)chanceNeededToContinue) {
                Territory retreatTer = Battle_RetreatTerCalculator.CalculateBestRetreatTer(data, player, new ArrayList<Territory>(possibleTerritories), battleTer);
                return retreatTer;
            }
        } else {
            List<Unit> responseAttackers = DUtils.DetermineResponseAttackers(data, GlobalCenter.CurrentPlayer, battleTer, simulatedAttack);
            List<Unit> responseDefenders = Match.getMatches(simulatedAttack.GetAverageAttackingUnitsRemaining(), Matches.UnitIsNotAir);
            AggregateResults responseResults = DUtils.GetBattleResults(responseAttackers, responseDefenders, battleTer, data, DSettings.LoadSettings().CA_Retreat_determinesIfAIShouldRetreat, true);
            int tradeScore = DUtils.GetTaskTradeScore(data, battleTer, attackers, defenders, simulatedAttack, responseAttackers, responseDefenders, responseResults);
            DUtils.Log(Level.FINER, "Attack_Trade battle assumed. Score: {0} Required: {1}", tradeScore, DSettings.LoadSettings().TR_attackTrade_totalTradeScoreRequired);
            if (tradeScore < DSettings.LoadSettings().TR_attackTrade_totalTradeScoreRequired) {
                Territory retreatTer = Battle_RetreatTerCalculator.CalculateBestRetreatTer(data, player, new ArrayList<Territory>(possibleTerritories), battleTer);
                return retreatTer;
            }
            int leftoverLandUnitsWanted = 2;
            int timesWeReachLeftoverLUnitsGoal = 0;
            for (BattleResults result : simulatedAttack.m_results) {
                if (Match.getMatches(result.getRemainingAttackingUnits(), Matches.UnitIsLand).size() < 2) continue;
                ++timesWeReachLeftoverLUnitsGoal;
            }
            float certaintyOfReachingLUnitsCount = (float)timesWeReachLeftoverLUnitsGoal / (float)simulatedAttack.m_results.size();
            if (certaintyOfReachingLUnitsCount < DUtils.ToFloat(DSettings.LoadSettings().TR_attackTrade_certaintyOfReachingDesiredNumberOfLeftoverLandUnitsRequired)) {
                Territory retreatTer = Battle_RetreatTerCalculator.CalculateBestRetreatTer(data, player, new ArrayList<Territory>(possibleTerritories), battleTer);
                return retreatTer;
            }
        }
        return null;
    }

    @Override
    public boolean confirmMoveInFaceOfAA(Collection<Territory> aaFiringTerritories) {
        return true;
    }

    @Override
    public Territory selectTerritoryForAirToLand(Collection<Territory> candidates, Territory currentTerritory, String unitMessage) {
        return candidates.iterator().next();
    }

    @Override
    public Collection<Unit> getNumberOfFightersToMoveToNewCarrier(Collection<Unit> fightersThatCanBeMoved, Territory from) {
        ArrayList<Unit> result = new ArrayList<Unit>();
        for (Unit fighter : fightersThatCanBeMoved) {
            result.add(fighter);
        }
        return result;
    }

    @Override
    public boolean shouldBomberBomb(Territory territory) {
        List<Unit> nonBomberAttackingUnits = Match.getMatches(territory.getUnits().getUnits(), new CompositeMatchAnd(Matches.unitIsOwnedBy(this.getWhoAmI()), Matches.UnitIsNotStrategicBomber));
        return nonBomberAttackingUnits.isEmpty();
    }

    @Override
    public Unit whatShouldBomberBomb(Territory territory, Collection<Unit> potentialTargets, Collection<Unit> bombers) {
        if (potentialTargets == null || potentialTargets.isEmpty()) {
            return null;
        }
        if (!Match.someMatch(potentialTargets, Matches.UnitIsFactoryOrCanProduceUnits)) {
            return potentialTargets.iterator().next();
        }
        if (Match.someMatch(potentialTargets, Matches.UnitIsFactory)) {
            return Match.getMatches(potentialTargets, Matches.UnitIsFactory).iterator().next();
        }
        return Match.getMatches(potentialTargets, Matches.UnitCanProduceUnits).iterator().next();
    }

    @Override
    public int[] selectFixedDice(int numRolls, int hitAt, boolean hitOnlyIfEquals, String message, int diceSides) {
        int[] dice = new int[numRolls];
        for (int i = 0; i < numRolls; ++i) {
            dice[i] = (int)Math.ceil(Math.random() * (double)diceSides);
        }
        return dice;
    }

    @Override
    public CasualtyDetails selectCasualties(Collection<Unit> selectFrom, Map<Unit, Collection<Unit>> dependents, int count, String message, DiceRoll dice, PlayerID hit, CasualtyList defaultCasualties, GUID battleID) {
        DUtils.Log(Level.FINE, "Select casualties method called. Message: {0}", message);
        return SelectCasualties.selectCasualties(this, this.getGameData(), selectFrom, dependents, count, message, dice, hit, defaultCasualties, battleID);
    }

    @Override
    public void reportError(String error) {
        DUtils.Log(Level.FINE, "Error message reported: {0}", error);
        if (error.equals("Wrong number of casualties selected") || error.equals("Cannot remove enough units of those types")) {
            SelectCasualties.NotifyCasualtySelectionError(error);
        }
    }

    @Override
    public Collection<Unit> selectUnitsQuery(Territory current, Collection<Unit> possible, String message) {
        return null;
    }
}

