/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI.Others;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.ai.Dynamix_AI.DSettings;
import games.strategy.triplea.ai.Dynamix_AI.DUtils;
import games.strategy.triplea.delegate.Matches;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Battle_RetreatTerCalculator {
    public static Territory CalculateBestRetreatTer(GameData data, PlayerID player, List<Territory> possibles, Territory battleTer) {
        List<Territory> ourCaps = DUtils.GetAllOurCaps_ThatWeOwn(data, player);
        Territory highestScoringTer = null;
        float highestScore = -2.1474836E9f;
        for (Territory ter : possibles) {
            float score = 0.0f;
            float oldSurvivalChance = DUtils.GetSurvivalChanceOfArmy(data, player, ter, DUtils.GetTerUnitsAtEndOfTurn(data, player, ter), 500);
            List<Unit> afterDefenders = DUtils.GetTerUnitsAtEndOfTurn(data, player, ter);
            afterDefenders.removeAll(battleTer.getUnits().getMatches(Matches.unitIsOwnedBy(player)));
            afterDefenders.addAll(battleTer.getUnits().getMatches(Matches.unitIsOwnedBy(player)));
            float newSurvivalChance = DUtils.GetSurvivalChanceOfArmy(data, player, ter, afterDefenders, 500);
            if (newSurvivalChance > 0.9f) {
                newSurvivalChance = 0.9f;
            }
            boolean isImportant = ourCaps.contains(ter);
            float importantTerChanceRequired = DUtils.ToFloat(DSettings.LoadSettings().TR_reinforceStabalize_enemyAttackSurvivalChanceRequired);
            if (isImportant && oldSurvivalChance < importantTerChanceRequired && newSurvivalChance >= importantTerChanceRequired) {
                score += 100000.0f;
            }
            score += newSurvivalChance * 10000.0f;
            if (!ter.isWater()) {
                score += DUtils.GetValueOfLandTer(ter, data, player);
            }
            if (!(score > highestScore)) continue;
            highestScore = score;
            highestScoringTer = ter;
        }
        return highestScoringTer;
    }
}

