/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI.Others;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.CachedInstanceCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.ThreatInvalidationCenter;
import games.strategy.triplea.ai.Dynamix_AI.DMatches;
import games.strategy.triplea.ai.Dynamix_AI.DSettings;
import games.strategy.triplea.ai.Dynamix_AI.DUtils;
import games.strategy.triplea.ai.Dynamix_AI.Others.NCM_TargetCalculator;
import games.strategy.triplea.ai.Dynamix_AI.Others.NCM_Task;
import games.strategy.triplea.delegate.Matches;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NCM_AirLandingCalculator {
    public static Territory CalculateLandingLocationForAirUnits(GameData data, PlayerID player, Territory territory, List<Unit> airUnits, List<NCM_Task> tasks) {
        float highestScore = -2.1474836E9f;
        Territory highestScoringTer = null;
        List<Territory> ourCaps = DUtils.GetAllOurCaps_ThatWeOwn(data, player);
        ArrayList<Territory> ourCapitalsTargets = new ArrayList<Territory>();
        for (Territory ourCap : ourCaps) {
            ourCapitalsTargets.add(NCM_TargetCalculator.CalculateNCMTargetForTerritory(data, player, ourCap, ourCap.getUnits().getUnits(), tasks));
        }
        for (Territory ter : data.getMap().getTerritories()) {
            if (ter.isWater() || DMatches.territoryIsOwnedByEnemy(data, player).match(ter) || CachedInstanceCenter.CachedBattleTracker.wasConquered(ter)) continue;
            int airUnitsAbleToMakeIt = 0;
            for (Unit air : airUnits) {
                if (!DUtils.CanUnitReachTer(data, territory, air, ter)) continue;
                ++airUnitsAbleToMakeIt;
            }
            if (airUnitsAbleToMakeIt == 0) continue;
            float oldSurvivalChance = DUtils.GetSurvivalChanceOfArmy(data, player, ter, DUtils.GetTerUnitsAtEndOfTurn(data, player, ter), DSettings.LoadSettings().CA_CMNCM_determinesIfTaskEndangersCap);
            List<Unit> afterDefenders = DUtils.GetTerUnitsAtEndOfTurn(data, player, ter);
            afterDefenders.removeAll(airUnits);
            afterDefenders.addAll(airUnits);
            float newSurvivalChance = DUtils.GetSurvivalChanceOfArmy(data, player, ter, afterDefenders, 500);
            if (newSurvivalChance > 0.9f) {
                newSurvivalChance = 0.9f;
            }
            float score = 0.0f;
            score += (float)(airUnitsAbleToMakeIt * 100000000);
            score += newSurvivalChance * 1.0E7f;
            boolean isImportant = ourCaps.contains(ter);
            float importantTerChanceRequired = DUtils.ToFloat(DSettings.LoadSettings().TR_reinforceStabalize_enemyAttackSurvivalChanceRequired);
            if (isImportant && oldSurvivalChance < importantTerChanceRequired && newSurvivalChance >= importantTerChanceRequired) {
                score += 100000.0f;
            }
            Territory closestCapTarget = DUtils.GetClosestTerInList(data, ourCapitalsTargets, territory);
            score -= (float)(DUtils.GetDistance_ForLandThenNoCondComparison(data, ter, closestCapTarget) * 100);
            Territory closestTerWithOurUnits = DUtils.GetClosestTerMatchingX(data, territory, Matches.territoryHasUnitsThatMatch(DUtils.CompMatchAnd(Matches.unitIsLandAndOwnedBy(player), DMatches.UnitCanAttack)));
            score -= (float)(DUtils.GetDistance_ForLandThenNoCondComparison(data, ter, closestTerWithOurUnits) * 100);
            if (DMatches.territoryIsOwnedBy(player).match(ter)) {
                score += 50.0f;
            }
            ArrayList<Territory> capsAndNeighbors = new ArrayList<Territory>();
            for (Territory cap : ourCaps) {
                capsAndNeighbors.addAll(DUtils.GetTerritoriesWithinXDistanceOfY(data, cap, 1));
            }
            HashSet capsAndNeighborsUnits = DUtils.ToHashSet(DUtils.GetUnitsInTerritories(capsAndNeighbors));
            boolean arePlanesFromCapsOrNeighbors = false;
            for (Unit recruit : airUnits) {
                if (!capsAndNeighborsUnits.contains(recruit)) continue;
                arePlanesFromCapsOrNeighbors = true;
                break;
            }
            if (arePlanesFromCapsOrNeighbors) {
                Territory ourClosestCap = DUtils.GetOurClosestCap(data, player, ter);
                ThreatInvalidationCenter.get(data, player).SuspendThreatInvalidation();
                List<Float> capTakeoverChances = DUtils.GetTerTakeoverChanceBeforeAndAfterMove(data, player, ourClosestCap, ter, airUnits, DSettings.LoadSettings().CA_CMNCM_determinesIfTaskEndangersCap);
                ThreatInvalidationCenter.get(data, player).ResumeThreatInvalidation();
                if (capTakeoverChances.get(1).floatValue() > 0.1f && (capTakeoverChances.get(1).floatValue() - capTakeoverChances.get(0).floatValue() > 0.01f || capTakeoverChances.get(3).floatValue() - capTakeoverChances.get(2).floatValue() > 1.0f)) {
                    DUtils.Log(Level.FINEST, "      Landing air units at {0} would endanger capital, so finding another landing ter.", ter);
                    continue;
                }
            }
            if (!(score > highestScore)) continue;
            highestScore = score;
            highestScoringTer = ter;
        }
        return highestScoringTer;
    }
}

