/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI.Others;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.GlobalCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.TacticalCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.ThreatInvalidationCenter;
import games.strategy.triplea.ai.Dynamix_AI.DMatches;
import games.strategy.triplea.ai.Dynamix_AI.DSettings;
import games.strategy.triplea.ai.Dynamix_AI.DSorting;
import games.strategy.triplea.ai.Dynamix_AI.DUtils;
import games.strategy.triplea.ai.Dynamix_AI.Dynamix_AI;
import games.strategy.triplea.ai.Dynamix_AI.Group.UnitGroup;
import games.strategy.triplea.ai.Dynamix_AI.Others.NCM_CallType;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.remote.IMoveDelegate;
import games.strategy.triplea.oddsCalculator.ta.AggregateResults;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NCM_Call {
    private Territory m_target = null;
    private NCM_CallType m_callType = NCM_CallType.Empty;
    private float m_priority = 0.0f;
    private GameData m_data = null;
    private float m_minSurvivalChance = 0.0f;
    private List<UnitGroup> m_recruitedUnits = new ArrayList<UnitGroup>();
    private boolean m_disqualified = false;
    private boolean m_completed = false;

    public NCM_Call(GameData data, Territory target, NCM_CallType type, float priority) {
        this.m_data = data;
        this.m_callType = type;
        this.m_priority = priority;
        this.m_target = target;
    }

    public Territory GetTarget() {
        return this.m_target;
    }

    public NCM_CallType GetCallType() {
        return this.m_callType;
    }

    public float GetPriority() {
        return this.m_priority;
    }

    public void SetPriority(float priority) {
        this.m_priority = priority;
    }

    private List<UnitGroup> getSortedPossibleRecruits() {
        HashMap<Unit, Territory> unitLocations = new HashMap<Unit, Territory>();
        HashMap<Unit, Integer> possibles = new HashMap<Unit, Integer>();
        boolean addedAA = false;
        for (final Territory ter : this.m_data.getMap().getTerritories()) {
            if (DMatches.territoryContainsMultipleAlliances(this.m_data).match(ter)) continue;
            final HashSet recruitsAsHashSet = DUtils.ToHashSet(this.GetRecruitedUnitsAsUnitList());
            Match<Unit> unitMatch = new Match<Unit>(){

                @Override
                public boolean match(Unit unit) {
                    UnitAttachment ua = UnitAttachment.get(unit.getUnitType());
                    if (!Matches.unitIsOwnedBy(GlobalCenter.CurrentPlayer).match(unit)) {
                        return false;
                    }
                    if (Matches.UnitIsFactory.match(unit) && ua.getDefense(unit.getOwner()) <= 0) {
                        return false;
                    }
                    if (recruitsAsHashSet.contains(unit)) {
                        return false;
                    }
                    return DUtils.CanUnitReachTer(NCM_Call.this.m_data, ter, unit, NCM_Call.this.m_target);
                }
            };
            List<Unit> units = Match.getMatches(DUtils.ToList(ter.getUnits().getUnits()), unitMatch);
            if (units.isEmpty()) continue;
            for (Unit unit : units) {
                int suitability;
                if (Matches.UnitIsAAforAnything.match(unit)) {
                    if (addedAA || ter.getUnits().getMatches(Matches.UnitIsFactory).size() > 0 && ter.getUnits().getMatches(Matches.UnitIsAAforAnything).size() <= 1) continue;
                    addedAA = true;
                }
                if ((suitability = DUtils.HowWellIsUnitSuitedToCall(this.m_data, this, ter, unit)) == Integer.MIN_VALUE) continue;
                possibles.put(unit, suitability);
                unitLocations.put(unit, ter);
            }
        }
        List sortedPossibles = DUtils.ToList(possibles.keySet());
        Collections.shuffle(sortedPossibles);
        sortedPossibles = DSorting.SortListByScores_List_D(sortedPossibles, possibles.values());
        ArrayList<UnitGroup> result = new ArrayList<UnitGroup>();
        for (Unit unit : sortedPossibles) {
            result.add(DUtils.CreateUnitGroupForUnits(Collections.singletonList(unit), (Territory)unitLocations.get(unit), this.m_data));
        }
        return result;
    }

    public void CalculateCallRequirements() {
        if (this.m_callType.equals((Object)NCM_CallType.Land_ForLandGrab)) {
            return;
        }
        if (this.m_callType == NCM_CallType.Land_ForDefensiveFront) {
            this.m_minSurvivalChance = 0.75f;
        } else if (this.m_callType == NCM_CallType.Land_ForCapitalDefense) {
            this.m_minSurvivalChance = 1.0f;
        }
    }

    public void SetCallRequirements(float minSurvivalChance) {
        this.m_minSurvivalChance = minSurvivalChance;
    }

    private float getMeetingOfMinSurvivalChanceScore(AggregateResults simulatedAttack, float minSurvivalChance) {
        if (this.m_callType.equals((Object)NCM_CallType.Land_ForLandGrab)) {
            if (this.m_recruitedUnits.size() > 0) {
                return 1.0f;
            }
            return 0.0f;
        }
        return DUtils.Divide_SL((float)simulatedAttack.getDefenderWinPercent(), minSurvivalChance);
    }

    private float getMeetingOfMaxBattleVolleysScore(AggregateResults simulatedAttack, int maxBattleVolleys) {
        if (this.m_callType.equals((Object)NCM_CallType.Land_ForLandGrab)) {
            if (this.m_recruitedUnits.size() > 0) {
                return 1.0f;
            }
            return 0.0f;
        }
        return DUtils.Divide_SL(maxBattleVolleys, (float)simulatedAttack.getAverageBattleRoundsFought());
    }

    public void RecruitUnits() {
        this.recruitEnoughUnitsToMeetXYZ(this.m_minSurvivalChance, 100);
    }

    public void RecruitUnits2() {
        if (this.m_callType.equals((Object)NCM_CallType.Land_ForLandGrab) && this.m_recruitedUnits.size() > 0) {
            return;
        }
        float minSurvivalChance = 0.9f;
        int maxBattleVolleys = 5;
        this.recruitEnoughUnitsToMeetXYZ(0.9f, 5);
    }

    public void RecruitUnits3() {
        if (this.m_callType.equals((Object)NCM_CallType.Land_ForLandGrab) && this.m_recruitedUnits.size() > 0) {
            return;
        }
        float minSurvivalChance = 1.0f;
        int maxBattleVolleys = 3;
        this.recruitEnoughUnitsToMeetXYZ(1.0f, 3);
    }

    private void recruitEnoughUnitsToMeetXYZ(float minSurvivalChance, int maxBattleVolleys) {
        float howCloseToMeetingBattleVolleyMax;
        AggregateResults simulatedAttack;
        float howCloseToMeetingMinSurvivalChance;
        List<Unit> defenders;
        List<Unit> attackers;
        List<UnitGroup> sortedPossibles = this.getSortedPossibleRecruits();
        if (sortedPossibles.isEmpty()) {
            return;
        }
        for (UnitGroup ug : sortedPossibles) {
            if (this.m_recruitedUnits.contains(ug)) continue;
            attackers = DUtils.GetSPNNEnemyUnitsThatCanReach(this.m_data, this.m_target, GlobalCenter.CurrentPlayer, Matches.TerritoryIsLandOrWater);
            defenders = this.GetRecruitedUnitsAsUnitList();
            defenders.addAll(DUtils.GetUnitsGoingToBePlacedAtX(this.m_data, GlobalCenter.CurrentPlayer, this.m_target));
            if (!DSettings.LoadSettings().AA_ignoreAlliedUnitsAsDefenses) {
                defenders.removeAll(this.m_target.getUnits().getUnits());
                defenders.addAll(this.m_target.getUnits().getUnits());
            }
            if ((howCloseToMeetingMinSurvivalChance = this.getMeetingOfMinSurvivalChanceScore(simulatedAttack = DUtils.GetBattleResults(attackers, defenders, this.m_target, this.m_data, 1, true), minSurvivalChance)) < 1.0f) {
                this.m_recruitedUnits.add(ug);
                continue;
            }
            howCloseToMeetingBattleVolleyMax = this.getMeetingOfMaxBattleVolleysScore(simulatedAttack, maxBattleVolleys);
            if (!(howCloseToMeetingBattleVolleyMax < 1.0f)) break;
            this.m_recruitedUnits.add(ug);
        }
        this.m_recruitedUnits = DUtils.TrimRecruits_NonMovedOnes(this.m_recruitedUnits, 7);
        for (UnitGroup ug : sortedPossibles) {
            if (this.m_recruitedUnits.contains(ug)) continue;
            attackers = DUtils.GetSPNNEnemyUnitsThatCanReach(this.m_data, this.m_target, GlobalCenter.CurrentPlayer, Matches.TerritoryIsLandOrWater);
            defenders = this.GetRecruitedUnitsAsUnitList();
            defenders.addAll(DUtils.GetUnitsGoingToBePlacedAtX(this.m_data, GlobalCenter.CurrentPlayer, this.m_target));
            if (!DSettings.LoadSettings().AA_ignoreAlliedUnitsAsDefenses) {
                defenders.removeAll(this.m_target.getUnits().getUnits());
                defenders.addAll(this.m_target.getUnits().getUnits());
            }
            if ((howCloseToMeetingMinSurvivalChance = this.getMeetingOfMinSurvivalChanceScore(simulatedAttack = DUtils.GetBattleResults(attackers, defenders, this.m_target, this.m_data, DSettings.LoadSettings().CA_CMNCM_determinesIfTasksRequirementsAreMetEnoughForRecruitingStop, true), minSurvivalChance)) < 1.0f) {
                this.m_recruitedUnits.add(ug);
                continue;
            }
            howCloseToMeetingBattleVolleyMax = this.getMeetingOfMaxBattleVolleysScore(simulatedAttack, maxBattleVolleys);
            if (!(howCloseToMeetingBattleVolleyMax < 1.0f)) break;
            this.m_recruitedUnits.add(ug);
        }
    }

    public List<UnitGroup> GetRecruitedUnits() {
        return this.m_recruitedUnits;
    }

    public List<Unit> GetRecruitedUnitsAsUnitList() {
        ArrayList<Unit> result = new ArrayList<Unit>();
        for (UnitGroup ug : this.m_recruitedUnits) {
            result.addAll(ug.GetUnits());
        }
        return result;
    }

    public boolean IsPlannedMoveWorthwhile(List<NCM_Call> allCalls) {
        DUtils.Log(Level.FINEST, "      Determining if ncm call is worthwhile. Target: {0} Recruits Size: {1}", this.m_target, this.m_recruitedUnits.size());
        if (this.m_recruitedUnits.isEmpty()) {
            return false;
        }
        PlayerID player = GlobalCenter.CurrentPlayer;
        List<Territory> ourCaps = DUtils.GetAllOurCaps(this.m_data, player);
        ArrayList<Territory> capsAndNeighbors = new ArrayList<Territory>();
        for (Territory cap : ourCaps) {
            capsAndNeighbors.addAll(DUtils.GetTerritoriesWithinXDistanceOfY(this.m_data, cap, 1));
        }
        HashSet capsAndNeighborsUnits = DUtils.ToHashSet(DUtils.GetUnitsInTerritories(capsAndNeighbors));
        boolean areRecruitsFromCapsOrNeighbors = false;
        for (Unit recruit : this.GetRecruitedUnitsAsUnitList()) {
            if (!capsAndNeighborsUnits.contains(recruit)) continue;
            areRecruitsFromCapsOrNeighbors = true;
            break;
        }
        if (areRecruitsFromCapsOrNeighbors && !ourCaps.contains(this.m_target)) {
            Territory ourClosestCap = DUtils.GetOurClosestCap(this.m_data, player, this.m_target);
            ThreatInvalidationCenter.get(this.m_data, player).SuspendThreatInvalidation();
            List recruits = DUtils.CombineCollections(this.GetRecruitedUnitsAsUnitList(), DUtils.GetUnitsGoingToBePlacedAtX(this.m_data, player, this.m_target));
            List<Float> capTakeoverChances = DUtils.GetTerTakeoverChanceBeforeAndAfterMove(this.m_data, player, ourClosestCap, this.m_target, recruits, DSettings.LoadSettings().CA_CMNCM_determinesIfTaskEndangersCap);
            ThreatInvalidationCenter.get(this.m_data, player).ResumeThreatInvalidation();
            if (capTakeoverChances.get(1).floatValue() > 0.1f && (capTakeoverChances.get(1).floatValue() - capTakeoverChances.get(0).floatValue() > 0.01f || capTakeoverChances.get(3).floatValue() - capTakeoverChances.get(2).floatValue() > 1.0f)) {
                DUtils.Log(Level.FINEST, "      Performing call would endanger capital, so canceling.", new Object[0]);
                return false;
            }
        }
        List<Unit> attackers = DUtils.GetSPNNEnemyUnitsThatCanReach(this.m_data, this.m_target, GlobalCenter.CurrentPlayer, Matches.TerritoryIsLandOrWater);
        List<Unit> defenders = this.GetRecruitedUnitsAsUnitList();
        defenders.addAll(DUtils.GetUnitsGoingToBePlacedAtX(this.m_data, GlobalCenter.CurrentPlayer, this.m_target));
        if (!DSettings.LoadSettings().AA_ignoreAlliedUnitsAsDefenses) {
            defenders.removeAll(this.m_target.getUnits().getUnits());
            defenders.addAll(this.m_target.getUnits().getUnits());
        }
        AggregateResults simulatedAttack = DUtils.GetBattleResults(attackers, defenders, this.m_target, this.m_data, DSettings.LoadSettings().CA_CMNCM_determinesResponseResultsToSeeIfTaskWorthwhile, true);
        DUtils.Log(Level.FINEST, "        Enemy attack simulated. Attackers Size: {0} Defenders Size: {1} Takeover Chance: {2}", attackers.size(), defenders.size(), simulatedAttack.getAttackerWinPercent());
        if (this.m_callType.equals((Object)NCM_CallType.Land_ForDefensiveFront)) {
            float howCloseToMeetingMinSurvivalChance = this.getMeetingOfMinSurvivalChanceScore(simulatedAttack, this.m_minSurvivalChance);
            DUtils.Log(Level.FINEST, "        How close to meeting min survival chance: {0} Needed: {1}", Float.valueOf(howCloseToMeetingMinSurvivalChance), Float.valueOf(0.98f));
            return !(howCloseToMeetingMinSurvivalChance < 0.98f);
        }
        if (this.m_callType.equals((Object)NCM_CallType.Land_ForCapitalDefense)) {
            float howCloseToMeetingMinSurvivalChance = this.getMeetingOfMinSurvivalChanceScore(simulatedAttack, this.m_minSurvivalChance);
            DUtils.Log(Level.FINEST, "        How close to meeting min survival chance: {0} Needed: {1}", Float.valueOf(howCloseToMeetingMinSurvivalChance), Float.valueOf(0.98f));
            if (howCloseToMeetingMinSurvivalChance < 0.98f) {
                DUtils.Log(Level.FINEST, "        Since this is a call for capital defense, we'll perform this call even if the requirements aren't met...", new Object[0]);
            }
            return true;
        }
        boolean canUnitsGetBack = false;
        if (UnitAttachment.get(this.m_recruitedUnits.get(0).GetFirstUnit().getUnitType()).getMovement(player) > 1) {
            canUnitsGetBack = true;
        }
        if (canUnitsGetBack) {
            return true;
        }
        int unitCost = DUtils.GetTUVOfUnits(this.GetRecruitedUnitsAsUnitList(), GlobalCenter.GetPUResource());
        TerritoryAttachment ta = TerritoryAttachment.get(this.m_target);
        List<Unit> landAttackers = DUtils.GetNNEnemyLUnitsThatCanReach(this.m_data, this.m_target, GlobalCenter.CurrentPlayer, Matches.TerritoryIsLandOrWater);
        return unitCost - 1 <= ta.getProduction() || landAttackers.isEmpty();
    }

    public boolean IsCallWithAdditionalRecruitsWorthwhile() {
        DUtils.Log(Level.FINEST, "      Determining if ncm call with additional recruits is worthwhile. Target: {0} Recruits Size: {1}", this.m_target, this.m_recruitedUnits.size());
        if (this.m_recruitedUnits.isEmpty()) {
            return false;
        }
        PlayerID player = GlobalCenter.CurrentPlayer;
        List<Territory> ourCaps = DUtils.GetAllOurCaps(this.m_data, player);
        ArrayList<Territory> capsAndNeighbors = new ArrayList<Territory>();
        for (Territory cap : ourCaps) {
            capsAndNeighbors.addAll(DUtils.GetTerritoriesWithinXDistanceOfY(this.m_data, cap, 1));
        }
        HashSet capsAndNeighborsUnits = DUtils.ToHashSet(DUtils.GetUnitsInTerritories(capsAndNeighbors));
        boolean areRecruitsFromCapsOrNeighbors = false;
        for (Unit recruit : this.GetRecruitedUnitsAsUnitList()) {
            if (!capsAndNeighborsUnits.contains(recruit)) continue;
            areRecruitsFromCapsOrNeighbors = true;
            break;
        }
        if (areRecruitsFromCapsOrNeighbors && !ourCaps.contains(this.m_target)) {
            Territory ourClosestCap = DUtils.GetOurClosestCap(this.m_data, player, this.m_target);
            ThreatInvalidationCenter.get(this.m_data, player).SuspendThreatInvalidation();
            List<Float> capTakeoverChances = DUtils.GetTerTakeoverChanceBeforeAndAfterMove(this.m_data, player, ourClosestCap, this.m_target, this.GetRecruitedUnitsAsUnitList(), DSettings.LoadSettings().CA_CMNCM_determinesIfTaskEndangersCap);
            ThreatInvalidationCenter.get(this.m_data, player).ResumeThreatInvalidation();
            if (capTakeoverChances.get(1).floatValue() > 0.1f && (capTakeoverChances.get(1).floatValue() - capTakeoverChances.get(0).floatValue() > 0.01f || capTakeoverChances.get(3).floatValue() - capTakeoverChances.get(2).floatValue() > 1.0f)) {
                DUtils.Log(Level.FINEST, "      Performing call with additional recruits would endanger capital, so canceling.", new Object[0]);
                return false;
            }
        }
        return true;
    }

    public boolean IsDisqualified() {
        return this.m_disqualified;
    }

    public void Disqualify() {
        this.m_disqualified = true;
    }

    public void Reset() {
        DUtils.Log(Level.FINER, "        Resetting call. Target: {0} Call Type: {1} Priority: {2} Recruit Size: {3}", new Object[]{this.m_target, this.m_callType, Float.valueOf(this.m_priority), this.m_recruitedUnits.size()});
        this.m_completed = false;
        this.m_disqualified = false;
        this.m_recruitedUnits = new ArrayList<UnitGroup>();
    }

    public boolean IsCompleted() {
        return this.m_completed;
    }

    public void PerformCall(IMoveDelegate mover) {
        String errors;
        if (this.m_recruitedUnits.isEmpty()) {
            DUtils.Log(Level.FINER, "      Call is called to perform, but there are no recruits! Target: {0} Call Type: {1} Priority: {2}", new Object[]{this.m_target, this.m_callType, Float.valueOf(this.m_priority)});
            this.m_completed = true;
            return;
        }
        UnitGroup.EnableMoveBuffering();
        boolean anythingMoved = false;
        for (UnitGroup ug : this.m_recruitedUnits) {
            if (ug.GetMovedTo() != null) continue;
            String error = ug.MoveAsFarTo_NCM(this.m_target, mover, true);
            if (error != null) {
                DUtils.Log(Level.FINER, "        NCM call perfoming move failed, reason: {0}", error);
                continue;
            }
            TacticalCenter.get(this.m_data, GlobalCenter.CurrentPlayer).FreezeUnits(ug.GetUnitsAsList());
            anythingMoved = true;
        }
        if (!anythingMoved) {
            this.m_disqualified = true;
            return;
        }
        if (!this.m_completed) {
            Dynamix_AI.Pause();
        }
        if ((errors = UnitGroup.PerformBufferedMovesAndDisableMoveBufferring(mover)) != null) {
            DUtils.Log(Level.FINER, "      Some errors occurred while performing moves: {0}", errors);
            this.m_disqualified = true;
            return;
        }
        this.m_completed = true;
    }
}

