/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.attatchments;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.DefaultAttachment;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.IAttachment;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.data.annotations.GameProperty;
import games.strategy.triplea.delegate.Matches;
import games.strategy.util.Match;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanalAttachment
extends DefaultAttachment {
    private static final long serialVersionUID = -1991066817386812634L;
    private String m_canalName = null;
    private HashSet<Territory> m_landTerritories = null;
    private HashSet<UnitType> m_excludedUnits = null;

    public CanalAttachment(String name, Attachable attachable, GameData gameData) {
        super(name, attachable, gameData);
    }

    public static Set<Territory> getAllCanalSeaZones(String canalName, GameData data) {
        HashSet<Territory> rVal = new HashSet<Territory>();
        for (Territory t : data.getMap()) {
            Set<CanalAttachment> canalAttachments = CanalAttachment.get(t);
            if (canalAttachments.isEmpty()) continue;
            for (CanalAttachment canalAttachment : canalAttachments) {
                if (!canalAttachment.getCanalName().equals(canalName)) continue;
                rVal.add(t);
            }
        }
        if (rVal.size() != 2) {
            throw new IllegalStateException("Wrong number of sea zones for canal (exactly 2 sea zones may have the same canalName):" + rVal);
        }
        return rVal;
    }

    public static Set<CanalAttachment> get(Territory t) {
        HashSet<CanalAttachment> rVal = new HashSet<CanalAttachment>();
        Map<String, IAttachment> map = t.getAttachments();
        Iterator<String> iter = map.keySet().iterator();
        while (iter.hasNext()) {
            IAttachment attachment = map.get(iter.next());
            String name = attachment.getName();
            if (!name.startsWith("canalAttatchment")) continue;
            rVal.add((CanalAttachment)attachment);
        }
        return rVal;
    }

    public static CanalAttachment get(Territory t, String nameOfAttachment) {
        CanalAttachment rVal = (CanalAttachment)t.getAttachment(nameOfAttachment);
        if (rVal == null) {
            throw new IllegalStateException("CanalAttachment: No canal attachment for:" + t.getName() + " with name: " + nameOfAttachment);
        }
        return rVal;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanalName(String name) {
        if (name == null) {
            this.m_canalName = null;
            return;
        }
        this.m_canalName = name;
    }

    public String getCanalName() {
        return this.m_canalName;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setLandTerritories(String landTerritories) {
        if (landTerritories == null) {
            this.m_landTerritories = null;
            return;
        }
        HashSet<Territory> terrs = new HashSet<Territory>();
        for (String name : landTerritories.split(":")) {
            Territory territory = this.getData().getMap().getTerritory(name);
            if (territory == null) {
                throw new IllegalStateException("Canals: No territory called: " + name + this.thisErrorMsg());
            }
            terrs.add(territory);
        }
        this.m_landTerritories = terrs;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setLandTerritories(HashSet<Territory> value) {
        this.m_landTerritories = value;
    }

    public HashSet<Territory> getLandTerritories() {
        return this.m_landTerritories;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setExcludedUnits(String value) {
        if (value == null) {
            this.m_excludedUnits = null;
            return;
        }
        if (this.m_excludedUnits == null) {
            this.m_excludedUnits = new HashSet();
        }
        if (value.equalsIgnoreCase("NONE")) {
            return;
        }
        if (value.equalsIgnoreCase("ALL")) {
            this.m_excludedUnits.addAll(this.getData().getUnitTypeList().getAllUnitTypes());
            return;
        }
        for (String name : value.split(":")) {
            UnitType ut = this.getData().getUnitTypeList().getUnitType(name);
            if (ut == null) {
                throw new IllegalStateException("Canals: No UnitType called: " + name + this.thisErrorMsg());
            }
            this.m_excludedUnits.add(ut);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setExcludedUnits(HashSet<UnitType> value) {
        this.m_excludedUnits = value;
    }

    public HashSet<UnitType> getExcludedUnits(GameData data) {
        if (this.m_excludedUnits == null) {
            return new HashSet<UnitType>(Match.getMatches(this.getData().getUnitTypeList().getAllUnitTypes(), Matches.UnitTypeIsAir));
        }
        return this.m_excludedUnits;
    }

    public void clearExcludedUnits() {
        this.m_excludedUnits.clear();
    }

    @Override
    public void validate(GameData data) throws GameParseException {
        if (this.m_canalName == null) {
            throw new GameParseException("Canals must have a canalName set!" + this.thisErrorMsg());
        }
        if (this.m_landTerritories == null || this.m_landTerritories.size() == 0) {
            throw new GameParseException("Canal named " + this.m_canalName + " must have landTerritories set!" + this.thisErrorMsg());
        }
    }
}

