/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.attatchments;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.DefaultAttachment;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.RelationshipType;
import games.strategy.engine.data.annotations.GameProperty;

public class RelationshipTypeAttachment
extends DefaultAttachment {
    private static final long serialVersionUID = -4367286684249791984L;
    public static final String ARCHETYPE_NEUTRAL = "neutral";
    public static final String ARCHETYPE_WAR = "war";
    public static final String ARCHETYPE_ALLIED = "allied";
    public static final String UPKEEP_FLAT = "flat";
    public static final String UPKEEP_PERCENTAGE = "percentage";
    public static final String PROPERTY_DEFAULT = "default";
    public static final String PROPERTY_TRUE = "true";
    public static final String PROPERTY_FALSE = "false";
    private String m_archeType = "war";
    private String m_helpsDefendAtSea = "default";
    private String m_canMoveLandUnitsOverOwnedLand = "default";
    private String m_canMoveAirUnitsOverOwnedLand = "default";
    private String m_alliancesCanChainTogether = "default";
    private String m_isDefaultWarPosition = "default";
    private String m_upkeepCost = "default";
    private String m_canLandAirUnitsOnOwnedLand = "default";
    private String m_canTakeOverOwnedTerritory = "default";
    private String m_givesBackOriginalTerritories = "default";
    private String m_canMoveIntoDuringCombatMove = "default";
    private String m_canMoveThroughCanals = "default";
    private String m_rocketsCanFlyOver = "default";

    public RelationshipTypeAttachment(String name, Attachable attachable, GameData gameData) {
        super(name, attachable, gameData);
    }

    public static RelationshipTypeAttachment get(RelationshipType pr) {
        RelationshipTypeAttachment rVal = (RelationshipTypeAttachment)pr.getAttachment("relationshipTypeAttachment");
        if (rVal == null) {
            throw new IllegalStateException("No relationshipType attachment for:" + pr.getName());
        }
        return rVal;
    }

    public static RelationshipTypeAttachment get(RelationshipType pr, String nameOfAttachment) {
        RelationshipTypeAttachment rVal = (RelationshipTypeAttachment)pr.getAttachment(nameOfAttachment);
        if (rVal == null) {
            throw new IllegalStateException("No relationshipType attachment for:" + pr.getName());
        }
        return rVal;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setArcheType(String archeType) throws GameParseException {
        if (archeType.toLowerCase().equals(ARCHETYPE_WAR)) {
            this.m_archeType = ARCHETYPE_WAR;
        } else if (archeType.toLowerCase().equals(ARCHETYPE_ALLIED)) {
            this.m_archeType = ARCHETYPE_ALLIED;
        } else if (archeType.toLowerCase().equals(ARCHETYPE_NEUTRAL)) {
            this.m_archeType = ARCHETYPE_NEUTRAL;
        } else {
            throw new GameParseException("archeType must be war,allied or neutral for " + this.thisErrorMsg());
        }
    }

    public String getArcheType() {
        return this.m_archeType;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanMoveAirUnitsOverOwnedLand(String canFlyOver) {
        this.m_canMoveAirUnitsOverOwnedLand = canFlyOver;
    }

    public boolean getCanMoveAirUnitsOverOwnedLand() {
        if (this.m_canMoveAirUnitsOverOwnedLand.equals(PROPERTY_DEFAULT)) {
            return this.isWar() || this.isAllied();
        }
        return this.m_canMoveAirUnitsOverOwnedLand.equals(PROPERTY_TRUE);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanMoveLandUnitsOverOwnedLand(String canFlyOver) {
        this.m_canMoveLandUnitsOverOwnedLand = canFlyOver;
    }

    public boolean getCanMoveLandUnitsOverOwnedLand() {
        if (this.m_canMoveLandUnitsOverOwnedLand.equals(PROPERTY_DEFAULT)) {
            return this.isWar() || this.isAllied();
        }
        return this.m_canMoveLandUnitsOverOwnedLand.equals(PROPERTY_TRUE);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanLandAirUnitsOnOwnedLand(String canLandAir) {
        this.m_canLandAirUnitsOnOwnedLand = canLandAir;
    }

    public boolean getCanLandAirUnitsOnOwnedLand() {
        if (this.m_canLandAirUnitsOnOwnedLand.equals(PROPERTY_DEFAULT)) {
            return this.isAllied();
        }
        return this.m_canLandAirUnitsOnOwnedLand.equals(PROPERTY_TRUE);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanTakeOverOwnedTerritory(String canTakeOver) {
        this.m_canTakeOverOwnedTerritory = canTakeOver;
    }

    public boolean getCanTakeOverOwnedTerritory() {
        if (this.m_canTakeOverOwnedTerritory.equals(PROPERTY_DEFAULT)) {
            return this.isWar();
        }
        return this.m_canTakeOverOwnedTerritory.equals(PROPERTY_TRUE);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setUpkeepCost(String integerCost) throws GameParseException {
        if (integerCost.equals(PROPERTY_DEFAULT)) {
            this.m_upkeepCost = PROPERTY_DEFAULT;
        } else {
            String[] s = integerCost.split(":");
            if (s.length < 1 || s.length > 2) {
                throw new GameParseException("upkeepCost must have either 1 or 2 fields" + this.thisErrorMsg());
            }
            int cost = RelationshipTypeAttachment.getInt(s[0]);
            if (s.length == 2 && !s[1].equals(UPKEEP_FLAT)) {
                if (s[1].equals(UPKEEP_PERCENTAGE)) {
                    if (cost > 100) {
                        throw new GameParseException("upkeepCost may not have a percentage greater than 100" + this.thisErrorMsg());
                    }
                } else {
                    throw new GameParseException("upkeepCost must have either: flat or percentage" + this.thisErrorMsg());
                }
            }
            this.m_upkeepCost = integerCost;
        }
    }

    public String getUpkeepCost() {
        if (this.m_upkeepCost.equals(PROPERTY_DEFAULT)) {
            return String.valueOf(0);
        }
        return this.m_upkeepCost;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAlliancesCanChainTogether(String value) throws GameParseException {
        if (!(value.equals(PROPERTY_DEFAULT) || value.equals(PROPERTY_FALSE) || value.equals(PROPERTY_TRUE))) {
            throw new GameParseException("alliancesCanChainTogether must be either default or false or true" + this.thisErrorMsg());
        }
        this.m_alliancesCanChainTogether = value;
    }

    public boolean getAlliancesCanChainTogether() {
        if (this.m_alliancesCanChainTogether.equals(PROPERTY_DEFAULT) || this.isWar() || this.isNeutral()) {
            return false;
        }
        return this.m_alliancesCanChainTogether.equals(PROPERTY_TRUE);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsDefaultWarPosition(String value) throws GameParseException {
        if (!(value.equals(PROPERTY_DEFAULT) || value.equals(PROPERTY_FALSE) || value.equals(PROPERTY_TRUE))) {
            throw new GameParseException("isDefaultWarPosition must be either default or false or true" + this.thisErrorMsg());
        }
        this.m_isDefaultWarPosition = value;
    }

    public boolean getIsDefaultWarPosition() {
        if (this.m_isDefaultWarPosition.equals(PROPERTY_DEFAULT) || this.isAllied() || this.isNeutral()) {
            return false;
        }
        return this.m_isDefaultWarPosition.equals(PROPERTY_TRUE);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setGivesBackOriginalTerritories(String value) throws GameParseException {
        if (!(value.equals(PROPERTY_DEFAULT) || value.equals(PROPERTY_FALSE) || value.equals(PROPERTY_TRUE))) {
            throw new GameParseException("givesBackOriginalTerritories must be either default or false or true" + this.thisErrorMsg());
        }
        this.m_givesBackOriginalTerritories = value;
    }

    public boolean getGivesBackOriginalTerritories() {
        if (this.m_givesBackOriginalTerritories.equals(PROPERTY_DEFAULT)) {
            return false;
        }
        return this.m_givesBackOriginalTerritories.equals(PROPERTY_TRUE);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanMoveIntoDuringCombatMove(String value) throws GameParseException {
        if (!(value.equals(PROPERTY_DEFAULT) || value.equals(PROPERTY_FALSE) || value.equals(PROPERTY_TRUE))) {
            throw new GameParseException("canMoveIntoDuringCombatMove must be either default or false or true" + this.thisErrorMsg());
        }
        this.m_canMoveIntoDuringCombatMove = value;
    }

    public boolean getCanMoveIntoDuringCombatMove() {
        if (this.m_canMoveIntoDuringCombatMove.equals(PROPERTY_DEFAULT)) {
            return true;
        }
        return this.m_canMoveIntoDuringCombatMove.equals(PROPERTY_TRUE);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanMoveThroughCanals(String value) throws GameParseException {
        if (!(value.equals(PROPERTY_DEFAULT) || value.equals(PROPERTY_FALSE) || value.equals(PROPERTY_TRUE))) {
            throw new GameParseException("canMoveIntoDuringCombatMove must be either default or false or true" + this.thisErrorMsg());
        }
        this.m_canMoveThroughCanals = value;
    }

    public boolean getCanMoveThroughCanals() {
        if (this.m_canMoveThroughCanals.equals(PROPERTY_DEFAULT)) {
            return this.isAllied();
        }
        return this.m_canMoveThroughCanals.equals(PROPERTY_TRUE);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRocketsCanFlyOver(String value) throws GameParseException {
        if (!(value.equals(PROPERTY_DEFAULT) || value.equals(PROPERTY_FALSE) || value.equals(PROPERTY_TRUE))) {
            throw new GameParseException("canMoveIntoDuringCombatMove must be either default or false or true" + this.thisErrorMsg());
        }
        this.m_rocketsCanFlyOver = value;
    }

    public boolean getRocketsCanFlyOver() {
        if (this.m_rocketsCanFlyOver.equals(PROPERTY_DEFAULT)) {
            return true;
        }
        return this.m_rocketsCanFlyOver.equals(PROPERTY_TRUE);
    }

    public boolean isWar() {
        return this.m_archeType.equals(ARCHETYPE_WAR);
    }

    public boolean isAllied() {
        return this.m_archeType.equals(ARCHETYPE_ALLIED);
    }

    public boolean isNeutral() {
        return this.m_archeType.equals(ARCHETYPE_NEUTRAL);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setHelpsDefendAtSea(String helpsDefendAtSea) throws GameParseException {
        if (helpsDefendAtSea.toLowerCase().equals(PROPERTY_TRUE)) {
            this.m_helpsDefendAtSea = PROPERTY_TRUE;
        } else if (helpsDefendAtSea.toLowerCase().equals(PROPERTY_FALSE)) {
            this.m_helpsDefendAtSea = PROPERTY_FALSE;
        } else if (helpsDefendAtSea.toLowerCase().equals(PROPERTY_DEFAULT)) {
            this.m_helpsDefendAtSea = PROPERTY_DEFAULT;
        } else {
            throw new GameParseException("helpsDefendAtSea must be true,false or default for " + this.thisErrorMsg());
        }
    }

    public boolean getHelpsDefendAtSea() {
        if (this.m_helpsDefendAtSea.equals(PROPERTY_DEFAULT)) {
            return this.isAllied();
        }
        return this.m_helpsDefendAtSea.equals(PROPERTY_TRUE);
    }

    public void validate(GameData data) throws GameParseException {
    }
}

