/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.attatchments;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.BattleRecordsList;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.IAttachment;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.RelationshipTracker;
import games.strategy.engine.data.RelationshipType;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.data.annotations.GameProperty;
import games.strategy.engine.data.annotations.InternalDoNotExport;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.AbstractPlayerRulesAttachment;
import games.strategy.triplea.attatchments.ICondition;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TechAdvance;
import games.strategy.triplea.delegate.TechTracker;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesAttachment
extends AbstractPlayerRulesAttachment
implements ICondition {
    private static final long serialVersionUID = 7301965634079412516L;
    private ArrayList<TechAdvance> m_techs = null;
    @InternalDoNotExport
    private int m_techCount = -1;
    private ArrayList<String> m_relationship = new ArrayList();
    private HashSet<PlayerID> m_atWarPlayers = null;
    @InternalDoNotExport
    private int m_atWarCount = -1;
    private String m_destroyedTUV = null;
    private ArrayList<Tuple<String, ArrayList<Territory>>> m_battle = new ArrayList();
    private String[] m_alliedOwnershipTerritories;
    private String[] m_directOwnershipTerritories;
    private String[] m_alliedExclusionTerritories;
    private String[] m_directExclusionTerritories;
    private String[] m_enemyExclusionTerritories;
    private String[] m_enemySurfaceExclusionTerritories;
    private String[] m_directPresenceTerritories;
    private String[] m_alliedPresenceTerritories;
    private String[] m_enemyPresenceTerritories;
    private IntegerMap<String> m_unitPresence = new IntegerMap();

    public RulesAttachment(String name, Attachable attachable, GameData gameData) {
        super(name, attachable, gameData);
    }

    public static RulesAttachment get(PlayerID player, String nameOfAttachment) {
        RulesAttachment rVal = (RulesAttachment)player.getAttachment(nameOfAttachment);
        if (rVal == null) {
            throw new IllegalStateException("Rules & Conditions: No rule attachment for:" + player.getName() + " with name: " + nameOfAttachment);
        }
        return rVal;
    }

    public static Set<RulesAttachment> getNationalObjectives(PlayerID player, GameData data) {
        HashSet<RulesAttachment> natObjs = new HashSet<RulesAttachment>();
        Map<String, IAttachment> map = player.getAttachments();
        for (Map.Entry<String, IAttachment> entry : map.entrySet()) {
            IAttachment attachment = entry.getValue();
            if (!(attachment instanceof RulesAttachment) || !attachment.getName().startsWith("objectiveAttachment")) continue;
            natObjs.add((RulesAttachment)attachment);
        }
        return natObjs;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setDestroyedTUV(String value) throws GameParseException {
        if (value == null) {
            this.m_destroyedTUV = null;
            return;
        }
        String[] s = value.split(":");
        if (s.length != 2) {
            throw new GameParseException("destroyedTUV must have 2 fields, value=currentRound/allRounds, count= the amount of TUV that this player must destroy" + this.thisErrorMsg());
        }
        int i = RulesAttachment.getInt(s[0]);
        if (i < -1) {
            throw new GameParseException("destroyedTUV count can not be less than -1 [with -1 meaning the condition is not active]" + this.thisErrorMsg());
        }
        if (!s[1].equals("currentRound") && !s[1].equals("allRounds")) {
            throw new GameParseException("destroyedTUV value must be currentRound or allRounds" + this.thisErrorMsg());
        }
        this.m_destroyedTUV = value;
    }

    public String getDestroyedTUV() {
        return this.m_destroyedTUV;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setBattle(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length < 5) {
            throw new GameParseException("battle must have at least 5 fields, attacker:defender:resultType:round:territory1..." + this.thisErrorMsg());
        }
        PlayerID attacker = this.getData().getPlayerList().getPlayerID(s[0]);
        if (attacker == null && !s[0].equalsIgnoreCase("any")) {
            throw new GameParseException("no player named: " + s[0] + this.thisErrorMsg());
        }
        PlayerID defender = this.getData().getPlayerList().getPlayerID(s[1]);
        if (defender == null && !s[1].equalsIgnoreCase("any")) {
            throw new GameParseException("no player named: " + s[1] + this.thisErrorMsg());
        }
        if (!s[2].equalsIgnoreCase("any")) {
            throw new GameParseException("battle allows the following for resultType: any" + this.thisErrorMsg());
        }
        if (!s[3].equalsIgnoreCase("currentRound")) {
            try {
                RulesAttachment.getInt(s[3].split("-")[0]);
                RulesAttachment.getInt(s[3].split("-")[1]);
            }
            catch (Exception e) {
                throw new GameParseException("round must either be currentRound or two numbers like: 2-4" + this.thisErrorMsg());
            }
        }
        ArrayList<Territory> terrs = new ArrayList<Territory>();
        GameMap map = this.getData().getMap();
        for (int i = 4; i < s.length; ++i) {
            Territory t = map.getTerritory(s[i]);
            if (t == null) {
                throw new GameParseException("no such territory called: " + s[i] + this.thisErrorMsg());
            }
            terrs.add(t);
        }
        this.m_battle.add(new Tuple(s[0] + ":" + s[1] + ":" + s[2] + ":" + s[3], terrs));
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setBattle(ArrayList<Tuple<String, ArrayList<Territory>>> value) {
        this.m_battle = value;
    }

    public ArrayList<Tuple<String, ArrayList<Territory>>> getBattle() {
        return this.m_battle;
    }

    public void clearBattle() {
        this.m_battle.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setRelationship(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length < 3 || s.length > 4) {
            throw new GameParseException("relationship should have value=\"playername1:playername2:relationshiptype:numberOfRoundsExisting\"" + this.thisErrorMsg());
        }
        if (this.getData().getPlayerList().getPlayerID(s[0]) == null) {
            throw new GameParseException("playername: " + s[0] + " isn't valid in condition with relationship: " + value + this.thisErrorMsg());
        }
        if (this.getData().getPlayerList().getPlayerID(s[1]) == null) {
            throw new GameParseException("playername: " + s[1] + " isn't valid in condition with relationship: " + value + this.thisErrorMsg());
        }
        if (!(s[2].equals("anyAllied") || s[2].equals("anyNeutral") || s[2].equals("anyWar") || Matches.isValidRelationshipName(this.getData()).match(s[2]))) {
            throw new GameParseException("relationship: " + s[2] + " isn't valid in condition with relationship: " + value + this.thisErrorMsg());
        }
        if (s.length == 4 && Integer.parseInt(s[3]) < -1) {
            throw new GameParseException("numberOfRoundsExisting should be a number between -1 and 100000.  -1 should be default value if you don't know what to put" + this.thisErrorMsg());
        }
        this.m_relationship.add(s.length == 3 ? value + ":-1" : value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRelationship(ArrayList<String> value) {
        this.m_relationship = value;
    }

    public ArrayList<String> getRelationship() {
        return this.m_relationship;
    }

    public void clearRelationship() {
        this.m_relationship.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAlliedOwnershipTerritories(String value) throws GameParseException {
        if (value == null) {
            this.m_alliedOwnershipTerritories = null;
            return;
        }
        this.m_alliedOwnershipTerritories = value.split(":");
        this.validateNames(this.m_alliedOwnershipTerritories);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAlliedOwnershipTerritories(String[] value) {
        this.m_alliedOwnershipTerritories = value;
    }

    public String[] getAlliedOwnershipTerritories() {
        return this.m_alliedOwnershipTerritories;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAlliedExclusionTerritories(String value) throws GameParseException {
        if (value == null) {
            this.m_alliedExclusionTerritories = null;
            return;
        }
        this.m_alliedExclusionTerritories = value.split(":");
        this.validateNames(this.m_alliedExclusionTerritories);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAlliedExclusionTerritories(String[] value) {
        this.m_alliedExclusionTerritories = value;
    }

    public String[] getAlliedExclusionTerritories() {
        return this.m_alliedExclusionTerritories;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setDirectExclusionTerritories(String value) throws GameParseException {
        if (value == null) {
            this.m_directExclusionTerritories = null;
            return;
        }
        this.m_directExclusionTerritories = value.split(":");
        this.validateNames(this.m_directExclusionTerritories);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setDirectExclusionTerritories(String[] value) {
        this.m_directExclusionTerritories = value;
    }

    public String[] getDirectExclusionTerritories() {
        return this.m_directExclusionTerritories;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setEnemyExclusionTerritories(String value) throws GameParseException {
        if (value == null) {
            this.m_enemyExclusionTerritories = null;
            return;
        }
        this.m_enemyExclusionTerritories = value.split(":");
        this.validateNames(this.m_enemyExclusionTerritories);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setEnemyExclusionTerritories(String[] value) {
        this.m_enemyExclusionTerritories = value;
    }

    public String[] getEnemyExclusionTerritories() {
        return this.m_enemyExclusionTerritories;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setDirectPresenceTerritories(String value) throws GameParseException {
        if (value == null) {
            this.m_directPresenceTerritories = null;
            return;
        }
        this.m_directPresenceTerritories = value.split(":");
        this.validateNames(this.m_directPresenceTerritories);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setDirectPresenceTerritories(String[] value) {
        this.m_directPresenceTerritories = value;
    }

    public String[] getDirectPresenceTerritories() {
        return this.m_directPresenceTerritories;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAlliedPresenceTerritories(String value) throws GameParseException {
        if (value == null) {
            this.m_alliedPresenceTerritories = null;
            return;
        }
        this.m_alliedPresenceTerritories = value.split(":");
        this.validateNames(this.m_alliedPresenceTerritories);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAlliedPresenceTerritories(String[] value) {
        this.m_alliedPresenceTerritories = value;
    }

    public String[] getAlliedPresenceTerritories() {
        return this.m_alliedPresenceTerritories;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setEnemyPresenceTerritories(String value) throws GameParseException {
        if (value == null) {
            this.m_enemyPresenceTerritories = null;
            return;
        }
        this.m_enemyPresenceTerritories = value.split(":");
        this.validateNames(this.m_enemyPresenceTerritories);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setEnemyPresenceTerritories(String[] value) {
        this.m_enemyPresenceTerritories = value;
    }

    public String[] getEnemyPresenceTerritories() {
        return this.m_enemyPresenceTerritories;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setEnemySurfaceExclusionTerritories(String value) throws GameParseException {
        if (value == null) {
            this.m_enemySurfaceExclusionTerritories = null;
            return;
        }
        this.m_enemySurfaceExclusionTerritories = value.split(":");
        this.validateNames(this.m_enemySurfaceExclusionTerritories);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setEnemySurfaceExclusionTerritories(String[] value) {
        this.m_enemySurfaceExclusionTerritories = value;
    }

    public String[] getEnemySurfaceExclusionTerritories() {
        return this.m_enemySurfaceExclusionTerritories;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setDirectOwnershipTerritories(String value) throws GameParseException {
        if (value == null) {
            this.m_directOwnershipTerritories = null;
            return;
        }
        this.m_directOwnershipTerritories = value.split(":");
        this.validateNames(this.m_directOwnershipTerritories);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setDirectOwnershipTerritories(String[] value) {
        this.m_directOwnershipTerritories = value;
    }

    public String[] getDirectOwnershipTerritories() {
        return this.m_directOwnershipTerritories;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setUnitPresence(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length <= 1) {
            throw new GameParseException("unitPresence must have at least 2 fields. Format value=unit1 count=number, or value=unit1:unit2:unit3 count=number" + this.thisErrorMsg());
        }
        int n = RulesAttachment.getInt(s[0]);
        if (n < 0) {
            throw new GameParseException("unitPresence must be a positive integer" + this.thisErrorMsg());
        }
        for (int i = 1; i < s.length; ++i) {
            String unitTypeToProduce = s[i];
            UnitType ut = this.getData().getUnitTypeList().getUnitType(unitTypeToProduce);
            if (ut != null || unitTypeToProduce.equals("any") || unitTypeToProduce.equals("ANY")) continue;
            throw new GameParseException("No unit called: " + unitTypeToProduce + this.thisErrorMsg());
        }
        value = value.replaceFirst(s[0] + ":", "");
        this.m_unitPresence.put(value, n);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setUnitPresence(IntegerMap<String> value) {
        this.m_unitPresence = value;
    }

    public IntegerMap<String> getUnitPresence() {
        return this.m_unitPresence;
    }

    public void clearUnitPresence() {
        this.m_unitPresence.clear();
    }

    public int getAtWarCount() {
        return this.m_atWarCount;
    }

    public int getTechCount() {
        return this.m_techCount;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAtWarPlayers(String players) throws GameParseException {
        int i;
        if (players == null) {
            this.m_atWarPlayers = null;
            return;
        }
        String[] s = players.split(":");
        int count = -1;
        if (s.length < 1) {
            throw new GameParseException("Empty enemy list" + this.thisErrorMsg());
        }
        try {
            this.m_atWarCount = count = RulesAttachment.getInt(s[0]);
        }
        catch (Exception e) {
            this.m_atWarCount = 0;
        }
        if (s.length < 1 || s.length == 1 && count != -1) {
            throw new GameParseException("Empty enemy list" + this.thisErrorMsg());
        }
        this.m_atWarPlayers = new HashSet();
        int n = i = count == -1 ? 0 : 1;
        while (i < s.length) {
            PlayerID player = this.getData().getPlayerList().getPlayerID(s[i]);
            if (player == null) {
                throw new GameParseException("Could not find player. name:" + s[i] + this.thisErrorMsg());
            }
            this.m_atWarPlayers.add(player);
            ++i;
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAtWarPlayers(HashSet<PlayerID> value) {
        this.m_atWarPlayers = value;
    }

    public HashSet<PlayerID> getAtWarPlayers() {
        return this.m_atWarPlayers;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setTechs(String techs) throws GameParseException {
        int i;
        if (techs == null) {
            this.m_techs = null;
            return;
        }
        String[] s = techs.split(":");
        int count = -1;
        if (s.length < 1) {
            throw new GameParseException("Empty tech list" + this.thisErrorMsg());
        }
        try {
            this.m_techCount = count = RulesAttachment.getInt(s[0]);
        }
        catch (Exception e) {
            this.m_techCount = 0;
        }
        if (s.length < 1 || s.length == 1 && count != -1) {
            throw new GameParseException("Empty tech list" + this.thisErrorMsg());
        }
        this.m_techs = new ArrayList();
        int n = i = count == -1 ? 0 : 1;
        while (i < s.length) {
            TechAdvance ta = this.getData().getTechnologyFrontier().getAdvanceByProperty(s[i]);
            if (ta == null) {
                ta = this.getData().getTechnologyFrontier().getAdvanceByName(s[i]);
            }
            if (ta == null) {
                throw new GameParseException("Technology not found :" + s + this.thisErrorMsg());
            }
            this.m_techs.add(ta);
            ++i;
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setTechs(ArrayList<TechAdvance> value) {
        this.m_techs = value;
    }

    public ArrayList<TechAdvance> getTechs() {
        return this.m_techs;
    }

    @Override
    public boolean isSatisfied(HashMap<ICondition, Boolean> testedConditions) {
        if (testedConditions == null) {
            throw new IllegalStateException("testedConditions can not be null");
        }
        if (!testedConditions.containsKey(this)) {
            throw new IllegalStateException("testedConditions is incomplete and does not contain " + this.toString());
        }
        return testedConditions.get(this);
    }

    @Override
    public boolean isSatisfied(HashMap<ICondition, Boolean> testedConditions, IDelegateBridge aBridge) {
        String[] s;
        int requiredDestroyedTUV;
        List<PlayerID> enemies;
        String value;
        String[] terrs;
        if (testedConditions != null && testedConditions.containsKey(this)) {
            return testedConditions.get(this);
        }
        boolean objectiveMet = true;
        ArrayList<PlayerID> players = this.getPlayers();
        GameData data = aBridge.getData();
        if (objectiveMet && this.m_conditions.size() > 0) {
            if (testedConditions == null) {
                testedConditions = RulesAttachment.testAllConditionsRecursive(RulesAttachment.getAllConditionsRecursive(new HashSet<ICondition>(this.m_conditions), null), null, aBridge);
            }
            objectiveMet = RulesAttachment.areConditionsMet(new ArrayList<ICondition>(this.m_conditions), testedConditions, this.m_conditionType);
        }
        if (objectiveMet) {
            objectiveMet = this.m_switch;
        }
        if (objectiveMet && this.m_turns != null) {
            objectiveMet = this.checkTurns(data);
        }
        if (objectiveMet && this.getDirectPresenceTerritories() != null) {
            terrs = this.getDirectPresenceTerritories();
            value = new String();
            value = this.getTerritoryListAsStringBasedOnInputFromXML(terrs, players, data);
            terrs = value.split(":");
            objectiveMet = this.checkUnitPresence(objectiveMet, this.getListedTerritories(terrs), "direct", this.getTerritoryCount(), players, data);
        }
        if (objectiveMet && this.getAlliedPresenceTerritories() != null) {
            terrs = this.getAlliedPresenceTerritories();
            value = new String();
            value = this.getTerritoryListAsStringBasedOnInputFromXML(terrs, players, data);
            terrs = value.split(":");
            objectiveMet = this.checkUnitPresence(objectiveMet, this.getListedTerritories(terrs), "allied", this.getTerritoryCount(), players, data);
        }
        if (objectiveMet && this.getEnemyPresenceTerritories() != null) {
            terrs = this.getEnemyPresenceTerritories();
            value = new String();
            value = this.getTerritoryListAsStringBasedOnInputFromXML(terrs, players, data);
            terrs = value.split(":");
            objectiveMet = this.checkUnitPresence(objectiveMet, this.getListedTerritories(terrs), "enemy", this.getTerritoryCount(), players, data);
        }
        if (objectiveMet && this.getDirectExclusionTerritories() != null) {
            terrs = this.getDirectExclusionTerritories();
            value = new String();
            value = this.getTerritoryListAsStringBasedOnInputFromXML(terrs, players, data);
            terrs = value.split(":");
            objectiveMet = this.checkUnitExclusions(objectiveMet, this.getListedTerritories(terrs), "direct", this.getTerritoryCount(), players, data);
        }
        if (objectiveMet && this.getAlliedExclusionTerritories() != null) {
            terrs = this.getAlliedExclusionTerritories();
            value = new String();
            value = this.getTerritoryListAsStringBasedOnInputFromXML(terrs, players, data);
            terrs = value.split(":");
            objectiveMet = this.checkUnitExclusions(objectiveMet, this.getListedTerritories(terrs), "allied", this.getTerritoryCount(), players, data);
        }
        if (objectiveMet && this.getEnemyExclusionTerritories() != null) {
            terrs = this.getEnemyExclusionTerritories();
            value = new String();
            value = this.getTerritoryListAsStringBasedOnInputFromXML(terrs, players, data);
            terrs = value.split(":");
            objectiveMet = this.checkUnitExclusions(objectiveMet, this.getListedTerritories(terrs), "enemy", this.getTerritoryCount(), players, data);
        }
        if (objectiveMet && this.getEnemySurfaceExclusionTerritories() != null) {
            terrs = this.getEnemySurfaceExclusionTerritories();
            value = new String();
            value = this.getTerritoryListAsStringBasedOnInputFromXML(terrs, players, data);
            terrs = value.split(":");
            objectiveMet = this.checkUnitExclusions(objectiveMet, this.getListedTerritories(terrs), "enemy_surface", this.getTerritoryCount(), players, data);
        }
        if (objectiveMet && this.getAlliedOwnershipTerritories() != null) {
            List<PlayerID> allies;
            terrs = this.getAlliedOwnershipTerritories();
            value = new String();
            if (terrs.length == 1) {
                if (terrs[0].equals("original")) {
                    allies = Match.getMatches(data.getPlayerList().getPlayers(), Matches.isAlliedWithAnyOfThesePlayers(players, data));
                    value = value + ":" + this.getTerritoryListAsStringBasedOnInputFromXML(terrs, allies, data);
                    value = value.replaceFirst(":", "");
                } else if (terrs[0].equals("enemy")) {
                    enemies = Match.getMatches(data.getPlayerList().getPlayers(), Matches.isAtWarWithAnyOfThesePlayers(players, data));
                    value = value + ":" + this.getTerritoryListAsStringBasedOnInputFromXML(terrs, enemies, data);
                    value = value.replaceFirst(":", "");
                } else {
                    value = this.getTerritoryListAsStringBasedOnInputFromXML(terrs, players, data);
                }
            } else if (terrs.length == 2) {
                if (terrs[1].equals("original")) {
                    allies = Match.getMatches(data.getPlayerList().getPlayers(), Matches.isAlliedWithAnyOfThesePlayers(players, data));
                    value = value + ":" + this.getTerritoryListAsStringBasedOnInputFromXML(terrs, allies, data);
                    value = value.replaceFirst(":", "");
                } else if (terrs[1].equals("enemy")) {
                    enemies = Match.getMatches(data.getPlayerList().getPlayers(), Matches.isAtWarWithAnyOfThesePlayers(players, data));
                    value = value + ":" + this.getTerritoryListAsStringBasedOnInputFromXML(terrs, enemies, data);
                    value = value.replaceFirst(":", "");
                } else {
                    value = this.getTerritoryListAsStringBasedOnInputFromXML(terrs, players, data);
                }
            } else {
                value = this.getTerritoryListAsStringBasedOnInputFromXML(terrs, players, data);
            }
            terrs = value.split(":");
            objectiveMet = this.checkAlliedOwnership(objectiveMet, this.getListedTerritories(terrs), this.getTerritoryCount(), players, data);
        }
        if (objectiveMet && this.getDirectOwnershipTerritories() != null) {
            terrs = this.getDirectOwnershipTerritories();
            value = new String();
            if (terrs.length == 1) {
                if (terrs[0].equals("original")) {
                    value = this.getTerritoryListAsStringBasedOnInputFromXML(terrs, players, data);
                } else if (terrs[0].equals("enemy")) {
                    enemies = Match.getMatches(data.getPlayerList().getPlayers(), Matches.isAtWarWithAnyOfThesePlayers(players, data));
                    value = value + ":" + this.getTerritoryListAsStringBasedOnInputFromXML(terrs, enemies, data);
                    value = value.replaceFirst(":", "");
                } else {
                    value = this.getTerritoryListAsStringBasedOnInputFromXML(terrs, players, data);
                }
            } else if (terrs.length == 2) {
                if (terrs[1].equals("original")) {
                    value = this.getTerritoryListAsStringBasedOnInputFromXML(terrs, players, data);
                } else if (terrs[1].equals("enemy")) {
                    enemies = Match.getMatches(data.getPlayerList().getPlayers(), Matches.isAtWarWithAnyOfThesePlayers(players, data));
                    value = value + ":" + this.getTerritoryListAsStringBasedOnInputFromXML(terrs, enemies, data);
                    value = value.replaceFirst(":", "");
                } else {
                    value = this.getTerritoryListAsStringBasedOnInputFromXML(terrs, players, data);
                }
            } else {
                value = this.getTerritoryListAsStringBasedOnInputFromXML(terrs, players, data);
            }
            terrs = value.split(":");
            objectiveMet = this.checkDirectOwnership(objectiveMet, this.getListedTerritories(terrs), this.getTerritoryCount(), players);
        }
        PlayerID playerAttachedTo = (PlayerID)this.getAttachedTo();
        if (objectiveMet && this.getAtWarPlayers() != null) {
            objectiveMet = this.checkAtWar(playerAttachedTo, this.getAtWarPlayers(), this.getAtWarCount(), data);
        }
        if (objectiveMet && this.m_techs != null) {
            objectiveMet = this.checkTechs(playerAttachedTo, data);
        }
        if (objectiveMet && this.m_relationship.size() > 0) {
            objectiveMet = this.checkRelationships();
        }
        if (objectiveMet && this.m_destroyedTUV != null && (requiredDestroyedTUV = RulesAttachment.getInt((s = this.m_destroyedTUV.split(":"))[0])) >= 0) {
            boolean justCurrentRound = s[1].equals("currentRound");
            int destroyedTUVforThisRoundSoFar = BattleRecordsList.getTUVdamageCausedByPlayer(playerAttachedTo, data.getBattleRecordsList(), 0, data.getSequence().getRound(), justCurrentRound, false);
            if (requiredDestroyedTUV > destroyedTUVforThisRoundSoFar) {
                objectiveMet = false;
            }
            if (this.getCountEach()) {
                this.m_eachMultiple = destroyedTUVforThisRoundSoFar;
            }
        }
        if (objectiveMet && !this.m_battle.isEmpty()) {
            BattleRecordsList brl = data.getBattleRecordsList();
            int round = data.getSequence().getRound();
            for (Tuple<String, ArrayList<Territory>> entry : this.m_battle) {
                String[] type = entry.getFirst().split(":");
                PlayerID attacker = data.getPlayerList().getPlayerID(type[0]);
                PlayerID defender = data.getPlayerList().getPlayerID(type[1]);
                String resultType = type[2];
                String roundType = type[3];
                int start = 0;
                int end = round;
                boolean currentRound = roundType.equalsIgnoreCase("currentRound");
                if (!currentRound) {
                    String[] rounds = roundType.split("-");
                    start = RulesAttachment.getInt(rounds[0]);
                    end = RulesAttachment.getInt(rounds[1]);
                }
                if (objectiveMet = BattleRecordsList.getWereThereBattlesInTerritoriesMatching(attacker, defender, resultType, (Collection<Territory>)entry.getSecond(), brl, start, end, currentRound)) continue;
                break;
            }
        }
        int hitTarget = RulesAttachment.getInt(this.m_chance.split(":")[0]);
        int diceSides = RulesAttachment.getInt(this.m_chance.split(":")[1]);
        if (objectiveMet && hitTarget != diceSides) {
            int rollResult = aBridge.getRandom(diceSides, "Attempting the Condition: " + MyFormatter.attachmentNameToText(this.getName())) + 1;
            objectiveMet = rollResult <= hitTarget;
            String notificationMessage = "Rolling (" + hitTarget + " out of " + diceSides + ") result: " + rollResult + " = " + (objectiveMet ? "Success!" : "Failure!") + " (for " + MyFormatter.attachmentNameToText(this.getName()) + ")";
            aBridge.getHistoryWriter().startEvent(notificationMessage);
            ((ITripleaPlayer)aBridge.getRemote(aBridge.getPlayerID())).reportMessage(notificationMessage, notificationMessage);
        }
        return objectiveMet != this.m_invert;
    }

    private boolean checkRelationships() {
        for (String aRelationCheck : this.m_relationship) {
            String[] relationCheck = aRelationCheck.split(":");
            PlayerID p1 = this.getData().getPlayerList().getPlayerID(relationCheck[0]);
            PlayerID p2 = this.getData().getPlayerList().getPlayerID(relationCheck[1]);
            int relationshipsExistance = Integer.parseInt(relationCheck[3]);
            RelationshipTracker.Relationship currentRelationship = this.getData().getRelationshipTracker().getRelationship(p1, p2);
            RelationshipType currentRelationshipType = currentRelationship.getRelationshipType();
            if (!this.relationShipExistsLongEnnough(currentRelationship, relationshipsExistance)) {
                return false;
            }
            if (relationCheck[2].equals("anyAllied") && Matches.RelationshipTypeIsAllied.match(currentRelationshipType) || relationCheck[2].equals("anyNeutral") && Matches.RelationshipTypeIsNeutral.match(currentRelationshipType) || relationCheck[2].equals("anyWar") && Matches.RelationshipTypeIsAtWar.match(currentRelationshipType) || currentRelationshipType.equals(this.getData().getRelationshipTypeList().getRelationshipType(relationCheck[2]))) continue;
            return false;
        }
        return true;
    }

    private boolean relationShipExistsLongEnnough(RelationshipTracker.Relationship r, int relationshipsExistance) {
        int roundCurrentRelationshipWasCreated = r.getRoundCreated();
        return this.getData().getSequence().getRound() - (roundCurrentRelationshipWasCreated += Properties.getRelationshipsLastExtraRounds(this.getData())) >= relationshipsExistance;
    }

    private boolean checkUnitPresence(boolean satisfied, Collection<Territory> Territories, String exclType, int numberNeeded, List<PlayerID> players, GameData data) {
        int numberMet = 0;
        satisfied = false;
        boolean useSpecific = false;
        if (this.getUnitPresence() != null && !this.getUnitPresence().keySet().isEmpty()) {
            useSpecific = true;
        }
        for (Territory terr : Territories) {
            Collection<Unit> allUnits = terr.getUnits().getUnits();
            if (exclType.equals("direct")) {
                allUnits.removeAll(Match.getMatches(allUnits, Matches.unitIsOwnedByOfAnyOfThesePlayers(players).invert()));
            } else if (exclType.equals("allied")) {
                allUnits.retainAll(Match.getMatches(allUnits, Matches.alliedUnitOfAnyOfThesePlayers(players, data)));
            } else if (exclType.equals("enemy")) {
                allUnits.retainAll(Match.getMatches(allUnits, Matches.enemyUnitOfAnyOfThesePlayers(players, data)));
            } else {
                return false;
            }
            if (allUnits.size() <= 0) continue;
            if (!useSpecific) {
                if (++numberMet < numberNeeded) continue;
                satisfied = true;
                if (this.getCountEach()) continue;
                break;
            }
            if (!useSpecific) continue;
            IntegerMap<String> unitComboMap = this.getUnitPresence();
            Set<String> unitCombos = unitComboMap.keySet();
            boolean hasEnough = false;
            for (String uc : unitCombos) {
                Set<UnitType> typesAllowed;
                int unitsNeeded = unitComboMap.getInt(uc);
                hasEnough = uc == null || uc.equals("ANY") || uc.equals("any") ? allUnits.size() >= unitsNeeded : Match.getMatches(allUnits, Matches.unitIsOfTypes(typesAllowed = data.getUnitTypeList().getUnitTypes(uc.split(":")))).size() >= unitsNeeded;
                if (hasEnough) continue;
                break;
            }
            if (!hasEnough || ++numberMet < numberNeeded) continue;
            satisfied = true;
            if (this.getCountEach()) continue;
            break;
        }
        if (this.getCountEach()) {
            this.m_eachMultiple = numberMet;
        }
        return satisfied;
    }

    private boolean checkUnitExclusions(boolean satisfied, Collection<Territory> Territories, String exclType, int numberNeeded, List<PlayerID> players, GameData data) {
        int numberMet = 0;
        satisfied = false;
        boolean useSpecific = false;
        if (this.getUnitPresence() != null && !this.getUnitPresence().keySet().isEmpty()) {
            useSpecific = true;
        }
        for (Territory terr : Territories) {
            Collection<Unit> allUnits = terr.getUnits().getUnits();
            if (exclType.equals("allied")) {
                allUnits.removeAll(Match.getMatches(allUnits, Matches.unitIsOwnedByOfAnyOfThesePlayers(players)));
                allUnits.retainAll(Match.getMatches(allUnits, Matches.alliedUnitOfAnyOfThesePlayers(players, data)));
            } else if (exclType.equals("direct")) {
                allUnits.removeAll(Match.getMatches(allUnits, Matches.unitIsOwnedByOfAnyOfThesePlayers(players).invert()));
            } else if (exclType.equals("enemy")) {
                allUnits.retainAll(Match.getMatches(allUnits, Matches.enemyUnitOfAnyOfThesePlayers(players, data)));
            } else if (exclType.equals("enemy_surface")) {
                allUnits.retainAll(Match.getMatches(allUnits, new CompositeMatchAnd(Matches.enemyUnitOfAnyOfThesePlayers(players, data), Matches.UnitIsNotSub, Matches.UnitIsNotTransportButCouldBeCombatTransport)));
            } else {
                return false;
            }
            if (allUnits.size() == 0) {
                if (++numberMet < numberNeeded) continue;
                satisfied = true;
                if (this.getCountEach()) continue;
                break;
            }
            if (!useSpecific) continue;
            IntegerMap<String> unitComboMap = this.getUnitPresence();
            Set<String> unitCombos = unitComboMap.keySet();
            boolean hasLess = false;
            for (String uc : unitCombos) {
                Set<UnitType> typesAllowed;
                int unitsMax = unitComboMap.getInt(uc);
                hasLess = uc == null || uc.equals("ANY") || uc.equals("any") ? allUnits.size() <= unitsMax : Match.getMatches(allUnits, Matches.unitIsOfTypes(typesAllowed = data.getUnitTypeList().getUnitTypes(uc.split(":")))).size() <= unitsMax;
                if (hasLess) continue;
                break;
            }
            if (!hasLess || ++numberMet < numberNeeded) continue;
            satisfied = true;
            if (this.getCountEach()) continue;
            break;
        }
        if (this.getCountEach()) {
            this.m_eachMultiple = numberMet;
        }
        return satisfied;
    }

    private boolean checkAlliedOwnership(boolean satisfied, Collection<Territory> listedTerrs, int numberNeeded, Collection<PlayerID> players, GameData data) {
        int numberMet = 0;
        satisfied = false;
        List<PlayerID> allies = Match.getMatches(data.getPlayerList().getPlayers(), Matches.isAlliedWithAnyOfThesePlayers(players, data));
        for (Territory listedTerr : listedTerrs) {
            if (!Matches.isTerritoryOwnedBy(allies).match(listedTerr) || ++numberMet < numberNeeded) continue;
            satisfied = true;
            if (this.getCountEach()) continue;
            break;
        }
        if (this.getCountEach()) {
            this.m_eachMultiple = numberMet;
        }
        return satisfied;
    }

    private boolean checkDirectOwnership(boolean satisfied, Collection<Territory> listedTerrs, int numberNeeded, Collection<PlayerID> players) {
        int numberMet = 0;
        satisfied = false;
        for (Territory listedTerr : listedTerrs) {
            if (!Matches.isTerritoryOwnedBy(players).match(listedTerr) || ++numberMet < numberNeeded) continue;
            satisfied = true;
            if (this.getCountEach()) continue;
            break;
        }
        if (this.getCountEach()) {
            this.m_eachMultiple = numberMet;
        }
        return satisfied;
    }

    private boolean checkAtWar(PlayerID player, Set<PlayerID> enemies, int count, GameData data) {
        int found = 0;
        for (PlayerID e : enemies) {
            if (!data.getRelationshipTracker().isAtWar(player, e)) continue;
            ++found;
        }
        if (count == 0) {
            return count == found;
        }
        if (this.getCountEach()) {
            this.m_eachMultiple = found;
        }
        return found >= count;
    }

    private boolean checkTechs(PlayerID player, GameData data) {
        int found = 0;
        for (TechAdvance a : TechTracker.getTechAdvances(player, data)) {
            if (!this.m_techs.contains(a)) continue;
            ++found;
        }
        if (this.m_techCount == 0) {
            return this.m_techCount == found;
        }
        if (this.getCountEach()) {
            this.m_eachMultiple = found;
        }
        return found >= this.m_techCount;
    }

    @Override
    public void validate(GameData data) throws GameParseException {
        super.validate(data);
        this.validateNames(this.m_alliedOwnershipTerritories);
        this.validateNames(this.m_enemyExclusionTerritories);
        this.validateNames(this.m_enemySurfaceExclusionTerritories);
        this.validateNames(this.m_alliedExclusionTerritories);
        this.validateNames(this.m_directExclusionTerritories);
        this.validateNames(this.m_directOwnershipTerritories);
        this.validateNames(this.m_directPresenceTerritories);
        this.validateNames(this.m_alliedPresenceTerritories);
        this.validateNames(this.m_enemyPresenceTerritories);
    }
}

