/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.attatchments;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.DefaultAttachment;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.data.annotations.GameProperty;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.TechAbilityAttachment;
import games.strategy.triplea.attatchments.TechAttachment;
import games.strategy.triplea.attatchments.UnitSupportAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TechTracker;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import games.strategy.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitAttachment
extends DefaultAttachment {
    private static final long serialVersionUID = -2946748686268541820L;
    public static final String UNITSMAYNOTLANDONCARRIER = "unitsMayNotLandOnCarrier";
    public static final String UNITSMAYNOTLEAVEALLIEDCARRIER = "unitsMayNotLeaveAlliedCarrier";
    private boolean m_isAir = false;
    private boolean m_isSea = false;
    private int m_movement = 0;
    private boolean m_canBlitz = false;
    private boolean m_isKamikaze = false;
    private String[] m_canInvadeOnlyFrom;
    private IntegerMap<Resource> m_fuelCost = new IntegerMap();
    private boolean m_canNotMoveDuringCombatMove = false;
    private Tuple<Integer, String> m_movementLimit = null;
    private int m_attack = 0;
    private int m_defense = 0;
    private boolean m_isInfrastructure = false;
    private boolean m_canBombard = false;
    private int m_bombard = -1;
    private boolean m_isSub = false;
    private boolean m_isDestroyer = false;
    private boolean m_artillery = false;
    private boolean m_artillerySupportable = false;
    private int m_unitSupportCount = -1;
    private boolean m_isMarine = false;
    private boolean m_isSuicide = false;
    private Tuple<Integer, String> m_attackingLimit = null;
    private int m_attackRolls = 1;
    private int m_defenseRolls = 1;
    private boolean m_chooseBestRoll = false;
    private boolean m_isCombatTransport = false;
    private int m_transportCapacity = -1;
    private int m_transportCost = -1;
    private int m_carrierCapacity = -1;
    private int m_carrierCost = -1;
    private boolean m_isAirTransport = false;
    private boolean m_isAirTransportable = false;
    private boolean m_isInfantry = false;
    private boolean m_isLandTransport = false;
    private boolean m_isAAforCombatOnly = false;
    private boolean m_isAAforBombingThisUnitOnly = false;
    private boolean m_isAAforFlyOverOnly = false;
    private boolean m_isRocket = false;
    private int m_attackAA = 1;
    private int m_attackAAmaxDieSides = -1;
    private int m_maxAAattacks = -1;
    private String m_typeAA = "AA";
    private HashSet<UnitType> m_targetsAA = null;
    private boolean m_mayOverStackAA = false;
    private HashSet<UnitType> m_willNotFireIfPresent = new HashSet();
    private boolean m_isStrategicBomber = false;
    private int m_bombingMaxDieSides = -1;
    private int m_bombingBonus = -1;
    private boolean m_canIntercept = false;
    private boolean m_canEscort = false;
    private int m_airDefense = 0;
    private int m_airAttack = 0;
    private HashSet<UnitType> m_bombingTargets = null;
    private boolean m_isFactory = false;
    private boolean m_canProduceUnits = false;
    private int m_canProduceXUnits = -1;
    private IntegerMap<UnitType> m_createsUnitsList = new IntegerMap();
    private IntegerMap<Resource> m_createsResourcesList = new IntegerMap();
    private boolean m_isTwoHit = false;
    private boolean m_canBeDamaged = false;
    private int m_maxDamage = -1;
    private int m_maxOperationalDamage = -1;
    private boolean m_canDieFromReachingMaxDamage = false;
    private boolean m_isConstruction = false;
    private String m_constructionType = "none";
    private int m_constructionsPerTerrPerTypePerTurn = -1;
    private int m_maxConstructionsPerTypePerTerr = -1;
    private int m_canOnlyBePlacedInTerritoryValuedAtX = -1;
    private ArrayList<String[]> m_requiresUnits = new ArrayList();
    private IntegerMap<UnitType> m_consumesUnits = new IntegerMap();
    private String[] m_unitPlacementRestrictions;
    private int m_maxBuiltPerPlayer = -1;
    private Tuple<Integer, String> m_placementLimit = null;
    private boolean m_canScramble = false;
    private boolean m_isAirBase = false;
    private int m_maxScrambleDistance = -1;
    private int m_maxScrambleCount = -1;
    private int m_blockade = 0;
    private String[] m_repairsUnits;
    private IntegerMap<UnitType> m_givesMovement = new IntegerMap();
    private ArrayList<Tuple<String, PlayerID>> m_destroyedWhenCapturedBy = new ArrayList();
    private LinkedHashMap<String, Tuple<String, IntegerMap<UnitType>>> m_whenCapturedChangesInto = new LinkedHashMap();
    private ArrayList<PlayerID> m_canBeCapturedOnEnteringBy = new ArrayList();
    private ArrayList<PlayerID> m_canBeGivenByTerritoryTo = new ArrayList();
    private ArrayList<Tuple<Tuple<Integer, Integer>, Tuple<String, String>>> m_whenCombatDamaged = new ArrayList();
    private ArrayList<String> m_receivesAbilityWhenWith = new ArrayList();
    private HashSet<String> m_special = new HashSet();

    public static UnitAttachment get(UnitType type) {
        UnitAttachment rVal = (UnitAttachment)type.getAttachment("unitAttatchment");
        if (rVal == null) {
            throw new IllegalStateException("No unit type attachment for:" + type.getName());
        }
        return rVal;
    }

    public static UnitAttachment get(UnitType type, String nameOfAttachment) {
        UnitAttachment rVal = (UnitAttachment)type.getAttachment(nameOfAttachment);
        if (rVal == null) {
            throw new IllegalStateException("No unit type attachment for:" + type.getName() + " with name:" + nameOfAttachment);
        }
        return rVal;
    }

    public static Collection<UnitType> getUnitTypesFromUnitList(Collection<Unit> units) {
        ArrayList<UnitType> types = new ArrayList<UnitType>();
        for (Unit u : units) {
            if (types.contains(u.getType())) continue;
            types.add(u.getType());
        }
        return types;
    }

    public UnitAttachment(String name, Attachable attachable, GameData gameData) {
        super(name, attachable, gameData);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanIntercept(String value) {
        this.m_canIntercept = UnitAttachment.getBool(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanIntercept(Boolean value) {
        this.m_canIntercept = value;
    }

    public boolean getCanIntercept() {
        return this.m_canIntercept;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanEscort(String value) {
        this.m_canEscort = UnitAttachment.getBool(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanEscort(Boolean value) {
        this.m_canEscort = value;
    }

    public boolean getCanEscort() {
        return this.m_canEscort;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAirDefense(String value) {
        this.m_airDefense = UnitAttachment.getInt(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAirDefense(Integer value) {
        this.m_airDefense = value;
    }

    public int getAirDefense(PlayerID player) {
        return Math.min(this.getData().getDiceSides(), Math.max(0, this.m_airDefense + TechAbilityAttachment.getAirDefenseBonus((UnitType)this.getAttachedTo(), player, this.getData())));
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAirAttack(String value) {
        this.m_airAttack = UnitAttachment.getInt(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAirAttack(Integer value) {
        this.m_airAttack = value;
    }

    public int getAirAttack(PlayerID player) {
        return Math.min(this.getData().getDiceSides(), Math.max(0, this.m_airAttack + TechAbilityAttachment.getAirAttackBonus((UnitType)this.getAttachedTo(), player, this.getData())));
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsAirTransport(String s) {
        this.m_isAirTransport = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsAirTransport(Boolean s) {
        this.m_isAirTransport = s;
    }

    public boolean getIsAirTransport() {
        return this.m_isAirTransport;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsAirTransportable(String s) {
        this.m_isAirTransportable = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsAirTransportable(Boolean s) {
        this.m_isAirTransportable = s;
    }

    public boolean getIsAirTransportable() {
        return this.m_isAirTransportable;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setCanBeGivenByTerritoryTo(String value) throws GameParseException {
        String[] temp;
        for (String name : temp = value.split(":")) {
            PlayerID tempPlayer = this.getData().getPlayerList().getPlayerID(name);
            if (tempPlayer != null) {
                this.m_canBeGivenByTerritoryTo.add(tempPlayer);
                continue;
            }
            if (name.equalsIgnoreCase("true") || name.equalsIgnoreCase("false")) {
                this.m_canBeGivenByTerritoryTo.clear();
                continue;
            }
            throw new GameParseException("No player named: " + name + this.thisErrorMsg());
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanBeGivenByTerritoryTo(ArrayList<PlayerID> value) {
        this.m_canBeGivenByTerritoryTo = value;
    }

    public ArrayList<PlayerID> getCanBeGivenByTerritoryTo() {
        return this.m_canBeGivenByTerritoryTo;
    }

    public void clearCanBeGivenByTerritoryTo() {
        this.m_canBeGivenByTerritoryTo.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setCanBeCapturedOnEnteringBy(String value) throws GameParseException {
        String[] temp;
        for (String name : temp = value.split(":")) {
            PlayerID tempPlayer = this.getData().getPlayerList().getPlayerID(name);
            if (tempPlayer == null) {
                throw new GameParseException("No player named: " + name + this.thisErrorMsg());
            }
            this.m_canBeCapturedOnEnteringBy.add(tempPlayer);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanBeCapturedOnEnteringBy(ArrayList<PlayerID> value) {
        this.m_canBeCapturedOnEnteringBy = value;
    }

    public ArrayList<PlayerID> getCanBeCapturedOnEnteringBy() {
        return this.m_canBeCapturedOnEnteringBy;
    }

    public void clearCanBeCapturedOnEnteringBy() {
        this.m_canBeCapturedOnEnteringBy.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setWhenCapturedChangesInto(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length < 5 || (s.length - 1) % 2 != 0) {
            throw new GameParseException("whenCapturedChangesInto must have 5 or more values, playerFrom:playerTo:keepAttributes:unitType:howMany (you may have additional unitType:howMany:unitType:howMany, etc" + this.thisErrorMsg());
        }
        PlayerID pfrom = this.getData().getPlayerList().getPlayerID(s[0]);
        if (pfrom == null && !s[0].equals("any")) {
            throw new GameParseException("whenCapturedChangesInto: No player named: " + s[0] + this.thisErrorMsg());
        }
        PlayerID pto = this.getData().getPlayerList().getPlayerID(s[1]);
        if (pto == null && !s[1].equals("any")) {
            throw new GameParseException("whenCapturedChangesInto: No player named: " + s[1] + this.thisErrorMsg());
        }
        UnitAttachment.getBool(s[2]);
        IntegerMap<UnitType> unitsToMake = new IntegerMap<UnitType>();
        for (int i = 3; i < s.length; ++i) {
            UnitType ut = this.getData().getUnitTypeList().getUnitType(s[i]);
            if (ut == null) {
                throw new GameParseException("whenCapturedChangesInto: No unit named: " + s[3] + this.thisErrorMsg());
            }
            int howMany = UnitAttachment.getInt(s[++i]);
            unitsToMake.put(ut, howMany);
        }
        this.m_whenCapturedChangesInto.put(s[0] + ":" + s[1], new Tuple(s[2], unitsToMake));
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setWhenCapturedChangesInto(LinkedHashMap<String, Tuple<String, IntegerMap<UnitType>>> value) {
        this.m_whenCapturedChangesInto = value;
    }

    public LinkedHashMap<String, Tuple<String, IntegerMap<UnitType>>> getWhenCapturedChangesInto() {
        return this.m_whenCapturedChangesInto;
    }

    public void clearWhenCapturedChangesInto() {
        this.m_whenCapturedChangesInto.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setDestroyedWhenCapturedBy(String value) throws GameParseException {
        String[] temp;
        String byOrFrom = "BY";
        if (value.startsWith("BY:") && this.getData().getPlayerList().getPlayerID("BY") == null) {
            byOrFrom = "BY";
            value = value.replaceFirst("BY:", "");
        } else if (value.startsWith("FROM:") && this.getData().getPlayerList().getPlayerID("FROM") == null) {
            byOrFrom = "FROM";
            value = value.replaceFirst("FROM:", "");
        }
        for (String name : temp = value.split(":")) {
            PlayerID tempPlayer = this.getData().getPlayerList().getPlayerID(name);
            if (tempPlayer == null) {
                throw new GameParseException("No player named: " + name + this.thisErrorMsg());
            }
            this.m_destroyedWhenCapturedBy.add(new Tuple<String, PlayerID>(byOrFrom, tempPlayer));
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setDestroyedWhenCapturedBy(ArrayList<Tuple<String, PlayerID>> value) {
        this.m_destroyedWhenCapturedBy = value;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setDestroyedWhenCapturedFrom(String value) throws GameParseException {
        if (!value.startsWith("BY:") && !value.startsWith("FROM:")) {
            value = "FROM:" + value;
        }
        this.setDestroyedWhenCapturedBy(value);
    }

    public ArrayList<Tuple<String, PlayerID>> getDestroyedWhenCapturedBy() {
        return this.m_destroyedWhenCapturedBy;
    }

    public void clearDestroyedWhenCapturedBy() {
        this.m_destroyedWhenCapturedBy.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanBlitz(String s) {
        this.m_canBlitz = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanBlitz(Boolean s) {
        this.m_canBlitz = s;
    }

    public boolean getCanBlitz(PlayerID player) {
        if (this.m_canBlitz) {
            return true;
        }
        return TechAbilityAttachment.getUnitAbilitiesGained("canBlitz", (UnitType)this.getAttachedTo(), player, this.getData());
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsSub(String s) {
        this.m_isSub = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsSub(Boolean s) {
        this.m_isSub = s;
    }

    public boolean getIsSub() {
        return this.m_isSub;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsCombatTransport(String s) {
        this.m_isCombatTransport = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsCombatTransport(Boolean s) {
        this.m_isCombatTransport = s;
    }

    public boolean getIsCombatTransport() {
        return this.m_isCombatTransport;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsStrategicBomber(String s) {
        this.m_isStrategicBomber = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsStrategicBomber(Boolean s) {
        this.m_isStrategicBomber = s;
    }

    public boolean getIsStrategicBomber() {
        return this.m_isStrategicBomber;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsDestroyer(String s) {
        this.m_isDestroyer = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsDestroyer(Boolean s) {
        this.m_isDestroyer = s;
    }

    public boolean getIsDestroyer() {
        return this.m_isDestroyer;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanBombard(String s) {
        this.m_canBombard = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanBombard(Boolean s) {
        this.m_canBombard = s;
    }

    public boolean getCanBombard(PlayerID player) {
        if (this.m_canBombard) {
            return true;
        }
        return TechAbilityAttachment.getUnitAbilitiesGained("canBombard", (UnitType)this.getAttachedTo(), player, this.getData());
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsAir(String s) {
        this.m_isAir = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsAir(Boolean s) {
        this.m_isAir = s;
    }

    public boolean getIsAir() {
        return this.m_isAir;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsSea(String s) {
        this.m_isSea = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsSea(Boolean s) {
        this.m_isSea = s;
    }

    public boolean getIsSea() {
        return this.m_isSea;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsFactory(String s) {
        this.m_isFactory = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsFactory(Boolean s) {
        this.m_isFactory = s;
    }

    public boolean getIsFactory() {
        return this.m_isFactory;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanProduceUnits(String s) {
        this.m_canProduceUnits = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanProduceUnits(Boolean s) {
        this.m_canProduceUnits = s;
    }

    public boolean getCanProduceUnits() {
        return this.m_canProduceUnits;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanProduceXUnits(String s) {
        this.m_canProduceXUnits = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanProduceXUnits(Integer s) {
        this.m_canProduceXUnits = s;
    }

    public int getCanProduceXUnits() {
        return this.m_canProduceXUnits;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanOnlyBePlacedInTerritoryValuedAtX(String s) {
        this.m_canOnlyBePlacedInTerritoryValuedAtX = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanOnlyBePlacedInTerritoryValuedAtX(Integer s) {
        this.m_canOnlyBePlacedInTerritoryValuedAtX = s;
    }

    public int getCanOnlyBePlacedInTerritoryValuedAtX() {
        return this.m_canOnlyBePlacedInTerritoryValuedAtX;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setUnitPlacementRestrictions(String value) {
        if (value == null) {
            this.m_unitPlacementRestrictions = null;
            return;
        }
        this.m_unitPlacementRestrictions = value.split(":");
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setUnitPlacementRestrictions(String[] value) {
        this.m_unitPlacementRestrictions = value;
    }

    public String[] getUnitPlacementRestrictions() {
        return this.m_unitPlacementRestrictions;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setUnitPlacementOnlyAllowedIn(String value) throws GameParseException {
        String valueRestricted = new String();
        String[] valueAllowed = value.split(":");
        if (valueAllowed != null) {
            this.getListedTerritories(valueAllowed);
            Collection<Territory> allTerrs = this.getData().getMap().getTerritories();
            for (Territory item : allTerrs) {
                boolean match = false;
                for (String allowed : valueAllowed) {
                    if (!allowed.matches(item.getName())) continue;
                    match = true;
                }
                if (match) continue;
                valueRestricted = valueRestricted + ":" + item.getName();
            }
            valueRestricted = valueRestricted.replaceFirst(":", "");
            this.m_unitPlacementRestrictions = valueRestricted.split(":");
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRepairsUnits(String value) {
        if (value == null) {
            this.m_repairsUnits = null;
            return;
        }
        this.m_repairsUnits = value.split(":");
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRepairsUnits(String[] value) {
        this.m_repairsUnits = value;
    }

    public String[] getRepairsUnits() {
        return this.m_repairsUnits;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setSpecial(String value) throws GameParseException {
        String[] s;
        for (String option : s = value.split(":")) {
            if (!option.equals("none") && !option.equals("canOnlyPlaceInOriginalTerritories")) {
                throw new GameParseException("special does not allow: " + option + this.thisErrorMsg());
            }
            this.m_special.add(option);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setSpecial(HashSet<String> value) {
        this.m_special = value;
    }

    public HashSet<String> getSpecial() {
        return this.m_special;
    }

    public void clearSpecial() {
        this.m_special.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanInvadeOnlyFrom(String value) {
        if (value == null) {
            this.m_canInvadeOnlyFrom = null;
            return;
        }
        String[] canOnlyInvadeFrom = value.split(":");
        if (canOnlyInvadeFrom[0].toLowerCase().equals("none")) {
            this.m_canInvadeOnlyFrom = new String[]{"none"};
            return;
        }
        if (canOnlyInvadeFrom[0].toLowerCase().equals("all")) {
            this.m_canInvadeOnlyFrom = new String[]{"all"};
            return;
        }
        this.m_canInvadeOnlyFrom = canOnlyInvadeFrom;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanInvadeOnlyFrom(String[] value) {
        this.m_canInvadeOnlyFrom = value;
    }

    public boolean canInvadeFrom(String transport) {
        UnitType ut = this.getData().getUnitTypeList().getUnitType(transport);
        if (ut == null) {
            throw new IllegalStateException("No unit called:" + transport + this.thisErrorMsg());
        }
        if (this.m_canInvadeOnlyFrom == null || Arrays.asList(this.m_canInvadeOnlyFrom).isEmpty() || this.m_canInvadeOnlyFrom[0].equals("") || this.m_canInvadeOnlyFrom[0].equals("all")) {
            return true;
        }
        return Arrays.asList(this.m_canInvadeOnlyFrom).contains(transport);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setRequiresUnits(String value) {
        this.m_requiresUnits.add(value.split(":"));
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRequiresUnits(ArrayList<String[]> value) {
        this.m_requiresUnits = value;
    }

    public ArrayList<String[]> getRequiresUnits() {
        return this.m_requiresUnits;
    }

    public void clearRequiresUnits() {
        this.m_requiresUnits.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setWhenCombatDamaged(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length != 3 && s.length != 4) {
            throw new GameParseException("whenCombatDamaged must have 3 or 4 parts: value=effect:optionalNumber, count=integer:integer" + this.thisErrorMsg());
        }
        int from = UnitAttachment.getInt(s[0]);
        int to = UnitAttachment.getInt(s[1]);
        if (from < 0 || to < 0 || to < from) {
            throw new GameParseException("whenCombatDamaged damaged integers must be positive, and the second integer must be equal to or greater than the first" + this.thisErrorMsg());
        }
        Tuple<Integer, Integer> fromTo = new Tuple<Integer, Integer>(from, to);
        Tuple<String, Object> effectNum = s.length == 3 ? new Tuple<String, Object>(s[2], null) : new Tuple<String, String>(s[2], s[3]);
        this.m_whenCombatDamaged.add(new Tuple<Tuple<Integer, Integer>, Tuple<String, Object>>(fromTo, effectNum));
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setWhenCombatDamaged(ArrayList<Tuple<Tuple<Integer, Integer>, Tuple<String, String>>> value) {
        this.m_whenCombatDamaged = value;
    }

    public ArrayList<Tuple<Tuple<Integer, Integer>, Tuple<String, String>>> getWhenCombatDamaged() {
        return this.m_whenCombatDamaged;
    }

    public void clearWhenCombatDamaged() {
        this.m_whenCombatDamaged.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setReceivesAbilityWhenWith(String value) {
        this.m_receivesAbilityWhenWith.add(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setReceivesAbilityWhenWith(ArrayList<String> value) {
        this.m_receivesAbilityWhenWith = value;
    }

    public ArrayList<String> getReceivesAbilityWhenWith() {
        return this.m_receivesAbilityWhenWith;
    }

    public void clearReceivesAbilityWhenWith() {
        this.m_receivesAbilityWhenWith.clear();
    }

    public static IntegerMap<Tuple<String, String>> getReceivesAbilityWhenWithMap(Collection<Unit> units, String filterForAbility, GameData data) {
        IntegerMap<Tuple<String, String>> map = new IntegerMap<Tuple<String, String>>();
        Collection<UnitType> canReceive = UnitAttachment.getUnitTypesFromUnitList(Match.getMatches(units, Matches.UnitCanReceivesAbilityWhenWith()));
        for (UnitType ut : canReceive) {
            ArrayList<String> receives = UnitAttachment.get(ut).getReceivesAbilityWhenWith();
            for (String receive : receives) {
                String[] s = receive.split(":");
                if (filterForAbility != null && !filterForAbility.equals(s[0])) continue;
                map.put(new Tuple<String, String>(s[0], s[1]), Match.countMatches(units, Matches.unitIsOfType(data.getUnitTypeList().getUnitType(s[1]))));
            }
        }
        return map;
    }

    public static Collection<Unit> getUnitsWhichReceivesAbilityWhenWith(Collection<Unit> units, String filterForAbility, GameData data) {
        if (Match.noneMatch(units, Matches.UnitCanReceivesAbilityWhenWith())) {
            return new ArrayList<Unit>();
        }
        ArrayList<Unit> unitsCopy = new ArrayList<Unit>(units);
        HashSet<Unit> whichReceiveNoDuplicates = new HashSet<Unit>();
        IntegerMap<Tuple<String, String>> whichGive = UnitAttachment.getReceivesAbilityWhenWithMap(unitsCopy, filterForAbility, data);
        for (Tuple<String, String> abilityUnitType : whichGive.keySet()) {
            List<Unit> receives = Match.getNMatches(unitsCopy, whichGive.getInt(abilityUnitType), Matches.UnitCanReceivesAbilityWhenWith(filterForAbility, abilityUnitType.getSecond()));
            whichReceiveNoDuplicates.addAll(receives);
            unitsCopy.removeAll(receives);
        }
        return whichReceiveNoDuplicates;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsConstruction(String s) {
        this.m_isConstruction = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsConstruction(Boolean s) {
        this.m_isConstruction = s;
    }

    public boolean getIsConstruction() {
        return this.m_isConstruction;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setConstructionType(String s) {
        this.m_constructionType = s;
    }

    public String getConstructionType() {
        return this.m_constructionType;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setConstructionsPerTerrPerTypePerTurn(String s) {
        this.m_constructionsPerTerrPerTypePerTurn = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setConstructionsPerTerrPerTypePerTurn(Integer s) {
        this.m_constructionsPerTerrPerTypePerTurn = s;
    }

    public int getConstructionsPerTerrPerTypePerTurn() {
        return this.m_constructionsPerTerrPerTypePerTurn;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMaxConstructionsPerTypePerTerr(String s) {
        this.m_maxConstructionsPerTypePerTerr = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMaxConstructionsPerTypePerTerr(Integer s) {
        this.m_maxConstructionsPerTypePerTerr = s;
    }

    public int getMaxConstructionsPerTypePerTerr() {
        return this.m_maxConstructionsPerTypePerTerr;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsMarine(String s) {
        this.m_isMarine = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsMarine(Boolean s) {
        this.m_isMarine = s;
    }

    public boolean getIsMarine() {
        return this.m_isMarine;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsInfantry(String s) {
        this.m_isInfantry = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsInfantry(Boolean s) {
        this.m_isInfantry = s;
    }

    public boolean getIsInfantry() {
        return this.m_isInfantry;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsLandTransport(String s) {
        this.m_isLandTransport = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsLandTransport(Boolean s) {
        this.m_isLandTransport = s;
    }

    public boolean isLandTransport() {
        return this.m_isLandTransport;
    }

    public boolean getIsLandTransport() {
        return this.m_isLandTransport;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setTransportCapacity(String s) {
        this.m_transportCapacity = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setTransportCapacity(Integer s) {
        this.m_transportCapacity = s;
    }

    public int getTransportCapacity() {
        return this.m_transportCapacity;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsTwoHit(String s) {
        this.m_isTwoHit = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsTwoHit(Boolean s) {
        this.m_isTwoHit = s;
    }

    public boolean getIsTwoHit() {
        return this.m_isTwoHit;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setTransportCost(String s) {
        this.m_transportCost = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setTransportCost(Integer s) {
        this.m_transportCost = s;
    }

    public int getTransportCost() {
        return this.m_transportCost;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMaxBuiltPerPlayer(String s) {
        this.m_maxBuiltPerPlayer = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMaxBuiltPerPlayer(Integer s) {
        this.m_maxBuiltPerPlayer = s;
    }

    public int getMaxBuiltPerPlayer() {
        return this.m_maxBuiltPerPlayer;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCarrierCapacity(String s) {
        this.m_carrierCapacity = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCarrierCapacity(Integer s) {
        this.m_carrierCapacity = s;
    }

    public int getCarrierCapacity() {
        return this.m_carrierCapacity;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCarrierCost(String s) {
        this.m_carrierCost = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCarrierCost(Integer s) {
        this.m_carrierCost = s;
    }

    public int getCarrierCost() {
        return this.m_carrierCost;
    }

    @GameProperty(xmlProperty=true, gameProperty=false, adds=false)
    public void setArtillery(String s) throws GameParseException {
        this.m_artillery = UnitAttachment.getBool(s);
        if (this.m_artillery) {
            UnitSupportAttachment.addRule((UnitType)this.getAttachedTo(), this.getData(), false);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=false, adds=false)
    public void setArtillery(Boolean s) throws GameParseException {
        this.m_artillery = s;
        if (this.m_artillery) {
            UnitSupportAttachment.addRule((UnitType)this.getAttachedTo(), this.getData(), false);
        }
    }

    public boolean getArtillery() {
        return this.m_artillery;
    }

    @GameProperty(xmlProperty=true, gameProperty=false, adds=false)
    public void setArtillerySupportable(String s) throws GameParseException {
        this.m_artillerySupportable = UnitAttachment.getBool(s);
        if (this.m_artillerySupportable) {
            UnitSupportAttachment.addTarget((UnitType)this.getAttachedTo(), this.getData());
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=false, adds=false)
    public void setArtillerySupportable(Boolean s) throws GameParseException {
        this.m_artillerySupportable = s;
        if (this.m_artillerySupportable) {
            UnitSupportAttachment.addTarget((UnitType)this.getAttachedTo(), this.getData());
        }
    }

    public boolean getArtillerySupportable() {
        return this.m_artillerySupportable;
    }

    @GameProperty(xmlProperty=true, gameProperty=false, adds=false)
    public void setUnitSupportCount(String s) {
        this.m_unitSupportCount = UnitAttachment.getInt(s);
        UnitSupportAttachment.setOldSupportCount((UnitType)this.getAttachedTo(), this.getData(), s);
    }

    @GameProperty(xmlProperty=true, gameProperty=false, adds=false)
    public void setUnitSupportCount(Integer s) {
        this.m_unitSupportCount = s;
        UnitSupportAttachment.setOldSupportCount((UnitType)this.getAttachedTo(), this.getData(), s.toString());
    }

    public int getUnitSupportCount() {
        return this.m_unitSupportCount > 0 ? this.m_unitSupportCount : 1;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setBombard(String s) {
        this.m_bombard = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setBombard(Integer s) {
        this.m_bombard = s;
    }

    public int getBombard(PlayerID player) {
        return this.m_bombard > 0 ? this.m_bombard : this.m_attack;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMovement(String s) {
        this.m_movement = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMovement(Integer s) {
        this.m_movement = s;
    }

    public int getMovement(PlayerID player) {
        return Math.max(0, this.m_movement + TechAbilityAttachment.getMovementBonus((UnitType)this.getAttachedTo(), player, this.getData()));
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAttack(String s) {
        this.m_attack = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAttack(Integer s) {
        this.m_attack = s;
    }

    public int getAttack(PlayerID player) {
        int attackValue = this.m_attack + TechAbilityAttachment.getAttackBonus((UnitType)this.getAttachedTo(), player, this.getData());
        if (attackValue > 0 && player.isAI()) {
            attackValue += Properties.getAIBonusAttack(this.getData());
        }
        return Math.min(this.getData().getDiceSides(), Math.max(0, attackValue));
    }

    int getRawAttack() {
        return this.m_attack;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAttackRolls(String s) {
        this.m_attackRolls = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAttackRolls(Integer s) {
        this.m_attackRolls = s;
    }

    public int getAttackRolls(PlayerID player) {
        if (this.getAttack(player) <= 0) {
            return 0;
        }
        return Math.max(0, this.m_attackRolls + TechAbilityAttachment.getAttackRollsBonus((UnitType)this.getAttachedTo(), player, this.getData()));
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setDefense(String s) {
        this.m_defense = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setDefense(Integer s) {
        this.m_defense = s;
    }

    public int getDefense(PlayerID player) {
        int defenseValue = this.m_defense + TechAbilityAttachment.getDefenseBonus((UnitType)this.getAttachedTo(), player, this.getData());
        if (defenseValue > 0 && this.m_isSub && TechTracker.hasSuperSubs(player)) {
            int bonus = Properties.getSuper_Sub_Defense_Bonus(this.getData());
            defenseValue += bonus;
        }
        if (defenseValue > 0 && player.isAI()) {
            defenseValue += Properties.getAIBonusDefense(this.getData());
        }
        return Math.min(this.getData().getDiceSides(), Math.max(0, defenseValue));
    }

    int getRawDefense() {
        return this.m_defense;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setDefenseRolls(String s) {
        this.m_defenseRolls = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setDefenseRolls(Integer s) {
        this.m_defenseRolls = s;
    }

    public int getDefenseRolls(PlayerID player) {
        if (this.getDefense(player) <= 0) {
            return 0;
        }
        return Math.max(0, this.m_defenseRolls + TechAbilityAttachment.getDefenseRollsBonus((UnitType)this.getAttachedTo(), player, this.getData()));
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setChooseBestRoll(String s) {
        this.m_chooseBestRoll = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setChooseBestRoll(Boolean s) {
        this.m_chooseBestRoll = s;
    }

    public boolean getChooseBestRoll() {
        return this.m_chooseBestRoll;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanScramble(String s) {
        this.m_canScramble = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanScramble(Boolean s) {
        this.m_canScramble = s;
    }

    public boolean getCanScramble() {
        return this.m_canScramble;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMaxScrambleCount(String s) {
        this.m_maxScrambleCount = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMaxScrambleCount(Integer s) {
        this.m_maxScrambleCount = s;
    }

    public int getMaxScrambleCount() {
        return this.m_maxScrambleCount;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMaxScrambleDistance(String s) {
        this.m_maxScrambleDistance = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMaxScrambleDistance(Integer s) {
        this.m_maxScrambleDistance = s;
    }

    public int getMaxScrambleDistance() {
        return this.m_maxScrambleDistance;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMaxOperationalDamage(String s) {
        this.m_maxOperationalDamage = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMaxOperationalDamage(Integer s) {
        this.m_maxOperationalDamage = s;
    }

    public int getMaxOperationalDamage() {
        return this.m_maxOperationalDamage;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMaxDamage(String s) {
        this.m_maxDamage = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMaxDamage(Integer s) {
        this.m_maxDamage = s;
    }

    public int getMaxDamage() {
        return this.m_maxDamage;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsAirBase(String s) {
        this.m_isAirBase = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsAirBase(Boolean s) {
        this.m_isAirBase = s;
    }

    public boolean getIsAirBase() {
        return this.m_isAirBase;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsInfrastructure(String s) {
        this.m_isInfrastructure = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsInfrastructure(Boolean s) {
        this.m_isInfrastructure = s;
    }

    public boolean getIsInfrastructure() {
        return this.m_isInfrastructure;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanBeDamaged(String s) {
        this.m_canBeDamaged = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanBeDamaged(Boolean s) {
        this.m_canBeDamaged = s;
    }

    public boolean getCanBeDamaged() {
        return this.m_canBeDamaged;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanDieFromReachingMaxDamage(String s) {
        this.m_canDieFromReachingMaxDamage = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanDieFromReachingMaxDamage(Boolean s) {
        this.m_canDieFromReachingMaxDamage = s;
    }

    public boolean getCanDieFromReachingMaxDamage() {
        return this.m_canDieFromReachingMaxDamage;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsSuicide(String s) {
        this.m_isSuicide = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsSuicide(Boolean s) {
        this.m_isSuicide = s;
    }

    public boolean getIsSuicide() {
        return this.m_isSuicide;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsKamikaze(String s) {
        this.m_isKamikaze = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsKamikaze(Boolean s) {
        this.m_isKamikaze = s;
    }

    public boolean getIsKamikaze() {
        return this.m_isKamikaze;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setBlockade(String s) {
        this.m_blockade = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setBlockade(Integer s) {
        this.m_blockade = s;
    }

    public int getBlockade() {
        return this.m_blockade;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setGivesMovement(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length <= 0 || s.length > 2) {
            throw new GameParseException("givesMovement can not be empty or have more than two fields" + this.thisErrorMsg());
        }
        String unitTypeToProduce = s[1];
        UnitType ut = this.getData().getUnitTypeList().getUnitType(unitTypeToProduce);
        if (ut == null) {
            throw new GameParseException("No unit called:" + unitTypeToProduce + this.thisErrorMsg());
        }
        int n = UnitAttachment.getInt(s[0]);
        this.m_givesMovement.put(ut, n);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setGivesMovement(IntegerMap<UnitType> value) {
        this.m_givesMovement = value;
    }

    public IntegerMap<UnitType> getGivesMovement() {
        return this.m_givesMovement;
    }

    public void clearGivesMovement() {
        this.m_givesMovement.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setConsumesUnits(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length <= 0 || s.length > 2) {
            throw new GameParseException("consumesUnits can not be empty or have more than two fields" + this.thisErrorMsg());
        }
        String unitTypeToProduce = s[1];
        UnitType ut = this.getData().getUnitTypeList().getUnitType(unitTypeToProduce);
        if (ut == null) {
            throw new GameParseException("No unit called:" + unitTypeToProduce + this.thisErrorMsg());
        }
        int n = UnitAttachment.getInt(s[0]);
        if (n < 1) {
            throw new GameParseException("consumesUnits must have positive values" + this.thisErrorMsg());
        }
        this.m_consumesUnits.put(ut, n);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setConsumesUnits(IntegerMap<UnitType> value) {
        this.m_consumesUnits = value;
    }

    public IntegerMap<UnitType> getConsumesUnits() {
        return this.m_consumesUnits;
    }

    public void clearConsumesUnits() {
        this.m_consumesUnits.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setCreatesUnitsList(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length <= 0 || s.length > 2) {
            throw new GameParseException("createsUnitsList can not be empty or have more than two fields" + this.thisErrorMsg());
        }
        String unitTypeToProduce = s[1];
        UnitType ut = this.getData().getUnitTypeList().getUnitType(unitTypeToProduce);
        if (ut == null) {
            throw new GameParseException("createsUnitsList: No unit called:" + unitTypeToProduce + this.thisErrorMsg());
        }
        int n = UnitAttachment.getInt(s[0]);
        if (n < 1) {
            throw new GameParseException("createsUnitsList must have positive values" + this.thisErrorMsg());
        }
        this.m_createsUnitsList.put(ut, n);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCreatesUnitsList(IntegerMap<UnitType> value) {
        this.m_createsUnitsList = value;
    }

    public IntegerMap<UnitType> getCreatesUnitsList() {
        return this.m_createsUnitsList;
    }

    public void clearCreatesUnitsList() {
        this.m_createsUnitsList.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setCreatesResourcesList(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length <= 0 || s.length > 2) {
            throw new GameParseException("createsResourcesList can not be empty or have more than two fields" + this.thisErrorMsg());
        }
        String resourceToProduce = s[1];
        Resource r = this.getData().getResourceList().getResource(resourceToProduce);
        if (r == null) {
            throw new GameParseException("createsResourcesList: No resource called:" + resourceToProduce + this.thisErrorMsg());
        }
        int n = UnitAttachment.getInt(s[0]);
        this.m_createsResourcesList.put(r, n);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCreatesResourcesList(IntegerMap<Resource> value) {
        this.m_createsResourcesList = value;
    }

    public IntegerMap<Resource> getCreatesResourcesList() {
        return this.m_createsResourcesList;
    }

    public void clearCreatesResourcesList() {
        this.m_createsResourcesList.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setFuelCost(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length != 2) {
            throw new GameParseException("fuelCost must have two fields" + this.thisErrorMsg());
        }
        String resourceToProduce = s[1];
        Resource r = this.getData().getResourceList().getResource(resourceToProduce);
        if (r == null) {
            throw new GameParseException("fuelCost: No resource called:" + resourceToProduce + this.thisErrorMsg());
        }
        int n = UnitAttachment.getInt(s[0]);
        if (n < 0) {
            throw new GameParseException("fuelCost must have positive values" + this.thisErrorMsg());
        }
        this.m_fuelCost.put(r, n);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setFuelCost(IntegerMap<Resource> value) {
        this.m_fuelCost = value;
    }

    public IntegerMap<Resource> getFuelCost() {
        return this.m_fuelCost;
    }

    public void clearFuelCost() {
        this.m_fuelCost.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setBombingBonus(String s) {
        this.m_bombingBonus = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setBombingBonus(Integer s) {
        this.m_bombingBonus = s;
    }

    public int getBombingBonus() {
        return this.m_bombingBonus;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setBombingMaxDieSides(String s) {
        this.m_bombingMaxDieSides = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setBombingMaxDieSides(Integer s) {
        this.m_bombingMaxDieSides = s;
    }

    public int getBombingMaxDieSides() {
        return this.m_bombingMaxDieSides;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setBombingTargets(String value) throws GameParseException {
        String[] s;
        if (value == null) {
            this.m_bombingTargets = null;
            return;
        }
        if (this.m_bombingTargets == null) {
            this.m_bombingTargets = new HashSet();
        }
        for (String u : s = value.split(":")) {
            UnitType ut = this.getData().getUnitTypeList().getUnitType(u);
            if (ut == null) {
                throw new GameParseException("bombingTargets: no such unit type: " + u + this.thisErrorMsg());
            }
            this.m_bombingTargets.add(ut);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setBombingTargets(HashSet<UnitType> value) {
        this.m_bombingTargets = value;
    }

    public HashSet<UnitType> getBombingTargets(GameData data) {
        if (this.m_bombingTargets != null) {
            return this.m_bombingTargets;
        }
        return new HashSet<UnitType>(data.getUnitTypeList().getAllUnitTypes());
    }

    public void clearBombingTargets() {
        this.m_bombingTargets.clear();
    }

    public static Set<UnitType> getAllowedBombingTargetsIntersection(Collection<Unit> bombersOrRockets, GameData data) {
        if (bombersOrRockets.isEmpty()) {
            return new HashSet<UnitType>();
        }
        Collection<UnitType> allowedTargets = data.getUnitTypeList().getAllUnitTypes();
        for (Unit u : bombersOrRockets) {
            UnitAttachment ua = UnitAttachment.get(u.getType());
            HashSet<UnitType> bombingTargets = ua.getBombingTargets(data);
            if (bombingTargets == null) continue;
            allowedTargets = Util.intersection(allowedTargets, bombingTargets);
        }
        return new HashSet<UnitType>(allowedTargets);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsAA(String s) throws GameParseException {
        UnitAttachment.getBool(s);
        this.setIsAAforCombatOnly(s);
        this.setIsAAforBombingThisUnitOnly(s);
        this.setIsAAforFlyOverOnly(s);
        this.setIsAAmovement(s);
        this.setIsRocket(s);
        this.setIsInfrastructure(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsAA(Boolean s) throws GameParseException {
        this.setIsAAforCombatOnly(s);
        this.setIsAAforBombingThisUnitOnly(s);
        this.setIsAAforFlyOverOnly(s);
        this.setIsAAmovement(s);
        this.setIsRocket(s);
        this.setIsInfrastructure(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAttackAA(String s) {
        this.m_attackAA = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAttackAA(Integer s) {
        this.m_attackAA = s;
    }

    public int getAttackAA(PlayerID player) {
        return Math.max(0, Math.min(this.getAttackAAmaxDieSides(), this.m_attackAA + TechAbilityAttachment.getRadarBonus((UnitType)this.getAttachedTo(), player, this.getData())));
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAttackAAmaxDieSides(String s) {
        this.m_attackAAmaxDieSides = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAttackAAmaxDieSides(Integer s) {
        this.m_attackAAmaxDieSides = s;
    }

    public int getAttackAAmaxDieSides() {
        if (this.m_attackAAmaxDieSides < 0) {
            return this.getData().getDiceSides();
        }
        return this.m_attackAAmaxDieSides;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMaxAAattacks(String s) throws GameParseException {
        int attacks = UnitAttachment.getInt(s);
        if (attacks < -1) {
            throw new GameParseException("maxAAattacks must be positive" + this.thisErrorMsg());
        }
        this.m_maxAAattacks = UnitAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMaxAAattacks(Integer s) {
        this.m_maxAAattacks = s;
    }

    public int getMaxAAattacks() {
        return this.m_maxAAattacks;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMayOverStackAA(String s) {
        this.m_mayOverStackAA = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMayOverStackAA(Boolean s) {
        this.m_mayOverStackAA = s;
    }

    public boolean getMayOverStackAA() {
        return this.m_mayOverStackAA;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsAAforCombatOnly(String s) {
        this.m_isAAforCombatOnly = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsAAforCombatOnly(Boolean s) {
        this.m_isAAforCombatOnly = s;
    }

    public boolean getIsAAforCombatOnly() {
        return this.m_isAAforCombatOnly;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsAAforBombingThisUnitOnly(String s) {
        this.m_isAAforBombingThisUnitOnly = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsAAforBombingThisUnitOnly(Boolean s) {
        this.m_isAAforBombingThisUnitOnly = s;
    }

    public boolean getIsAAforBombingThisUnitOnly() {
        return this.m_isAAforBombingThisUnitOnly;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsAAforFlyOverOnly(String s) {
        this.m_isAAforFlyOverOnly = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsAAforFlyOverOnly(Boolean s) {
        this.m_isAAforFlyOverOnly = s;
    }

    public boolean getIsAAforFlyOverOnly() {
        return this.m_isAAforFlyOverOnly;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsRocket(String s) {
        this.m_isRocket = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsRocket(Boolean s) {
        this.m_isRocket = s;
    }

    public boolean getIsRocket() {
        return this.m_isRocket;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setTypeAA(String s) {
        this.m_typeAA = s;
    }

    public String getTypeAA() {
        return this.m_typeAA;
    }

    public static Set<String> getAllOfTypeAAs(Collection<Unit> aaUnits, Collection<Unit> targets, Match<Unit> typeOfAA, HashMap<String, HashSet<UnitType>> airborneTechTargetsAllowed) {
        HashSet<String> rVal = new HashSet<String>();
        for (Unit u : Match.getMatches(aaUnits, Matches.UnitIsAAthatCanHitTheseUnits(targets, typeOfAA, airborneTechTargetsAllowed))) {
            rVal.add(UnitAttachment.get(u.getType()).getTypeAA());
        }
        return rVal;
    }

    public static Set<String> getAllOfTypeAAs(Collection<Unit> aaUnitsAlreadyVerified) {
        HashSet<String> rVal = new HashSet<String>();
        for (Unit u : aaUnitsAlreadyVerified) {
            rVal.add(UnitAttachment.get(u.getType()).getTypeAA());
        }
        return rVal;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setTargetsAA(String value) throws GameParseException {
        String[] s;
        if (value == null) {
            this.m_targetsAA = null;
            return;
        }
        if (this.m_targetsAA == null) {
            this.m_targetsAA = new HashSet();
        }
        for (String u : s = value.split(":")) {
            UnitType ut = this.getData().getUnitTypeList().getUnitType(u);
            if (ut == null) {
                throw new GameParseException("AAtargets: no such unit type: " + u + this.thisErrorMsg());
            }
            this.m_targetsAA.add(ut);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setTargetsAA(HashSet<UnitType> value) {
        this.m_targetsAA = value;
    }

    public HashSet<UnitType> getTargetsAA(GameData data) {
        if (this.m_targetsAA != null) {
            return this.m_targetsAA;
        }
        HashSet<UnitType> airTypes = new HashSet<UnitType>();
        for (UnitType ut : data.getUnitTypeList()) {
            if (!UnitAttachment.get(ut).getIsAir()) continue;
            airTypes.add(ut);
        }
        return airTypes;
    }

    public void clearTargetsAA() {
        this.m_targetsAA.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setWillNotFireIfPresent(String value) throws GameParseException {
        String[] s;
        for (String u : s = value.split(":")) {
            UnitType ut = this.getData().getUnitTypeList().getUnitType(u);
            if (ut == null) {
                throw new GameParseException("willNotFireIfPresent: no such unit type: " + u + this.thisErrorMsg());
            }
            this.m_willNotFireIfPresent.add(ut);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setWillNotFireIfPresent(HashSet<UnitType> value) {
        this.m_willNotFireIfPresent = value;
    }

    public HashSet<UnitType> getWillNotFireIfPresent() {
        return this.m_willNotFireIfPresent;
    }

    public void clearWillNotFireIfPresent() {
        this.m_willNotFireIfPresent.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsAAmovement(String s) throws GameParseException {
        this.setCanNotMoveDuringCombatMove(s);
        if (UnitAttachment.getBool(s)) {
            this.setMovementLimit("2147483647:allied");
            this.setAttackingLimit("2147483647:allied");
            this.setPlacementLimit("2147483647:allied");
        } else {
            this.m_movementLimit = null;
            this.m_attackingLimit = null;
            this.m_placementLimit = null;
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsAAmovement(Boolean s) throws GameParseException {
        this.setCanNotMoveDuringCombatMove(s);
        if (s.booleanValue()) {
            this.setMovementLimit("2147483647:allied");
            this.setAttackingLimit("2147483647:allied");
            this.setPlacementLimit("2147483647:allied");
        } else {
            this.m_movementLimit = null;
            this.m_attackingLimit = null;
            this.m_placementLimit = null;
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanNotMoveDuringCombatMove(String s) {
        this.m_canNotMoveDuringCombatMove = UnitAttachment.getBool(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCanNotMoveDuringCombatMove(Boolean s) {
        this.m_canNotMoveDuringCombatMove = s;
    }

    public boolean getCanNotMoveDuringCombatMove() {
        return this.m_canNotMoveDuringCombatMove;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMovementLimit(String value) throws GameParseException {
        if (value == null) {
            this.m_movementLimit = null;
            return;
        }
        UnitType ut = (UnitType)this.getAttachedTo();
        if (ut == null) {
            throw new GameParseException("getAttachedTo returned null" + this.thisErrorMsg());
        }
        String[] s = value.split(":");
        if (s.length != 2) {
            throw new GameParseException("movementLimit must have 2 fields, value and count" + this.thisErrorMsg());
        }
        int max = UnitAttachment.getInt(s[0]);
        if (max < 0) {
            throw new GameParseException("movementLimit count must have a positive number" + this.thisErrorMsg());
        }
        if (!(s[1].equals("owned") || s[1].equals("allied") || s[1].equals("total"))) {
            throw new GameParseException("movementLimit value must owned, allied, or total" + this.thisErrorMsg());
        }
        this.m_movementLimit = new Tuple<Integer, String>(max, s[1]);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMovementLimit(Tuple<Integer, String> value) {
        this.m_movementLimit = value;
    }

    public Tuple<Integer, String> getMovementLimit() {
        return this.m_movementLimit;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAttackingLimit(String value) throws GameParseException {
        if (value == null) {
            this.m_attackingLimit = null;
            return;
        }
        UnitType ut = (UnitType)this.getAttachedTo();
        if (ut == null) {
            throw new GameParseException("getAttachedTo returned null" + this.thisErrorMsg());
        }
        String[] s = value.split(":");
        if (s.length != 2) {
            throw new GameParseException("attackingLimit must have 2 fields, value and count" + this.thisErrorMsg());
        }
        int max = UnitAttachment.getInt(s[0]);
        if (max < 0) {
            throw new GameParseException("attackingLimit count must have a positive number" + this.thisErrorMsg());
        }
        if (!(s[1].equals("owned") || s[1].equals("allied") || s[1].equals("total"))) {
            throw new GameParseException("attackingLimit value must owned, allied, or total" + this.thisErrorMsg());
        }
        this.m_attackingLimit = new Tuple<Integer, String>(max, s[1]);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAttackingLimit(Tuple<Integer, String> value) {
        this.m_attackingLimit = value;
    }

    public Tuple<Integer, String> getAttackingLimit() {
        return this.m_attackingLimit;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setPlacementLimit(String value) throws GameParseException {
        if (value == null) {
            this.m_placementLimit = null;
            return;
        }
        UnitType ut = (UnitType)this.getAttachedTo();
        if (ut == null) {
            throw new GameParseException("getAttachedTo returned null" + this.thisErrorMsg());
        }
        String[] s = value.split(":");
        if (s.length != 2) {
            throw new GameParseException("placementLimit must have 2 fields, value and count" + this.thisErrorMsg());
        }
        int max = UnitAttachment.getInt(s[0]);
        if (max < 0) {
            throw new GameParseException("placementLimit count must have a positive number" + this.thisErrorMsg());
        }
        if (!(s[1].equals("owned") || s[1].equals("allied") || s[1].equals("total"))) {
            throw new GameParseException("placementLimit value must owned, allied, or total" + this.thisErrorMsg());
        }
        this.m_placementLimit = new Tuple<Integer, String>(max, s[1]);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setPlacementLimit(Tuple<Integer, String> value) {
        this.m_placementLimit = value;
    }

    public Tuple<Integer, String> getPlacementLimit() {
        return this.m_placementLimit;
    }

    public static int getMaximumNumberOfThisUnitTypeToReachStackingLimit(String limitType, UnitType ut, Territory t, PlayerID owner, GameData data) {
        Tuple<Integer, String> stackingLimit;
        UnitAttachment ua = UnitAttachment.get(ut);
        if (limitType.equals("movementLimit")) {
            stackingLimit = ua.getMovementLimit();
        } else if (limitType.equals("attackingLimit")) {
            stackingLimit = ua.getAttackingLimit();
        } else if (limitType.equals("placementLimit")) {
            stackingLimit = ua.getPlacementLimit();
        } else {
            throw new IllegalStateException("getMaximumNumberOfThisUnitTypeToReachStackingLimit does not allow limitType: " + limitType);
        }
        if (stackingLimit == null) {
            return Integer.MAX_VALUE;
        }
        int max = stackingLimit.getFirst();
        if (!(max != Integer.MAX_VALUE || !ua.getIsAAforBombingThisUnitOnly() && !ua.getIsAAforCombatOnly() || Properties.getWW2V2(data) || Properties.getWW2V3(data) || Properties.getMultipleAAPerTerritory(data))) {
            max = 1;
        }
        CompositeMatchAnd<Unit> stackingMatch = new CompositeMatchAnd<Unit>(Matches.unitIsOfType(ut));
        String stackingType = stackingLimit.getSecond();
        if (stackingType.equals("owned")) {
            stackingMatch.add(Matches.unitIsOwnedBy(owner));
        } else if (stackingType.equals("allied")) {
            stackingMatch.add(Matches.isUnitAllied(owner, data));
        }
        int totalInTerritory = Match.countMatches(t.getUnits().getUnits(), stackingMatch);
        return Math.max(0, max - totalInTerritory);
    }

    @Override
    public void validate(GameData data) throws GameParseException {
        if (this.m_isAir) {
            if (this.m_isSea || this.m_isFactory || this.m_isSub || this.m_transportCost != -1 || this.m_carrierCapacity != -1 || this.m_canBlitz || this.m_canBombard || this.m_isMarine || this.m_isInfantry || this.m_isLandTransport || this.m_isAirTransportable || this.m_isCombatTransport) {
                throw new GameParseException("air units can not have certain properties, " + this.thisErrorMsg());
            }
        } else if (this.m_isSea) {
            if (this.m_canIntercept || this.m_canEscort || this.m_canBlitz || this.m_isAir || this.m_isFactory || this.m_isStrategicBomber || this.m_carrierCost != -1 || this.m_transportCost != -1 || this.m_isMarine || this.m_isInfantry || this.m_isLandTransport || this.m_isAirTransportable || this.m_isAirTransport || this.m_isKamikaze) {
                throw new GameParseException("sea units can not have certain properties, " + this.thisErrorMsg());
            }
        } else if (this.m_canIntercept || this.m_canEscort || this.m_canBombard || this.m_isStrategicBomber || this.m_isSub || this.m_carrierCapacity != -1 || this.m_bombard != -1 || this.m_transportCapacity != -1 || this.m_isAirTransport || this.m_isCombatTransport || this.m_isKamikaze) {
            throw new GameParseException("land units can not have certain properties, " + this.thisErrorMsg());
        }
        if (this.m_attackAA < 0 || this.m_attackAAmaxDieSides < -1 || this.m_attackAAmaxDieSides > 200) {
            throw new GameParseException("attackAA or attackAAmaxDieSides is wrong, " + this.thisErrorMsg());
        }
        if (this.m_carrierCapacity != -1 && this.m_carrierCost != -1) {
            throw new GameParseException("carrierCost and carrierCapacity can not be set at same time, " + this.thisErrorMsg());
        }
        if (this.m_transportCost != -1 && this.m_transportCapacity != -1) {
            throw new GameParseException("transportCost and transportCapacity can not be set at same time, " + this.thisErrorMsg());
        }
        if ((this.m_bombingBonus >= 0 || this.m_bombingMaxDieSides >= 0) && !this.m_isStrategicBomber && !this.m_isRocket || this.m_bombingBonus < -1 || this.m_bombingMaxDieSides < -1 || this.m_bombingBonus > 10000 || this.m_bombingMaxDieSides > 200) {
            throw new GameParseException("something wrong with bombingBonus or bombingMaxDieSides, " + this.thisErrorMsg());
        }
        if (this.m_maxBuiltPerPlayer < -1) {
            throw new GameParseException("maxBuiltPerPlayer can not be negative, " + this.thisErrorMsg());
        }
        if (this.m_isCombatTransport && this.m_transportCapacity < 1) {
            throw new GameParseException("can not have isCombatTransport on unit without transportCapacity, " + this.thisErrorMsg());
        }
        if (this.m_isSea && this.m_transportCapacity != -1 && Properties.getTransportCasualtiesRestricted(data) && (this.m_attack > 0 || this.m_defense > 0) && !this.m_isCombatTransport) {
            throw new GameParseException("Restricted transports cannot have attack or defense, " + this.thisErrorMsg());
        }
        if (this.m_isConstruction && (this.m_constructionType == null || this.m_constructionType.equals("none") || this.m_constructionType.equals("") || this.m_constructionsPerTerrPerTypePerTurn < 0 || this.m_maxConstructionsPerTypePerTerr < 0)) {
            throw new GameParseException("Constructions must have constructionType and positive constructionsPerTerrPerType and maxConstructionsPerType, " + this.thisErrorMsg());
        }
        if (!(this.m_isConstruction || (this.m_constructionType == null || this.m_constructionType.equals("none") || this.m_constructionType.equals("")) && this.m_constructionsPerTerrPerTypePerTurn < 0 && this.m_maxConstructionsPerTypePerTerr < 0)) {
            throw new GameParseException("Constructions must have isConstruction true, " + this.thisErrorMsg());
        }
        if (this.m_constructionsPerTerrPerTypePerTurn > this.m_maxConstructionsPerTypePerTerr) {
            throw new GameParseException("Constructions must have constructionsPerTerrPerTypePerTurn Less than maxConstructionsPerTypePerTerr, " + this.thisErrorMsg());
        }
        if (this.m_unitPlacementRestrictions != null) {
            this.getListedTerritories(this.m_unitPlacementRestrictions);
        }
        if (this.m_repairsUnits != null) {
            this.getListedUnits(this.m_repairsUnits);
        }
        if (this.m_requiresUnits != null) {
            for (String[] stringArray : this.m_requiresUnits) {
                this.getListedUnits(stringArray);
            }
        }
        if (this.m_canBeDamaged && this.m_maxDamage < 1 || !this.m_canBeDamaged && !this.m_isFactory && this.m_maxDamage >= 0 || this.m_canDieFromReachingMaxDamage && this.m_maxDamage < 0 && !this.m_isFactory || this.m_canBeDamaged && this.m_isFactory) {
            throw new GameParseException("something wrong with canBeDamaged or maxDamage or canDieFromReachingMaxDamage or isFactory, " + this.thisErrorMsg());
        }
        if (this.m_canInvadeOnlyFrom != null && !this.m_canInvadeOnlyFrom[0].equals("all") && !this.m_canInvadeOnlyFrom[0].equals("none")) {
            for (String transport : this.m_canInvadeOnlyFrom) {
                UnitType ut = this.getData().getUnitTypeList().getUnitType(transport);
                if (ut == null) {
                    throw new GameParseException("No unit called:" + transport + this.thisErrorMsg());
                }
                if (ut.getAttachments() != null && !ut.getAttachments().isEmpty()) continue;
                throw new GameParseException(transport + " has no attachments, please declare " + transport + " in the xml before using it as a transport" + this.thisErrorMsg());
            }
        }
        if (!this.m_receivesAbilityWhenWith.isEmpty()) {
            for (String string : this.m_receivesAbilityWhenWith) {
                String[] s = string.split(":");
                if (s.length != 2) {
                    throw new GameParseException("receivesAbilityWhenWith must have 2 parts, 'ability:unit'" + this.thisErrorMsg());
                }
                if (this.getData().getUnitTypeList().getUnitType(s[1]) == null) {
                    throw new GameParseException("receivesAbilityWhenWith, unit does not exist, name:" + s[1] + this.thisErrorMsg());
                }
                if (s[0].equals("canBlitz")) continue;
                throw new GameParseException("receivesAbilityWhenWith so far only supports: canBlitz" + this.thisErrorMsg());
            }
        }
        if (!this.m_whenCombatDamaged.isEmpty()) {
            for (Tuple tuple : this.m_whenCombatDamaged) {
                String obj = (String)((Tuple)tuple.getSecond()).getFirst();
                if (obj.equals(UNITSMAYNOTLANDONCARRIER) || obj.equals(UNITSMAYNOTLEAVEALLIEDCARRIER)) continue;
                throw new GameParseException("m_whenCombatDamaged so far only supports: unitsMayNotLandOnCarrier, unitsMayNotLeaveAlliedCarrier" + this.thisErrorMsg());
            }
        }
    }

    public Collection<UnitType> getListedUnits(String[] list) {
        ArrayList<UnitType> rVal = new ArrayList<UnitType>();
        for (String name : list) {
            UnitType ut = this.getData().getUnitTypeList().getUnitType(name);
            if (ut == null) {
                throw new IllegalStateException("No unit called: " + name + this.thisErrorMsg());
            }
            rVal.add(ut);
        }
        return rVal;
    }

    public Collection<Territory> getListedTerritories(String[] list) throws GameParseException {
        ArrayList<Territory> rVal = new ArrayList<Territory>();
        for (String name : list) {
            Territory territory = this.getData().getMap().getTerritory(name);
            if (territory == null) {
                throw new GameParseException("No territory called: " + name + this.thisErrorMsg());
            }
            rVal.add(territory);
        }
        return rVal;
    }

    private boolean playerHasRockets(PlayerID player) {
        TechAttachment ta = (TechAttachment)player.getAttachment("techAttatchment");
        if (ta == null) {
            return false;
        }
        return ta.getRocket();
    }

    private boolean playerHasMechInf(PlayerID player) {
        TechAttachment ta = (TechAttachment)player.getAttachment("techAttatchment");
        if (ta == null) {
            return false;
        }
        return ta.getMechanizedInfantry();
    }

    private boolean playerHasParatroopers(PlayerID player) {
        TechAttachment ta = (TechAttachment)player.getAttachment("techAttatchment");
        if (ta == null) {
            return false;
        }
        return ta.getParatroopers();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public String allUnitStatsForExporter() {
        return this.getAttachedTo().toString().replaceFirst("games.strategy.engine.data.", "") + " with:" + "  isAir:" + this.m_isAir + "  isSea:" + this.m_isSea + "  movement:" + this.m_movement + "  attack:" + this.m_attack + "  defense:" + this.m_defense + "  isTwoHit:" + this.m_isTwoHit + "  isFactory:" + this.m_isFactory + "  canBlitz:" + this.m_canBlitz + "  artillerySupportable:" + this.m_artillerySupportable + "  artillery:" + this.m_artillery + "  unitSupportCount:" + this.m_unitSupportCount + "  attackRolls:" + this.m_attackRolls + "  defenseRolls:" + this.m_defenseRolls + "  chooseBestRoll:" + this.m_chooseBestRoll + "  isMarine:" + this.m_isMarine + "  isInfantry:" + this.m_isInfantry + "  isLandTransport:" + this.m_isLandTransport + "  isAirTransportable:" + this.m_isAirTransportable + "  isAirTransport:" + this.m_isAirTransport + "  isStrategicBomber:" + this.m_isStrategicBomber + "  transportCapacity:" + this.m_transportCapacity + "  transportCost:" + this.m_transportCost + "  carrierCapacity:" + this.m_carrierCapacity + "  carrierCost:" + this.m_carrierCost + "  isSub:" + this.m_isSub + "  isDestroyer:" + this.m_isDestroyer + "  canBombard:" + this.m_canBombard + "  bombard:" + this.m_bombard + "  isAAforCombatOnly:" + this.m_isAAforCombatOnly + "  isAAforBombingThisUnitOnly:" + this.m_isAAforBombingThisUnitOnly + "  isAAforFlyOverOnly:" + this.m_isAAforFlyOverOnly + "  attackAA:" + this.m_attackAA + "  attackAAmaxDieSides:" + this.m_attackAAmaxDieSides + "  maxAAattacks:" + this.m_maxAAattacks + "  mayOverStackAA:" + this.m_mayOverStackAA + "  typeAA:" + this.m_typeAA + "  targetsAA:" + (this.m_targetsAA != null ? (this.m_targetsAA.size() == 0 ? "empty" : this.m_targetsAA.toString()) : "all air units") + "  willNotFireIfPresent:" + (this.m_willNotFireIfPresent != null ? (this.m_willNotFireIfPresent.size() == 0 ? "empty" : this.m_willNotFireIfPresent.toString()) : "null") + "  isRocket:" + this.m_isRocket + "  canProduceUnits:" + this.m_canProduceUnits + "  canProduceXUnits:" + this.m_canProduceXUnits + "  createsUnitsList:" + (this.m_createsUnitsList != null ? (this.m_createsUnitsList.size() == 0 ? "empty" : this.m_createsUnitsList.toString()) : "null") + "  createsResourcesList:" + (this.m_createsResourcesList != null ? (this.m_createsResourcesList.size() == 0 ? "empty" : this.m_createsResourcesList.toString()) : "null") + "  fuelCost:" + (this.m_fuelCost != null ? (this.m_fuelCost.size() == 0 ? "empty" : this.m_fuelCost.toString()) : "null") + "  isInfrastructure:" + this.m_isInfrastructure + "  isConstruction:" + this.m_isConstruction + "  constructionType:" + this.m_constructionType + "  constructionsPerTerrPerTypePerTurn:" + this.m_constructionsPerTerrPerTypePerTurn + "  maxConstructionsPerTypePerTerr:" + this.m_maxConstructionsPerTypePerTerr + "  destroyedWhenCapturedBy:" + (this.m_destroyedWhenCapturedBy != null ? (this.m_destroyedWhenCapturedBy.size() == 0 ? "empty" : this.m_destroyedWhenCapturedBy.toString()) : "null") + "  canBeCapturedOnEnteringBy:" + (this.m_canBeCapturedOnEnteringBy != null ? (this.m_canBeCapturedOnEnteringBy.size() == 0 ? "empty" : this.m_canBeCapturedOnEnteringBy.toString()) : "null") + "  canBeDamaged:" + this.m_canBeDamaged + "  canDieFromReachingMaxDamage:" + this.m_canDieFromReachingMaxDamage + "  maxOperationalDamage:" + this.m_maxOperationalDamage + "  maxDamage:" + this.m_maxDamage + "  unitPlacementRestrictions:" + (this.m_unitPlacementRestrictions != null ? (this.m_unitPlacementRestrictions.length == 0 ? "empty" : Arrays.toString(this.m_unitPlacementRestrictions)) : "null") + "  requiresUnits:" + (this.m_requiresUnits != null ? (this.m_requiresUnits.size() == 0 ? "empty" : MyFormatter.listOfArraysToString(this.m_requiresUnits)) : "null") + "  consumesUnits:" + (this.m_consumesUnits != null ? (this.m_consumesUnits.size() == 0 ? "empty" : this.m_consumesUnits.toString()) : "null") + "  canOnlyBePlacedInTerritoryValuedAtX:" + this.m_canOnlyBePlacedInTerritoryValuedAtX + "  maxBuiltPerPlayer:" + this.m_maxBuiltPerPlayer + "  special:" + (this.m_special != null ? (this.m_special.size() == 0 ? "empty" : this.m_special.toString()) : "null") + "  isSuicide:" + this.m_isSuicide + "  isSuicide:" + this.m_isSuicide + "  isCombatTransport:" + this.m_isCombatTransport + "  canInvadeOnlyFrom:" + (this.m_canInvadeOnlyFrom != null ? (this.m_canInvadeOnlyFrom.length == 0 ? "empty" : Arrays.toString(this.m_canInvadeOnlyFrom)) : "null") + "  canBeGivenByTerritoryTo:" + (this.m_canBeGivenByTerritoryTo != null ? (this.m_canBeGivenByTerritoryTo.size() == 0 ? "empty" : this.m_canBeGivenByTerritoryTo.toString()) : "null") + "  receivesAbilityWhenWith:" + (this.m_receivesAbilityWhenWith != null ? (this.m_receivesAbilityWhenWith.size() == 0 ? "empty" : this.m_receivesAbilityWhenWith.toString()) : "null") + "  whenCombatDamaged:" + (this.m_whenCombatDamaged != null ? (this.m_whenCombatDamaged.size() == 0 ? "empty" : this.m_whenCombatDamaged.toString()) : "null") + "  blockade:" + this.m_blockade + "  bombingMaxDieSides:" + this.m_bombingMaxDieSides + "  bombingBonus:" + this.m_bombingBonus + "  bombingTargets:" + this.m_bombingTargets + "  givesMovement:" + (this.m_givesMovement != null ? (this.m_givesMovement.size() == 0 ? "empty" : this.m_givesMovement.toString()) : "null") + "  repairsUnits:" + (this.m_repairsUnits != null ? (this.m_repairsUnits.length == 0 ? "empty" : Arrays.toString(this.m_repairsUnits)) : "null") + "  canScramble:" + this.m_canScramble + "  maxScrambleDistance:" + this.m_maxScrambleDistance + "  isAirBase:" + this.m_isAirBase + "  maxScrambleCount:" + this.m_maxScrambleCount + "  whenCapturedChangesInto:" + (this.m_whenCapturedChangesInto != null ? (this.m_whenCapturedChangesInto.size() == 0 ? "empty" : this.m_whenCapturedChangesInto.toString()) : "null") + "  canIntercept:" + this.m_canIntercept + "  canEscort:" + this.m_canEscort + "  airDefense:" + this.m_airDefense + "  airAttack:" + this.m_airAttack + "  canNotMoveDuringCombatMove:" + this.m_canNotMoveDuringCombatMove + "  movementLimit:" + (this.m_movementLimit != null ? this.m_movementLimit.toString() : "null") + "  attackingLimit:" + (this.m_attackingLimit != null ? this.m_attackingLimit.toString() : "null") + "  placementLimit:" + (this.m_placementLimit != null ? this.m_placementLimit.toString() : "null");
    }

    public String toStringShortAndOnlyImportantDifferences(PlayerID player, boolean useHTML, boolean includeAttachedToName) {
        int bombingBonus;
        StringBuilder stats = new StringBuilder();
        if (includeAttachedToName && this != null && this.getAttachedTo() != null) {
            stats.append(this.getAttachedTo().toString().replaceFirst("games.strategy.engine.data.", "") + ", ");
        }
        if (this.m_isAir) {
            stats.append("Air unit, ");
        } else if (this.m_isSea) {
            stats.append("Sea unit, ");
        } else {
            stats.append("Land unit, ");
        }
        if (this.getAttack(player) > 0) {
            stats.append((this.getAttackRolls(player) > 1 ? this.getAttackRolls(player) + "x " : "") + this.getAttack(player) + " Attack, ");
        }
        if (this.getDefense(player) > 0) {
            stats.append((this.getDefenseRolls(player) > 1 ? this.getDefenseRolls(player) + "x " : "") + this.getDefense(player) + " Defense, ");
        }
        if (this.getMovement(player) > 0) {
            stats.append(this.getMovement(player) + " Movement, ");
        }
        if (this.m_isTwoHit) {
            stats.append("Two Hitpoints, ");
        }
        if ((this.m_isFactory || this.m_canProduceUnits) && this.m_canProduceXUnits < 0) {
            stats.append("can Produce Units Up To Territory Value, ");
        } else if ((this.m_isFactory || this.m_canProduceUnits) && this.m_canProduceXUnits > 0) {
            stats.append("can Produce " + this.m_canProduceXUnits + " Units, ");
        }
        if (this.m_createsUnitsList != null && this.m_createsUnitsList.size() == 1) {
            stats.append("Produces " + this.m_createsUnitsList.totalValues() + " " + this.m_createsUnitsList.keySet().iterator().next().getName() + " Each Turn, ");
        } else if (this.m_createsUnitsList != null && this.m_createsUnitsList.size() > 1) {
            stats.append("Produces " + this.m_createsUnitsList.totalValues() + " Units Each Turn, ");
        }
        if (this.m_createsResourcesList != null && this.m_createsResourcesList.size() == 1) {
            stats.append("Produces " + this.m_createsResourcesList.totalValues() + " " + this.m_createsResourcesList.keySet().iterator().next().getName() + " Each Turn, ");
        } else if (this.m_createsResourcesList != null && this.m_createsResourcesList.size() > 1) {
            stats.append("Produces " + this.m_createsResourcesList.totalValues() + " Resources Each Turn, ");
        }
        if (this.m_fuelCost != null && this.m_fuelCost.size() == 1) {
            stats.append("Uses " + this.m_fuelCost.totalValues() + " " + this.m_fuelCost.keySet().iterator().next().getName() + " Each movement point, ");
        } else if (this.m_fuelCost != null && this.m_fuelCost.size() > 1) {
            stats.append("Uses " + this.m_fuelCost.totalValues() + " Resources Each movement point, ");
        }
        if (this.m_isAAforCombatOnly || this.m_isAAforBombingThisUnitOnly || this.m_isAAforFlyOverOnly) {
            stats.append(this.getAttackAA(player) + "/" + (this.m_attackAAmaxDieSides != -1 ? this.m_attackAAmaxDieSides : this.getData().getDiceSides()) + " ");
            if (this.m_isAAforCombatOnly && this.m_isAAforBombingThisUnitOnly && this.m_isAAforFlyOverOnly) {
                stats.append("Anti-Air, ");
            } else if (this.m_isAAforCombatOnly && this.m_isAAforFlyOverOnly && !Properties.getAATerritoryRestricted(this.getData())) {
                stats.append("Anti-Air for Combat & FlyOver, ");
            } else if (this.m_isAAforBombingThisUnitOnly && this.m_isAAforFlyOverOnly && !Properties.getAATerritoryRestricted(this.getData())) {
                stats.append("Anti-Air for Raids & FlyOver, ");
            } else if (this.m_isAAforCombatOnly) {
                stats.append("Anti-Air for Combat, ");
            } else if (this.m_isAAforBombingThisUnitOnly) {
                stats.append("Anti-Air for Raids, ");
            } else if (this.m_isAAforFlyOverOnly) {
                stats.append("Anti-Air for FlyOver, ");
            }
            if (this.m_maxAAattacks > -1) {
                stats.append(this.m_maxAAattacks + " AA Attacks");
            }
        }
        if (this.m_isRocket && this.playerHasRockets(player)) {
            stats.append("can Rocket Attack, ");
            bombingBonus = this.getBombingBonus();
            if ((this.m_bombingMaxDieSides != -1 || bombingBonus != -1) && Properties.getUseBombingMaxDiceSidesAndBonus(this.getData())) {
                stats.append((bombingBonus != -1 ? bombingBonus + 1 : 1) + "-" + (this.m_bombingMaxDieSides != -1 ? this.m_bombingMaxDieSides + (bombingBonus != -1 ? bombingBonus : 0) : this.getData().getDiceSides() + (bombingBonus != -1 ? bombingBonus : 0)) + " Rocket Damage, ");
            } else {
                stats.append("1-" + this.getData().getDiceSides() + " Rocket Damage, ");
            }
        }
        if (useHTML) {
            stats.append("<br /> &nbsp;&nbsp;&nbsp;&nbsp; ");
        }
        if (this.m_isInfrastructure || this.m_isFactory) {
            stats.append("can be Captured, ");
        }
        if (this.m_isConstruction || this.m_isFactory) {
            stats.append("can be Placed Without Factory, ");
        }
        if ((this.m_canBeDamaged || this.m_isFactory) && Properties.getSBRAffectsUnitProduction(this.getData())) {
            stats.append("can be Damaged By Raids, ");
            if (this.m_canDieFromReachingMaxDamage) {
                stats.append("will Die If Max Damage Reached, ");
            }
        } else if ((this.m_canBeDamaged || this.m_isFactory) && Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(this.getData())) {
            stats.append("can be Damaged By Raids, ");
            if (this.m_maxOperationalDamage > -1) {
                stats.append(this.m_maxOperationalDamage + " Max Operational Damage, ");
            }
            if ((this.m_canProduceUnits || this.m_isFactory) && this.m_canProduceXUnits < 0) {
                stats.append("Total Damage up to " + (this.m_maxDamage > -1 ? this.m_maxDamage : 2) + "x Territory Value, ");
            } else if (this.m_maxDamage > -1) {
                stats.append(this.m_maxDamage + " Max Total Damage, ");
            }
            if (this.m_canDieFromReachingMaxDamage) {
                stats.append("will Die If Max Damage Reached, ");
            }
        } else if (this.m_canBeDamaged || this.m_isFactory) {
            stats.append("can be Attacked By Raids, ");
        }
        if (this.m_isAirBase && Properties.getScramble_Rules_In_Effect(this.getData())) {
            stats.append("can Allow Scrambling, ");
        }
        if (this.m_canScramble && Properties.getScramble_Rules_In_Effect(this.getData())) {
            stats.append("can Scramble " + (this.m_maxScrambleDistance > 0 ? this.m_maxScrambleDistance : 1) + " Distance, ");
        }
        if (this.m_artillery) {
            stats.append("can Give Attack Bonus, ");
        }
        if (this.m_artillerySupportable) {
            stats.append("can Receive Attack Bonus, ");
        }
        if (this.m_isMarine) {
            stats.append("1 Amphibious Attack Bonus, ");
        }
        if (this.getCanBlitz(player)) {
            stats.append("can Blitz, ");
        }
        if (!this.m_receivesAbilityWhenWith.isEmpty()) {
            if (this.m_receivesAbilityWhenWith.size() == 1) {
                stats.append("receives " + this.m_receivesAbilityWhenWith.get(0).split(":")[0] + " when paired with " + this.m_receivesAbilityWhenWith.get(0).split(":")[1] + ", ");
            } else {
                stats.append("receives abilities when paired with other units, ");
            }
        }
        if (this.m_isStrategicBomber) {
            stats.append("can Perform Raids, ");
            bombingBonus = this.getBombingBonus();
            if ((this.m_bombingMaxDieSides != -1 || bombingBonus != -1) && Properties.getUseBombingMaxDiceSidesAndBonus(this.getData())) {
                stats.append((bombingBonus != -1 ? bombingBonus + 1 : 1) + "-" + (this.m_bombingMaxDieSides != -1 ? this.m_bombingMaxDieSides + (bombingBonus != -1 ? bombingBonus : 0) : this.getData().getDiceSides() + (bombingBonus != -1 ? bombingBonus : 0)) + " Raid Damage, ");
            } else {
                stats.append("1-" + this.getData().getDiceSides() + " Raid Damage, ");
            }
        }
        if (this.m_isSub) {
            stats.append("is Stealth, ");
        }
        if (this.m_isDestroyer) {
            stats.append("is Anti-Stealth, ");
        }
        if (this.getCanBombard(player) && this.getBombard(player) > 0) {
            stats.append(this.getBombard(player) + " Bombard, ");
        }
        if (this.m_blockade > 0) {
            stats.append(this.m_blockade + " Blockade Loss, ");
        }
        if (this.m_isSuicide) {
            stats.append("Suicide/Munition Unit, ");
        }
        if (this.m_isAir && (this.m_isKamikaze || Properties.getKamikaze_Airplanes(this.getData()))) {
            stats.append("can use All Movement To Attack Target, ");
        }
        if (this.m_isInfantry && this.playerHasMechInf(player)) {
            stats.append("can be Transported By Land, ");
        }
        if (this.m_isLandTransport && this.playerHasMechInf(player)) {
            stats.append("is a Land Transport, ");
        }
        if (this.m_isAirTransportable && this.playerHasParatroopers(player)) {
            stats.append("can be Transported By Air, ");
        }
        if (this.m_isAirTransport && this.playerHasParatroopers(player)) {
            stats.append("is an Air Transport, ");
        }
        if (this.m_isCombatTransport && this.m_transportCapacity > 0) {
            stats.append("is a Combat Transport, ");
        } else if (this.m_transportCapacity > 0 && this.m_isSea) {
            stats.append("is a Sea Transport, ");
        }
        if (this.m_transportCost > -1) {
            stats.append(this.m_transportCost + " Transporting Cost, ");
        }
        if (this.m_transportCapacity > 0 && this.m_isSea) {
            stats.append(this.m_transportCapacity + " Transporting Capacity, ");
        } else if (this.m_transportCapacity > 0 && this.m_isAir && this.playerHasParatroopers(player)) {
            stats.append(this.m_transportCapacity + " Transporting Capacity, ");
        } else if (this.m_transportCapacity > 0 && this.playerHasMechInf(player) && !this.m_isSea && !this.m_isAir) {
            stats.append(this.m_transportCapacity + " Transporting Capacity, ");
        }
        if (this.m_carrierCost > -1) {
            stats.append(this.m_carrierCost + " Carrier Cost, ");
        }
        if (this.m_carrierCapacity > 0) {
            stats.append(this.m_carrierCapacity + " Carrier Capacity, ");
        }
        if (!this.m_whenCombatDamaged.isEmpty()) {
            stats.append("when hit this unit loses certain abilities, ");
        }
        if (useHTML) {
            stats.append("<br /> &nbsp;&nbsp;&nbsp;&nbsp; ");
        }
        if (this.m_maxBuiltPerPlayer > -1) {
            stats.append(this.m_maxBuiltPerPlayer + " Max Built Allowed, ");
        }
        if (this.m_repairsUnits != null && Properties.getTwoHitPointUnitsRequireRepairFacilities(this.getData()) && (Properties.getBattleshipsRepairAtBeginningOfRound(this.getData()) || Properties.getBattleshipsRepairAtEndOfRound(this.getData()))) {
            stats.append("can Repair Some Units, ");
        }
        if (this.m_givesMovement != null && this.m_givesMovement.totalValues() > 0 && Properties.getUnitsMayGiveBonusMovement(this.getData())) {
            stats.append("can Give Bonus Movement, ");
        } else if (this.m_givesMovement != null && this.m_givesMovement.totalValues() < 0 && Properties.getUnitsMayGiveBonusMovement(this.getData())) {
            stats.append("can Take Away Movement, ");
        }
        if (this.m_consumesUnits != null && this.m_consumesUnits.totalValues() == 1) {
            stats.append("unit is an Upgrade Of " + this.m_consumesUnits.keySet().iterator().next().getName() + ", ");
        } else if (this.m_consumesUnits != null && this.m_consumesUnits.totalValues() > 1) {
            stats.append("unit Consumes Other Units On Placement, ");
        }
        if (this.m_requiresUnits != null && this.m_requiresUnits.size() == 1 && this.m_requiresUnits.iterator().next().length == 1 && Properties.getUnitPlacementRestrictions(this.getData())) {
            stats.append("unit can only be Placed Where There Is A " + this.m_requiresUnits.iterator().next()[0] + ", ");
        } else if (this.m_requiresUnits != null && this.m_requiresUnits.size() > 0 && Properties.getUnitPlacementRestrictions(this.getData())) {
            stats.append("unit Requires Other Units Present To Be Placed, ");
        }
        if (this.m_unitPlacementRestrictions != null && Properties.getUnitPlacementRestrictions(this.getData())) {
            stats.append("has Placement Restrictions, ");
        }
        if (this.m_canOnlyBePlacedInTerritoryValuedAtX > 0 && Properties.getUnitPlacementRestrictions(this.getData())) {
            stats.append("must be Placed In Territory Valued >=" + this.m_canOnlyBePlacedInTerritoryValuedAtX + ", ");
        }
        if (this.m_canNotMoveDuringCombatMove) {
            stats.append("cannot Combat Move, ");
        }
        if (this.m_movementLimit != null) {
            if (!(this.m_movementLimit.getFirst() != Integer.MAX_VALUE || !this.m_isAAforBombingThisUnitOnly && !this.m_isAAforCombatOnly || Properties.getWW2V2(this.getData()) || Properties.getWW2V3(this.getData()) || Properties.getMultipleAAPerTerritory(this.getData()))) {
                stats.append("max of 1 " + this.m_movementLimit.getSecond() + " moving per territory, ");
            } else if (this.m_movementLimit.getFirst() < 10000) {
                stats.append("max of " + this.m_movementLimit.getFirst() + " " + this.m_movementLimit.getSecond() + " moving per territory, ");
            }
        }
        if (this.m_attackingLimit != null) {
            if (!(this.m_attackingLimit.getFirst() != Integer.MAX_VALUE || !this.m_isAAforBombingThisUnitOnly && !this.m_isAAforCombatOnly || Properties.getWW2V2(this.getData()) || Properties.getWW2V3(this.getData()) || Properties.getMultipleAAPerTerritory(this.getData()))) {
                stats.append("max of 1 " + this.m_attackingLimit.getSecond() + " attacking per territory, ");
            } else if (this.m_attackingLimit.getFirst() < 10000) {
                stats.append("max of " + this.m_attackingLimit.getFirst() + " " + this.m_attackingLimit.getSecond() + " attacking per territory, ");
            }
        }
        if (this.m_placementLimit != null) {
            if (!(this.m_placementLimit.getFirst() != Integer.MAX_VALUE || !this.m_isAAforBombingThisUnitOnly && !this.m_isAAforCombatOnly || Properties.getWW2V2(this.getData()) || Properties.getWW2V3(this.getData()) || Properties.getMultipleAAPerTerritory(this.getData()))) {
                stats.append("max of 1 " + this.m_placementLimit.getSecond() + " placed per territory, ");
            } else if (this.m_placementLimit.getFirst() < 10000) {
                stats.append("max of " + this.m_placementLimit.getFirst() + " " + this.m_placementLimit.getSecond() + " placed per territory, ");
            }
        }
        if (stats.indexOf(", ") > -1) {
            stats.delete(stats.lastIndexOf(", "), stats.length() - 1);
        }
        return stats.toString();
    }

    @Deprecated
    @GameProperty(xmlProperty=true, gameProperty=false, adds=false)
    public void setIsParatroop(String s) {
    }

    @Deprecated
    @GameProperty(xmlProperty=true, gameProperty=false, adds=false)
    public void setIsMechanized(String s) {
    }
}

