/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.net.GUID;
import games.strategy.triplea.ai.weakAI.WeakAI;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.triplea.delegate.dataObjects.BattleRecord;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.triplea.ui.display.ITripleaDisplay;
import games.strategy.util.IntegerMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBattle
implements IBattle,
Serializable {
    private static final long serialVersionUID = 871090498661731337L;
    protected final GUID m_battleID = new GUID();
    protected boolean m_headless = false;
    protected final Territory m_battleSite;
    protected final PlayerID m_attacker;
    protected PlayerID m_defender;
    protected final BattleTracker m_battleTracker;
    protected final GameData m_data;
    protected int m_round = 0;
    protected final boolean m_isBombingRun;
    protected boolean m_isAmphibious = false;
    protected IBattle.BattleType m_battleType;
    protected boolean m_isOver = false;
    protected final Map<Unit, Collection<Unit>> m_dependentUnits = new HashMap<Unit, Collection<Unit>>();
    protected List<Unit> m_attackingUnits = new ArrayList<Unit>();
    protected List<Unit> m_defendingUnits = new ArrayList<Unit>();
    protected List<Unit> m_amphibiousLandAttackers = new ArrayList<Unit>();
    protected List<Unit> m_bombardingUnits = new ArrayList<Unit>();
    protected BattleRecord.BattleResultDescription m_battleResultDescription;
    protected IBattle.WhoWon m_whoWon = IBattle.WhoWon.NOTFINISHED;
    protected int m_attackerLostTUV = 0;
    protected int m_defenderLostTUV = 0;

    public AbstractBattle(Territory battleSite, PlayerID attacker, BattleTracker battleTracker, boolean isBombingRun, IBattle.BattleType battleType, GameData data) {
        this.m_battleTracker = battleTracker;
        this.m_attacker = attacker;
        this.m_battleSite = battleSite;
        this.m_isBombingRun = isBombingRun;
        this.m_battleType = battleType;
        this.m_data = data;
        this.m_defender = AbstractBattle.findDefender(battleSite, attacker, data);
    }

    @Override
    public Collection<Unit> getDependentUnits(Collection<Unit> units) {
        ArrayList<Unit> rVal = new ArrayList<Unit>();
        for (Unit unit : units) {
            Collection<Unit> dependent = this.m_dependentUnits.get(unit);
            if (dependent == null) continue;
            rVal.addAll(dependent);
        }
        return rVal;
    }

    @Override
    public void addBombardingUnit(Unit unit) {
        this.m_bombardingUnits.add(unit);
    }

    @Override
    public Collection<Unit> getBombardingUnits() {
        return new ArrayList<Unit>(this.m_bombardingUnits);
    }

    @Override
    public boolean isAmphibious() {
        return this.m_isAmphibious;
    }

    @Override
    public Collection<Unit> getAmphibiousLandAttackers() {
        return new ArrayList<Unit>(this.m_amphibiousLandAttackers);
    }

    @Override
    public Collection<Unit> getAttackingUnits() {
        return new ArrayList<Unit>(this.m_attackingUnits);
    }

    @Override
    public Collection<Unit> getDefendingUnits() {
        return new ArrayList<Unit>(this.m_defendingUnits);
    }

    @Override
    public List<Unit> getRemainingAttackingUnits() {
        return new ArrayList<Unit>(this.m_attackingUnits);
    }

    @Override
    public List<Unit> getRemainingDefendingUnits() {
        return new ArrayList<Unit>(this.m_defendingUnits);
    }

    @Override
    public abstract boolean isEmpty();

    @Override
    public final boolean isOver() {
        return this.m_isOver;
    }

    @Override
    public boolean isBombingRun() {
        return this.m_isBombingRun;
    }

    @Override
    public IBattle.BattleType getBattleType() {
        return this.m_battleType;
    }

    @Override
    public int getBattleRound() {
        return this.m_round;
    }

    @Override
    public IBattle.WhoWon getWhoWon() {
        return this.m_whoWon;
    }

    @Override
    public BattleRecord.BattleResultDescription getBattleResultDescription() {
        return this.m_battleResultDescription;
    }

    @Override
    public GUID getBattleID() {
        return this.m_battleID;
    }

    @Override
    public final Territory getTerritory() {
        return this.m_battleSite;
    }

    @Override
    public PlayerID getAttacker() {
        return this.m_attacker;
    }

    @Override
    public PlayerID getDefender() {
        return this.m_defender;
    }

    public void setHeadless(boolean aBool) {
        this.m_headless = aBool;
    }

    @Override
    public abstract void fight(IDelegateBridge var1);

    @Override
    public abstract Change addAttackChange(Route var1, Collection<Unit> var2, HashMap<Unit, HashSet<Unit>> var3);

    @Override
    public abstract void removeAttack(Route var1, Collection<Unit> var2);

    @Override
    public abstract void unitsLostInPrecedingBattle(IBattle var1, Collection<Unit> var2, IDelegateBridge var3);

    public int hashCode() {
        return this.m_battleSite.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof IBattle)) {
            return false;
        }
        IBattle other = (IBattle)o;
        return other.getTerritory().equals(this.m_battleSite) && other.isBombingRun() == this.isBombingRun() && other.getBattleType().equals((Object)this.getBattleType());
    }

    public String toString() {
        return "Battle in:" + this.m_battleSite + " battle type:" + (Object)((Object)this.m_battleType) + " defender:" + this.m_defender.getName() + " attacked by:" + this.m_attacker.getName() + " attacking with: " + this.m_attackingUnits;
    }

    public static PlayerID findDefender(Territory battleSite, PlayerID attacker, GameData data) {
        if (battleSite == null) {
            return PlayerID.NULL_PLAYERID;
        }
        PlayerID defender = null;
        if (!battleSite.isWater()) {
            defender = battleSite.getOwner();
        }
        if (data == null || attacker == null) {
            if (defender == null) {
                return PlayerID.NULL_PLAYERID;
            }
            return defender;
        }
        if (defender == null || battleSite.isWater() || !data.getRelationshipTracker().isAtWar(attacker, defender)) {
            IntegerMap<PlayerID> players = battleSite.getUnits().getPlayerUnitCounts();
            int max = -1;
            for (PlayerID current : players.keySet()) {
                int count;
                if (current.equals(attacker) || !data.getRelationshipTracker().isAtWar(attacker, current) || (count = players.getInt(current)) <= max) continue;
                max = count;
                defender = current;
            }
        }
        if (defender == null) {
            return PlayerID.NULL_PLAYERID;
        }
        return defender;
    }

    public static int getMaxHits(Collection<Unit> units) {
        int count = 0;
        for (Unit unit : units) {
            if (UnitAttachment.get(unit.getUnitType()).getIsTwoHit()) {
                count += 2;
                count -= unit.getHits();
                continue;
            }
            ++count;
        }
        return count;
    }

    protected static TransportTracker getTransportTracker() {
        return new TransportTracker();
    }

    protected static ITripleaDisplay getDisplay(IDelegateBridge bridge) {
        return (ITripleaDisplay)bridge.getDisplayChannelBroadcaster();
    }

    protected static ITripleaPlayer getRemote(IDelegateBridge bridge) {
        return (ITripleaPlayer)bridge.getRemote();
    }

    protected static ITripleaPlayer getRemote(PlayerID player, IDelegateBridge bridge) {
        if (player.isNull()) {
            return new WeakAI(player.getName(), "E.Z. Fodder (AI)");
        }
        return (ITripleaPlayer)bridge.getRemote(player);
    }
}

