/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.common.delegate.BaseDelegate;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.RelationshipTracker;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.message.IRemote;
import games.strategy.engine.pbem.PBEMMessagePoster;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.PlayerAttachment;
import games.strategy.triplea.attatchments.TechAbilityAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.EndTurnExtendedDelegateState;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveDelegate;
import games.strategy.triplea.delegate.remote.IAbstractEndTurnDelegate;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEndTurnDelegate
extends BaseDelegate
implements IAbstractEndTurnDelegate {
    private boolean m_needToInitialize = true;
    private boolean m_hasPostedTurnSummary = false;
    private static int CONVOY_BLOCKADE_DICE_SIDES = 6;

    private boolean doBattleShipsRepairEndOfTurn() {
        return Properties.getBattleshipsRepairAtEndOfRound(this.getData());
    }

    private boolean isGiveUnitsByTerritory() {
        return Properties.getGiveUnitsByTerritory(this.getData());
    }

    @Override
    public void start(IDelegateBridge aBridge) {
        GameData data = aBridge.getData();
        Resource PUs = data.getResourceList().getResource("PUs");
        int leftOverPUs = aBridge.getPlayerID().getResources().getQuantity(PUs);
        super.start(aBridge);
        if (!this.m_needToInitialize) {
            return;
        }
        this.m_hasPostedTurnSummary = false;
        PlayerAttachment pa = PlayerAttachment.get(this.m_player);
        ArrayList<Territory> capitalsListOriginal = new ArrayList<Territory>(TerritoryAttachment.getAllCapitals(this.m_player, data));
        ArrayList<Territory> capitalsListOwned = new ArrayList<Territory>(TerritoryAttachment.getAllCurrentlyOwnedCapitals(this.m_player, data));
        if (!capitalsListOriginal.isEmpty() && capitalsListOwned.isEmpty() || pa != null && pa.getRetainCapitalProduceNumber() > capitalsListOwned.size()) {
            return;
        }
        Collection<Territory> territories = data.getMap().getTerritoriesOwnedBy(this.m_player);
        int toAdd = this.getProduction(territories);
        int blockadeLoss = this.getProductionLoss(this.m_player, data, aBridge);
        toAdd -= blockadeLoss;
        int total = this.m_player.getResources().getQuantity(PUs) + (toAdd *= Properties.getPU_Multiplier(data).intValue());
        String transcriptText = blockadeLoss == 0 ? this.m_player.getName() + " collect " + toAdd + MyFormatter.pluralize(" PU", toAdd) + "; end with " + total + MyFormatter.pluralize(" PU", total) + " total" : this.m_player.getName() + " collect " + toAdd + MyFormatter.pluralize(" PU", toAdd) + " (" + blockadeLoss + " lost to blockades)" + "; end with " + total + MyFormatter.pluralize(" PU", total) + " total";
        aBridge.getHistoryWriter().startEvent(transcriptText);
        int bonds = this.rollWarBonds(aBridge, this.m_player, data);
        if (bonds > 0) {
            toAdd += bonds;
            transcriptText = this.m_player.getName() + " collect " + bonds + MyFormatter.pluralize(" PU", bonds) + " from War Bonds; end with " + (total += bonds) + MyFormatter.pluralize(" PU", total) + " total";
            aBridge.getHistoryWriter().startEvent(transcriptText);
        }
        if (total < 0) {
            toAdd -= total;
            total = 0;
        }
        Change change = ChangeFactory.changeResourcesChange(this.m_player, PUs, toAdd);
        aBridge.addChange(change);
        if (data.getProperties().get("Pacific Theater", false) && pa != null) {
            Change changeVP = ChangeFactory.attachmentPropertyChange(pa, pa.getVps() + toAdd / 10 + pa.getCaptureVps() / 10, "vps");
            Change changeCapVP = ChangeFactory.attachmentPropertyChange(pa, "0", "captureVps");
            CompositeChange ccVP = new CompositeChange(changeVP, changeCapVP);
            aBridge.addChange(ccVP);
        }
        this.addOtherResources(aBridge);
        this.doNationalObjectivesAndOtherEndTurnEffects(aBridge);
        if (this.doBattleShipsRepairEndOfTurn()) {
            MoveDelegate.repairBattleShips(aBridge, aBridge.getPlayerID(), false);
        }
        if (this.isGiveUnitsByTerritory() && pa != null && pa.getGiveUnitControl() != null && !pa.getGiveUnitControl().isEmpty()) {
            this.changeUnitOwnership(aBridge);
        }
        int currentPUs = this.m_player.getResources().getQuantity(PUs);
        float gainedPUS = Math.max(0, currentPUs - leftOverPUs);
        int relationshipUpkeepCostFlat = 0;
        int relationshipUpkeepCostPercentage = 0;
        int relationshipUpkeepTotalCost = 0;
        for (RelationshipTracker.Relationship r : data.getRelationshipTracker().getRelationships(this.m_player)) {
            String[] upkeep = r.getRelationshipType().getRelationshipTypeAttachment().getUpkeepCost().split(":");
            if (upkeep.length == 1 || upkeep[1].equals("flat")) {
                relationshipUpkeepCostFlat += Integer.parseInt(upkeep[0]);
                continue;
            }
            if (!upkeep[1].equals("percentage")) continue;
            relationshipUpkeepCostPercentage += Integer.parseInt(upkeep[0]);
        }
        if ((relationshipUpkeepCostPercentage = Math.min(100, relationshipUpkeepCostPercentage)) != 0) {
            relationshipUpkeepTotalCost += Math.round(gainedPUS * (float)relationshipUpkeepCostPercentage / 100.0f);
        }
        if (relationshipUpkeepCostFlat != 0) {
            relationshipUpkeepTotalCost += relationshipUpkeepCostFlat;
        }
        relationshipUpkeepTotalCost = Math.min(currentPUs, relationshipUpkeepTotalCost);
        if ((relationshipUpkeepTotalCost = -1 * relationshipUpkeepTotalCost) != 0) {
            int newTotal = currentPUs + relationshipUpkeepTotalCost;
            transcriptText = this.m_player.getName() + (relationshipUpkeepTotalCost < 0 ? " pays " : " taxes ") + -1 * relationshipUpkeepTotalCost + MyFormatter.pluralize(" PU", relationshipUpkeepTotalCost) + " in order to maintain current relationships with other players, and ends the turn with " + newTotal + MyFormatter.pluralize(" PU", newTotal);
            aBridge.getHistoryWriter().startEvent(transcriptText);
            Change upkeep = ChangeFactory.changeResourcesChange(this.m_player, PUs, relationshipUpkeepTotalCost);
            aBridge.addChange(upkeep);
        }
        this.m_needToInitialize = false;
    }

    @Override
    public void end() {
        super.end();
        this.m_needToInitialize = true;
        DelegateFinder.battleDelegate(this.getData()).getBattleTracker().clear();
    }

    @Override
    public Serializable saveState() {
        EndTurnExtendedDelegateState state = new EndTurnExtendedDelegateState();
        state.superState = super.saveState();
        state.m_needToInitialize = this.m_needToInitialize;
        state.m_hasPostedTurnSummary = this.m_hasPostedTurnSummary;
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        EndTurnExtendedDelegateState s = (EndTurnExtendedDelegateState)state;
        super.loadState(s.superState);
        this.m_needToInitialize = s.m_needToInitialize;
        this.m_hasPostedTurnSummary = s.m_hasPostedTurnSummary;
    }

    private int rollWarBonds(IDelegateBridge aBridge, PlayerID player, GameData data) {
        int count = TechAbilityAttachment.getWarBondDiceNumber(player, data);
        int sides = TechAbilityAttachment.getWarBondDiceSides(player, data);
        if (sides <= 0 || count <= 0) {
            return 0;
        }
        String annotation = player.getName() + " roll to resolve War Bonds: ";
        DiceRoll dice = DiceRoll.rollNDice(aBridge, count, sides, annotation);
        int total = 0;
        for (int i = 0; i < dice.size(); ++i) {
            total += dice.getDie(i).getValue() + 1;
        }
        this.getRemotePlayer(player).reportMessage(annotation + MyFormatter.asDice(dice), annotation + MyFormatter.asDice(dice));
        return total;
    }

    private ITripleaPlayer getRemotePlayer(PlayerID player) {
        return (ITripleaPlayer)this.m_bridge.getRemote(player);
    }

    private void changeUnitOwnership(IDelegateBridge aBridge) {
        PlayerID Player = aBridge.getPlayerID();
        PlayerAttachment pa = PlayerAttachment.get(Player);
        ArrayList<PlayerID> PossibleNewOwners = pa.getGiveUnitControl();
        Collection<Territory> territories = aBridge.getData().getMap().getTerritories();
        CompositeChange change = new CompositeChange();
        ArrayList<Tuple<Territory, List<Unit>>> changeList = new ArrayList<Tuple<Territory, List<Unit>>>();
        for (Territory territory : territories) {
            TerritoryAttachment ta = (TerritoryAttachment)territory.getAttachment("territoryAttatchment");
            if (ta == null || ta.getChangeUnitOwners() == null || ta.getChangeUnitOwners().isEmpty()) continue;
            ArrayList<PlayerID> terrNewOwners = ta.getChangeUnitOwners();
            for (PlayerID terrNewOwner : terrNewOwners) {
                List<Unit> units;
                if (!PossibleNewOwners.contains(terrNewOwner) || (units = territory.getUnits().getMatches(new CompositeMatchAnd<Unit>(Matches.unitOwnedBy(Player), Matches.UnitCanBeGivenByTerritoryTo(terrNewOwner)))).isEmpty()) continue;
                change.add(ChangeFactory.changeOwner(units, terrNewOwner, territory));
                changeList.add(new Tuple<Territory, List<Unit>>(territory, units));
            }
        }
        if (!change.isEmpty() && !changeList.isEmpty()) {
            if (changeList.size() == 1) {
                Tuple tuple = (Tuple)changeList.iterator().next();
                aBridge.getHistoryWriter().startEvent("Some Units in " + ((Territory)tuple.getFirst()).getName() + " change ownership: " + MyFormatter.unitsToTextNoOwner((Collection)tuple.getSecond()), tuple.getSecond());
            } else {
                aBridge.getHistoryWriter().startEvent("Units Change Ownership");
                for (Tuple tuple : changeList) {
                    aBridge.getHistoryWriter().addChildToEvent("Some Units in " + ((Territory)tuple.getFirst()).getName() + " change ownership: " + MyFormatter.unitsToTextNoOwner((Collection)tuple.getSecond()), tuple.getSecond());
                }
            }
            aBridge.addChange(change);
        }
    }

    protected abstract void addOtherResources(IDelegateBridge var1);

    protected abstract void doNationalObjectivesAndOtherEndTurnEffects(IDelegateBridge var1);

    protected int getProduction(Collection<Territory> territories) {
        return AbstractEndTurnDelegate.getProduction(territories, this.getData());
    }

    public static int getProduction(Collection<Territory> territories, GameData data) {
        int value = 0;
        for (Territory current : territories) {
            TerritoryAttachment attachment = (TerritoryAttachment)current.getAttachment("territoryAttatchment");
            if (attachment == null) {
                throw new IllegalStateException("No attachment for owned territory:" + current.getName());
            }
            if (!Matches.territoryCanCollectIncomeFrom(current.getOwner(), data).match(current)) continue;
            value += attachment.getProduction();
        }
        return value;
    }

    protected int getProductionLoss(PlayerID player, GameData data, IDelegateBridge aBridge) {
        GameMap map = data.getMap();
        List<Territory> blockable = Match.getMatches(map.getTerritories(), Matches.territoryIsBlockadeZone);
        if (blockable.isEmpty()) {
            return 0;
        }
        CompositeMatchAnd enemyUnits = new CompositeMatchAnd(Matches.enemyUnit(player, data));
        int totalLoss = 0;
        boolean rollDiceForBlockadeDamage = Properties.getConvoyBlockadesRollDiceForCost(data);
        ArrayList<String> transcripts = new ArrayList<String>();
        HashMap<Territory, Tuple<Integer, List<Territory>>> damagePerBlockadeZone = new HashMap<Territory, Tuple<Integer, List<Territory>>>();
        for (Territory b : blockable) {
            List<Territory> viableNeighbors = Match.getMatches(map.getNeighbors(b), new CompositeMatchAnd(Matches.isTerritoryOwnedBy(player), Matches.territoryCanCollectIncomeFrom(player, data)));
            int maxLoss = this.getProduction(viableNeighbors);
            if (maxLoss <= 0) continue;
            int loss = 0;
            List<Unit> enemies = Match.getMatches(b.getUnits().getUnits(), enemyUnits);
            if (rollDiceForBlockadeDamage) {
                int numberOfDice = 0;
                for (Unit u : enemies) {
                    numberOfDice += UnitAttachment.get(u.getType()).getBlockade();
                }
                if (numberOfDice > 0) {
                    String transcript = "Rolling for Convoy Blockade Damage in " + b.getName();
                    int[] dice = aBridge.getRandom(CONVOY_BLOCKADE_DICE_SIDES, numberOfDice, transcript);
                    transcripts.add(transcript + ". Rolls: " + MyFormatter.asDice(dice));
                    for (int d : dice) {
                        int roll = d + 1;
                        loss += roll <= 3 ? roll : 0;
                    }
                }
            } else {
                for (Unit u : enemies) {
                    loss += UnitAttachment.get(u.getType()).getBlockade();
                }
            }
            if (loss <= 0) continue;
            int lossForBlockade = Math.min(maxLoss, loss);
            damagePerBlockadeZone.put(b, new Tuple<Integer, List<Territory>>(lossForBlockade, viableNeighbors));
            totalLoss += lossForBlockade;
        }
        if (totalLoss <= 0) {
            return 0;
        }
        ArrayList<Territory> blockadeZonesSorted = new ArrayList<Territory>(damagePerBlockadeZone.keySet());
        Collections.sort(blockadeZonesSorted, AbstractEndTurnDelegate.getSingleBlockadeThenHighestToLowestBlockadeDamage(damagePerBlockadeZone));
        IntegerMap<Territory> totalDamageTracker = new IntegerMap<Territory>();
        for (Territory b : blockadeZonesSorted) {
            int damageToTerr;
            Tuple<Integer, List<Territory>> tuple = damagePerBlockadeZone.get(b);
            ArrayList terrsLosingIncome = new ArrayList(tuple.getSecond());
            Collections.sort(terrsLosingIncome, AbstractEndTurnDelegate.getSingleNeighborBlockadesThenHighestToLowestProduction(blockadeZonesSorted, map));
            Iterator iter = terrsLosingIncome.iterator();
            for (int damageForZone = tuple.getFirst().intValue(); damageForZone > 0 && iter.hasNext(); damageForZone -= damageToTerr) {
                Territory t = (Territory)iter.next();
                int maxProductionLessPreviousDamage = TerritoryAttachment.get(t).getProduction() - totalDamageTracker.getInt(t);
                damageToTerr = Math.min(damageForZone, maxProductionLessPreviousDamage);
                totalDamageTracker.put(t, damageToTerr + totalDamageTracker.getInt(t));
            }
        }
        int realTotalLoss = Math.max(0, totalDamageTracker.totalValues());
        if (rollDiceForBlockadeDamage && realTotalLoss > 0 && !transcripts.isEmpty()) {
            aBridge.getHistoryWriter().startEvent("Total Cost from Convoy Blockades: " + realTotalLoss);
            for (String t : transcripts) {
                aBridge.getHistoryWriter().addChildToEvent(t);
            }
        }
        return realTotalLoss;
    }

    @Override
    public void setHasPostedTurnSummary(boolean hasPostedTurnSummary) {
        this.m_hasPostedTurnSummary = hasPostedTurnSummary;
    }

    @Override
    public boolean getHasPostedTurnSummary() {
        return this.m_hasPostedTurnSummary;
    }

    @Override
    public boolean postTurnSummary(PBEMMessagePoster poster) {
        this.m_hasPostedTurnSummary = poster.post(this.m_bridge.getHistoryWriter());
        return this.m_hasPostedTurnSummary;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getDisplayName() {
        return this.m_displayName;
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return IAbstractEndTurnDelegate.class;
    }

    private static Comparator<Territory> getSingleNeighborBlockadesThenHighestToLowestProduction(final Collection<Territory> blockadeZones, final GameMap map) {
        return new Comparator<Territory>(){

            @Override
            public int compare(Territory t1, Territory t2) {
                int p2;
                if (t1 == t2 || t1.equals(t2) || t1 == null && t2 == null) {
                    return 0;
                }
                if (t1 == null) {
                    return 1;
                }
                if (t2 == null) {
                    return -1;
                }
                ArrayList<Territory> neighborBlockades1 = new ArrayList<Territory>(map.getNeighbors(t1));
                neighborBlockades1.retainAll(blockadeZones);
                int n1 = neighborBlockades1.size();
                ArrayList<Territory> neighborBlockades2 = new ArrayList<Territory>(map.getNeighbors(t2));
                neighborBlockades2.retainAll(blockadeZones);
                int n2 = neighborBlockades2.size();
                if (n1 == 1 && n2 != 1) {
                    return -1;
                }
                if (n2 == 1 && n1 != 1) {
                    return 1;
                }
                TerritoryAttachment ta1 = TerritoryAttachment.get(t1);
                TerritoryAttachment ta2 = TerritoryAttachment.get(t2);
                if (ta1 == null && ta2 == null) {
                    return 0;
                }
                if (ta1 == null) {
                    return 1;
                }
                if (ta2 == null) {
                    return -1;
                }
                int p1 = ta1.getProduction();
                if (p1 == (p2 = ta2.getProduction())) {
                    return 0;
                }
                if (p1 > p2) {
                    return -1;
                }
                return 1;
            }
        };
    }

    private static Comparator<Territory> getSingleBlockadeThenHighestToLowestBlockadeDamage(final HashMap<Territory, Tuple<Integer, List<Territory>>> damagePerBlockadeZone) {
        return new Comparator<Territory>(){

            @Override
            public int compare(Territory t1, Territory t2) {
                int d2;
                if (t1 == t2 || t1.equals(t2) || t1 == null && t2 == null) {
                    return 0;
                }
                if (t1 == null) {
                    return 1;
                }
                if (t2 == null) {
                    return -1;
                }
                Tuple tuple1 = (Tuple)damagePerBlockadeZone.get(t1);
                Tuple tuple2 = (Tuple)damagePerBlockadeZone.get(t2);
                int num1 = ((List)tuple1.getSecond()).size();
                int num2 = ((List)tuple2.getSecond()).size();
                if (num1 == 1 && num2 != 1) {
                    return -1;
                }
                if (num2 == 1 && num1 != 1) {
                    return 1;
                }
                int d1 = (Integer)tuple1.getFirst();
                if (d1 == (d2 = ((Integer)tuple2.getFirst()).intValue())) {
                    return 0;
                }
                if (d1 > d2) {
                    return -1;
                }
                return 1;
            }
        };
    }
}

