/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.common.delegate.BaseDelegate;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.RouteScripted;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.delegate.AutoSave;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.message.IRemote;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.ai.weakAI.WeakAI;
import games.strategy.triplea.attatchments.PlayerAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.AirMovementValidator;
import games.strategy.triplea.delegate.BattleExtendedDelegateState;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MustFightBattle;
import games.strategy.triplea.delegate.OriginalOwnerTracker;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.triplea.delegate.TripleADelegateBridge;
import games.strategy.triplea.delegate.UnitComparator;
import games.strategy.triplea.delegate.dataObjects.BattleListing;
import games.strategy.triplea.delegate.dataObjects.BattleRecord;
import games.strategy.triplea.delegate.remote.IBattleDelegate;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.oddsCalculator.ta.BattleResults;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.util.CompositeMatch;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AutoSave(beforeStepStart=true, afterStepEnd=true)
public class BattleDelegate
extends BaseDelegate
implements IBattleDelegate {
    private BattleTracker m_battleTracker = new BattleTracker();
    private OriginalOwnerTracker m_originalOwnerTracker = new OriginalOwnerTracker();
    private boolean m_needToInitialize = true;
    private boolean m_needToScramble = true;
    private boolean m_needToKamikazeSuicideAttacks = true;
    private boolean m_needToAddBombardmentSources = true;
    private boolean m_needToRecordBattleStatistics = true;
    private boolean m_needToCheckDefendingPlanesCanLand = true;
    private boolean m_needToCleanup = true;
    private IBattle m_currentBattle = null;

    @Override
    public void start(IDelegateBridge aBridge) {
        super.start(new TripleADelegateBridge(aBridge));
        if (this.m_needToInitialize) {
            BattleDelegate.doInitialize(this.m_battleTracker, this.m_bridge);
            this.m_needToInitialize = false;
        }
        if (this.m_needToScramble) {
            this.doScrambling();
            this.m_needToScramble = false;
        }
        if (this.m_needToKamikazeSuicideAttacks) {
            this.doKamikazeSuicideAttacks();
            this.m_needToKamikazeSuicideAttacks = false;
        }
        if (this.m_needToAddBombardmentSources) {
            this.addBombardmentSources();
            this.m_needToAddBombardmentSources = false;
        }
    }

    @Override
    public void end() {
        if (this.m_needToRecordBattleStatistics) {
            this.getBattleTracker().sendBattleRecordsToGameData(this.m_bridge);
            this.m_needToRecordBattleStatistics = false;
        }
        if (this.m_needToCleanup) {
            this.getBattleTracker().clearBattleRecords();
            this.scramblingCleanup();
            this.airBattleCleanup();
            this.m_needToCleanup = false;
        }
        if (this.m_needToCheckDefendingPlanesCanLand) {
            this.checkDefendingPlanesCanLand();
            this.m_needToCheckDefendingPlanesCanLand = false;
        }
        super.end();
        this.m_needToInitialize = true;
        this.m_needToScramble = true;
        this.m_needToKamikazeSuicideAttacks = true;
        this.m_needToAddBombardmentSources = true;
        this.m_needToRecordBattleStatistics = true;
        this.m_needToCleanup = true;
        this.m_needToCheckDefendingPlanesCanLand = true;
    }

    @Override
    public Serializable saveState() {
        BattleExtendedDelegateState state = new BattleExtendedDelegateState();
        state.superState = super.saveState();
        state.m_battleTracker = this.m_battleTracker;
        state.m_originalOwnerTracker = this.m_originalOwnerTracker;
        state.m_needToInitialize = this.m_needToInitialize;
        state.m_needToScramble = this.m_needToScramble;
        state.m_needToKamikazeSuicideAttacks = this.m_needToKamikazeSuicideAttacks;
        state.m_needToAddBombardmentSources = this.m_needToAddBombardmentSources;
        state.m_needToRecordBattleStatistics = this.m_needToRecordBattleStatistics;
        state.m_needToCheckDefendingPlanesCanLand = this.m_needToCheckDefendingPlanesCanLand;
        state.m_needToCleanup = this.m_needToCleanup;
        state.m_currentBattle = this.m_currentBattle;
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        BattleExtendedDelegateState s = (BattleExtendedDelegateState)state;
        super.loadState(s.superState);
        this.m_battleTracker = s.m_battleTracker;
        this.m_originalOwnerTracker = s.m_originalOwnerTracker;
        this.m_needToInitialize = s.m_needToInitialize;
        this.m_needToScramble = s.m_needToScramble;
        this.m_needToKamikazeSuicideAttacks = s.m_needToKamikazeSuicideAttacks;
        this.m_needToAddBombardmentSources = s.m_needToAddBombardmentSources;
        this.m_needToRecordBattleStatistics = s.m_needToRecordBattleStatistics;
        this.m_needToCheckDefendingPlanesCanLand = s.m_needToCheckDefendingPlanesCanLand;
        this.m_needToCleanup = s.m_needToCleanup;
        this.m_currentBattle = s.m_currentBattle;
    }

    public static void doInitialize(BattleTracker battleTracker, IDelegateBridge aBridge) {
        BattleDelegate.setupUnitsInSameTerritoryBattles(battleTracker, aBridge);
        battleTracker.clearFinishedBattles(aBridge);
        BattleDelegate.resetMaxScrambleCount(aBridge);
    }

    @Override
    public String fightBattle(Territory territory, boolean bombing) {
        IBattle battle = this.m_battleTracker.getPendingBattle(territory, bombing);
        if (this.m_currentBattle != null && this.m_currentBattle != battle) {
            return "Must finish " + this.getFightingWord(this.m_currentBattle) + " in " + this.m_currentBattle.getTerritory() + " first";
        }
        if (battle == null) {
            return "No pending battle in" + territory.getName();
        }
        Collection<IBattle> allMustPrecede = this.m_battleTracker.getDependentOn(battle);
        if (!allMustPrecede.isEmpty()) {
            IBattle firstPrecede = allMustPrecede.iterator().next();
            String name = firstPrecede.getTerritory().getName();
            return "Must complete " + this.getFightingWord(battle) + " in " + name + " first";
        }
        this.m_currentBattle = battle;
        battle.fight(this.m_bridge);
        this.m_currentBattle = null;
        return null;
    }

    private String getFightingWord(IBattle battle) {
        return battle.isBombingRun() ? "Bombing Run" : "Battle";
    }

    @Override
    public BattleListing getBattles() {
        Collection<Territory> battles = this.m_battleTracker.getPendingBattleSites(false);
        Collection<Territory> bombing = this.m_battleTracker.getPendingBattleSites(true);
        return new BattleListing(battles, bombing);
    }

    private boolean isShoreBombardPerGroundUnitRestricted(GameData data) {
        return Properties.getShoreBombardPerGroundUnitRestricted(data);
    }

    public BattleTracker getBattleTracker() {
        return this.m_battleTracker;
    }

    public IDelegateBridge getBattleBridge() {
        return this.getBridge();
    }

    public OriginalOwnerTracker getOriginalOwnerTracker() {
        return this.m_originalOwnerTracker;
    }

    private void addBombardmentSources() {
        PlayerID attacker = this.m_bridge.getPlayerID();
        ITripleaPlayer remotePlayer = (ITripleaPlayer)this.m_bridge.getRemote();
        CompositeMatchAnd<Unit> ownedAndCanBombard = new CompositeMatchAnd<Unit>(Matches.unitCanBombard(attacker), Matches.unitIsOwnedBy(attacker));
        Map<Territory, Collection<IBattle>> adjBombardment = this.getPossibleBombardingTerritories();
        Iterator<Territory> territories = adjBombardment.keySet().iterator();
        boolean shoreBombardPerGroundUnitRestricted = this.isShoreBombardPerGroundUnitRestricted(this.getData());
        block0: while (territories.hasNext()) {
            Territory t = territories.next();
            if (this.m_battleTracker.hasPendingBattle(t, false)) continue;
            Collection<IBattle> battles = adjBombardment.get(t);
            if ((battles = Match.getMatches(battles, Matches.BattleIsAmphibious)).isEmpty()) continue;
            List<Unit> bombardUnits = t.getUnits().getMatches(ownedAndCanBombard);
            ArrayList<Unit> ListedBombardUnits = new ArrayList<Unit>();
            ListedBombardUnits.addAll(bombardUnits);
            this.sortUnitsToBombard(ListedBombardUnits, attacker);
            Iterator bombarding = ListedBombardUnits.iterator();
            if (!bombardUnits.isEmpty() && !remotePlayer.selectShoreBombard(t)) continue;
            while (bombarding.hasNext()) {
                Unit u = (Unit)bombarding.next();
                IBattle battle = this.selectBombardingBattle(u, t, battles);
                if (battle == null) continue;
                if (shoreBombardPerGroundUnitRestricted && battle.getAmphibiousLandAttackers().size() <= battle.getBombardingUnits().size()) {
                    battles.remove(battle);
                    continue block0;
                }
                battle.addBombardingUnit(u);
            }
        }
    }

    private void sortUnitsToBombard(List<Unit> units, PlayerID player) {
        if (units.isEmpty()) {
            return;
        }
        Collections.sort(units, UnitComparator.getDecreasingAttackComparator(player));
    }

    private Map<Territory, Collection<IBattle>> getPossibleBombardingTerritories() {
        HashMap<Territory, Collection<IBattle>> possibleBombardingTerritories = new HashMap<Territory, Collection<IBattle>>();
        for (Territory t : this.m_battleTracker.getPendingBattleSites(false)) {
            IBattle battle = this.m_battleTracker.getPendingBattle(t, false);
            if (!(battle instanceof MustFightBattle)) continue;
            Map<Territory, Collection<Unit>> attackingFromMap = ((MustFightBattle)battle).getAttackingFromMap();
            for (Territory neighbor : ((MustFightBattle)battle).getAttackingFrom()) {
                if (this.m_battleTracker.noBombardAllowedFromHere(neighbor) || Match.allMatch(attackingFromMap.get(neighbor), Matches.UnitIsAir)) continue;
                ArrayList<IBattle> battles = (ArrayList<IBattle>)possibleBombardingTerritories.get(neighbor);
                if (battles == null) {
                    battles = new ArrayList<IBattle>();
                    possibleBombardingTerritories.put(neighbor, battles);
                }
                battles.add(battle);
            }
        }
        return possibleBombardingTerritories;
    }

    private IBattle selectBombardingBattle(Unit u, Territory uTerritory, Collection<IBattle> battles) {
        Boolean bombardRestricted = this.isShoreBombardPerGroundUnitRestricted(this.getData());
        if (battles.size() == 1) {
            return battles.iterator().next();
        }
        ArrayList<Territory> territories = new ArrayList<Territory>();
        HashMap<Territory, IBattle> battleTerritories = new HashMap<Territory, IBattle>();
        for (IBattle battle : battles) {
            if (bombardRestricted.booleanValue()) {
                if (battle.getBombardingUnits().size() < battle.getAmphibiousLandAttackers().size()) {
                    territories.add(battle.getTerritory());
                }
            } else {
                territories.add(battle.getTerritory());
            }
            battleTerritories.put(battle.getTerritory(), battle);
        }
        ITripleaPlayer remotePlayer = (ITripleaPlayer)this.m_bridge.getRemote();
        Territory bombardingTerritory = null;
        if (!territories.isEmpty()) {
            bombardingTerritory = remotePlayer.selectBombardingTerritory(u, uTerritory, territories, true);
        }
        if (bombardingTerritory != null) {
            return (IBattle)battleTerritories.get(bombardingTerritory);
        }
        return null;
    }

    private static void setupUnitsInSameTerritoryBattles(BattleTracker battleTracker, IDelegateBridge aBridge) {
        PlayerID player = aBridge.getPlayerID();
        GameData data = aBridge.getData();
        boolean ignoreTransports = BattleDelegate.isIgnoreTransportInMovement(data);
        boolean ignoreSubs = BattleDelegate.isIgnoreSubInMovement(data);
        CompositeMatchAnd seaTransports = new CompositeMatchAnd(Matches.UnitIsTransportButNotCombatTransport, Matches.UnitIsSea);
        CompositeMatchOr seaTranportsOrSubs = new CompositeMatchOr(seaTransports, Matches.UnitIsSub);
        CompositeMatchAnd anyTerritoryWithOwnAndEnemy = new CompositeMatchAnd(Matches.territoryHasUnitsOwnedBy(player), Matches.territoryHasEnemyUnits(player, data));
        CompositeMatchAnd enemyTerritoryAndOwnUnits = new CompositeMatchAnd(Matches.isTerritoryEnemyAndNotUnownedWater(player, data), Matches.territoryHasUnitsOwnedBy(player));
        CompositeMatchOr enemyUnitsOrEnemyTerritory = new CompositeMatchOr(anyTerritoryWithOwnAndEnemy, enemyTerritoryAndOwnUnits);
        for (Territory territory : Match.getMatches(data.getMap().getTerritories(), enemyUnitsOrEnemyTerritory)) {
            BattleResults results;
            List<Unit> attackingUnits = territory.getUnits().getMatches(Matches.unitIsOwnedBy(player));
            List<Unit> enemyUnits = territory.getUnits().getMatches(Matches.enemyUnit(player, data));
            IBattle bombingBattle = battleTracker.getPendingBattle(territory, true);
            if (bombingBattle != null) {
                attackingUnits.removeAll(bombingBattle.getAttackingUnits());
            }
            if (attackingUnits.isEmpty() || Match.allMatch(attackingUnits, Matches.UnitIsFactoryOrIsInfrastructure)) continue;
            IBattle battle = battleTracker.getPendingBattle(territory, false);
            if (battle == null) {
                aBridge.getHistoryWriter().startEvent(player.getName() + " creates battle in territory " + territory.getName());
                battleTracker.addBattle(new RouteScripted(territory), attackingUnits, false, player, aBridge, null);
                battle = battleTracker.getPendingBattle(territory, false);
            }
            if (battle == null) continue;
            if (battle != null && bombingBattle != null) {
                battleTracker.addDependency(battle, bombingBattle);
            }
            if (battle != null && battle.isEmpty()) {
                battle.addAttackChange(new RouteScripted(territory), attackingUnits, null);
            }
            if (battle != null && !battle.getAttackingUnits().containsAll(attackingUnits)) {
                List<Unit> attackingUnitsNeedToBeAdded = attackingUnits;
                attackingUnitsNeedToBeAdded.removeAll(battle.getAttackingUnits());
                attackingUnitsNeedToBeAdded = territory.isWater() ? Match.getMatches(attackingUnitsNeedToBeAdded, Matches.UnitIsLand.invert()) : Match.getMatches(attackingUnitsNeedToBeAdded, Matches.UnitIsSea.invert());
                if (!attackingUnitsNeedToBeAdded.isEmpty()) {
                    battle.addAttackChange(new RouteScripted(territory), attackingUnitsNeedToBeAdded, null);
                }
            }
            if (battle != null && ignoreTransports && Match.allMatch(attackingUnits, seaTransports) && Match.allMatch(enemyUnits, seaTransports) || Match.allMatch(attackingUnits, Matches.unitHasAttackValueOfAtLeast(1).invert()) && Match.allMatch(enemyUnits, Matches.unitHasDefendValueOfAtLeast(1).invert())) {
                BattleResults results2 = new BattleResults(battle, IBattle.WhoWon.DRAW, data);
                battleTracker.getBattleRecords(data).addResultToBattle(player, battle.getBattleID(), null, 0, 0, BattleRecord.BattleResultDescription.STALEMATE, results2, 0);
                battleTracker.removeBattle(battle);
                continue;
            }
            if (battle == null || attackingUnits.isEmpty() || !ignoreTransports && !ignoreSubs) continue;
            ITripleaPlayer remotePlayer = (ITripleaPlayer)aBridge.getRemote();
            if (ignoreTransports && Match.allMatch(enemyUnits, seaTransports)) {
                if (remotePlayer.selectAttackTransports(territory)) continue;
                results = new BattleResults(battle, IBattle.WhoWon.ATTACKER, data);
                battleTracker.getBattleRecords(data).addResultToBattle(player, battle.getBattleID(), null, 0, 0, BattleRecord.BattleResultDescription.WON_WITH_ENEMY_LEFT, results, 0);
                battleTracker.removeBattle(battle);
                continue;
            }
            if (ignoreSubs && Match.allMatch(enemyUnits, Matches.UnitIsSub)) {
                if (remotePlayer.selectAttackSubs(territory)) continue;
                results = new BattleResults(battle, IBattle.WhoWon.ATTACKER, data);
                battleTracker.getBattleRecords(data).addResultToBattle(player, battle.getBattleID(), null, 0, 0, BattleRecord.BattleResultDescription.WON_WITH_ENEMY_LEFT, results, 0);
                battleTracker.removeBattle(battle);
                continue;
            }
            if (!ignoreSubs || !ignoreTransports || !Match.allMatch(enemyUnits, seaTranportsOrSubs) || remotePlayer.selectAttackUnits(territory)) continue;
            results = new BattleResults(battle, IBattle.WhoWon.ATTACKER, data);
            battleTracker.getBattleRecords(data).addResultToBattle(player, battle.getBattleID(), null, 0, 0, BattleRecord.BattleResultDescription.WON_WITH_ENEMY_LEFT, results, 0);
            battleTracker.removeBattle(battle);
        }
    }

    private void doScrambling() {
        PlayerID defender;
        GameData data = this.getData();
        if (!Properties.getScramble_Rules_In_Effect(data)) {
            return;
        }
        boolean fromIslandOnly = Properties.getScramble_From_Island_Only(data);
        boolean toSeaOnly = Properties.getScramble_To_Sea_Only(data);
        boolean toAnyAmphibious = Properties.getScrambleToAnyAmphibiousAssault(data);
        int maxScrambleDistance = 0;
        Iterator<UnitType> utIter = data.getUnitTypeList().iterator();
        while (utIter.hasNext()) {
            UnitAttachment ua = UnitAttachment.get(utIter.next());
            if (!ua.getCanScramble() || maxScrambleDistance >= ua.getMaxScrambleDistance()) continue;
            maxScrambleDistance = ua.getMaxScrambleDistance();
        }
        CompositeMatchAnd<Unit> airbasesCanScramble = new CompositeMatchAnd<Unit>(Matches.unitIsEnemyOf(data, this.m_player), Matches.UnitIsAirBase, Matches.UnitIsDisabled().invert());
        CompositeMatchAnd<Territory> canScramble = new CompositeMatchAnd<Territory>(new CompositeMatchOr(Matches.TerritoryIsWater, Matches.isTerritoryEnemy(this.m_player, data)), Matches.territoryHasUnitsThatMatch(new CompositeMatchAnd<Unit>(Matches.UnitCanScramble, Matches.unitIsEnemyOf(data, this.m_player), Matches.UnitIsDisabled().invert())), Matches.territoryHasUnitsThatMatch(airbasesCanScramble));
        if (fromIslandOnly) {
            canScramble.add(Matches.TerritoryIsIsland);
        }
        HashMap<Territory, HashSet<Territory>> scrambleTerrs = new HashMap<Territory, HashSet<Territory>>();
        Collection<Territory> territoriesWithBattles = this.m_battleTracker.getPendingBattleSites(false);
        List<Territory> territoriesWithBattlesWater = Match.getMatches(territoriesWithBattles, Matches.TerritoryIsWater);
        List<Territory> territoriesWithBattlesLand = Match.getMatches(territoriesWithBattles, Matches.TerritoryIsLand);
        for (Territory battleTerr : territoriesWithBattlesWater) {
            HashSet<Territory> canScrambleFrom = new HashSet<Territory>(Match.getMatches(data.getMap().getNeighbors(battleTerr, maxScrambleDistance), canScramble));
            if (canScrambleFrom.isEmpty()) continue;
            scrambleTerrs.put(battleTerr, canScrambleFrom);
        }
        for (Territory battleTerr : territoriesWithBattlesLand) {
            HashSet<Territory> canScrambleFrom;
            IBattle battle = this.m_battleTracker.getPendingBattle(battleTerr, false);
            if (!toSeaOnly && !(canScrambleFrom = new HashSet<Territory>(Match.getMatches(data.getMap().getNeighbors(battleTerr, maxScrambleDistance), canScramble))).isEmpty()) {
                scrambleTerrs.put(battleTerr, canScrambleFrom);
            }
            if (!battle.isAmphibious() || !(battle instanceof MustFightBattle)) continue;
            MustFightBattle mfb = (MustFightBattle)battle;
            Collection<Territory> amphibFromTerrs = mfb.getAmphibiousAttackTerritories();
            amphibFromTerrs.removeAll(territoriesWithBattlesWater);
            for (Territory amphibFrom : amphibFromTerrs) {
                HashSet<Territory> canScrambleFrom2 = (HashSet<Territory>)scrambleTerrs.get(amphibFrom);
                if (canScrambleFrom2 == null) {
                    canScrambleFrom2 = new HashSet<Territory>();
                }
                if (toAnyAmphibious) {
                    canScrambleFrom2.addAll(Match.getMatches(data.getMap().getNeighbors(amphibFrom, maxScrambleDistance), canScramble));
                } else if (canScramble.match(battleTerr)) {
                    canScrambleFrom2.add(battleTerr);
                }
                if (canScrambleFrom2.isEmpty()) continue;
                scrambleTerrs.put(amphibFrom, canScrambleFrom2);
            }
        }
        if (scrambleTerrs.isEmpty()) {
            return;
        }
        HashMap scramblersByTerritoryPlayer = new HashMap();
        for (Territory to : scrambleTerrs.keySet()) {
            HashMap<Territory, Tuple<List<Unit>, List<Unit>>> scramblers = new HashMap<Territory, Tuple<List<Unit>, List<Unit>>>();
            defender = null;
            if (this.m_battleTracker.hasPendingBattle(to, false)) {
                defender = MustFightBattle.findDefender(to, this.m_player, data);
            }
            for (Territory from : (HashSet)scrambleTerrs.get(to)) {
                if (defender == null) {
                    defender = MustFightBattle.findDefender(from, this.m_player, data);
                }
                List<Unit> airbases = from.getUnits().getMatches(airbasesCanScramble);
                int maxCanScramble = BattleDelegate.getMaxScrambleCount(airbases);
                Route toBattleRoute = data.getMap().getRoute_IgnoreEnd(from, to, Matches.TerritoryIsNotImpassable);
                List<Unit> canScrambleAir = from.getUnits().getMatches(new CompositeMatchAnd<Unit>(Matches.unitIsEnemyOf(data, this.m_player), Matches.UnitCanScramble, Matches.UnitIsDisabled().invert(), Matches.UnitWasScrambled.invert(), Matches.unitCanScrambleOnRouteDistance(toBattleRoute)));
                if (maxCanScramble <= 0 || canScrambleAir.isEmpty()) continue;
                scramblers.put(from, new Tuple<List<Unit>, List<Unit>>(airbases, canScrambleAir));
            }
            if (defender == null || scramblers.isEmpty()) continue;
            Tuple<Territory, PlayerID> terrPlayer = new Tuple<Territory, PlayerID>(to, defender);
            ArrayList tempScrambleList = (ArrayList)scramblersByTerritoryPlayer.get(terrPlayer);
            if (tempScrambleList == null) {
                tempScrambleList = new ArrayList();
            }
            tempScrambleList.add(scramblers);
            scramblersByTerritoryPlayer.put(terrPlayer, tempScrambleList);
        }
        for (Tuple terrPlayer : scramblersByTerritoryPlayer.keySet()) {
            Territory to = (Territory)terrPlayer.getFirst();
            defender = (PlayerID)terrPlayer.getSecond();
            if (defender == null || defender.isNull()) continue;
            boolean scrambledHere = false;
            for (HashMap scramblers : (Collection)scramblersByTerritoryPlayer.get(terrPlayer)) {
                HashMap<Territory, Collection<Unit>> toScramble;
                Iterator tIter = scramblers.keySet().iterator();
                while (tIter.hasNext()) {
                    Territory t = (Territory)tIter.next();
                    ((Collection)((Tuple)scramblers.get(t)).getSecond()).retainAll(t.getUnits().getUnits());
                    if (!((Collection)((Tuple)scramblers.get(t)).getSecond()).isEmpty()) continue;
                    tIter.remove();
                }
                if (scramblers.isEmpty() || (toScramble = BattleDelegate.getRemote(defender, this.m_bridge).scrambleUnitsQuery(to, scramblers)) == null) continue;
                if (!scramblers.keySet().containsAll(toScramble.keySet())) {
                    throw new IllegalStateException("Trying to scramble from illegal territory");
                }
                for (Territory t : scramblers.keySet()) {
                    if (toScramble.get(t) == null || toScramble.get(t).size() <= BattleDelegate.getMaxScrambleCount((Collection)((Tuple)scramblers.get(t)).getFirst())) continue;
                    throw new IllegalStateException("Trying to scramble " + toScramble.get(t).size() + " out of " + t.getName() + ", but max allowed is " + ((Tuple)scramblers.get(t)).getFirst());
                }
                CompositeChange change = new CompositeChange();
                for (Territory t : toScramble.keySet()) {
                    Collection<Unit> scrambling = toScramble.get(t);
                    if (scrambling == null || scrambling.isEmpty()) continue;
                    int numberScrambled = scrambling.size();
                    List<Unit> airbases = t.getUnits().getMatches(airbasesCanScramble);
                    int maxCanScramble = BattleDelegate.getMaxScrambleCount(airbases);
                    if (maxCanScramble != Integer.MAX_VALUE) {
                        for (Unit airbase : airbases) {
                            int allowedScramble;
                            int newAllowed = allowedScramble = ((TripleAUnit)airbase).getMaxScrambleCount();
                            if (allowedScramble > 0) {
                                if (allowedScramble >= numberScrambled) {
                                    newAllowed = allowedScramble - numberScrambled;
                                    numberScrambled = 0;
                                } else {
                                    newAllowed = 0;
                                    numberScrambled -= allowedScramble;
                                }
                                change.add(ChangeFactory.unitPropertyChange(airbase, newAllowed, "maxScrambleCount"));
                            }
                            if (numberScrambled > 0) continue;
                            break;
                        }
                    }
                    for (Unit u : scrambling) {
                        change.add(ChangeFactory.unitPropertyChange(u, t, "originatedFrom"));
                        change.add(ChangeFactory.unitPropertyChange(u, true, "wasScrambled"));
                    }
                    change.add(ChangeFactory.moveUnits(t, to, scrambling));
                    this.m_bridge.getHistoryWriter().startEvent(defender.getName() + " scrambles " + scrambling.size() + " units out of " + t.getName() + " to defend against the attack in " + to.getName(), scrambling);
                    scrambledHere = true;
                }
                if (change.isEmpty()) continue;
                this.m_bridge.addChange(change);
            }
            if (!scrambledHere) continue;
            IBattle battle = this.m_battleTracker.getPendingBattle(to, false);
            if (battle == null) {
                List<Unit> attackingUnits = to.getUnits().getMatches(Matches.unitIsOwnedBy(this.m_player));
                this.m_bridge.getHistoryWriter().startEvent(defender.getName() + " scrambles to create a battle in territory " + to.getName());
                this.m_battleTracker.addBattle(new RouteScripted(to), attackingUnits, false, this.m_player, this.m_bridge, null);
                battle = this.m_battleTracker.getPendingBattle(to, false);
                if (battle instanceof MustFightBattle) {
                    MustFightBattle mfb = (MustFightBattle)battle;
                    Set<Territory> neighborsLand = data.getMap().getNeighbors(to, Matches.TerritoryIsLand);
                    if (Match.someMatch(attackingUnits, Matches.UnitIsTransport)) {
                        CompositeChange change1 = new CompositeChange();
                        mfb.reLoadTransports(attackingUnits, change1);
                        if (!change1.isEmpty()) {
                            this.m_bridge.addChange(change1);
                        }
                        TransportTracker tt = new TransportTracker();
                        HashMap<Territory, Map<Unit, Collection<Unit>>> dependencies = new HashMap<Territory, Map<Unit, Collection<Unit>>>();
                        Map<Unit, Collection<Unit>> dependenciesForMFB = tt.transporting(attackingUnits, attackingUnits);
                        for (Unit transport : Match.getMatches(attackingUnits, Matches.UnitIsTransport)) {
                            if (dependenciesForMFB.containsKey(transport)) continue;
                            dependenciesForMFB.put(transport, new ArrayList());
                        }
                        dependencies.put(to, dependenciesForMFB);
                        for (Territory t : neighborsLand) {
                            ArrayList<Unit> allNeighborUnits = new ArrayList<Unit>(Match.getMatches(attackingUnits, Matches.UnitIsTransport));
                            allNeighborUnits.addAll(t.getUnits().getMatches(Matches.unitIsLandAndOwnedBy(this.m_player)));
                            Map<Unit, Collection<Unit>> dependenciesForNeighbors = tt.transporting(Match.getMatches(allNeighborUnits, Matches.UnitIsTransport), Match.getMatches(allNeighborUnits, Matches.UnitIsTransport.invert()));
                            dependencies.put(t, dependenciesForNeighbors);
                        }
                        mfb.addDependentUnits((Map)dependencies.get(to));
                        for (Territory territoryNeighborToNewBattle : neighborsLand) {
                            IBattle battleInTerritoryNeighborToNewBattle = this.m_battleTracker.getPendingBattle(territoryNeighborToNewBattle, false);
                            if (battleInTerritoryNeighborToNewBattle == null || !(battleInTerritoryNeighborToNewBattle instanceof MustFightBattle)) continue;
                            MustFightBattle mfbattleInTerritoryNeighborToNewBattle = (MustFightBattle)battleInTerritoryNeighborToNewBattle;
                            mfbattleInTerritoryNeighborToNewBattle.addDependentUnits((Map)dependencies.get(territoryNeighborToNewBattle));
                        }
                    }
                    if (Match.someMatch(attackingUnits, Matches.UnitIsAir.invert())) {
                        HashMap<Territory, Collection<Unit>> attackingFromMap = new HashMap<Territory, Collection<Unit>>();
                        Set<Territory> neighbors = data.getMap().getNeighbors(to, Matches.TerritoryIsLand.match(to) ? Matches.TerritoryIsLand : Matches.TerritoryIsWater);
                        neighbors.removeAll(territoriesWithBattles);
                        neighbors.removeAll(Match.getMatches(neighbors, Matches.territoryHasEnemyUnits(this.m_player, data)));
                        for (Territory t : neighbors) {
                            attackingFromMap.put(t, attackingUnits);
                        }
                        mfb.setAttackingFromAndMap(attackingFromMap);
                    }
                }
            } else if (battle instanceof MustFightBattle) {
                ((MustFightBattle)battle).resetDefendingUnits(to, this.m_player, data);
            }
            if (!to.isWater()) continue;
            for (Territory t : data.getMap().getNeighbors(to, Matches.TerritoryIsLand)) {
                IBattle battleAmphib = this.m_battleTracker.getPendingBattle(t, false);
                if (battleAmphib == null) continue;
                if (!this.m_battleTracker.getDependentOn(battle).contains(battleAmphib)) {
                    this.m_battleTracker.addDependency(battleAmphib, battle);
                }
                if (!(battleAmphib instanceof MustFightBattle)) continue;
                ((MustFightBattle)battleAmphib).resetDefendingUnits(t, this.m_player, data);
            }
        }
    }

    public static int getMaxScrambleCount(Collection<Unit> airbases) {
        if (!Match.allMatch(airbases, new CompositeMatchAnd(Matches.UnitIsAirBase, Matches.UnitIsDisabled().invert()))) {
            throw new IllegalStateException("All units must be viable airbases");
        }
        int maxScrambled = 0;
        for (Unit base : airbases) {
            int baseMax = ((TripleAUnit)base).getMaxScrambleCount();
            if (baseMax == -1) {
                return Integer.MAX_VALUE;
            }
            maxScrambled += baseMax;
        }
        return maxScrambled;
    }

    private void scramblingCleanup() {
        GameData data = this.getData();
        if (!Properties.getScramble_Rules_In_Effect(data)) {
            return;
        }
        boolean mustReturnToBase = Properties.getScrambled_Units_Return_To_Base(data);
        for (Territory t : data.getMap().getTerritories()) {
            int carrierCostOfCurrentTerr = 0;
            List<Unit> wasScrambled = t.getUnits().getMatches(Matches.UnitWasScrambled);
            for (Unit u : wasScrambled) {
                CompositeChange change = new CompositeChange();
                Territory originatedFrom = TripleAUnit.get(u).getOriginatedFrom();
                Territory landingTerr = null;
                String historyText = "";
                if (!mustReturnToBase || !Matches.isTerritoryAllied(u.getOwner(), data).match(originatedFrom)) {
                    Collection<Territory> possible = BattleDelegate.whereCanAirLand(Collections.singletonList(u), t, u.getOwner(), data, this.m_battleTracker, carrierCostOfCurrentTerr, 1, true, !mustReturnToBase, true);
                    if (possible.size() > 1) {
                        landingTerr = BattleDelegate.getRemote(u.getOwner(), this.m_bridge).selectTerritoryForAirToLand(possible, t, MyFormatter.unitsToText(Collections.singletonList(u)));
                    } else if (possible.size() == 1) {
                        landingTerr = possible.iterator().next();
                    }
                    if (landingTerr == null || landingTerr.equals(t)) {
                        carrierCostOfCurrentTerr += AirMovementValidator.carrierCost(Collections.singletonList(u));
                        historyText = "Scrambled unit stays in territory " + t.getName();
                    } else {
                        historyText = "Moving scrambled unit from " + t.getName() + " to " + landingTerr.getName();
                    }
                } else {
                    landingTerr = originatedFrom;
                    historyText = "Moving scrambled unit from " + t.getName() + " back to originating territory: " + landingTerr.getName();
                }
                if (landingTerr != null) {
                    change.add(ChangeFactory.moveUnits(t, landingTerr, Collections.singletonList(u)));
                }
                change.add(ChangeFactory.unitPropertyChange(u, null, "originatedFrom"));
                change.add(ChangeFactory.unitPropertyChange(u, false, "wasScrambled"));
                if (change.isEmpty()) continue;
                this.m_bridge.getHistoryWriter().startEvent(historyText, u);
                this.m_bridge.addChange(change);
            }
        }
    }

    private static void resetMaxScrambleCount(IDelegateBridge aBridge) {
        GameData data = aBridge.getData();
        if (!Properties.getScramble_Rules_In_Effect(data)) {
            return;
        }
        CompositeChange change = new CompositeChange();
        for (Territory t : data.getMap().getTerritories()) {
            List<Unit> airbases = t.getUnits().getMatches(Matches.UnitIsAirBase);
            for (Unit u : airbases) {
                int allowedMax;
                UnitAttachment ua = UnitAttachment.get(u.getType());
                int currentMax = ((TripleAUnit)u).getMaxScrambleCount();
                if (currentMax == (allowedMax = ua.getMaxScrambleCount())) continue;
                change.add(ChangeFactory.unitPropertyChange(u, allowedMax, "maxScrambleCount"));
            }
        }
        if (!change.isEmpty()) {
            aBridge.getHistoryWriter().startEvent("Preparing Airbases for Possible Scrambling");
            aBridge.addChange(change);
        }
    }

    private void airBattleCleanup() {
        GameData data = this.getData();
        if (!Properties.getRaidsMayBePreceededByAirBattles(data)) {
            return;
        }
        CompositeChange change = new CompositeChange();
        for (Territory t : data.getMap().getTerritories()) {
            for (Unit u : t.getUnits().getMatches(Matches.UnitWasInAirBattle)) {
                change.add(ChangeFactory.unitPropertyChange(u, false, "wasInAirBattle"));
            }
        }
        if (!change.isEmpty()) {
            this.m_bridge.getHistoryWriter().startEvent("Cleaning up after air battles");
            this.m_bridge.addChange(change);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkDefendingPlanesCanLand() {
        GameData data = this.getData();
        Map<Territory, Collection<Unit>> defendingAirThatCanNotLand = this.m_battleTracker.getDefendingAirThatCanNotLand();
        boolean isWW2v2orIsSurvivingAirMoveToLand = Properties.getWW2V2(data) || Properties.getSurvivingAirMoveToLand(data);
        CompositeMatchAnd<Unit> alliedDefendingAir = new CompositeMatchAnd<Unit>(Matches.UnitIsAir, Matches.UnitWasScrambled.invert());
        Iterator<Map.Entry<Territory, Collection<Unit>>> i$ = defendingAirThatCanNotLand.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<Territory, Collection<Unit>> entry = i$.next();
            Territory battleSite = entry.getKey();
            Collection<Unit> defendingAir = entry.getValue();
            if (defendingAir == null || defendingAir.isEmpty()) continue;
            PlayerID defender = MustFightBattle.findDefender(battleSite, this.m_player, data);
            Set<Territory> neighbors = data.getMap().getNeighbors(battleSite);
            CompositeMatchAnd alliedLandTerritories = new CompositeMatchAnd(Matches.airCanLandOnThisAlliedNonConqueredLandTerritory(defender, data));
            List<Territory> canLandHere = Match.getMatches(neighbors, alliedLandTerritories);
            CompositeMatchAnd neighboringSeaZonesWithAlliedUnits = new CompositeMatchAnd(Matches.TerritoryIsWater, Matches.territoryHasAlliedUnits(defender, data));
            List<Territory> areSeaNeighbors = Match.getMatches(neighbors, neighboringSeaZonesWithAlliedUnits);
            CompositeMatchAnd<Unit> alliedCarrier = new CompositeMatchAnd<Unit>(new Match[0]);
            alliedCarrier.add(Matches.UnitIsCarrier);
            alliedCarrier.add(Matches.alliedUnit(defender, data));
            CompositeMatchAnd<Unit> alliedPlane = new CompositeMatchAnd<Unit>(new Match[0]);
            alliedPlane.add(Matches.UnitIsAir);
            alliedPlane.add(Matches.alliedUnit(defender, data));
            for (Territory currentTerritory : areSeaNeighbors) {
                int alliedPlaneCost;
                List<Unit> alliedCarriers = currentTerritory.getUnits().getMatches(alliedCarrier);
                List<Unit> alliedPlanes = currentTerritory.getUnits().getMatches(alliedPlane);
                int alliedCarrierCapacity = AirMovementValidator.carrierCapacity(alliedCarriers, currentTerritory);
                if (alliedCarrierCapacity - (alliedPlaneCost = AirMovementValidator.carrierCost(alliedPlanes)) < 1) continue;
                canLandHere.add(currentTerritory);
            }
            if (!isWW2v2orIsSurvivingAirMoveToLand) {
                if (canLandHere.size() > 0) {
                    for (Territory currentTerritory : canLandHere) {
                        if (data.getMap().getNeighbors(currentTerritory).size() != 1) continue;
                        BattleDelegate.moveAirAndLand(this.m_bridge, defendingAir, defendingAir, currentTerritory, battleSite);
                    }
                }
            } else {
                Territory territory = null;
                while (canLandHere.size() > 1 && defendingAir.size() > 0) {
                    territory = BattleDelegate.getRemote(defender, this.m_bridge).selectTerritoryForAirToLand(canLandHere, battleSite, MyFormatter.unitsToText(defendingAir));
                    if (territory == null) {
                        territory = (Territory)canLandHere.iterator().next();
                    }
                    if (territory.isWater()) {
                        BattleDelegate.landPlanesOnCarriers(this.m_bridge, alliedDefendingAir, defendingAir, canLandHere, alliedCarrier, alliedPlane, territory, battleSite);
                        canLandHere.remove(territory);
                        continue;
                    }
                    BattleDelegate.moveAirAndLand(this.m_bridge, defendingAir, defendingAir, territory, battleSite);
                }
                if (canLandHere.size() > 0 && defendingAir.size() > 0) {
                    territory = (Territory)canLandHere.iterator().next();
                    if (territory.isWater()) {
                        BattleDelegate.landPlanesOnCarriers(this.m_bridge, alliedDefendingAir, defendingAir, canLandHere, alliedCarrier, alliedPlane, territory, battleSite);
                    } else {
                        BattleDelegate.moveAirAndLand(this.m_bridge, defendingAir, defendingAir, territory, battleSite);
                        continue;
                    }
                }
            }
            if (defendingAir.size() <= 0) continue;
            this.m_bridge.getHistoryWriter().addChildToEvent(MyFormatter.unitsToText(defendingAir) + " could not land and were killed", defendingAir);
            Change change = ChangeFactory.removeUnits(battleSite, defendingAir);
            this.m_bridge.addChange(change);
        }
        return;
    }

    private static void landPlanesOnCarriers(IDelegateBridge bridge, CompositeMatch<Unit> alliedDefendingAir, Collection<Unit> defendingAir, Collection<Territory> canLandHere, CompositeMatch<Unit> alliedCarrier, CompositeMatch<Unit> alliedPlane, Territory newTerritory, Territory battleSite) {
        int alliedPlaneCostSelected;
        List<Unit> alliedCarriersSelected = newTerritory.getUnits().getMatches(alliedCarrier);
        List<Unit> alliedPlanesSelected = newTerritory.getUnits().getMatches(alliedPlane);
        int alliedCarrierCapacitySelected = AirMovementValidator.carrierCapacity(alliedCarriersSelected, newTerritory);
        int territoryCapacity = alliedCarrierCapacitySelected - (alliedPlaneCostSelected = AirMovementValidator.carrierCost(alliedPlanesSelected));
        if (territoryCapacity > 0) {
            List<Unit> movingAir = Match.getNMatches(defendingAir, territoryCapacity, alliedDefendingAir);
            BattleDelegate.moveAirAndLand(bridge, movingAir, defendingAir, newTerritory, battleSite);
        }
    }

    private static void moveAirAndLand(IDelegateBridge bridge, Collection<Unit> defendingAirBeingMoved, Collection<Unit> defendingAirTotal, Territory newTerritory, Territory battleSite) {
        bridge.getHistoryWriter().addChildToEvent(MyFormatter.unitsToText(defendingAirBeingMoved) + " forced to land in " + newTerritory.getName(), defendingAirBeingMoved);
        Change change = ChangeFactory.moveUnits(battleSite, newTerritory, defendingAirBeingMoved);
        bridge.addChange(change);
        defendingAirTotal.removeAll(defendingAirBeingMoved);
    }

    private void doKamikazeSuicideAttacks() {
        GameData data = this.getData();
        if (!Properties.getUseKamikazeSuicideAttacks(data)) {
            return;
        }
        List<PlayerID> enemies = Match.getMatches(data.getPlayerList().getPlayers(), Matches.isAtWar(this.m_player, data));
        if (enemies.isEmpty()) {
            return;
        }
        CompositeMatchAnd<Unit> canBeAttackedDefault = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(this.m_player), Matches.UnitIsSea, Matches.UnitIsNotTransportButCouldBeCombatTransport, Matches.UnitIsNotSub);
        HashMap<PlayerID, ArrayList<Territory>> kamikazeZonesByEnemy = new HashMap<PlayerID, ArrayList<Territory>>();
        for (Territory territory : data.getMap().getTerritories()) {
            TerritoryAttachment ta = TerritoryAttachment.get(territory);
            if (ta == null || !ta.getKamikazeZone()) continue;
            PlayerID owner = null;
            if (!Properties.getKamikazeSuicideAttacksDoneByCurrentTerritoryOwner(data)) {
                owner = ta.getOccupiedTerrOf();
                if (owner == null) {
                    owner = ta.getOriginalOwner();
                }
                if (owner == null) {
                    continue;
                }
            } else {
                owner = territory.getOwner();
                if (owner == null) continue;
            }
            if (!enemies.contains(owner) || Match.noneMatch(territory.getUnits().getUnits(), Matches.unitIsOwnedBy(this.m_player))) continue;
            ArrayList<Territory> currentTerrs = (ArrayList<Territory>)kamikazeZonesByEnemy.get(owner);
            if (currentTerrs == null) {
                currentTerrs = new ArrayList<Territory>();
            }
            currentTerrs.add(territory);
            kamikazeZonesByEnemy.put(owner, currentTerrs);
        }
        if (kamikazeZonesByEnemy.isEmpty()) {
            return;
        }
        for (Map.Entry entry : kamikazeZonesByEnemy.entrySet()) {
            IntegerMap<Resource> resourcesAndAttackValues;
            PlayerID currentEnemy = (PlayerID)entry.getKey();
            PlayerAttachment pa = PlayerAttachment.get(currentEnemy);
            if (pa == null) continue;
            CompositeMatchAnd<Unit> canBeAttacked = canBeAttackedDefault;
            HashSet<UnitType> suicideAttackTargets = pa.getSuicideAttackTargets();
            if (suicideAttackTargets != null) {
                canBeAttacked = new CompositeMatchAnd(Matches.unitIsOwnedBy(this.m_player), Matches.unitIsOfTypes(suicideAttackTargets));
            }
            if ((resourcesAndAttackValues = pa.getSuicideAttackResources()).size() <= 0) continue;
            IntegerMap<Resource> playerResourceCollection = currentEnemy.getResources().getResourcesCopy();
            IntegerMap<Resource> attackTokens = new IntegerMap<Resource>();
            for (Resource possible : resourcesAndAttackValues.keySet()) {
                int amount = playerResourceCollection.getInt(possible);
                if (amount <= 0) continue;
                attackTokens.put(possible, amount);
            }
            if (attackTokens.size() <= 0) continue;
            Collection kamikazeZones = (Collection)entry.getValue();
            HashMap<Territory, Collection<Unit>> possibleUnitsToAttack = new HashMap<Territory, Collection<Unit>>();
            for (Territory t : kamikazeZones) {
                List<Unit> validTargets = t.getUnits().getMatches(canBeAttacked);
                if (validTargets.isEmpty()) continue;
                possibleUnitsToAttack.put(t, validTargets);
            }
            HashMap<Territory, HashMap<Unit, IntegerMap<Resource>>> attacks = BattleDelegate.getRemote(currentEnemy, this.m_bridge).selectKamikazeSuicideAttacks(possibleUnitsToAttack);
            if (attacks == null || attacks.isEmpty()) continue;
            for (Map.Entry<Territory, HashMap<Unit, IntegerMap<Resource>>> territoryEntry : attacks.entrySet()) {
                Territory t = territoryEntry.getKey();
                Collection<Unit> possibleUnits = possibleUnitsToAttack.get(t);
                if (possibleUnits == null || !possibleUnits.containsAll(territoryEntry.getValue().keySet())) {
                    throw new IllegalStateException("Player has chosen illegal units during Kamikaze Suicide Attacks");
                }
                for (IntegerMap<Resource> rMap : territoryEntry.getValue().values()) {
                    attackTokens.subtract(rMap);
                }
            }
            if (!attackTokens.isPositive()) {
                throw new IllegalStateException("Player has chosen illegal resource during Kamikaze Suicide Attacks");
            }
            for (Map.Entry<Territory, HashMap<Unit, IntegerMap<Resource>>> territoryEntry : attacks.entrySet()) {
                Territory location = territoryEntry.getKey();
                for (Map.Entry<Unit, IntegerMap<Resource>> unitEntry : territoryEntry.getValue().entrySet()) {
                    Unit unitUnderFire = unitEntry.getKey();
                    IntegerMap<Resource> numberOfAttacks = unitEntry.getValue();
                    if (numberOfAttacks == null || numberOfAttacks.size() <= 0 || numberOfAttacks.totalValues() <= 0) continue;
                    this.fireKamikazeSuicideAttacks(unitUnderFire, numberOfAttacks, resourcesAndAttackValues, currentEnemy, location);
                }
            }
        }
    }

    private void fireKamikazeSuicideAttacks(Unit unitUnderFire, IntegerMap<Resource> numberOfAttacks, IntegerMap<Resource> resourcesAndAttackValues, PlayerID firingEnemy, Territory location) {
        int[] rolls;
        int hits;
        CompositeChange change;
        block9: {
            int diceSides;
            block8: {
                GameData data = this.getData();
                diceSides = data.getDiceSides();
                change = new CompositeChange();
                hits = 0;
                rolls = null;
                if (!Properties.getLow_Luck(data)) break block8;
                int power = 0;
                for (Map.Entry<Resource, Integer> entry : numberOfAttacks.entrySet()) {
                    Resource r = entry.getKey();
                    int num = entry.getValue();
                    change.add(ChangeFactory.changeResourcesChange(firingEnemy, r, -num));
                    power += num * resourcesAndAttackValues.getInt(r);
                }
                if (power <= 0) break block9;
                hits = power / diceSides;
                int remainder = power % diceSides;
                if (remainder <= 0 || remainder <= (rolls = this.m_bridge.getRandom(diceSides, 1, "Rolling for remainder in Kamikaze Suicide Attack on unit: " + unitUnderFire.getType().getName()))[0]) break block9;
                ++hits;
                break block9;
            }
            int numTokens = numberOfAttacks.totalValues();
            rolls = this.m_bridge.getRandom(diceSides, numTokens, "Rolling for Kamikaze Suicide Attack on unit: " + unitUnderFire.getType().getName());
            int[] powerOfTokens = new int[numTokens];
            int j = 0;
            for (Map.Entry<Resource, Integer> entry : numberOfAttacks.entrySet()) {
                int num;
                Resource r = entry.getKey();
                change.add(ChangeFactory.changeResourcesChange(firingEnemy, r, -num));
                int power = resourcesAndAttackValues.getInt(r);
                for (num = entry.getValue().intValue(); num > 0; --num) {
                    powerOfTokens[j] = power;
                    ++j;
                }
            }
            for (int i = 0; i < rolls.length; ++i) {
                if (powerOfTokens[i] <= rolls[i]) continue;
                ++hits;
            }
        }
        String title = "Kamikaze Suicide Attack attacks " + MyFormatter.unitsToText(Collections.singleton(unitUnderFire));
        String dice = " scoring " + hits + " hits.  Rolls: " + MyFormatter.asDice(rolls);
        this.m_bridge.getHistoryWriter().startEvent(title + dice, unitUnderFire);
        if (hits > 0) {
            UnitAttachment ua = UnitAttachment.get(unitUnderFire.getType());
            int currentHits = unitUnderFire.getHits();
            if (ua.getIsTwoHit() && currentHits < 1 && hits == 1) {
                IntegerMap<Unit> hitMap = new IntegerMap<Unit>();
                hitMap.put(unitUnderFire, hits);
                change.add(ChangeFactory.unitsHit(hitMap));
                BattleDelegate.markDamaged(Collections.singleton(unitUnderFire), this.m_bridge);
            } else {
                change.add(ChangeFactory.removeUnits(location, Collections.singleton(unitUnderFire)));
            }
        }
        if (!change.isEmpty()) {
            this.m_bridge.addChange(change);
        }
        this.m_battleTracker.addNoBombardAllowedFromHere(location);
        BattleDelegate.getRemote(this.m_player, this.m_bridge).reportMessage(title + dice, title);
        BattleDelegate.getRemote(firingEnemy, this.m_bridge).reportMessage(title + dice, title);
    }

    public static void markDamaged(Collection<Unit> damaged, IDelegateBridge bridge) {
        if (damaged.size() == 0) {
            return;
        }
        Change damagedChange = null;
        IntegerMap<Unit> damagedMap = new IntegerMap<Unit>();
        damagedMap.putAll(damaged, 1);
        damagedChange = ChangeFactory.unitsHit(damagedMap);
        bridge.getHistoryWriter().addChildToEvent("Units damaged: " + MyFormatter.unitsToText(damaged), damaged);
        bridge.addChange(damagedChange);
    }

    public static Collection<Territory> whereCanAirLand(Collection<Unit> strandedAir, Territory currentTerr, PlayerID alliedPlayer, GameData data, BattleTracker battleTracker, int carrierCostForCurrentTerr, int allowedMovement, boolean byMovementCost, boolean useMaxScrambleDistance, boolean landInConquered) {
        HashSet<Territory> whereCanLand = new HashSet<Territory>();
        int maxDistance = allowedMovement;
        if (byMovementCost && maxDistance > 1 || useMaxScrambleDistance) {
            UnitType ut = null;
            for (Unit u : strandedAir) {
                if (ut == null) {
                    ut = u.getType();
                    continue;
                }
                if (ut.equals(u.getType())) continue;
                throw new IllegalStateException("whereCanAirLand can only accept 1 UnitType if byMovementCost or scrambled is true");
            }
            if (useMaxScrambleDistance) {
                maxDistance = UnitAttachment.get(ut).getMaxScrambleDistance();
            }
        }
        if (maxDistance < 1 || strandedAir == null || strandedAir.isEmpty()) {
            return Collections.singletonList(currentTerr);
        }
        boolean areNeutralsPassableByAir = Properties.getNeutralFlyoverAllowed(data) && !Properties.getNeutralsImpassable(data);
        HashSet<Territory> canNotLand = new HashSet<Territory>();
        canNotLand.addAll(battleTracker.getPendingBattleSites(false));
        canNotLand.addAll(Match.getMatches(data.getMap().getTerritories(), Matches.territoryHasEnemyUnits(alliedPlayer, data)));
        if (!landInConquered) {
            canNotLand.addAll(battleTracker.getConquered());
        }
        ArrayList<Territory> possibleTerrs = new ArrayList<Territory>(data.getMap().getNeighbors(currentTerr, maxDistance));
        if (byMovementCost && maxDistance > 1) {
            Iterator possibleIter = possibleTerrs.iterator();
            while (possibleIter.hasNext()) {
                Route route = data.getMap().getRoute(currentTerr, (Territory)possibleIter.next(), Matches.airCanFlyOver(alliedPlayer, data, areNeutralsPassableByAir));
                if (route != null && route.getMovementCost(strandedAir.iterator().next()) <= maxDistance) continue;
                possibleIter.remove();
            }
        }
        possibleTerrs.add(currentTerr);
        HashSet<Territory> availableLand = new HashSet<Territory>();
        availableLand.addAll(Match.getMatches(possibleTerrs, new CompositeMatchAnd(Matches.isTerritoryAllied(alliedPlayer, data), Matches.TerritoryIsLand)));
        availableLand.removeAll(canNotLand);
        whereCanLand.addAll(availableLand);
        if (Match.allMatch(strandedAir, Matches.UnitCanLandOnCarrier)) {
            HashSet<Territory> availableWater = new HashSet<Territory>();
            availableWater.addAll(Match.getMatches(possibleTerrs, new CompositeMatchAnd(Matches.territoryHasUnitsThatMatch(Matches.UnitIsAlliedCarrier(alliedPlayer, data)), Matches.TerritoryIsWater)));
            availableWater.removeAll(battleTracker.getPendingBattleSites(false));
            int carrierCost = AirMovementValidator.carrierCost(strandedAir);
            Iterator waterIter = availableWater.iterator();
            while (waterIter.hasNext()) {
                Territory t = (Territory)waterIter.next();
                int carrierCapacity = AirMovementValidator.carrierCapacity(t.getUnits().getMatches(Matches.UnitIsAlliedCarrier(alliedPlayer, data)), t);
                carrierCapacity = !t.equals(currentTerr) ? (carrierCapacity -= AirMovementValidator.carrierCost(t.getUnits().getMatches(new CompositeMatchAnd<Unit>(Matches.UnitCanLandOnCarrier, Matches.alliedUnit(alliedPlayer, data))))) : (carrierCapacity -= carrierCostForCurrentTerr);
                if (carrierCapacity >= carrierCost) continue;
                waterIter.remove();
            }
            whereCanLand.addAll(availableWater);
        }
        return whereCanLand;
    }

    private static boolean isIgnoreTransportInMovement(GameData data) {
        return Properties.getIgnoreTransportInMovement(data);
    }

    private static boolean isIgnoreSubInMovement(GameData data) {
        return Properties.getIgnoreSubInMovement(data);
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return IBattleDelegate.class;
    }

    static ITripleaPlayer getRemote(PlayerID player, IDelegateBridge bridge) {
        if (player.isNull()) {
            return new WeakAI(player.getName(), "E.Z. Fodder (AI)");
        }
        return (ITripleaPlayer)bridge.getRemote(player);
    }

    @Override
    public Territory getCurentBattle() {
        IBattle b = this.m_currentBattle;
        if (b != null) {
            return b.getTerritory();
        }
        return null;
    }
}

