/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.RulesAttachment;
import games.strategy.triplea.attatchments.TechAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.attatchments.UnitSupportAttachment;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.Die;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.StrategicBombingRaidPreBattle;
import games.strategy.triplea.delegate.TerritoryEffectHelper;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiceRoll
implements Externalizable {
    private List<Die> m_rolls;
    private int m_hits;

    public static Tuple<Integer, Integer> getAAattackAndMaxDiceSides(Collection<Unit> defendingEnemyAA, GameData data) {
        int diceSize;
        int highestAttack = 0;
        int chosenDiceSize = diceSize = data.getDiceSides();
        for (Unit u : defendingEnemyAA) {
            int attack;
            UnitAttachment ua = UnitAttachment.get(u.getType());
            int uaDiceSides = ua.getAttackAAmaxDieSides();
            if (uaDiceSides < 1) {
                uaDiceSides = diceSize;
            }
            if ((attack = ua.getAttackAA(u.getOwner())) > uaDiceSides) {
                attack = uaDiceSides;
            }
            if (!((float)attack / (float)uaDiceSides > (float)highestAttack / (float)chosenDiceSize)) continue;
            highestAttack = attack;
            chosenDiceSize = uaDiceSides;
        }
        if (highestAttack > chosenDiceSize / 2 && chosenDiceSize > 1) {
            highestAttack = chosenDiceSize / 2;
        }
        return new Tuple<Integer, Integer>(highestAttack, chosenDiceSize);
    }

    public static int getTotalAAattacks(Collection<Unit> defendingEnemyAA, Collection<Unit> validAttackingUnitsForThisRoll, GameData data) {
        int totalAAattacksNormal = 0;
        int totalAAattacksSurplus = 0;
        for (Unit aa : defendingEnemyAA) {
            UnitAttachment ua = UnitAttachment.get(aa.getType());
            if (ua.getMaxAAattacks() == -1) {
                totalAAattacksNormal = validAttackingUnitsForThisRoll.size();
                continue;
            }
            if (ua.getMayOverStackAA()) {
                totalAAattacksSurplus += ua.getMaxAAattacks();
                continue;
            }
            totalAAattacksNormal += ua.getMaxAAattacks();
        }
        totalAAattacksNormal = Math.min(totalAAattacksNormal, validAttackingUnitsForThisRoll.size());
        return totalAAattacksNormal + totalAAattacksSurplus;
    }

    public static DiceRoll rollAA(Collection<Unit> attackingUnitsAll, Collection<Unit> defendingAA, Match<Unit> targetUnitTypesForThisTypeAAMatch, IDelegateBridge bridge, Territory location) {
        String annotation;
        List<Unit> validAttackingUnitsForThisRoll = Match.getMatches(attackingUnitsAll, targetUnitTypesForThisTypeAAMatch);
        GameData data = bridge.getData();
        int hits = 0;
        ArrayList<Die> sortedDice = new ArrayList<Die>();
        Tuple<Integer, Integer> attackThenDiceSides = DiceRoll.getAAattackAndMaxDiceSides(defendingAA, data);
        int totalAAattacks = DiceRoll.getTotalAAattacks(defendingAA, validAttackingUnitsForThisRoll, data);
        int highestAttack = attackThenDiceSides.getFirst();
        int chosenDiceSize = attackThenDiceSides.getSecond();
        int hitAt = highestAttack - 1;
        int power = highestAttack;
        if (highestAttack > 0 && (Properties.getLow_Luck(data) || Properties.getLL_AA_ONLY(data))) {
            annotation = "Roll AA guns in " + location.getName();
            int groupSize = chosenDiceSize / power;
            if (Properties.getChoose_AA_Casualties(data)) {
                hits += DiceRoll.getLowLuckHits(bridge, sortedDice, power, chosenDiceSize, annotation, totalAAattacks);
            } else {
                Tuple<List<Unit>, List<Unit>> airSplit = BattleCalculator.categorizeLowLuckAirUnits(validAttackingUnitsForThisRoll, location, chosenDiceSize, groupSize);
                int firstGroupSize = airSplit.getFirst().size();
                hits += DiceRoll.getLowLuckHits(bridge, sortedDice, power, chosenDiceSize, annotation, Math.min(firstGroupSize, totalAAattacks));
                totalAAattacks = Math.max(0, totalAAattacks - firstGroupSize);
                int secondGroupSize = airSplit.getSecond().size();
                hits += DiceRoll.getLowLuckHits(bridge, sortedDice, power, chosenDiceSize, annotation, Math.min(secondGroupSize, totalAAattacks));
                totalAAattacks = Math.max(0, totalAAattacks - secondGroupSize);
            }
        } else if (highestAttack > 0) {
            annotation = "Roll AA guns in " + location.getName();
            int[] dice = bridge.getRandom(chosenDiceSize, totalAAattacks, annotation);
            for (int i = 0; i < dice.length; ++i) {
                boolean hit = dice[i] <= hitAt;
                sortedDice.add(new Die(dice[i], hitAt + 1, hit ? Die.DieType.HIT : Die.DieType.MISS));
                if (!hit) continue;
                ++hits;
            }
        }
        DiceRoll roll = new DiceRoll(sortedDice, hits);
        String annotation2 = "AA guns fire in " + location + " : " + MyFormatter.asDice(roll);
        bridge.getHistoryWriter().addChildToEvent(annotation2, roll);
        return roll;
    }

    private static int getLowLuckHits(IDelegateBridge bridge, List<Die> sortedDice, int power, int chosenDiceSize, String annotation, int numberOfAirUnits) {
        int hits = numberOfAirUnits * power / chosenDiceSize;
        int hitsFractional = numberOfAirUnits * power % chosenDiceSize;
        if (hitsFractional > 0) {
            boolean hit;
            int[] dice = bridge.getRandom(chosenDiceSize, 1, annotation);
            boolean bl = hit = hitsFractional > dice[0];
            if (hit) {
                ++hits;
            }
            Die die = new Die(dice[0], hitsFractional, hit ? Die.DieType.HIT : Die.DieType.MISS);
            sortedDice.add(die);
        }
        return hits;
    }

    public static DiceRoll rollDice(List<Unit> units, boolean defending, PlayerID player, IDelegateBridge bridge, IBattle battle, String annotation) {
        if (Properties.getLow_Luck(bridge.getData())) {
            return DiceRoll.rollDiceLowLuck(units, defending, player, bridge, battle, annotation);
        }
        return DiceRoll.rollDiceNormal(units, defending, player, bridge, battle, annotation);
    }

    public static DiceRoll rollNDice(IDelegateBridge bridge, int rollCount, int sides, String annotation) {
        if (rollCount == 0) {
            return new DiceRoll(new ArrayList<Die>(), 0);
        }
        int[] random = bridge.getRandom(sides, rollCount, annotation);
        ArrayList<Die> dice = new ArrayList<Die>();
        int diceIndex = 0;
        for (int i = 0; i < rollCount; ++i) {
            dice.add(new Die(random[diceIndex], 1, Die.DieType.IGNORED));
            ++diceIndex;
        }
        DiceRoll rVal = new DiceRoll(dice, rollCount);
        return rVal;
    }

    private static DiceRoll rollDiceLowLuck(List<Unit> units, boolean defending, PlayerID player, IDelegateBridge bridge, IBattle battle, String annotation) {
        GameData data = bridge.getData();
        boolean lhtrBombers = Properties.getLHTR_Heavy_Bombers(data);
        HashSet<List<UnitSupportAttachment>> supportRules = new HashSet<List<UnitSupportAttachment>>();
        IntegerMap<UnitSupportAttachment> supportLeft = new IntegerMap<UnitSupportAttachment>();
        DiceRoll.getSupport(units, supportRules, supportLeft, data, defending);
        Territory location = battle.getTerritory();
        int rollCount = BattleCalculator.getRolls(units, location, player, defending, new HashSet<List<UnitSupportAttachment>>(supportRules), new IntegerMap<UnitSupportAttachment>(supportLeft));
        if (rollCount == 0) {
            return new DiceRoll(new ArrayList<Die>(0), 0);
        }
        Iterator<Unit> iter = units.iterator();
        int power = 0;
        int hitCount = 0;
        while (iter.hasNext()) {
            Unit current = iter.next();
            UnitAttachment ua = UnitAttachment.get(current.getType());
            int rolls = BattleCalculator.getRolls(current, location, player, defending, new HashSet<List<UnitSupportAttachment>>(supportRules), new IntegerMap<UnitSupportAttachment>(supportLeft));
            int totalStr = 0;
            for (int i = 0; i < rolls; ++i) {
                int strength;
                if (i > 1 && (lhtrBombers || ua.getChooseBestRoll())) {
                    if (totalStr >= data.getDiceSides()) continue;
                    ++power;
                    ++totalStr;
                    continue;
                }
                if (defending) {
                    strength = ua.getDefense(current.getOwner());
                    strength = DiceRoll.isFirstTurnLimitedRoll(player, data) ? Math.min(1, strength) : (strength += DiceRoll.getSupport(current.getType(), supportRules, supportLeft));
                } else {
                    Collection<Unit> landUnits;
                    strength = ua.getAttack(current.getOwner());
                    if (ua.getIsMarine() && battle.isAmphibious() && (landUnits = battle.getAmphibiousLandAttackers()).contains(current)) {
                        ++strength;
                    }
                    if (ua.getIsSea() && battle.isAmphibious()) {
                        strength = ua.getBombard(current.getOwner());
                    }
                    strength += DiceRoll.getSupport(current.getType(), supportRules, supportLeft);
                }
                totalStr += (strength += TerritoryEffectHelper.getTerritoryCombatBonus(current.getType(), location, defending));
                power += Math.min(Math.max(strength, 0), data.getDiceSides());
            }
        }
        hitCount = power / data.getDiceSides();
        int[] random = new int[]{};
        ArrayList<Die> dice = new ArrayList<Die>();
        if ((power %= data.getDiceSides()) != 0) {
            boolean hit;
            random = bridge.getRandom(data.getDiceSides(), 1, annotation);
            boolean bl = hit = power > random[0];
            if (hit) {
                ++hitCount;
            }
            dice.add(new Die(random[0], power, hit ? Die.DieType.HIT : Die.DieType.MISS));
        }
        DiceRoll rVal = new DiceRoll(dice, hitCount);
        bridge.getHistoryWriter().addChildToEvent(annotation + " : " + MyFormatter.asDice(random), rVal);
        return rVal;
    }

    public static int getArtillerySupportAvailable(List<Unit> units, boolean defending, PlayerID player) {
        int artillerySupportAvailable = 0;
        if (!defending) {
            List<Unit> arty = Match.getMatches(units, Matches.UnitIsArtillery);
            for (Unit current : arty) {
                UnitAttachment ua = UnitAttachment.get(current.getType());
                artillerySupportAvailable += ua.getUnitSupportCount();
            }
            if (DiceRoll.isImprovedArtillerySupport(player)) {
                artillerySupportAvailable *= 2;
            }
        }
        return artillerySupportAvailable;
    }

    public static int getArtillerySupportAvailable(Unit u, boolean defending, PlayerID player) {
        if (Matches.UnitIsArtillery.match(u) && !defending) {
            UnitAttachment ua = UnitAttachment.get(u.getType());
            int artillerySupportAvailable = ua.getUnitSupportCount();
            if (DiceRoll.isImprovedArtillerySupport(player)) {
                artillerySupportAvailable *= 2;
            }
            return artillerySupportAvailable;
        }
        return 0;
    }

    public static int getSupportableAvailable(List<Unit> units, boolean defending, PlayerID player) {
        if (!defending) {
            return Match.countMatches(units, Matches.UnitIsArtillerySupportable);
        }
        return 0;
    }

    public static int getSupportableAvailable(Unit u, boolean defending, PlayerID player) {
        if (Matches.UnitIsArtillerySupportable.match(u) && !defending) {
            return 1;
        }
        return 0;
    }

    public static void getSupport(List<Unit> units, Set<List<UnitSupportAttachment>> support, IntegerMap<UnitSupportAttachment> supportLeft, GameData data, boolean defending) {
        for (UnitSupportAttachment rule : UnitSupportAttachment.get(data)) {
            if (rule.getPlayers().isEmpty() || (!defending || !rule.getDefence()) && (defending || !rule.getOffence())) continue;
            CompositeMatchAnd canSupport = new CompositeMatchAnd(Matches.unitIsOfType((UnitType)rule.getAttachedTo()), Matches.unitOwnedBy(rule.getPlayers()));
            List<Unit> supporters = Match.getMatches(units, canSupport);
            int numSupport = supporters.size();
            if (rule.getImpArtTech()) {
                numSupport += Match.getMatches(supporters, Matches.unitOwnerHasImprovedArtillerySupportTech()).size();
            }
            if (numSupport <= 0) continue;
            String bonusType = rule.getBonusType();
            supportLeft.put(rule, numSupport * rule.getNumber());
            Iterator<List<UnitSupportAttachment>> iter2 = support.iterator();
            List<UnitSupportAttachment> ruleType = null;
            boolean found = false;
            while (iter2.hasNext()) {
                ruleType = iter2.next();
                if (!ruleType.get(0).getBonusType().equals(bonusType)) continue;
                found = true;
                break;
            }
            if (!found) {
                ruleType = new ArrayList<UnitSupportAttachment>();
                support.add(ruleType);
            }
            ruleType.add(rule);
        }
        DiceRoll.sortSupportRules(support);
    }

    public static int getSupport(UnitType type, Set<List<UnitSupportAttachment>> support, IntegerMap<UnitSupportAttachment> supportLeft) {
        int strength = 0;
        Iterator<List<UnitSupportAttachment>> iter = support.iterator();
        block0: while (iter.hasNext()) {
            for (UnitSupportAttachment rule : iter.next()) {
                if (!rule.getUnitType().contains(type) || supportLeft.getInt(rule) <= 0) continue;
                strength += rule.getBonus();
                supportLeft.add(rule, -1);
                continue block0;
            }
        }
        return strength;
    }

    public static void sortByStrength(List<Unit> units, final boolean defending) {
        Comparator<Unit> comp = new Comparator<Unit>(){

            @Override
            public int compare(Unit u1, Unit u2) {
                Integer v2;
                Integer v1;
                if (defending) {
                    v1 = UnitAttachment.get(u1.getType()).getDefense(u1.getOwner());
                    v2 = UnitAttachment.get(u2.getType()).getDefense(u2.getOwner());
                } else {
                    v1 = UnitAttachment.get(u1.getType()).getAttack(u1.getOwner());
                    v2 = UnitAttachment.get(u2.getType()).getAttack(u2.getOwner());
                }
                return v1.compareTo(v2);
            }
        };
        Collections.sort(units, comp);
    }

    private static void sortSupportRules(Set<List<UnitSupportAttachment>> support) {
        Comparator<UnitSupportAttachment> compList = new Comparator<UnitSupportAttachment>(){

            @Override
            public int compare(UnitSupportAttachment u1, UnitSupportAttachment u2) {
                Integer v1 = Math.abs(u1.getBonus());
                Integer v2 = Math.abs(u2.getBonus());
                int compareTo = v2.compareTo(v1);
                if (compareTo != 0) {
                    return compareTo;
                }
                Integer s1 = u1.getUnitType().size();
                Integer s2 = u2.getUnitType().size();
                return s1.compareTo(s2);
            }
        };
        Iterator<List<UnitSupportAttachment>> iter = support.iterator();
        while (iter.hasNext()) {
            Collections.sort(iter.next(), compList);
        }
    }

    public static DiceRoll airBattle(List<Unit> unitsList, boolean defending, PlayerID player, IDelegateBridge bridge, IBattle battle, String annotation) {
        int[] random;
        Iterator iter;
        GameData data = bridge.getData();
        boolean lhtrBombers = Properties.getLHTR_Heavy_Bombers(data);
        ArrayList<Unit> units = new ArrayList<Unit>(unitsList);
        int rollCount = StrategicBombingRaidPreBattle.getAirBattleRolls(unitsList, defending);
        if (rollCount == 0) {
            return new DiceRoll(new ArrayList<Die>(), 0);
        }
        ArrayList<Die> dice = new ArrayList<Die>();
        int hitCount = 0;
        if (Properties.getLow_Luck(data)) {
            iter = units.iterator();
            int power = 0;
            while (iter.hasNext()) {
                Unit current = (Unit)iter.next();
                UnitAttachment ua = UnitAttachment.get(current.getType());
                int rolls = StrategicBombingRaidPreBattle.getAirBattleRolls(current, defending);
                int totalStrength = 0;
                int strength = Math.min(data.getDiceSides(), Math.max(0, defending ? ua.getAirDefense(current.getOwner()) : ua.getAirAttack(current.getOwner())));
                for (int i = 0; i < rolls; ++i) {
                    if (i > 1 && (lhtrBombers || ua.getChooseBestRoll())) {
                        ++totalStrength;
                        continue;
                    }
                    totalStrength += strength;
                }
                power += Math.min(Math.max(totalStrength, 0), data.getDiceSides());
            }
            hitCount = power / data.getDiceSides();
            random = new int[]{};
            if ((power %= data.getDiceSides()) != 0) {
                boolean hit;
                random = bridge.getRandom(data.getDiceSides(), 1, annotation);
                boolean bl = hit = power > random[0];
                if (hit) {
                    ++hitCount;
                }
                dice.add(new Die(random[0], power, hit ? Die.DieType.HIT : Die.DieType.MISS));
            }
        } else {
            random = bridge.getRandom(data.getDiceSides(), rollCount, annotation);
            iter = units.iterator();
            int diceIndex = 0;
            while (iter.hasNext()) {
                Unit current = (Unit)iter.next();
                UnitAttachment ua = UnitAttachment.get(current.getType());
                int strength = Math.min(data.getDiceSides(), Math.max(0, defending ? ua.getAirDefense(current.getOwner()) : ua.getAirAttack(current.getOwner())));
                int rolls = StrategicBombingRaidPreBattle.getAirBattleRolls(current, defending);
                if (rolls > 1 && (lhtrBombers || ua.getChooseBestRoll())) {
                    int minIndex = 0;
                    int min = data.getDiceSides();
                    for (int i = 0; i < rolls; ++i) {
                        if (random[diceIndex + i] >= min) continue;
                        min = random[diceIndex + i];
                        minIndex = i;
                    }
                    boolean hit = strength > random[diceIndex + minIndex];
                    dice.add(new Die(random[diceIndex + minIndex], strength, hit ? Die.DieType.HIT : Die.DieType.MISS));
                    for (int i = 0; i < rolls; ++i) {
                        if (i == minIndex) continue;
                        dice.add(new Die(random[diceIndex + i], strength, Die.DieType.IGNORED));
                    }
                    if (hit) {
                        ++hitCount;
                    }
                    diceIndex += rolls;
                    continue;
                }
                for (int i = 0; i < rolls; ++i) {
                    boolean hit = strength > random[diceIndex];
                    dice.add(new Die(random[diceIndex], strength, hit ? Die.DieType.HIT : Die.DieType.MISS));
                    if (hit) {
                        ++hitCount;
                    }
                    ++diceIndex;
                }
            }
        }
        DiceRoll rVal = new DiceRoll(dice, hitCount);
        bridge.getHistoryWriter().addChildToEvent(annotation + " : " + MyFormatter.asDice(random), rVal);
        return rVal;
    }

    private static DiceRoll rollDiceNormal(List<Unit> unitsList, boolean defending, PlayerID player, IDelegateBridge bridge, IBattle battle, String annotation) {
        GameData data = bridge.getData();
        ArrayList<Unit> units = new ArrayList<Unit>(unitsList);
        DiceRoll.sortByStrength(units, defending);
        boolean lhtrBombers = Properties.getLHTR_Heavy_Bombers(data);
        Territory location = battle.getTerritory();
        HashSet<List<UnitSupportAttachment>> supportRules = new HashSet<List<UnitSupportAttachment>>();
        IntegerMap<UnitSupportAttachment> supportLeft = new IntegerMap<UnitSupportAttachment>();
        DiceRoll.getSupport(units, supportRules, supportLeft, data, defending);
        int rollCount = BattleCalculator.getRolls(units, location, player, defending, new HashSet<List<UnitSupportAttachment>>(supportRules), new IntegerMap<UnitSupportAttachment>(supportLeft));
        if (rollCount == 0) {
            return new DiceRoll(new ArrayList<Die>(), 0);
        }
        int[] random = bridge.getRandom(data.getDiceSides(), rollCount, annotation);
        ArrayList<Die> dice = new ArrayList<Die>();
        Iterator iter = units.iterator();
        int hitCount = 0;
        int diceIndex = 0;
        while (iter.hasNext()) {
            Unit current = (Unit)iter.next();
            UnitAttachment ua = UnitAttachment.get(current.getType());
            int rolls = BattleCalculator.getRolls(current, location, player, defending, new HashSet<List<UnitSupportAttachment>>(supportRules), new IntegerMap<UnitSupportAttachment>(supportLeft));
            if (rolls > 1 && (lhtrBombers || ua.getChooseBestRoll())) {
                int strength = defending ? ua.getDefense(current.getOwner()) : ua.getAttack(current.getOwner());
                strength += DiceRoll.getSupport(current.getType(), supportRules, supportLeft);
                strength += TerritoryEffectHelper.getTerritoryCombatBonus(current.getType(), location, defending);
                strength = Math.min(Math.max(strength, 0), data.getDiceSides());
                int minIndex = 0;
                int min = data.getDiceSides();
                for (int i = 0; i < rolls; ++i) {
                    if (random[diceIndex + i] >= min) continue;
                    min = random[diceIndex + i];
                    minIndex = i;
                }
                boolean hit = strength > random[diceIndex + minIndex];
                dice.add(new Die(random[diceIndex + minIndex], strength, hit ? Die.DieType.HIT : Die.DieType.MISS));
                for (int i = 0; i < rolls; ++i) {
                    if (i == minIndex) continue;
                    dice.add(new Die(random[diceIndex + i], strength, Die.DieType.IGNORED));
                }
                if (hit) {
                    ++hitCount;
                }
                diceIndex += rolls;
                continue;
            }
            for (int i = 0; i < rolls; ++i) {
                int strength;
                if (defending) {
                    strength = ua.getDefense(current.getOwner());
                    strength = DiceRoll.isFirstTurnLimitedRoll(player, data) ? Math.min(1, strength) : (strength += DiceRoll.getSupport(current.getType(), supportRules, supportLeft));
                } else {
                    Collection<Unit> landUnits;
                    strength = ua.getAttack(current.getOwner());
                    if (ua.getIsMarine() && battle.isAmphibious() && (landUnits = battle.getAmphibiousLandAttackers()).contains(current)) {
                        ++strength;
                    }
                    if (ua.getIsSea() && battle.isAmphibious()) {
                        strength = ua.getBombard(current.getOwner());
                    }
                    strength += DiceRoll.getSupport(current.getType(), supportRules, supportLeft);
                }
                strength += TerritoryEffectHelper.getTerritoryCombatBonus(current.getType(), location, defending);
                strength = Math.min(Math.max(strength, 0), data.getDiceSides());
                boolean hit = strength > random[diceIndex];
                dice.add(new Die(random[diceIndex], strength, hit ? Die.DieType.HIT : Die.DieType.MISS));
                if (hit) {
                    ++hitCount;
                }
                ++diceIndex;
            }
        }
        DiceRoll rVal = new DiceRoll(dice, hitCount);
        bridge.getHistoryWriter().addChildToEvent(annotation + " : " + MyFormatter.asDice(random), rVal);
        return rVal;
    }

    public static boolean isFirstTurnLimitedRoll(PlayerID player, GameData data) {
        if (player.isNull() || data.getSequence().getRound() != 1 || DiceRoll.isNegateDominatingFirstRoundAttack(player)) {
            return false;
        }
        return DiceRoll.isDominatingFirstRoundAttack(data.getSequence().getStep().getPlayerID());
    }

    private static boolean isDominatingFirstRoundAttack(PlayerID player) {
        if (player == null) {
            return false;
        }
        RulesAttachment ra = (RulesAttachment)player.getAttachment("rulesAttatchment");
        if (ra == null) {
            return false;
        }
        return ra.getDominatingFirstRoundAttack();
    }

    private static boolean isNegateDominatingFirstRoundAttack(PlayerID player) {
        RulesAttachment ra = (RulesAttachment)player.getAttachment("rulesAttatchment");
        if (ra == null) {
            return false;
        }
        return ra.getNegateDominatingFirstRoundAttack();
    }

    public static boolean isAmphibious(Collection<Unit> m_units) {
        for (TripleAUnit tripleAUnit : m_units) {
            if (!tripleAUnit.getWasAmphibious()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAmphibiousMarine(UnitAttachment ua, GameData data) {
        data.acquireReadLock();
        try {
            BattleTracker bt = DelegateFinder.battleDelegate(data).getBattleTracker();
            Collection<Territory> m_pendingBattles = bt.getPendingBattleSites(false);
            for (Territory terr : m_pendingBattles) {
                IBattle battle = bt.getPendingBattle(terr, false);
                if (battle == null || !battle.isAmphibious() || !ua.getIsMarine()) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            data.releaseReadLock();
        }
        return false;
    }

    private static boolean isImprovedArtillerySupport(PlayerID player) {
        TechAttachment ta = (TechAttachment)player.getAttachment("techAttatchment");
        if (ta == null) {
            return false;
        }
        return ta.getImprovedArtillerySupport();
    }

    public static String getAnnotation(List<Unit> units, PlayerID player, IBattle battle) {
        StringBuilder buffer = new StringBuilder(80);
        buffer.append(player.getName()).append(" roll dice for ").append(MyFormatter.unitsToTextNoOwner(units));
        if (battle != null) {
            buffer.append(" in ").append(battle.getTerritory().getName()).append(", round ").append(battle.getBattleRound() + 1);
        }
        return buffer.toString();
    }

    public DiceRoll(int[] dice, int hits, int rollAt, boolean hitOnlyIfEquals) {
        this.m_hits = hits;
        this.m_rolls = new ArrayList<Die>(dice.length);
        for (int i = 0; i < dice.length; ++i) {
            boolean hit = hitOnlyIfEquals ? rollAt == dice[i] : dice[i] <= rollAt;
            this.m_rolls.add(new Die(dice[i], rollAt, hit ? Die.DieType.HIT : Die.DieType.MISS));
        }
    }

    public DiceRoll() {
    }

    private DiceRoll(List<Die> dice, int hits) {
        this.m_rolls = new ArrayList<Die>(dice);
        this.m_hits = hits;
    }

    public int getHits() {
        return this.m_hits;
    }

    public List<Die> getRolls(int rollAt) {
        ArrayList<Die> rVal = new ArrayList<Die>();
        for (Die die : this.m_rolls) {
            if (die.getRolledAt() != rollAt) continue;
            rVal.add(die);
        }
        return rVal;
    }

    public int size() {
        return this.m_rolls.size();
    }

    public Die getDie(int index) {
        return this.m_rolls.get(index);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int[] dice = new int[this.m_rolls.size()];
        for (int i = 0; i < this.m_rolls.size(); ++i) {
            dice[i] = this.m_rolls.get(i).getCompressedValue();
        }
        out.writeObject(dice);
        out.writeInt(this.m_hits);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int[] dice = (int[])in.readObject();
        this.m_rolls = new ArrayList<Die>(dice.length);
        for (int i = 0; i < dice.length; ++i) {
            this.m_rolls.add(Die.getFromWriteValue(dice[i]));
        }
        this.m_hits = in.readInt();
    }

    public String toString() {
        return "DiceRoll dice:" + this.m_rolls + " hits:" + this.m_hits;
    }
}

