/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.delegate.AirMovementValidator;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.triplea.delegate.UndoableMove;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.Match;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditValidator {
    private static String validateTerritoryBasic(GameData data, Territory territory, PlayerID player) {
        String result = null;
        List<UndoableMove> moves = DelegateFinder.moveDelegate(data).getMovesMade();
        for (UndoableMove move : moves) {
            if (move.getRoute().getStart() != territory && move.getRoute().getEnd() != territory) continue;
            return "Territory is start or end of a pending move";
        }
        return result;
    }

    public static String validateChangeTerritoryOwner(GameData data, Territory territory, PlayerID player) {
        String result = null;
        if (Matches.TerritoryIsWater.match(territory) && territory.getOwner().equals(PlayerID.NULL_PLAYERID)) {
            return "Territory is water";
        }
        result = EditValidator.validateTerritoryBasic(data, territory, player);
        if (result != null) {
            return result;
        }
        return result;
    }

    public static String validateAddUnits(GameData data, Territory territory, Collection<Unit> units) {
        String result = null;
        if (units.isEmpty()) {
            return "No units selected";
        }
        PlayerID player = units.iterator().next().getOwner();
        if (territory.isWater()) {
            if (!Match.allMatch(units, Matches.UnitIsSea)) {
                if (Match.someMatch(units, Matches.UnitIsLand)) {
                    return "Can not add land units to water";
                }
                if (Match.someMatch(units, Matches.UnitIsAir)) {
                    int carrierCost;
                    if (Match.someMatch(units, new CompositeMatchAnd(Matches.UnitIsAir, Matches.UnitCanLandOnCarrier.invert()))) {
                        return "Can not add air to water unless it can land on carriers";
                    }
                    CompositeMatchAnd<Unit> friendlyCarriers = new CompositeMatchAnd<Unit>(Matches.UnitIsCarrier, Matches.alliedUnit(player, data));
                    CompositeMatchAnd<Unit> friendlyAirUnits = new CompositeMatchAnd<Unit>(Matches.UnitIsAir, Matches.alliedUnit(player, data));
                    int carrierCapacityTotal = AirMovementValidator.carrierCapacity(territory.getUnits().getMatches(friendlyCarriers), territory) + AirMovementValidator.carrierCapacity(units, territory);
                    if (carrierCapacityTotal < (carrierCost = AirMovementValidator.carrierCost(territory.getUnits().getMatches(friendlyAirUnits)) + AirMovementValidator.carrierCost(units))) {
                        return "Can't add more air units to water without sufficient space";
                    }
                }
            }
        } else if (Match.someMatch(units, Matches.UnitIsSea)) {
            return "Can't add sea units to land";
        }
        if ((result = EditValidator.validateTerritoryBasic(data, territory, player)) != null) {
            return result;
        }
        return result;
    }

    public static String validateRemoveUnits(GameData data, Territory territory, Collection<Unit> units) {
        String result = null;
        if (units.isEmpty()) {
            return "No units selected";
        }
        PlayerID player = units.iterator().next().getOwner();
        if (!Match.allMatch(units, Matches.unitIsOwnedBy(player))) {
            return "Not all units have the same owner";
        }
        result = EditValidator.validateTerritoryBasic(data, territory, player);
        if (result != null) {
            return result;
        }
        TransportTracker transportTracker = new TransportTracker();
        for (Unit unit : Match.getMatches(units, Matches.UnitCanTransport)) {
            if (units.containsAll(transportTracker.transporting(unit))) continue;
            return "Can't remove transport without removing transported units";
        }
        for (Unit unit : Match.getMatches(units, Matches.UnitCanBeTransported)) {
            Unit transport = transportTracker.transportedBy(unit);
            if (transport == null || units.contains(transport)) continue;
            return "Can't remove transported units without removing transport";
        }
        return result;
    }
}

