/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.delegate.AbstractBattle;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.triplea.delegate.dataObjects.BattleRecord;
import games.strategy.triplea.oddsCalculator.ta.BattleResults;
import games.strategy.util.IntegerMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FinishedBattle
extends AbstractBattle {
    private static final long serialVersionUID = -5852495231826940879L;

    public FinishedBattle(Territory battleSite, PlayerID attacker, BattleTracker battleTracker, boolean isBombingRun, IBattle.BattleType battleType, GameData data, BattleRecord.BattleResultDescription battleResultDescription, IBattle.WhoWon whoWon, Collection<Unit> attackingUnits) {
        super(battleSite, attacker, battleTracker, isBombingRun, battleType, data);
        this.m_battleResultDescription = battleResultDescription;
        this.m_whoWon = whoWon;
        this.m_attackingUnits.addAll(attackingUnits);
    }

    public void setDefendingUnits(List<Unit> defendingUnits) {
        this.m_defendingUnits = defendingUnits;
    }

    @Override
    public boolean isEmpty() {
        return this.m_attackingUnits.isEmpty();
    }

    @Override
    public void fight(IDelegateBridge bridge) {
        if (!this.m_headless) {
            this.m_battleTracker.getBattleRecords(this.m_data).addResultToBattle(this.m_attacker, this.m_battleID, this.m_defender, this.m_attackerLostTUV, this.m_defenderLostTUV, this.m_battleResultDescription, new BattleResults(this, this.m_data), 0);
        }
        this.m_battleTracker.removeBattle(this);
        this.m_isOver = true;
    }

    @Override
    public Change addAttackChange(Route route, Collection<Unit> units, HashMap<Unit, HashSet<Unit>> targets) {
        Map<Unit, Collection<Unit>> addedTransporting = new TransportTracker().transporting(units);
        for (Unit unit : addedTransporting.keySet()) {
            if (this.m_dependentUnits.get(unit) != null) {
                ((Collection)this.m_dependentUnits.get(unit)).addAll(addedTransporting.get(unit));
                continue;
            }
            this.m_dependentUnits.put(unit, addedTransporting.get(unit));
        }
        this.m_attackingUnits.addAll(units);
        return ChangeFactory.EMPTY_CHANGE;
    }

    @Override
    public void removeAttack(Route route, Collection<Unit> units) {
        for (Unit dependence : this.m_dependentUnits.keySet()) {
            Collection dependent = (Collection)this.m_dependentUnits.get(dependence);
            dependent.removeAll(units);
        }
        this.m_attackingUnits.removeAll(units);
    }

    @Override
    public void unitsLostInPrecedingBattle(IBattle battle, Collection<Unit> units, IDelegateBridge bridge) {
        Collection<Unit> lost = this.getDependentUnits(units);
        if (lost.size() != 0) {
            this.m_attackingUnits.removeAll(lost);
            if (this.m_attackingUnits.isEmpty()) {
                IntegerMap<UnitType> costs = BattleCalculator.getCostsForTUV(this.m_attacker, this.m_data);
                int tuvLostAttacker = BattleCalculator.getTUV(lost, this.m_attacker, costs, this.m_data);
                this.m_attackerLostTUV += tuvLostAttacker;
                this.m_whoWon = IBattle.WhoWon.DEFENDER;
                if (!this.m_headless) {
                    this.m_battleTracker.getBattleRecords(this.m_data).addResultToBattle(this.m_attacker, this.m_battleID, this.m_defender, this.m_attackerLostTUV, this.m_defenderLostTUV, BattleRecord.BattleResultDescription.LOST, new BattleResults(this, this.m_data), 0);
                }
                this.m_battleTracker.removeBattle(this);
            }
        }
    }
}

