/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionFrontier;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.TechAttachment;
import games.strategy.triplea.delegate.TechAdvance;
import java.util.logging.Level;
import java.util.logging.Logger;

class ImprovedShipyardsAdvance
extends TechAdvance {
    private static final long serialVersionUID = 7613381831727736711L;

    public ImprovedShipyardsAdvance(GameData data) {
        super("Shipyards", data);
    }

    public String getProperty() {
        return "shipyards";
    }

    public void perform(PlayerID id, IDelegateBridge bridge) {
        GameData data = bridge.getData();
        if (!Properties.getUse_Shipyards(data)) {
            return;
        }
        ProductionFrontier current = id.getProductionFrontier();
        if (current.getName().endsWith("Shipyards")) {
            return;
        }
        String industrialTechName = current.getName() + "Shipyards";
        ProductionFrontier advancedTech = data.getProductionFrontierList().getProductionFrontier(industrialTechName);
        if (advancedTech == null) {
            Logger.getLogger(TechAdvance.class.getName()).log(Level.WARNING, "No tech named:" + industrialTechName + " not adding tech");
            return;
        }
        Change prodChange = ChangeFactory.changeProductionFrontier(id, advancedTech);
        bridge.addChange(prodChange);
    }

    public boolean hasTech(TechAttachment ta) {
        return ta.getShipyards();
    }
}

