/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.delegate.AbstractBattle;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.IBattle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockBattle
extends AbstractBattle {
    private static final long serialVersionUID = 6113135868274257523L;

    public MockBattle(Territory battleSite) {
        this(battleSite, null, null, null);
    }

    public MockBattle(Territory battleSite, PlayerID attacker, BattleTracker battleTracker, GameData data) {
        super(battleSite, attacker, battleTracker, false, IBattle.BattleType.MOCK_BATTLE, data);
    }

    @Override
    public Change addAttackChange(Route route, Collection<Unit> units, HashMap<Unit, HashSet<Unit>> targets) {
        return ChangeFactory.EMPTY_CHANGE;
    }

    @Override
    public void fight(IDelegateBridge bridge) {
    }

    @Override
    public void unitsLostInPrecedingBattle(IBattle battle, Collection<Unit> units, IDelegateBridge bridge) {
    }

    @Override
    public void removeAttack(Route route, Collection<Unit> units) {
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public void setIsAmphibious(boolean aBool) {
        this.m_isAmphibious = aBool;
    }

    public void setAmphibiousLandAttackers(Collection<Unit> units) {
        this.m_amphibiousLandAttackers = new ArrayList<Unit>(units);
    }

    public void setBombardingUnits(Collection<Unit> units) {
        this.m_bombardingUnits = new ArrayList<Unit>(units);
    }
}

