/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ResourceCollection;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.CanalAttachment;
import games.strategy.triplea.attatchments.PlayerAttachment;
import games.strategy.triplea.attatchments.RulesAttachment;
import games.strategy.triplea.attatchments.TechAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.AirMovementValidator;
import games.strategy.triplea.delegate.EditDelegate;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveDelegate;
import games.strategy.triplea.delegate.TerritoryEffectHelper;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.triplea.delegate.UndoableMove;
import games.strategy.triplea.delegate.UnitComparator;
import games.strategy.triplea.delegate.dataObjects.MoveValidationResult;
import games.strategy.triplea.delegate.dataObjects.MustMoveWithDetails;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.triplea.util.UnitSeperator;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.InverseMatch;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveValidator {
    public static final String TRANSPORT_HAS_ALREADY_UNLOADED_UNITS_IN_A_PREVIOUS_PHASE = "Transport has already unloaded units in a previous phase";
    public static final String TRANSPORT_MAY_NOT_UNLOAD_TO_FRIENDLY_TERRITORIES_UNTIL_AFTER_COMBAT_IS_RESOLVED = "Transport may not unload to friendly territories until after combat is resolved";
    public static final String TRANSPORT_HAS_ALREADY_UNLOADED_UNITS_TO = "Transport has already unloaded units to ";
    public static final String CANNOT_LOAD_AND_UNLOAD_AN_ALLIED_TRANSPORT_IN_THE_SAME_ROUND = "Cannot load and unload an allied transport in the same round";
    public static final String CANT_MOVE_THROUGH_IMPASSIBLE = "Can't move through impassible territories";
    public static final String CANT_MOVE_THROUGH_RESTRICTED = "Can't move through restricted territories";
    public static final String TOO_POOR_TO_VIOLATE_NEUTRALITY = "Not enough money to pay for violating neutrality";
    public static final String CANNOT_VIOLATE_NEUTRALITY = "Cannot violate neutrality";
    public static final String NOT_ALL_AIR_UNITS_CAN_LAND = "Not all air units can land";
    public static final String TRANSPORT_CANNOT_LOAD_AND_UNLOAD_AFTER_COMBAT = "Transport cannot both load AND unload after being in combat";
    public static final String LOST_BLITZ_ABILITY = "Unit lost blitz ability";
    public static final String NOT_ALL_UNITS_CAN_BLITZ = "Not all units can blitz";

    public static MoveValidationResult validateMove(Collection<Unit> units, Route route, PlayerID player, Collection<Unit> transportsToLoad, Map<Unit, Collection<Unit>> newDependents, boolean isNonCombat, List<UndoableMove> undoableMoves, GameData data) {
        MoveValidationResult result = new MoveValidationResult();
        if (route.hasNoSteps()) {
            return result;
        }
        if (MoveValidator.validateFirst(data, units, route, player, result).getError() != null) {
            return result;
        }
        if (isNonCombat ? MoveValidator.validateNonCombat(data, units, route, player, result).getError() != null : MoveValidator.validateCombat(data, units, route, player, result).getError() != null) {
            return result;
        }
        if (MoveValidator.validateNonEnemyUnitsOnPath(data, units, route, player, result).getError() != null) {
            return result;
        }
        if (MoveValidator.validateBasic(isNonCombat, data, units, route, player, transportsToLoad, newDependents, result).getError() != null) {
            return result;
        }
        if (AirMovementValidator.validateAirCanLand(data, units, route, player, result).getError() != null) {
            return result;
        }
        if (MoveValidator.validateTransport(isNonCombat, data, undoableMoves, units, route, player, transportsToLoad, newDependents, result).getError() != null) {
            return result;
        }
        if (MoveValidator.validateParatroops(isNonCombat, data, undoableMoves, units, route, player, result).getError() != null) {
            return result;
        }
        if (MoveValidator.validateCanal(data, units, route, player, result).getError() != null) {
            return result;
        }
        if (MoveValidator.validateFuel(data, units, route, player, result).getError() != null) {
            return result;
        }
        if (MoveDelegate.getBattleTracker(data).hasPendingBattle(route.getStart(), false) && Match.someMatch(units, Matches.UnitIsNotAir)) {
            boolean unitsStartedInTerritory = true;
            for (Unit unit : units) {
                if (MoveDelegate.getRouteUsedToMoveInto(undoableMoves, unit, route.getEnd()) == null) continue;
                unitsStartedInTerritory = false;
                break;
            }
            if (!unitsStartedInTerritory) {
                boolean attack;
                boolean unload = MoveValidator.isUnload(route);
                PlayerID endOwner = route.getEnd().getOwner();
                boolean bl = attack = !data.getRelationshipTracker().isAllied(endOwner, player) || MoveDelegate.getBattleTracker(data).wasConquered(route.getEnd());
                if (!unload || !attack) {
                    return result.setErrorReturnResult("Cannot move units out of battle zone");
                }
            }
        }
        return result;
    }

    static MoveValidationResult validateFirst(GameData data, Collection<Unit> units, Route route, PlayerID player, MoveValidationResult result) {
        if (!(units.isEmpty() || MoveValidator.getEditMode(data) || Match.allMatch(Match.getMatches(units, Matches.unitIsBeingTransportedByOrIsDependentOfSomeUnitInThisList(units, route, player, data).invert()), Matches.unitIsOwnedBy(player)))) {
            result.setError("Player, " + player.getName() + ", is not owner of all the units: " + MyFormatter.unitsToTextNoOwner(units));
            return result;
        }
        if (new HashSet<Unit>(units).size() != units.size()) {
            result.setError("Not all units unique, units:" + units + " unique:" + new HashSet<Unit>(units));
            return result;
        }
        if (!data.getMap().isValidRoute(route)) {
            result.setError("Invalid route:" + route);
            return result;
        }
        if (MoveValidator.validateMovementRestrictedByTerritory(data, units, route, player, result).getError() != null) {
            return result;
        }
        Collection<Territory> landOnRoute = route.getMatches(Matches.TerritoryIsLand);
        if (!landOnRoute.isEmpty()) {
            for (Territory t : landOnRoute) {
                if (Match.someMatch(units, Matches.UnitIsLand) && !data.getRelationshipTracker().canMoveLandUnitsOverOwnedLand(player, t.getOwner())) {
                    result.setError(player.getName() + " may not move land units over land owned by " + t.getOwner().getName());
                    return result;
                }
                if (!Match.someMatch(units, Matches.UnitIsAir) || data.getRelationshipTracker().canMoveAirUnitsOverOwnedLand(player, t.getOwner())) continue;
                result.setError(player.getName() + " may not move air units over land owned by " + t.getOwner().getName());
                return result;
            }
        }
        if (units.size() == 0) {
            return result.setErrorReturnResult("No units");
        }
        for (Unit unit : units) {
            if (!TripleAUnit.get(unit).getSubmerged()) continue;
            result.addDisallowedUnit("Cannot move submerged units", unit);
        }
        if (!route.getStart().getUnits().containsAll(units)) {
            return result.setErrorReturnResult("Not enough units in starting territory");
        }
        return result;
    }

    static MoveValidationResult validateFuel(GameData data, Collection<Unit> units, Route route, PlayerID player, MoveValidationResult result) {
        if (MoveValidator.getEditMode(data)) {
            return result;
        }
        ResourceCollection fuelCost = Route.getMovementCharge(units, route);
        if (player.getResources().has(fuelCost.getResourcesCopy())) {
            return result;
        }
        return result.setErrorReturnResult("Not enough resources to perform this move, you need: " + fuelCost + " for this move");
    }

    private static MoveValidationResult validateCanal(GameData data, Collection<Unit> units, Route route, PlayerID player, MoveValidationResult result) {
        if (MoveValidator.getEditMode(data)) {
            return result;
        }
        return result.setErrorReturnResult(MoveValidator.validateCanal(route, units, player, data));
    }

    private static MoveValidationResult validateCombat(GameData data, Collection<Unit> units, Route route, PlayerID player, MoveValidationResult result) {
        Set<Territory> end;
        if (MoveValidator.getEditMode(data)) {
            return result;
        }
        for (Territory t : route.getSteps()) {
            if (Matches.territoryOwnerRelationshipTypeCanMoveIntoDuringCombatMove(player).match(t)) continue;
            return result.setErrorReturnResult("Can not move into territories owned by " + t.getOwner().getName() + " during Combat Movement Phase");
        }
        if (!route.getStart().isWater() && Matches.isAtWar(route.getStart().getOwner(), data).match(player) && Matches.isAtWar(route.getEnd().getOwner(), data).match(player)) {
            if (!Matches.TerritoryIsBlitzable(player, data).match(route.getStart()) && !Match.allMatch(units, Matches.UnitIsAir)) {
                return result.setErrorReturnResult("Can not blitz out of a battle into enemy territory");
            }
            for (Unit u : Match.getMatches(units, new CompositeMatchAnd(Matches.UnitCanBlitz.invert(), Matches.UnitIsNotAir))) {
                result.addDisallowedUnit("Not all units can blitz out of empty enemy territory", u);
            }
        }
        if (!(!Match.someMatch(units, Matches.UnitCanNotMoveDuringCombatMove) || route.getStart().isWater() && route.getEnd().isWater())) {
            for (Unit unit : Match.getMatches(units, Matches.UnitCanNotMoveDuringCombatMove)) {
                result.addDisallowedUnit("Cannot move AA guns in combat movement phase", unit);
            }
        }
        if (MoveValidator.hasNeutralBeforeEnd(route) && !Match.allMatch(units, Matches.UnitIsAir) && !MoveValidator.isNeutralsBlitzable(data)) {
            return result.setErrorReturnResult("Must stop land units when passing through neutral territories");
        }
        if (Match.someMatch(units, Matches.UnitIsLand) && route.hasSteps()) {
            int enemyCount = 0;
            boolean allEnemyBlitzable = true;
            for (Territory current : route.getMiddleSteps()) {
                if (current.isWater() || !data.getRelationshipTracker().isAtWar(current.getOwner(), player) && !MoveDelegate.getBattleTracker(data).wasConquered(current)) continue;
                ++enemyCount;
                allEnemyBlitzable &= Matches.TerritoryIsBlitzable(player, data).match(current);
            }
            if (enemyCount > 0 && !allEnemyBlitzable) {
                if (MoveValidator.nonParatroopersPresent(player, units, route)) {
                    return result.setErrorReturnResult("Cannot blitz on that route");
                }
            } else if (allEnemyBlitzable && !route.getStart().isWater() && !route.getEnd().isWater()) {
                CompositeMatchOr blitzingUnit = new CompositeMatchOr(Matches.UnitCanBlitz, Matches.UnitIsAir);
                InverseMatch nonBlitzing = new InverseMatch(blitzingUnit);
                List<Unit> nonBlitzingUnits = Match.getMatches(units, nonBlitzing);
                nonBlitzingUnits.removeAll(UnitAttachment.getUnitsWhichReceivesAbilityWhenWith(units, "canBlitz", data));
                InverseMatch<Territory> territoryIsNotEnd = new InverseMatch<Territory>(Matches.territoryIs(route.getEnd()));
                InverseMatch<Territory> nonFriendlyTerritories = new InverseMatch<Territory>(Matches.isTerritoryFriendly(player, data));
                CompositeMatchAnd<Territory> notEndOrFriendlyTerrs = new CompositeMatchAnd<Territory>(nonFriendlyTerritories, territoryIsNotEnd);
                Match<Territory> foughtOver = Matches.territoryWasFoughOver(MoveDelegate.getBattleTracker(data));
                CompositeMatchAnd<Territory> notEndWasFought = new CompositeMatchAnd<Territory>(territoryIsNotEnd, foughtOver);
                Boolean wasStartFoughtOver = MoveDelegate.getBattleTracker(data).wasConquered(route.getStart()) || MoveDelegate.getBattleTracker(data).wasBlitzed(route.getStart());
                nonBlitzingUnits.addAll(Match.getMatches(units, Matches.unitIsOfTypes(TerritoryEffectHelper.getUnitTypesThatLostBlitz(wasStartFoughtOver != false ? route.getAllTerritories() : route.getSteps()))));
                for (Unit unit : nonBlitzingUnits) {
                    if (Matches.UnitIsAirTransportable.match(unit) || Matches.UnitIsInfantry.match(unit)) continue;
                    TripleAUnit tAUnit = (TripleAUnit)unit;
                    if (!wasStartFoughtOver.booleanValue() && !tAUnit.getWasInCombat() && !route.someMatch(notEndOrFriendlyTerrs) && !route.someMatch(notEndWasFought)) continue;
                    result.addDisallowedUnit(NOT_ALL_UNITS_CAN_BLITZ, unit);
                }
            }
        }
        if (Match.someMatch(units, Matches.UnitIsAir) && route.hasSteps() && (!Properties.getNeutralFlyoverAllowed(data) || MoveValidator.isNeutralsImpassable(data)) && Match.someMatch(route.getMiddleSteps(), Matches.TerritoryIsNeutralButNotWater)) {
            return result.setErrorReturnResult("Air units cannot fly over neutral territories");
        }
        if (MoveValidator.hasConqueredNonBlitzedNonWaterOnRoute(route, data) && !Match.allMatch(units, Matches.UnitIsAir)) {
            return result.setErrorReturnResult("Cannot move through newly captured territories");
        }
        if (Match.someMatch(units, Matches.UnitWasInCombat) && Match.someMatch(units, Matches.UnitWasUnloadedThisTurn) && Match.allMatch(end = Collections.singleton(route.getEnd()), Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(player, data)) && !route.getEnd().getUnits().isEmpty()) {
            return result.setErrorReturnResult("Units cannot participate in multiple battles");
        }
        if (MoveValidator.isUnload(route) && Matches.isTerritoryEnemy(player, data).match(route.getEnd())) {
            for (Unit unit : Match.getMatches(units, Matches.UnitCanInvade.invert())) {
                result.addDisallowedUnit(unit.getUnitType().getName() + " can't invade from " + TripleAUnit.get(unit).getTransportedBy().getUnitType().getName(), unit);
            }
        }
        return result;
    }

    private static MoveValidationResult validateNonCombat(GameData data, Collection<Unit> units, Route route, PlayerID player, MoveValidationResult result) {
        boolean navalMayNotNonComIntoControlled;
        if (MoveValidator.getEditMode(data)) {
            return result;
        }
        if (route.someMatch(Matches.TerritoryIsImpassable)) {
            return result.setErrorReturnResult(CANT_MOVE_THROUGH_IMPASSIBLE);
        }
        if (!route.someMatch(Matches.TerritoryIsPassableAndNotRestricted(player, data))) {
            return result.setErrorReturnResult(CANT_MOVE_THROUGH_RESTRICTED);
        }
        CompositeMatchOr<Territory> battle = new CompositeMatchOr<Territory>(new Match[0]);
        battle.add(Matches.TerritoryIsNeutralButNotWater);
        battle.add(Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(player, data));
        CompositeMatchAnd<Unit> transportsCanNotControl = new CompositeMatchAnd<Unit>(new Match[0]);
        transportsCanNotControl.add(Matches.UnitIsTransportAndNotDestroyer);
        transportsCanNotControl.add(Matches.UnitIsTransportButNotCombatTransport);
        boolean bl = navalMayNotNonComIntoControlled = MoveValidator.isWW2V2(data) || Properties.getNavalUnitsMayNotNonCombatMoveIntoControlledSeaZones(data);
        if (((Match)battle).match(route.getEnd())) {
            if (!navalMayNotNonComIntoControlled && MoveValidator.isSubControlSeaZoneRestricted(data) && Match.allMatch(units, Matches.UnitIsSub)) {
                return result;
            }
            if (!navalMayNotNonComIntoControlled && !MoveValidator.isTransportControlSeaZone(data) && Match.allMatch(units, transportsCanNotControl)) {
                return result;
            }
            if (!navalMayNotNonComIntoControlled && route.allMatch(Matches.TerritoryIsWater) && MoveValidator.noEnemyUnitsOnPathMiddleSteps(route, player, data) && !Matches.territoryHasEnemyUnits(player, data).match(route.getEnd())) {
                return result;
            }
            return result.setErrorReturnResult("Cannot advance units to battle in non combat");
        }
        if (MoveValidator.isSubmersibleSubsAllowed(data) && Match.allMatch(units, Matches.UnitIsSub) && MoveValidator.enemyDestroyerOnPath(route, player, data)) {
            return result.setErrorReturnResult("Cannot move submarines under destroyers");
        }
        if (route.getEnd().getUnits().someMatch(Matches.enemyUnit(player, data))) {
            if (MoveValidator.onlyIgnoredUnitsOnPath(route, player, data, false)) {
                return result;
            }
            CompositeMatchOr<Unit> friendlyOrSubmerged = new CompositeMatchOr<Unit>(new Match[0]);
            friendlyOrSubmerged.add(Matches.enemyUnit(player, data).invert());
            friendlyOrSubmerged.add(Matches.unitIsSubmerged(data));
            if (!(route.getEnd().getUnits().allMatch(friendlyOrSubmerged) || Match.allMatch(units, Matches.UnitIsAir) && route.getEnd().isWater() || Match.allMatch(units, Matches.UnitIsSub) && Properties.getSubsCanEndNonCombatMoveWithEnemies(data))) {
                return result.setErrorReturnResult("Cannot advance to battle in non combat");
            }
        }
        if (Match.allMatch(units, Matches.UnitIsAir)) {
            if (route.someMatch(new CompositeMatchAnd<Territory>(Matches.TerritoryIsNeutralButNotWater, Matches.TerritoryIsWater.invert())) && (!Properties.getNeutralFlyoverAllowed(data) || MoveValidator.isNeutralsImpassable(data))) {
                return result.setErrorReturnResult("Air units cannot fly over neutral territories in non combat");
            }
        } else {
            CompositeMatchOr<Territory> neutralOrEnemy = new CompositeMatchOr<Territory>(Matches.TerritoryIsNeutralButNotWater, Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(player, data));
            if (!(!route.someMatch(neutralOrEnemy) || !navalMayNotNonComIntoControlled && route.allMatch(Matches.TerritoryIsWater) || !MoveValidator.noEnemyUnitsOnPathMiddleSteps(route, player, data) || Matches.territoryHasEnemyUnits(player, data).match(route.getEnd()) || route.allMatch(new CompositeMatchOr<Territory>(Matches.TerritoryIsWater, new CompositeMatchAnd(Matches.TerritoryIsPassableAndNotRestricted(player, data), Matches.isTerritoryAllied(player, data), Matches.TerritoryIsLand))) && !MoveValidator.nonParatroopersPresent(player, units, route))) {
                return result.setErrorReturnResult("Cannot move units to neutral or enemy territories in non combat");
            }
        }
        return result;
    }

    static MoveValidationResult validateMovementRestrictedByTerritory(GameData data, Collection<Unit> units, Route route, PlayerID player, MoveValidationResult result) {
        block6: {
            Set<Territory> listedTerritories;
            String movementRestrictionType;
            block5: {
                if (MoveValidator.getEditMode(data)) {
                    return result;
                }
                if (!MoveValidator.isMovementByTerritoryRestricted(data)) {
                    return result;
                }
                RulesAttachment ra = (RulesAttachment)player.getAttachment("rulesAttatchment");
                if (ra == null || ra.getMovementRestrictionTerritories() == null) {
                    return result;
                }
                movementRestrictionType = ra.getMovementRestrictionType();
                listedTerritories = ra.getListedTerritories(ra.getMovementRestrictionTerritories());
                if (!movementRestrictionType.equals("allowed")) break block5;
                for (Territory current : route.getAllTerritories()) {
                    if (listedTerritories.contains(current)) continue;
                    return result.setErrorReturnResult("Cannot move outside restricted territories");
                }
                break block6;
            }
            if (!movementRestrictionType.equals("disallowed")) break block6;
            for (Territory current : route.getAllTerritories()) {
                if (!listedTerritories.contains(current)) continue;
                return result.setErrorReturnResult("Cannot move to restricted territories");
            }
        }
        return result;
    }

    private static MoveValidationResult validateNonEnemyUnitsOnPath(GameData data, Collection<Unit> units, Route route, PlayerID player, MoveValidationResult result) {
        if (MoveValidator.getEditMode(data)) {
            return result;
        }
        if (MoveValidator.noEnemyUnitsOnPathMiddleSteps(route, player, data)) {
            return result;
        }
        if (Match.allMatch(units, Matches.UnitIsAir)) {
            return result;
        }
        if (MoveValidator.isSubmersibleSubsAllowed(data) && Match.allMatch(units, Matches.UnitIsSub)) {
            if (MoveValidator.enemyDestroyerOnPath(route, player, data)) {
                return result.setErrorReturnResult("Cannot move submarines under destroyers");
            }
            return result;
        }
        if (MoveValidator.onlyIgnoredUnitsOnPath(route, player, data, true)) {
            return result;
        }
        if (MoveValidator.nonParatroopersPresent(player, units, route)) {
            return result.setErrorReturnResult("Enemy units on path");
        }
        return result;
    }

    private static MoveValidationResult validateBasic(boolean isNonCombat, GameData data, Collection<Unit> units, Route route, PlayerID player, Collection<Unit> transportsToLoad, Map<Unit, Collection<Unit>> newDependents, MoveValidationResult result) {
        boolean isEditMode = MoveValidator.getEditMode(data);
        if (route.getEnd() != null && !route.getEnd().getUnits().containsAll(transportsToLoad) && !units.containsAll(transportsToLoad)) {
            return result.setErrorReturnResult("Transports not found in route end");
        }
        if (!isEditMode) {
            for (Unit unit : Match.getMatches(units, Matches.enemyUnit(player, data))) {
                result.addDisallowedUnit("Can only move friendly units", unit);
            }
            Collection<Unit> moveTest = route.getStart().isWater() ? MoveValidator.getNonLand(units) : units;
            for (Unit unit : Match.getMatches(moveTest, Matches.unitIsOwnedBy(player).invert())) {
                if (UnitAttachment.get(unit.getType()).getCarrierCost() > 0 && data.getRelationshipTracker().isAllied(player, unit.getOwner())) continue;
                result.addDisallowedUnit("Can only move own troops", unit);
            }
            int mechanizedSupportAvailable = MoveValidator.getMechanizedSupportAvail(route, units, player);
            Map<Unit, Collection<Unit>> dependencies = MoveValidator.getDependents(Match.getMatches(units, Matches.UnitCanTransport), data);
            if (!newDependents.isEmpty()) {
                for (Unit transport : dependencies.keySet()) {
                    if (!dependencies.get(transport).isEmpty()) continue;
                    dependencies.put(transport, newDependents.get(transport));
                }
            }
            for (Unit unit : moveTest) {
                if (Matches.UnitHasEnoughMovementForRoute(route).match(unit)) continue;
                boolean unitOK = false;
                if (Matches.UnitIsAirTransportable.match(unit) && Matches.unitHasNotMoved.match(unit) && mechanizedSupportAvailable > 0 && Matches.unitHasNotMoved.match(unit) && Matches.UnitIsInfantry.match(unit)) {
                    if (Match.someMatch(units, Matches.UnitIsAirTransport)) {
                        for (Unit airTransport : dependencies.keySet()) {
                            if (dependencies.get(airTransport) != null && !dependencies.get(airTransport).contains(unit)) continue;
                            unitOK = true;
                            break;
                        }
                        if (unitOK) continue;
                        result.addDisallowedUnit("Not all units have enough movement", unit);
                        continue;
                    }
                    --mechanizedSupportAvailable;
                    continue;
                }
                if (Matches.UnitIsAirTransportable.match(unit) && Matches.unitHasNotMoved.match(unit)) {
                    for (Unit airTransport : dependencies.keySet()) {
                        if (dependencies.get(airTransport) != null && !dependencies.get(airTransport).contains(unit)) continue;
                        unitOK = true;
                        break;
                    }
                    if (unitOK) continue;
                    result.addDisallowedUnit("Not all units have enough movement", unit);
                    continue;
                }
                if (mechanizedSupportAvailable > 0 && Matches.unitHasNotMoved.match(unit) && Matches.UnitIsInfantry.match(unit)) {
                    --mechanizedSupportAvailable;
                    continue;
                }
                if (Matches.UnitTypeCanLandOnCarrier.match(unit.getType()) && MoveValidator.isAlliedAirDependents(data) && Match.someMatch(moveTest, Matches.UnitIsAlliedCarrier(unit.getOwner(), data))) continue;
                result.addDisallowedUnit("Not all units have enough movement", unit);
            }
            if (route.hasNeutralBeforeEnd() && !Match.allMatch(units, Matches.UnitIsAir) && !MoveValidator.isNeutralsBlitzable(data)) {
                return result.setErrorReturnResult("Must stop land units when passing through neutral territories");
            }
        }
        if (route.getEnd() != null && route.getEnd().isWater()) {
            for (Unit unit : MoveValidator.getUnitsThatCantGoOnWater(units)) {
                result.addDisallowedUnit("Not all units can end at water", unit);
            }
        }
        if (Match.someMatch(units, Matches.UnitIsSea) && route.hasLand()) {
            for (Unit unit : Match.getMatches(units, Matches.UnitIsSea)) {
                result.addDisallowedUnit("Sea units cannot go on land", unit);
            }
        }
        if (route.getEnd() != null) {
            List<Unit> unitsWithStackingLimits = Match.getMatches(units, new CompositeMatchOr(Matches.UnitHasMovementLimit, Matches.UnitHasAttackingLimit));
            for (Territory t : route.getSteps()) {
                int maxAllowed;
                UnitType ut;
                ArrayList<Unit> unitsAllowedSoFar = new ArrayList<Unit>();
                if (Matches.isTerritoryEnemyAndNotUnownedWater(player, data).match(t) || t.getUnits().someMatch(Matches.unitIsEnemyOf(data, player))) {
                    for (Unit unit : unitsWithStackingLimits) {
                        ut = unit.getType();
                        maxAllowed = UnitAttachment.getMaximumNumberOfThisUnitTypeToReachStackingLimit("attackingLimit", ut, t, player, data);
                        if ((maxAllowed -= Match.countMatches(unitsAllowedSoFar, Matches.unitIsOfType(ut))) > 0) {
                            unitsAllowedSoFar.add(unit);
                            continue;
                        }
                        result.addDisallowedUnit("UnitType " + ut.getName() + " has reached stacking limit", unit);
                    }
                    if (PlayerAttachment.getCanTheseUnitsMoveWithoutViolatingStackingLimit("attackingLimit", units, t, player, data)) continue;
                    return result.setErrorReturnResult("Units Can Not Go Over Stacking Limit");
                }
                for (Unit unit : unitsWithStackingLimits) {
                    ut = unit.getType();
                    maxAllowed = UnitAttachment.getMaximumNumberOfThisUnitTypeToReachStackingLimit("movementLimit", ut, t, player, data);
                    if ((maxAllowed -= Match.countMatches(unitsAllowedSoFar, Matches.unitIsOfType(ut))) > 0) {
                        unitsAllowedSoFar.add(unit);
                        continue;
                    }
                    result.addDisallowedUnit("UnitType " + ut.getName() + " has reached stacking limit", unit);
                }
                if (PlayerAttachment.getCanTheseUnitsMoveWithoutViolatingStackingLimit("movementLimit", units, t, player, data)) continue;
                return result.setErrorReturnResult("Units Can Not Go Over Stacking Limit");
            }
        }
        if (!isEditMode && route.someMatch(Matches.TerritoryIsImpassable)) {
            return result.setErrorReturnResult(CANT_MOVE_THROUGH_IMPASSIBLE);
        }
        if (MoveValidator.canCrossNeutralTerritory(data, route, player, result).getError() != null) {
            return result;
        }
        if (MoveValidator.isNeutralsImpassable(data) && !MoveValidator.isNeutralsBlitzable(data) && !route.getMatches(Matches.TerritoryIsNeutralButNotWater).isEmpty()) {
            return result.setErrorReturnResult(CANNOT_VIOLATE_NEUTRALITY);
        }
        return result;
    }

    @Deprecated
    public static boolean hasEnoughMovement(Collection<Unit> units, Route route) {
        return Match.allMatch(units, Matches.UnitHasEnoughMovementForRoute(route));
    }

    private static int getMechanizedSupportAvail(Route route, Collection<Unit> units, PlayerID player) {
        int mechanizedSupportAvailable = 0;
        if (MoveValidator.isMechanizedInfantry(player)) {
            CompositeMatchAnd transportLand = new CompositeMatchAnd(Matches.UnitIsLandTransport, Matches.unitIsOwnedBy(player));
            mechanizedSupportAvailable = Match.countMatches(units, transportLand);
        }
        return mechanizedSupportAvailable;
    }

    public static Map<Unit, Collection<Unit>> getDependents(Collection<Unit> units, GameData data) {
        TransportTracker tracker = new TransportTracker();
        HashMap<Unit, Collection<Unit>> dependents = new HashMap<Unit, Collection<Unit>>();
        for (Unit unit : units) {
            dependents.put(unit, tracker.transporting(unit));
        }
        return dependents;
    }

    @Deprecated
    public static boolean hasEnoughMovement(Collection<Unit> units, int length) {
        return Match.allMatch(units, Matches.UnitHasEnoughMovement(length));
    }

    @Deprecated
    public static boolean hasEnoughMovement(Unit unit, Route route) {
        return Matches.UnitHasEnoughMovementForRoute(route).match(unit);
    }

    @Deprecated
    public static boolean hasEnoughMovement(Unit unit, int length) {
        return Matches.UnitHasEnoughMovement(length).match(unit);
    }

    public static boolean noEnemyUnitsOnPathMiddleSteps(Route route, PlayerID player, GameData data) {
        CompositeMatchOr<Unit> alliedOrNonCombat = new CompositeMatchOr<Unit>(Matches.UnitIsFactoryOrIsInfrastructure, Matches.enemyUnit(player, data).invert(), Matches.unitIsSubmerged(data));
        for (Territory current : route.getMiddleSteps()) {
            if (current.getUnits().allMatch(alliedOrNonCombat)) continue;
            return false;
        }
        return true;
    }

    public static boolean onlyIgnoredUnitsOnPath(Route route, PlayerID player, GameData data, boolean ignoreRouteEnd) {
        CompositeMatchOr<Unit> subOnly = new CompositeMatchOr<Unit>(Matches.UnitIsFactoryOrIsInfrastructure, Matches.UnitIsSub, Matches.enemyUnit(player, data).invert());
        CompositeMatchOr<Unit> transportOnly = new CompositeMatchOr<Unit>(Matches.UnitIsFactoryOrIsInfrastructure, Matches.UnitIsTransportButNotCombatTransport, Matches.UnitIsLand, Matches.enemyUnit(player, data).invert());
        CompositeMatchOr<Unit> transportOrSubOnly = new CompositeMatchOr<Unit>(Matches.UnitIsFactoryOrIsInfrastructure, Matches.UnitIsTransportButNotCombatTransport, Matches.UnitIsLand, Matches.UnitIsSub, Matches.enemyUnit(player, data).invert());
        boolean getIgnoreTransportInMovement = MoveValidator.isIgnoreTransportInMovement(data);
        boolean getIgnoreSubInMovement = MoveValidator.isIgnoreSubInMovement(data);
        boolean validMove = false;
        List<Territory> steps = ignoreRouteEnd ? route.getMiddleSteps() : route.getSteps();
        for (Territory current : steps) {
            if (!current.isWater()) continue;
            if (getIgnoreTransportInMovement && getIgnoreSubInMovement && current.getUnits().allMatch(transportOrSubOnly)) {
                validMove = true;
                continue;
            }
            if (getIgnoreTransportInMovement && !getIgnoreSubInMovement && current.getUnits().allMatch(transportOnly)) {
                validMove = true;
                continue;
            }
            if (!getIgnoreTransportInMovement && getIgnoreSubInMovement && current.getUnits().allMatch(subOnly)) {
                validMove = true;
                continue;
            }
            return false;
        }
        return validMove;
    }

    public static boolean enemyDestroyerOnPath(Route route, PlayerID player, GameData data) {
        CompositeMatchAnd<Unit> enemyDestroyer = new CompositeMatchAnd<Unit>(Matches.UnitIsDestroyer, Matches.enemyUnit(player, data));
        for (Territory current : route.getMiddleSteps()) {
            if (!current.getUnits().someMatch(enemyDestroyer)) continue;
            return true;
        }
        return false;
    }

    private static boolean getEditMode(GameData data) {
        return EditDelegate.getEditMode(data);
    }

    public static boolean hasConqueredNonBlitzedNonWaterOnRoute(Route route, GameData data) {
        for (Territory current : route.getMiddleSteps()) {
            if (Matches.TerritoryIsWater.match(current) || !MoveDelegate.getBattleTracker(data).wasConquered(current) || MoveDelegate.getBattleTracker(data).wasBlitzed(current)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMechanizedInfantry(PlayerID player) {
        TechAttachment ta = (TechAttachment)player.getAttachment("techAttatchment");
        if (ta == null) {
            return false;
        }
        return ta.getMechanizedInfantry();
    }

    private static boolean isParatroopers(PlayerID player) {
        TechAttachment ta = (TechAttachment)player.getAttachment("techAttatchment");
        if (ta == null) {
            return false;
        }
        return ta.getParatroopers();
    }

    @Deprecated
    public static boolean isUnload(Route route) {
        return route.isUnload();
    }

    @Deprecated
    public static boolean isLoad(Route route) {
        return route.isLoad();
    }

    public static boolean isLoad(Collection<Unit> units, Map<Unit, Collection<Unit>> newDependents, Route route, GameData data, PlayerID player) {
        boolean checkForAlreadyTransported;
        Map<Unit, Collection<Unit>> alreadyLoaded = MoveValidator.mustMoveWith(units, newDependents, route.getStart(), data, player);
        if (route.hasNoSteps() && alreadyLoaded.isEmpty()) {
            return false;
        }
        boolean bl = checkForAlreadyTransported = !route.getStart().isWater() && MoveValidator.hasWater(route);
        if (checkForAlreadyTransported) {
            List<Unit> transports = Match.getMatches(units, new CompositeMatchOr(Matches.UnitIsTransport, Matches.UnitIsAirTransport));
            List<Unit> transportable = Match.getMatches(units, new CompositeMatchOr(Matches.UnitCanBeTransported, Matches.UnitIsAirTransportable));
            if (alreadyLoaded.keySet().containsAll(transports)) {
                for (Unit unit : transportable) {
                    boolean found = false;
                    for (Unit transport : transports) {
                        if (alreadyLoaded.get(transport) != null && !alreadyLoaded.get(transport).contains(unit)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return checkForAlreadyTransported;
                }
            } else {
                return checkForAlreadyTransported;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean hasNeutralBeforeEnd(Route route) {
        return route.hasNeutralBeforeEnd();
    }

    public static int getTransportCost(Collection<Unit> units) {
        if (units == null) {
            return 0;
        }
        int cost = 0;
        for (Unit item : units) {
            cost += UnitAttachment.get(item.getType()).getTransportCost();
        }
        return cost;
    }

    public static boolean validLoad(Collection<Unit> units, Collection<Unit> transports) {
        return true;
    }

    public static Collection<Unit> getUnitsThatCantGoOnWater(Collection<Unit> units) {
        ArrayList<Unit> retUnits = new ArrayList<Unit>();
        for (Unit unit : units) {
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            if (ua.getIsSea() || ua.getIsAir() || ua.getTransportCost() != -1) continue;
            retUnits.add(unit);
        }
        return retUnits;
    }

    public static boolean hasUnitsThatCantGoOnWater(Collection<Unit> units) {
        return !MoveValidator.getUnitsThatCantGoOnWater(units).isEmpty();
    }

    @Deprecated
    public static boolean hasWater(Route route) {
        return route.hasWater();
    }

    @Deprecated
    public static boolean hasLand(Route route) {
        return route.hasLand();
    }

    public static Collection<Unit> getNonLand(Collection<Unit> units) {
        CompositeMatchOr<Unit> match = new CompositeMatchOr<Unit>(new Match[0]);
        match.add(Matches.UnitIsAir);
        match.add(Matches.UnitIsSea);
        return Match.getMatches(units, match);
    }

    public static Collection<Unit> getFriendly(Territory territory, PlayerID player, GameData data) {
        return territory.getUnits().getMatches(Matches.alliedUnit(player, data));
    }

    public static int getMaxMovement(Collection<Unit> units) {
        if (units.size() == 0) {
            throw new IllegalArgumentException("no units");
        }
        int max = 0;
        for (Unit unit : units) {
            int left = TripleAUnit.get(unit).getMovementLeft();
            max = Math.max(left, max);
        }
        return max;
    }

    public static int getLeastMovement(Collection<Unit> units) {
        if (units.size() == 0) {
            throw new IllegalArgumentException("no units");
        }
        int least = Integer.MAX_VALUE;
        for (Unit unit : units) {
            int left = TripleAUnit.get(unit).getMovementLeft();
            least = Math.min(left, least);
        }
        return least;
    }

    public static int getTransportCapacityFree(Territory territory, PlayerID id, GameData data, TransportTracker tracker) {
        CompositeMatchAnd<Unit> friendlyTransports = new CompositeMatchAnd<Unit>(Matches.UnitIsTransport, Matches.alliedUnit(id, data));
        List<Unit> transports = territory.getUnits().getMatches(friendlyTransports);
        int sum = 0;
        for (Unit transport : transports) {
            sum += tracker.getAvailableCapacity(transport);
        }
        return sum;
    }

    private static MoveValidationResult canCrossNeutralTerritory(GameData data, Route route, PlayerID player, MoveValidationResult result) {
        Collection<Territory> neutrals = MoveDelegate.getEmptyNeutral(route);
        int PUs = player.getResources().getQuantity("PUs");
        if (PUs < MoveValidator.getNeutralCharge(data, neutrals.size())) {
            return result.setErrorReturnResult(TOO_POOR_TO_VIOLATE_NEUTRALITY);
        }
        return result;
    }

    private static Territory getTerritoryTransportHasUnloadedTo(List<UndoableMove> undoableMoves, Unit transport) {
        for (UndoableMove undoableMove : undoableMoves) {
            if (!undoableMove.wasTransportUnloaded(transport)) continue;
            return undoableMove.getRoute().getEnd();
        }
        return null;
    }

    private static MoveValidationResult validateTransport(boolean isNonCombat, GameData data, List<UndoableMove> undoableMoves, Collection<Unit> units, Route route, PlayerID player, Collection<Unit> transportsToLoad, Map<Unit, Collection<Unit>> newDependents, MoveValidationResult result) {
        block31: {
            boolean isEditMode = MoveValidator.getEditMode(data);
            if (Match.allMatch(units, Matches.UnitIsAir)) {
                return result;
            }
            if (!route.hasWater()) {
                return result;
            }
            Boolean seaOrNoTransportsPresent = transportsToLoad.isEmpty() || Match.someMatch(transportsToLoad, new CompositeMatchAnd(Matches.UnitIsSea, Matches.UnitCanTransport));
            if (!seaOrNoTransportsPresent.booleanValue()) {
                return result;
            }
            TransportTracker transportTracker = new TransportTracker();
            Territory routeEnd = route.getEnd();
            Territory routeStart = route.getStart();
            if (!isEditMode && MoveValidator.isUnload(route)) {
                if (route.hasMoreThenOneStep()) {
                    return result.setErrorReturnResult("Unloading units must stop where they are unloaded");
                }
                for (Unit unit : transportTracker.getUnitsLoadedOnAlliedTransportsThisTurn(units)) {
                    result.addDisallowedUnit(CANNOT_LOAD_AND_UNLOAD_AN_ALLIED_TRANSPORT_IN_THE_SAME_ROUND, unit);
                }
                Collection<Unit> transports = MoveDelegate.mapTransports(route, units, null).values();
                boolean isScramblingOrKamikazeAttacksEnabled = Properties.getScramble_Rules_In_Effect(data) || Properties.getUseKamikazeSuicideAttacks(data);
                for (Unit transport : transports) {
                    if (!(isNonCombat || route.numberOfStepsIncludingStart() != 2 || !isScramblingOrKamikazeAttacksEnabled && !Matches.territoryHasEnemyUnits(player, data).match(routeStart) || Matches.territoryHasEnemyUnits(player, data).match(routeEnd) || Matches.isTerritoryEnemyAndNotUnownedWater(player, data).match(routeEnd))) {
                        for (Unit unit : transportTracker.transporting(transport)) {
                            result.addDisallowedUnit(TRANSPORT_MAY_NOT_UNLOAD_TO_FRIENDLY_TERRITORIES_UNTIL_AFTER_COMBAT_IS_RESOLVED, unit);
                        }
                    }
                    if (transportTracker.hasTransportUnloadedInPreviousPhase(transport)) {
                        for (Unit unit : transportTracker.transporting(transport)) {
                            result.addDisallowedUnit(TRANSPORT_HAS_ALREADY_UNLOADED_UNITS_IN_A_PREVIOUS_PHASE, unit);
                        }
                        continue;
                    }
                    if (transportTracker.isTransportUnloadRestrictedToAnotherTerritory(transport, route.getEnd())) {
                        Territory alreadyUnloadedTo = MoveValidator.getTerritoryTransportHasUnloadedTo(undoableMoves, transport);
                        for (Unit unit : transportTracker.transporting(transport)) {
                            result.addDisallowedUnit(TRANSPORT_HAS_ALREADY_UNLOADED_UNITS_TO + alreadyUnloadedTo.getName(), unit);
                        }
                        continue;
                    }
                    if (!transportTracker.isTransportUnloadRestrictedInNonCombat(transport)) continue;
                    for (Unit unit : transportTracker.transporting(transport)) {
                        result.addDisallowedUnit(TRANSPORT_CANNOT_LOAD_AND_UNLOAD_AFTER_COMBAT, unit);
                    }
                }
            }
            List<Unit> land = Match.getMatches(units, Matches.UnitIsLand);
            List<Unit> landAndAir = Match.getMatches(units, new CompositeMatchOr(Matches.UnitIsLand, Matches.UnitIsAir));
            InverseMatch<Unit> cantBeTransported = new InverseMatch<Unit>(Matches.UnitCanBeTransported);
            for (Unit unit : Match.getMatches(land, cantBeTransported)) {
                result.addDisallowedUnit("Not all units can be transported", unit);
            }
            if (!isEditMode && route.hasLand() && !route.getStart().isWater() && !route.getEnd().isWater() && MoveValidator.nonParatroopersPresent(player, landAndAir, route)) {
                return result.setErrorReturnResult("Invalid move, only start or end can be land when route has water.");
            }
            if (!isEditMode && !route.getEnd().isWater() && !route.getStart().isWater() && MoveValidator.nonParatroopersPresent(player, landAndAir, route)) {
                return result.setErrorReturnResult("Must stop units at a transport on route");
            }
            if (route.getEnd().isWater() && route.getStart().isWater()) {
                for (Unit unit : units) {
                    Unit transport;
                    Collection<Unit> holding;
                    UnitAttachment ua = UnitAttachment.get(unit.getType());
                    if (ua.getTransportCapacity() != -1 && (holding = transportTracker.transporting(unit)) != null && !units.containsAll(holding)) {
                        result.addDisallowedUnit("Transports cannot leave their units", unit);
                    }
                    if (ua.getTransportCost() == -1 || (transport = transportTracker.transportedBy(unit)) == null || units.contains(transport)) continue;
                    result.addDisallowedUnit("Unit must stay with its transport while moving", unit);
                }
            }
            if (!route.isLoad()) break block31;
            if (!isEditMode && !route.hasExactlyOneStep() && MoveValidator.nonParatroopersPresent(player, landAndAir, route)) {
                return result.setErrorReturnResult("Units cannot move before loading onto transports");
            }
            CompositeMatchAnd<Unit> enemyNonSubmerged = new CompositeMatchAnd<Unit>(Matches.enemyUnit(player, data), new InverseMatch<Unit>(Matches.unitIsSubmerged(data)));
            if (route.getEnd().getUnits().someMatch(enemyNonSubmerged) && MoveValidator.nonParatroopersPresent(player, landAndAir, route) && !MoveValidator.onlyIgnoredUnitsOnPath(route, player, data, false) && !MoveDelegate.getBattleTracker(data).didAllThesePlayersJustGoToWarThisTurn(player, route.getEnd().getUnits().getUnits(), data)) {
                return result.setErrorReturnResult("Cannot load when enemy sea units are present");
            }
            Map<Unit, Unit> unitsToTransports = MoveDelegate.mapTransports(route, land, transportsToLoad);
            Iterator iter = land.iterator();
            while (!isEditMode && iter.hasNext()) {
                Unit transport;
                Unit unit;
                unit = (TripleAUnit)iter.next();
                if (Matches.unitHasMoved.match(unit)) {
                    result.addDisallowedUnit("Units cannot move before loading onto transports", unit);
                }
                if ((transport = unitsToTransports.get(unit)) == null) continue;
                if (transportTracker.hasTransportUnloadedInPreviousPhase(transport)) {
                    result.addDisallowedUnit(TRANSPORT_HAS_ALREADY_UNLOADED_UNITS_IN_A_PREVIOUS_PHASE, unit);
                    continue;
                }
                if (!transportTracker.isTransportUnloadRestrictedToAnotherTerritory(transport, route.getEnd())) continue;
                Territory alreadyUnloadedTo = MoveValidator.getTerritoryTransportHasUnloadedTo(undoableMoves, transport);
                for (TripleAUnit tripleAUnit : transportsToLoad) {
                    if (transportTracker.isTransportUnloadRestrictedToAnotherTerritory(tripleAUnit, route.getEnd())) continue;
                    UnitAttachment ua = UnitAttachment.get(unit.getType());
                    if (transportTracker.getAvailableCapacity(tripleAUnit) < ua.getTransportCost()) continue;
                    alreadyUnloadedTo = null;
                    break;
                }
                if (alreadyUnloadedTo == null) continue;
                result.addDisallowedUnit(TRANSPORT_HAS_ALREADY_UNLOADED_UNITS_TO + alreadyUnloadedTo.getName(), unit);
            }
            if (!unitsToTransports.keySet().containsAll(land)) {
                UnitAttachment ua;
                Set<UnitCategory> unitsToLoadCategories = UnitSeperator.categorize(land);
                if (unitsToTransports.size() == 0 || unitsToLoadCategories.size() == 1) {
                    for (Unit unit : land) {
                        if (unitsToTransports.containsKey(unit) || (ua = UnitAttachment.get(unit.getType())).getTransportCost() == -1) continue;
                        result.addDisallowedUnit("Not enough transports", unit);
                    }
                } else {
                    for (Unit unit : land) {
                        ua = UnitAttachment.get(unit.getType());
                        if (ua.getTransportCost() == -1) continue;
                        result.addUnresolvedUnit("Not enough transports", unit);
                    }
                }
            }
        }
        return result;
    }

    public static boolean allLandUnitsAreBeingParatroopered(Collection<Unit> units, Route route, PlayerID player) {
        if (!Match.allMatch(units, new CompositeMatchOr(Matches.UnitIsAirTransportable, Matches.UnitIsAirTransport, Matches.UnitIsAir))) {
            return false;
        }
        List<Unit> paratroopsRequiringTransport = Match.getMatches(units, Matches.UnitIsAirTransportable);
        if (paratroopsRequiringTransport.isEmpty()) {
            return false;
        }
        List<Unit> airTransports = Match.getMatches(units, Matches.UnitIsAirTransport);
        List<Unit> allParatroops = MoveDelegate.mapAirTransportPossibilities(route, paratroopsRequiringTransport, airTransports, false, player);
        if (!allParatroops.containsAll(paratroopsRequiringTransport)) {
            return false;
        }
        Map<Unit, Unit> transportLoadMap = MoveDelegate.mapAirTransports(route, units, airTransports, true, player);
        return transportLoadMap.keySet().containsAll(paratroopsRequiringTransport);
    }

    private static boolean nonParatroopersPresent(PlayerID player, Collection<Unit> units, Route route) {
        if (!MoveValidator.isParatroopers(player)) {
            return true;
        }
        if (!Match.allMatch(units, new CompositeMatchOr(Matches.UnitIsAir, Matches.UnitIsLand))) {
            return true;
        }
        for (Unit unit : Match.getMatches(units, Matches.UnitIsNotAirTransportable)) {
            if (!Matches.UnitIsLand.match(unit)) continue;
            return true;
        }
        return !MoveValidator.allLandUnitsAreBeingParatroopered(units, route, player);
    }

    private static List<Unit> getParatroopsRequiringTransport(Collection<Unit> units, final Route route) {
        return Match.getMatches(units, new CompositeMatchAnd(Matches.UnitIsAirTransportable, new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                return TripleAUnit.get(u).getMovementLeft() < route.getMovementCost(u) || route.crossesWater() || route.getEnd().isWater();
            }
        }));
    }

    private static MoveValidationResult validateParatroops(boolean nonCombat, GameData data, List<UndoableMove> undoableMoves, Collection<Unit> units, Route route, PlayerID player, MoveValidationResult result) {
        if (!MoveValidator.isParatroopers(player)) {
            return result;
        }
        if (Match.noneMatch(units, Matches.UnitIsAirTransportable) || Match.noneMatch(units, Matches.UnitIsAirTransport)) {
            return result;
        }
        if (nonCombat && !MoveValidator.isParatroopersCanMoveDuringNonCombat(data)) {
            return result.setErrorReturnResult("Paratroops may not move during NonCombat");
        }
        if (!MoveValidator.getEditMode(data)) {
            List<Unit> paratroopsRequiringTransport = MoveValidator.getParatroopsRequiringTransport(units, route);
            if (paratroopsRequiringTransport.isEmpty()) {
                return result;
            }
            List<Unit> airTransports = Match.getMatches(units, Matches.UnitIsAirTransport);
            Map<Unit, Unit> airTransportsAndParatroops = MoveDelegate.mapAirTransports(route, paratroopsRequiringTransport, airTransports, true, player);
            for (Unit paratroop : airTransportsAndParatroops.keySet()) {
                Unit transport;
                if (Matches.unitHasMoved.match(paratroop)) {
                    result.addDisallowedUnit("Cannot paratroop units that have already moved", paratroop);
                }
                if (!Matches.unitHasMoved.match(transport = airTransportsAndParatroops.get(paratroop))) continue;
                result.addDisallowedUnit("Cannot move then transport paratroops", transport);
            }
            Territory routeEnd = route.getEnd();
            for (Unit paratroop : paratroopsRequiringTransport) {
                if (Matches.unitHasMoved.match(paratroop)) {
                    result.addDisallowedUnit("Cannot paratroop units that have already moved", paratroop);
                }
                if (Matches.isTerritoryFriendly(player, data).match(routeEnd) && !MoveValidator.isParatroopersCanMoveDuringNonCombat(data)) {
                    result.addDisallowedUnit("Paratroops must advance to battle", paratroop);
                }
                if (nonCombat || !Matches.isTerritoryFriendly(player, data).match(routeEnd) || !MoveValidator.isParatroopersCanMoveDuringNonCombat(data)) continue;
                result.addDisallowedUnit("Paratroops may only airlift during Non-Combat Movement Phase", paratroop);
            }
            if (!Properties.getParatroopersCanAttackDeepIntoEnemyTerritory(data) || nonCombat) {
                for (Territory current : Match.getMatches(route.getMiddleSteps(), Matches.TerritoryIsLand)) {
                    if (!Matches.isTerritoryEnemy(player, data).match(current)) continue;
                    return result.setErrorReturnResult("Must stop paratroops in first enemy territory");
                }
            }
        }
        return result;
    }

    public static String validateCanal(Route route, Collection<Unit> units, PlayerID player, GameData data) {
        for (Territory routeTerritory : route.getAllTerritories()) {
            String result = MoveValidator.validateCanal(routeTerritory, route, units, player, data);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static String validateCanal(Territory territory, Route route, Collection<Unit> units, PlayerID player, GameData data) {
        Set<CanalAttachment> canalAttachments = CanalAttachment.get(territory);
        if (canalAttachments.isEmpty()) {
            return null;
        }
        for (CanalAttachment attachment : canalAttachments) {
            if (attachment == null) continue;
            if (route != null) {
                boolean mustCheck = false;
                Territory last = null;
                Set<Territory> connectionToCheck = CanalAttachment.getAllCanalSeaZones(attachment.getCanalName(), data);
                for (Territory current : route.getAllTerritories()) {
                    if (last != null) {
                        ArrayList<Territory> lastTwo = new ArrayList<Territory>();
                        lastTwo.add(last);
                        lastTwo.add(current);
                        mustCheck = lastTwo.containsAll(connectionToCheck);
                        if (mustCheck) break;
                    }
                    last = current;
                }
                if (!mustCheck) continue;
            }
            if (units != null && Match.allMatch(units, Matches.unitIsOfTypes(attachment.getExcludedUnits(data)))) continue;
            for (Territory borderTerritory : attachment.getLandTerritories()) {
                if (!data.getRelationshipTracker().canMoveThroughCanals(player, borderTerritory.getOwner())) {
                    return "Must own " + borderTerritory.getName() + " to go through " + attachment.getCanalName();
                }
                if (!MoveDelegate.getBattleTracker(data).wasConquered(borderTerritory)) continue;
                return "Cannot move through " + attachment.getCanalName() + " without owning " + borderTerritory.getName() + " for an entire turn";
            }
        }
        return null;
    }

    public static MustMoveWithDetails getMustMoveWith(Territory start, Collection<Unit> units, Map<Unit, Collection<Unit>> newDependents, GameData data, PlayerID player) {
        return new MustMoveWithDetails(MoveValidator.mustMoveWith(units, newDependents, start, data, player));
    }

    private static Map<Unit, Collection<Unit>> mustMoveWith(Collection<Unit> units, Map<Unit, Collection<Unit>> newDependents, Territory start, GameData data, PlayerID player) {
        HashMap<Unit, Collection<Unit>> newMapping;
        ArrayList<Unit> sortedUnits = new ArrayList<Unit>(units);
        Collections.sort(sortedUnits, UnitComparator.getIncreasingMovementComparator());
        HashMap<Unit, Collection<Unit>> mapping = new HashMap<Unit, Collection<Unit>>();
        mapping.putAll(MoveValidator.transportsMustMoveWith(sortedUnits));
        if (mapping.isEmpty()) {
            mapping.putAll(MoveValidator.carrierMustMoveWith(sortedUnits, start, data, player));
        } else {
            newMapping = new HashMap<Unit, Collection<Unit>>();
            newMapping.putAll(MoveValidator.carrierMustMoveWith(sortedUnits, start, data, player));
            if (!newMapping.isEmpty()) {
                MoveValidator.addToMapping(mapping, newMapping);
            }
        }
        if (mapping.isEmpty()) {
            mapping.putAll(MoveValidator.airTransportsMustMoveWith(sortedUnits, newDependents));
        } else {
            newMapping = new HashMap();
            newMapping.putAll(MoveValidator.airTransportsMustMoveWith(sortedUnits, newDependents));
            if (!newMapping.isEmpty()) {
                MoveValidator.addToMapping(mapping, newMapping);
            }
        }
        return mapping;
    }

    private static void addToMapping(Map<Unit, Collection<Unit>> mapping, Map<Unit, Collection<Unit>> newMapping) {
        for (Unit key : newMapping.keySet()) {
            if (mapping.containsKey(key)) {
                Collection<Unit> heldUnits = mapping.get(key);
                heldUnits.addAll(newMapping.get(key));
                mapping.put(key, heldUnits);
                continue;
            }
            mapping.put(key, newMapping.get(key));
        }
    }

    private static Map<Unit, Collection<Unit>> transportsMustMoveWith(Collection<Unit> units) {
        TransportTracker transportTracker = new TransportTracker();
        HashMap<Unit, Collection<Unit>> mustMoveWith = new HashMap<Unit, Collection<Unit>>();
        List<Unit> transports = Match.getMatches(units, Matches.UnitIsTransport);
        for (Unit transport : transports) {
            Collection<Unit> transporting = transportTracker.transporting(transport);
            mustMoveWith.put(transport, transporting);
        }
        return mustMoveWith;
    }

    private static Map<Unit, Collection<Unit>> airTransportsMustMoveWith(Collection<Unit> units, Map<Unit, Collection<Unit>> newDependents) {
        TransportTracker transportTracker = new TransportTracker();
        HashMap<Unit, Collection<Unit>> mustMoveWith = new HashMap<Unit, Collection<Unit>>();
        List<Unit> airTransports = Match.getMatches(units, Matches.UnitIsAirTransport);
        for (Unit airTransport : airTransports) {
            if (mustMoveWith.containsKey(airTransport)) continue;
            Collection<Unit> transporting = transportTracker.transporting(airTransport);
            if ((transporting == null || transporting.isEmpty()) && !newDependents.isEmpty()) {
                transporting = newDependents.get(airTransport);
            }
            mustMoveWith.put(airTransport, transporting);
        }
        return mustMoveWith;
    }

    public static Map<Unit, Collection<Unit>> carrierMustMoveWith(Collection<Unit> units, Territory start, GameData data, PlayerID player) {
        return MoveValidator.carrierMustMoveWith(units, start.getUnits().getUnits(), data, player);
    }

    public static Map<Unit, Collection<Unit>> carrierMustMoveWith(Collection<Unit> units, Collection<Unit> startUnits, GameData data, PlayerID player) {
        CompositeMatchAnd<Unit> friendlyNotOwnedAir = new CompositeMatchAnd<Unit>(new Match[0]);
        friendlyNotOwnedAir.add(Matches.alliedUnit(player, data));
        friendlyNotOwnedAir.addInverse(Matches.unitIsOwnedBy(player));
        friendlyNotOwnedAir.add(Matches.UnitCanLandOnCarrier);
        List<Unit> alliedAir = Match.getMatches(startUnits, friendlyNotOwnedAir);
        if (alliedAir.isEmpty()) {
            return Collections.emptyMap();
        }
        CompositeMatchAnd<Unit> friendlyNotOwnedCarrier = new CompositeMatchAnd<Unit>(new Match[0]);
        friendlyNotOwnedCarrier.add(Matches.UnitIsCarrier);
        friendlyNotOwnedCarrier.add(Matches.alliedUnit(player, data));
        friendlyNotOwnedCarrier.addInverse(Matches.unitIsOwnedBy(player));
        List<Unit> alliedCarrier = Match.getMatches(startUnits, friendlyNotOwnedCarrier);
        for (Unit carrier : alliedCarrier) {
            Collection<Unit> carrying = MoveValidator.getCanCarry(carrier, alliedAir);
            alliedAir.removeAll(carrying);
        }
        if (alliedAir.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Unit, Collection<Unit>> mapping = new HashMap<Unit, Collection<Unit>>();
        List<Unit> ownedCarrier = Match.getMatches(units, new CompositeMatchAnd(Matches.UnitIsCarrier, Matches.unitIsOwnedBy(player)));
        for (Unit carrier : ownedCarrier) {
            Collection<Unit> carrying = MoveValidator.getCanCarry(carrier, alliedAir);
            alliedAir.removeAll(carrying);
            mapping.put(carrier, carrying);
        }
        return mapping;
    }

    private static Collection<Unit> getCanCarry(Unit carrier, Collection<Unit> selectFrom) {
        UnitAttachment ua = UnitAttachment.get(carrier.getUnitType());
        ArrayList<Unit> canCarry = new ArrayList<Unit>();
        int available = ua.getCarrierCapacity();
        Iterator<Unit> iter = selectFrom.iterator();
        TripleAUnit tACarrier = (TripleAUnit)carrier;
        while (iter.hasNext()) {
            Unit plane = iter.next();
            TripleAUnit tAPlane = (TripleAUnit)plane;
            UnitAttachment planeAttachment = UnitAttachment.get(plane.getUnitType());
            int cost = planeAttachment.getCarrierCost();
            if (available >= cost && (tACarrier.getAlreadyMoved() == tAPlane.getAlreadyMoved() || Matches.unitHasNotMoved.match(plane) && Matches.unitHasNotMoved.match(carrier))) {
                available -= cost;
                canCarry.add(plane);
            }
            if (available != 0) continue;
            break;
        }
        return canCarry;
    }

    public static Route getBestRoute(Territory start, Territory end, GameData data, PlayerID player, Collection<Unit> units) {
        Route waterRoute;
        Route landRoute;
        Route defaultRoute;
        boolean hasLand = Match.someMatch(units, Matches.UnitIsLand);
        boolean hasAir = Match.someMatch(units, Matches.UnitIsAir);
        boolean isNeutralsImpassable = MoveValidator.isNeutralsImpassable(data) || hasAir && !Properties.getNeutralFlyoverAllowed(data);
        Match<Territory> noNeutral = Matches.TerritoryIsNeutralButNotWater.invert();
        Match<Territory> noAA = Matches.territoryHasEnemyAAforAnything(player, data).invert();
        Match<Territory> noEnemy = Matches.territoryHasEnemyUnits(player, data).invert();
        CompositeMatchAnd<Territory> noImpassible = new CompositeMatchAnd<Territory>(Matches.TerritoryIsPassableAndNotRestricted(player, data));
        if (hasAir) {
            noImpassible.add(Matches.TerritoryAllowsCanMoveAirUnitsOverOwnedLand(player, data));
        }
        if (hasLand) {
            noImpassible.add(Matches.TerritoryAllowsCanMoveLandUnitsOverOwnedLand(player, data));
        }
        if ((defaultRoute = isNeutralsImpassable ? data.getMap().getRoute_IgnoreEnd(start, end, new CompositeMatchAnd<Territory>(noNeutral, noImpassible)) : data.getMap().getRoute_IgnoreEnd(start, end, noImpassible)) == null) {
            defaultRoute = data.getMap().getRoute_IgnoreEnd(start, end, isNeutralsImpassable ? new CompositeMatchAnd(noNeutral, Matches.TerritoryIsImpassable) : Matches.TerritoryIsImpassable);
            if (defaultRoute == null) {
                return data.getMap().getRoute(start, end);
            }
            return defaultRoute;
        }
        ArrayList<Unit> unitsWhichAreNotBeingTransportedOrDependent = new ArrayList<Unit>(Match.getMatches(units, Matches.unitIsBeingTransportedByOrIsDependentOfSomeUnitInThisList(units, defaultRoute, player, data).invert()));
        boolean mustGoLand = false;
        boolean mustGoSea = false;
        if (!start.isWater() && !end.isWater() && (landRoute = isNeutralsImpassable ? data.getMap().getRoute_IgnoreEnd(start, end, new CompositeMatchAnd<Territory>(Matches.TerritoryIsLand, noNeutral, noImpassible)) : data.getMap().getRoute_IgnoreEnd(start, end, new CompositeMatchAnd<Territory>(Matches.TerritoryIsLand, noImpassible))) != null && Match.someMatch(unitsWhichAreNotBeingTransportedOrDependent, Matches.UnitIsLand)) {
            defaultRoute = landRoute;
            mustGoLand = true;
        }
        if (start.isWater() && end.isWater() && (waterRoute = data.getMap().getRoute_IgnoreEnd(start, end, new CompositeMatchAnd<Territory>(Matches.TerritoryIsWater, noImpassible))) != null && Match.someMatch(unitsWhichAreNotBeingTransportedOrDependent, Matches.UnitIsSea)) {
            defaultRoute = waterRoute;
            mustGoSea = true;
        }
        ArrayList<Match> tests = isNeutralsImpassable ? new ArrayList<CompositeMatchAnd>(Arrays.asList(new CompositeMatchAnd(noEnemy, noNeutral), new CompositeMatchAnd(noAA, noNeutral))) : new ArrayList<Match>(Arrays.asList(new CompositeMatchAnd(noEnemy, noNeutral), new CompositeMatchAnd(noAA, noNeutral), noEnemy, noAA, noNeutral));
        for (Match match : tests) {
            CompositeMatchAnd<Object> testMatch = null;
            testMatch = mustGoLand ? new CompositeMatchAnd(match, Matches.TerritoryIsLand, noImpassible) : (mustGoSea ? new CompositeMatchAnd(match, Matches.TerritoryIsWater, noImpassible) : new CompositeMatchAnd<Territory>(match, noImpassible));
            Route testRoute = data.getMap().getRoute_IgnoreEnd(start, end, testMatch);
            if (testRoute == null || testRoute.getLargestMovementCost(unitsWhichAreNotBeingTransportedOrDependent) > defaultRoute.getLargestMovementCost(unitsWhichAreNotBeingTransportedOrDependent)) continue;
            return testRoute;
        }
        return defaultRoute;
    }

    private static boolean areNeutralsPassableByAir(GameData data) {
        return Properties.getNeutralFlyoverAllowed(data) && !MoveValidator.isNeutralsImpassable(data);
    }

    private static boolean isWW2V2(GameData data) {
        return Properties.getWW2V2(data);
    }

    private static boolean isNeutralsImpassable(GameData data) {
        return Properties.getNeutralsImpassable(data);
    }

    private static boolean isNeutralsBlitzable(GameData data) {
        return Properties.getNeutralsBlitzable(data) && !MoveValidator.isNeutralsImpassable(data);
    }

    private static boolean isWW2V3(GameData data) {
        return Properties.getWW2V3(data);
    }

    private static boolean isMultipleAAPerTerritory(GameData data) {
        return Properties.getMultipleAAPerTerritory(data);
    }

    private static int getNeutralCharge(GameData data, Route route) {
        return MoveValidator.getNeutralCharge(data, MoveDelegate.getEmptyNeutral(route).size());
    }

    private static boolean isMovementByTerritoryRestricted(GameData data) {
        return Properties.getMovementByTerritoryRestricted(data);
    }

    private static boolean isParatroopersCanMoveDuringNonCombat(GameData data) {
        return Properties.getParatroopersCanMoveDuringNonCombat(data);
    }

    private static int getNeutralCharge(GameData data, int numberOfTerritories) {
        return numberOfTerritories * Properties.getNeutralCharge(data);
    }

    private static boolean isSubmersibleSubsAllowed(GameData data) {
        return Properties.getSubmersible_Subs(data);
    }

    private static boolean isKamikazeAircraft(GameData data) {
        return Properties.getKamikaze_Airplanes(data);
    }

    private static boolean isAlliedAirDependents(GameData data) {
        return Properties.getAlliedAirDependents(data);
    }

    private static boolean isIgnoreTransportInMovement(GameData data) {
        return Properties.getIgnoreTransportInMovement(data);
    }

    private static boolean isIgnoreSubInMovement(GameData data) {
        return Properties.getIgnoreSubInMovement(data);
    }

    private static boolean isSubControlSeaZoneRestricted(GameData data) {
        return Properties.getSubControlSeaZoneRestricted(data);
    }

    private static boolean isTransportControlSeaZone(GameData data) {
        return Properties.getTransportControlSeaZone(data);
    }

    private MoveValidator() {
    }
}

