/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.TechAbilityAttachment;
import games.strategy.triplea.delegate.AAInMoveUtil;
import games.strategy.triplea.delegate.AbstractMoveDelegate;
import games.strategy.triplea.delegate.BattleDelegate;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.EditDelegate;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MovePerformer;
import games.strategy.triplea.delegate.MoveValidator;
import games.strategy.triplea.delegate.SpecialMoveExtendedDelegateState;
import games.strategy.triplea.delegate.TripleADelegateBridge;
import games.strategy.triplea.delegate.UndoableMove;
import games.strategy.triplea.delegate.dataObjects.MoveValidationResult;
import games.strategy.triplea.delegate.remote.IMoveDelegate;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecialMoveDelegate
extends AbstractMoveDelegate
implements IMoveDelegate {
    private boolean m_needToInitialize = true;
    private boolean m_allowAirborne = true;

    @Override
    public void start(IDelegateBridge aBridge) {
        super.start(new TripleADelegateBridge(aBridge));
        GameData data = this.getData();
        if (!SpecialMoveDelegate.allowAirborne(this.m_player, data)) {
            this.m_allowAirborne = false;
            return;
        }
        boolean onlyWhereUnderAttackAlready = Properties.getAirborneAttacksOnlyInExistingBattles(data);
        BattleTracker battleTracker = AbstractMoveDelegate.getBattleTracker(data);
        if (this.m_needToInitialize && onlyWhereUnderAttackAlready) {
            BattleDelegate.doInitialize(battleTracker, aBridge);
            this.m_needToInitialize = false;
        }
    }

    @Override
    public void end() {
        super.end();
        this.m_needToInitialize = true;
        this.m_allowAirborne = true;
    }

    @Override
    public Serializable saveState() {
        SpecialMoveExtendedDelegateState state = new SpecialMoveExtendedDelegateState();
        state.superState = super.saveState();
        state.m_needToInitialize = this.m_needToInitialize;
        state.m_allowAirborne = this.m_allowAirborne;
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        SpecialMoveExtendedDelegateState s = (SpecialMoveExtendedDelegateState)state;
        super.loadState(s.superState);
        this.m_needToInitialize = s.m_needToInitialize;
        this.m_allowAirborne = s.m_allowAirborne;
    }

    @Override
    public String move(Collection<Unit> units, Route route, Collection<Unit> transportsThatCanBeLoaded, Map<Unit, Collection<Unit>> newDependents) {
        String numErrorsMsg;
        if (!this.m_allowAirborne) {
            return "No Airborne Movement Allowed Yet";
        }
        GameData data = this.getData();
        PlayerID player = this.getUnitsOwner(units);
        MoveValidationResult result = SpecialMoveDelegate.validateMove(units, route, player, transportsThatCanBeLoaded, newDependents, this.m_nonCombat, this.m_movesToUndo, data);
        StringBuilder errorMsg = new StringBuilder(100);
        int numProblems = result.getTotalWarningCount() - (result.hasError() ? 0 : 1);
        String string = numErrorsMsg = numProblems > 0 ? "; " + numProblems + " " + MyFormatter.pluralize("error", numProblems) + " not shown" : "";
        if (result.hasError()) {
            return errorMsg.append(result.getError()).append(numErrorsMsg).toString();
        }
        if (result.hasDisallowedUnits()) {
            return errorMsg.append(result.getDisallowedUnitWarning(0)).append(numErrorsMsg).toString();
        }
        if (result.hasUnresolvedUnits()) {
            return errorMsg.append(result.getUnresolvedUnitWarning(0)).append(numErrorsMsg).toString();
        }
        AAInMoveUtil aaInMoveUtil = new AAInMoveUtil();
        aaInMoveUtil.initialize(this.m_bridge);
        Collection<Territory> aaFiringTerritores = aaInMoveUtil.getTerritoriesWhereAAWillFire(route, units);
        if (!aaFiringTerritores.isEmpty() && !this.getRemotePlayer().confirmMoveInFaceOfAA(aaFiringTerritores)) {
            return null;
        }
        UndoableMove currentMove = new UndoableMove(data, units, route);
        for (UndoableMove otherMove : this.m_movesToUndo) {
            if (!otherMove.getStart().equals(route.getStart())) continue;
            currentMove.addDependency(otherMove);
        }
        CompositeChange airborneChange = new CompositeChange();
        for (Unit u : units) {
            airborneChange.add(ChangeFactory.unitPropertyChange(u, true, "airborne"));
        }
        currentMove.addChange(airborneChange);
        List<Unit> basesAtStart = route.getStart().getUnits().getMatches(SpecialMoveDelegate.getAirborneBaseMatch(player, data));
        Change fillLaunchCapacity = SpecialMoveDelegate.getNewAssignmentOfNumberLaunchedChange(units.size(), basesAtStart, player, data);
        currentMove.addChange(fillLaunchCapacity);
        String transcriptText = MyFormatter.unitsToTextNoOwner(units) + " moved from " + route.getStart().getName() + " to " + route.getEnd().getName();
        this.m_bridge.getHistoryWriter().startEvent(transcriptText, currentMove.getDescriptionObject());
        this.m_bridge.addChange(airborneChange);
        this.m_bridge.addChange(fillLaunchCapacity);
        this.m_tempMovePerformer = new MovePerformer();
        this.m_tempMovePerformer.initialize(this);
        this.m_tempMovePerformer.moveUnits(units, route, player, transportsThatCanBeLoaded, newDependents, currentMove);
        this.m_tempMovePerformer = null;
        return null;
    }

    public static MoveValidationResult validateMove(Collection<Unit> units, Route route, PlayerID player, Collection<Unit> transportsToLoad, Map<Unit, Collection<Unit>> newDependents, boolean isNonCombat, List<UndoableMove> undoableMoves, GameData data) {
        MoveValidationResult result = new MoveValidationResult();
        if (route.hasNoSteps()) {
            return result;
        }
        if (MoveValidator.validateFirst(data, units, route, player, result).getError() != null) {
            return result;
        }
        if (MoveValidator.validateFuel(data, units, route, player, result).getError() != null) {
            return result;
        }
        boolean isEditMode = SpecialMoveDelegate.getEditMode(data);
        if (!isEditMode) {
            for (Unit unit : Match.getMatches(units, Matches.unitIsOwnedBy(player).invert())) {
                result.addDisallowedUnit("Can only move owned units", unit);
            }
        }
        if (SpecialMoveDelegate.validateAirborneMovements(data, units, route, player, result).getError() != null) {
            return result;
        }
        return result;
    }

    private static MoveValidationResult validateAirborneMovements(GameData data, Collection<Unit> units, Route route, PlayerID player, MoveValidationResult result) {
        if (!TechAbilityAttachment.getAllowAirborneForces(player, data)) {
            return result.setErrorReturnResult("Do Not Have Airborne Tech");
        }
        int airborneDistance = TechAbilityAttachment.getAirborneDistance(player, data);
        Set<UnitType> airborneBases = TechAbilityAttachment.getAirborneBases(player, data);
        Set<UnitType> airborneTypes = TechAbilityAttachment.getAirborneTypes(player, data);
        if (airborneDistance <= 0 || airborneBases.isEmpty() || airborneTypes.isEmpty()) {
            return result.setErrorReturnResult("Require Airborne Forces And Launch Capacity Tech");
        }
        if (route.numberOfSteps() > airborneDistance) {
            return result.setErrorReturnResult("Destination Is Out Of Range");
        }
        Match<Unit> airborneBaseMatch = SpecialMoveDelegate.getAirborneMatch(player, airborneBases);
        Territory start = route.getStart();
        Territory end = route.getEnd();
        List<Unit> basesAtStart = start.getUnits().getMatches(airborneBaseMatch);
        if (basesAtStart.isEmpty()) {
            return result.setErrorReturnResult("Require Airborne Base At Originating Territory");
        }
        int airborneCapacity = TechAbilityAttachment.getAirborneCapacity(basesAtStart, player, data);
        if (airborneCapacity <= 0) {
            return result.setErrorReturnResult("Airborne Bases Must Have Launch Capacity");
        }
        if (airborneCapacity < units.size()) {
            ArrayList<Unit> overMax = new ArrayList<Unit>(units);
            overMax.removeAll(Match.getNMatches(units, airborneCapacity, Match.ALWAYS_MATCH));
            for (Unit u : overMax) {
                result.addDisallowedUnit("Airborne Base Capacity Has Been Reached", u);
            }
        }
        ArrayList<Unit> airborne = new ArrayList<Unit>();
        for (Unit u : units) {
            if (!Matches.unitIsOwnedBy(player).match(u)) {
                result.addDisallowedUnit("Must Own All Airborne Forces", u);
                continue;
            }
            if (!Matches.unitIsOfTypes(airborneTypes).match(u)) {
                result.addDisallowedUnit("Can Only Launch Airborne Forces", u);
                continue;
            }
            if (Matches.UnitIsDisabled().match(u)) {
                result.addDisallowedUnit("Must Not Be Disabled", u);
                continue;
            }
            if (!Matches.unitHasNotMoved.match(u)) {
                result.addDisallowedUnit("Must Not Have Previously Moved Airborne Forces", u);
                continue;
            }
            if (Matches.UnitIsAirborne.match(u)) {
                result.addDisallowedUnit("Can Not Move Units Already Airborne", u);
                continue;
            }
            airborne.add(u);
        }
        if (airborne.isEmpty()) {
            return result;
        }
        BattleTracker battleTracker = AbstractMoveDelegate.getBattleTracker(data);
        boolean onlyWhereUnderAttackAlready = Properties.getAirborneAttacksOnlyInExistingBattles(data);
        boolean onlyEnemyTerritories = Properties.getAirborneAttacksOnlyInEnemyTerritories(data);
        if (!Match.allMatch(route.getSteps(), Matches.TerritoryIsPassableAndNotRestricted(player, data))) {
            return result.setErrorReturnResult("May Not Fly Over Impassable or Restricted Territories");
        }
        if (!Match.allMatch(route.getSteps(), Matches.TerritoryAllowsCanMoveAirUnitsOverOwnedLand(player, data))) {
            return result.setErrorReturnResult("May Only Fly Over Territories Where Air May Move");
        }
        boolean someLand = Match.someMatch(airborne, Matches.UnitIsLand);
        boolean someSea = Match.someMatch(airborne, Matches.UnitIsSea);
        boolean land = Matches.TerritoryIsLand.match(end);
        boolean sea = Matches.TerritoryIsWater.match(end);
        if (someLand && someSea) {
            return result.setErrorReturnResult("Can Not Mix Land and Sea Units");
        }
        if (someLand) {
            if (!land) {
                return result.setErrorReturnResult("Can Not Move Land Units To Sea");
            }
        } else if (someSea && !sea) {
            return result.setErrorReturnResult("Can Not Move Sea Units To Land");
        }
        if (onlyWhereUnderAttackAlready) {
            IBattle battle = battleTracker.getPendingBattle(end, false);
            if (battle == null) {
                return result.setErrorReturnResult("Airborne May Only Attack Territories Already Under Assault");
            }
            if (land && someLand && !Match.someMatch(battle.getAttackingUnits(), Matches.UnitIsLand)) {
                return result.setErrorReturnResult("Battle Must Have Some Land Units Participating Already");
            }
            if (sea && someSea && !Match.someMatch(battle.getAttackingUnits(), Matches.UnitIsSea)) {
                return result.setErrorReturnResult("Battle Must Have Some Sea Units Participating Already");
            }
        } else if (onlyEnemyTerritories && !Matches.isTerritoryEnemyAndNotUnownedWater(player, data).match(end) && !Matches.territoryHasEnemyUnits(player, data).match(end)) {
            return result.setErrorReturnResult("Destination Must Be Enemy Or Contain Enemy Units");
        }
        return result;
    }

    public static Match<Unit> getAirborneTypesMatch(PlayerID player, GameData data) {
        return SpecialMoveDelegate.getAirborneMatch(player, TechAbilityAttachment.getAirborneTypes(player, data));
    }

    public static Match<Unit> getAirborneBaseMatch(PlayerID player, GameData data) {
        return SpecialMoveDelegate.getAirborneMatch(player, TechAbilityAttachment.getAirborneBases(player, data));
    }

    public static Match<Unit> getAirborneMatch(PlayerID player, Set<UnitType> types) {
        return new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.unitIsOfTypes(types), Matches.UnitIsDisabled().invert(), Matches.unitHasNotMoved, Matches.UnitIsAirborne.invert());
    }

    private static Change getNewAssignmentOfNumberLaunchedChange(int newNumberLaunched, Collection<Unit> bases, PlayerID player, GameData data) {
        CompositeChange launchedChange = new CompositeChange();
        if (newNumberLaunched <= 0) {
            return launchedChange;
        }
        IntegerMap<UnitType> capacityMap = TechAbilityAttachment.getAirborneCapacity(player, data);
        for (Unit u : bases) {
            if (newNumberLaunched <= 0) break;
            int numberLaunchedAlready = ((TripleAUnit)u).getLaunched();
            int capacity = capacityMap.getInt(u.getType());
            int toAdd = Math.min(newNumberLaunched, capacity - numberLaunchedAlready);
            if (toAdd <= 0) continue;
            newNumberLaunched -= toAdd;
            launchedChange.add(ChangeFactory.unitPropertyChange(u, toAdd + numberLaunchedAlready, "launched"));
        }
        return launchedChange;
    }

    public static boolean allowAirborne(PlayerID player, GameData data) {
        if (!TechAbilityAttachment.getAllowAirborneForces(player, data)) {
            return false;
        }
        int airborneDistance = TechAbilityAttachment.getAirborneDistance(player, data);
        Set<UnitType> airborneBases = TechAbilityAttachment.getAirborneBases(player, data);
        Set<UnitType> airborneTypes = TechAbilityAttachment.getAirborneTypes(player, data);
        if (airborneDistance <= 0 || airborneBases.isEmpty() || airborneTypes.isEmpty()) {
            return false;
        }
        GameMap map = data.getMap();
        List<Territory> territoriesWeCanLaunchFrom = Match.getMatches(map.getTerritories(), Matches.territoryHasUnitsThatMatch(SpecialMoveDelegate.getAirborneMatch(player, airborneBases)));
        return !territoriesWeCanLaunchFrom.isEmpty();
    }

    private static boolean getEditMode(GameData data) {
        return EditDelegate.getEditMode(data);
    }

    @Override
    public int PUsAlreadyLost(Territory t) {
        return 0;
    }

    @Override
    public void PUsLost(Territory t, int amt) {
    }
}

