/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.NamedAttachable;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.TechnologyFrontier;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.TechAttachment;
import games.strategy.triplea.delegate.AARadarAdvance;
import games.strategy.triplea.delegate.DestroyerBombardTechAdvance;
import games.strategy.triplea.delegate.HeavyBomberAdvance;
import games.strategy.triplea.delegate.ImprovedArtillerySupportAdvance;
import games.strategy.triplea.delegate.ImprovedShipyardsAdvance;
import games.strategy.triplea.delegate.IncreasedFactoryProductionAdvance;
import games.strategy.triplea.delegate.IndustrialTechnologyAdvance;
import games.strategy.triplea.delegate.JetPowerAdvance;
import games.strategy.triplea.delegate.LongRangeAircraftAdvance;
import games.strategy.triplea.delegate.MechanizedInfantryAdvance;
import games.strategy.triplea.delegate.ParatroopersAdvance;
import games.strategy.triplea.delegate.RocketsAdvance;
import games.strategy.triplea.delegate.SuperSubsAdvance;
import games.strategy.triplea.delegate.WarBondsAdvance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TechAdvance
extends NamedAttachable
implements Serializable {
    private static final long serialVersionUID = -1076712297024403156L;
    private static List<TechAdvance> s_WW2V1Advances = null;
    private static List<TechAdvance> s_WW2V2Advances = null;
    private static List<TechAdvance> s_WW2V3Advances = null;
    private static List<TechAdvance> s_AirNavalAdvances = null;
    private static List<TechAdvance> s_LandProductionAdvances = null;
    private static List<TechAdvance> s_allDefined = null;
    private static List<TechnologyFrontier> s_WW2V3Categories = null;
    public static TechAdvance JET_POWER = null;
    public static TechAdvance SUPER_SUBS = null;
    public static TechAdvance LONG_RANGE_AIRCRAFT = null;
    public static TechAdvance ROCKETS = null;
    public static TechAdvance INDUSTRIAL_TECHNOLOGY = null;
    public static TechAdvance HEAVY_BOMBER = null;
    public static TechAdvance DESTROYER_BOMBARD = null;
    public static TechAdvance IMPROVED_ARTILLERY_SUPPORT = null;
    public static TechAdvance PARATROOPERS = null;
    public static TechAdvance INCREASED_FACTORY_PRODUCTION = null;
    public static TechAdvance WAR_BONDS = null;
    public static TechAdvance MECHANIZED_INFANTRY = null;
    public static TechAdvance AA_RADAR = null;
    public static TechAdvance IMPROVED_SHIPYARDS = null;

    public TechAdvance(String name, GameData data) {
        super(name, data);
    }

    public abstract String getProperty();

    public abstract void perform(PlayerID var1, IDelegateBridge var2);

    public abstract boolean hasTech(TechAttachment var1);

    public static void setStaticTechs(GameData data) {
        JET_POWER = new JetPowerAdvance(data);
        SUPER_SUBS = new SuperSubsAdvance(data);
        LONG_RANGE_AIRCRAFT = new LongRangeAircraftAdvance(data);
        ROCKETS = new RocketsAdvance(data);
        INDUSTRIAL_TECHNOLOGY = new IndustrialTechnologyAdvance(data);
        HEAVY_BOMBER = new HeavyBomberAdvance(data);
        DESTROYER_BOMBARD = new DestroyerBombardTechAdvance(data);
        IMPROVED_ARTILLERY_SUPPORT = new ImprovedArtillerySupportAdvance(data);
        PARATROOPERS = new ParatroopersAdvance(data);
        INCREASED_FACTORY_PRODUCTION = new IncreasedFactoryProductionAdvance(data);
        WAR_BONDS = new WarBondsAdvance(data);
        MECHANIZED_INFANTRY = new MechanizedInfantryAdvance(data);
        AA_RADAR = new AARadarAdvance(data);
        IMPROVED_SHIPYARDS = new ImprovedShipyardsAdvance(data);
        s_WW2V1Advances = new ArrayList<TechAdvance>();
        s_WW2V1Advances.add(JET_POWER);
        s_WW2V1Advances.add(SUPER_SUBS);
        s_WW2V1Advances.add(LONG_RANGE_AIRCRAFT);
        s_WW2V1Advances.add(ROCKETS);
        s_WW2V1Advances.add(INDUSTRIAL_TECHNOLOGY);
        s_WW2V1Advances.add(HEAVY_BOMBER);
        s_WW2V1Advances = Collections.unmodifiableList(s_WW2V1Advances);
        s_WW2V2Advances = new ArrayList<TechAdvance>();
        s_WW2V2Advances.add(JET_POWER);
        s_WW2V2Advances.add(SUPER_SUBS);
        s_WW2V2Advances.add(LONG_RANGE_AIRCRAFT);
        s_WW2V2Advances.add(ROCKETS);
        s_WW2V2Advances.add(DESTROYER_BOMBARD);
        s_WW2V2Advances.add(HEAVY_BOMBER);
        s_WW2V2Advances.add(INDUSTRIAL_TECHNOLOGY);
        s_WW2V2Advances = Collections.unmodifiableList(s_WW2V2Advances);
        s_WW2V3Advances = new ArrayList<TechAdvance>();
        s_WW2V3Advances.add(SUPER_SUBS);
        s_WW2V3Advances.add(JET_POWER);
        s_WW2V3Advances.add(IMPROVED_SHIPYARDS);
        s_WW2V3Advances.add(AA_RADAR);
        s_WW2V3Advances.add(LONG_RANGE_AIRCRAFT);
        s_WW2V3Advances.add(HEAVY_BOMBER);
        s_WW2V3Advances.add(IMPROVED_ARTILLERY_SUPPORT);
        s_WW2V3Advances.add(ROCKETS);
        s_WW2V3Advances.add(PARATROOPERS);
        s_WW2V3Advances.add(INCREASED_FACTORY_PRODUCTION);
        s_WW2V3Advances.add(WAR_BONDS);
        s_WW2V3Advances.add(MECHANIZED_INFANTRY);
        s_WW2V3Advances = Collections.unmodifiableList(s_WW2V3Advances);
        s_AirNavalAdvances = new ArrayList<TechAdvance>();
        s_AirNavalAdvances.add(SUPER_SUBS);
        s_AirNavalAdvances.add(JET_POWER);
        s_AirNavalAdvances.add(IMPROVED_SHIPYARDS);
        s_AirNavalAdvances.add(AA_RADAR);
        s_AirNavalAdvances.add(LONG_RANGE_AIRCRAFT);
        s_AirNavalAdvances.add(HEAVY_BOMBER);
        s_AirNavalAdvances = Collections.unmodifiableList(s_AirNavalAdvances);
        s_LandProductionAdvances = new ArrayList<TechAdvance>();
        s_LandProductionAdvances.add(IMPROVED_ARTILLERY_SUPPORT);
        s_LandProductionAdvances.add(ROCKETS);
        s_LandProductionAdvances.add(PARATROOPERS);
        s_LandProductionAdvances.add(INCREASED_FACTORY_PRODUCTION);
        s_LandProductionAdvances.add(WAR_BONDS);
        s_LandProductionAdvances.add(MECHANIZED_INFANTRY);
        s_LandProductionAdvances = Collections.unmodifiableList(s_LandProductionAdvances);
        s_allDefined = new ArrayList<TechAdvance>();
        s_allDefined.addAll(s_WW2V3Advances);
        s_allDefined.add(INDUSTRIAL_TECHNOLOGY);
        s_allDefined.add(DESTROYER_BOMBARD);
        s_allDefined = Collections.unmodifiableList(s_allDefined);
    }

    public static List<TechAdvance> getTechAdvances(GameData data) {
        return TechAdvance.getTechAdvances(data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TechAdvance> getTechAdvances(GameData data, PlayerID player) {
        TechnologyFrontier technologyFrontier;
        data.acquireReadLock();
        try {
            technologyFrontier = data.getTechnologyFrontier();
        }
        finally {
            data.releaseReadLock();
        }
        if (technologyFrontier != null && !technologyFrontier.isEmpty()) {
            if (player != null) {
                return player.getTechnologyFrontierList().getAdvances();
            }
            return technologyFrontier.getTechs();
        }
        boolean isWW2V2 = Properties.getWW2V2(data);
        boolean isWW2V3 = Properties.getWW2V3(data);
        if (isWW2V2) {
            return s_WW2V2Advances;
        }
        if (isWW2V3) {
            return s_WW2V3Advances;
        }
        return s_WW2V1Advances;
    }

    public static TechAdvance findDefinedAdvance(String s) {
        for (TechAdvance t : s_allDefined) {
            if (!t.getProperty().equals(s)) continue;
            return t;
        }
        throw new IllegalArgumentException(s + " is not a valid technology");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TechnologyFrontier> getTechCategories(GameData data, PlayerID player) {
        TechnologyFrontier technologyFrontier;
        data.acquireReadLock();
        try {
            technologyFrontier = data.getTechnologyFrontier();
        }
        finally {
            data.releaseReadLock();
        }
        if (player != null && technologyFrontier != null && !technologyFrontier.isEmpty()) {
            return player.getTechnologyFrontierList().getFrontiers();
        }
        if (s_WW2V3Categories == null) {
            ArrayList<TechnologyFrontier> tf = new ArrayList<TechnologyFrontier>();
            TechnologyFrontier an = new TechnologyFrontier("Air and Naval Advances", data);
            an.addAdvance(s_AirNavalAdvances);
            TechnologyFrontier lp = new TechnologyFrontier("Land and Production Advances", data);
            lp.addAdvance(s_LandProductionAdvances);
            tf.add(an);
            tf.add(lp);
            s_WW2V3Categories = tf;
        }
        return s_WW2V3Categories;
    }

    public static TechAdvance findAdvance(String s, GameData data, PlayerID player) {
        for (TechAdvance t : TechAdvance.getTechAdvances(data, player)) {
            if (!t.getProperty().equals(s)) continue;
            return t;
        }
        throw new IllegalArgumentException(s + " is not a valid technology");
    }

    public static List<TechAdvance> getDefinedAdvances() {
        return s_allDefined;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof TechAdvance)) {
            return false;
        }
        TechAdvance ta = (TechAdvance)o;
        if (ta.getName() == null || this.getName() == null) {
            return false;
        }
        return this.getName().equals(ta.getName());
    }

    @Override
    public int hashCode() {
        if (this.getName() == null) {
            return super.hashCode();
        }
        return this.getName().hashCode();
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

