/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.Matches;
import games.strategy.util.IntegerMap;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitBattleComparator
implements Comparator<Unit> {
    private final boolean m_defending;
    private final IntegerMap<UnitType> m_costs;
    private final GameData m_data;
    private final boolean m_bonus;

    public UnitBattleComparator(boolean defending, IntegerMap<UnitType> costs, GameData data, boolean bonus) {
        this.m_defending = defending;
        this.m_costs = costs;
        this.m_data = data;
        this.m_bonus = bonus;
    }

    @Override
    public int compare(Unit u1, Unit u2) {
        int cost2;
        UnitAttachment ua2;
        if (u1.equals(u2)) {
            return 0;
        }
        UnitAttachment ua1 = UnitAttachment.get(u1.getType());
        if (ua1 == (ua2 = UnitAttachment.get(u2.getType()))) {
            return 0;
        }
        int power1 = BattleCalculator.getUnitPowerForSorting(u1, this.m_defending, this.m_data);
        int power2 = BattleCalculator.getUnitPowerForSorting(u2, this.m_defending, this.m_data);
        if (this.m_bonus) {
            if (Matches.UnitIsTransport.match(u1) && Matches.transportIsTransporting().match(u1) || Matches.UnitIsAir.match(u1) || Matches.UnitIsTwoHit.match(u1) || Matches.UnitIsCarrier.match(u1)) {
                ++power1;
            }
            if (Matches.UnitIsTransport.match(u2) && Matches.transportIsTransporting().match(u2) || Matches.UnitIsAir.match(u2) || Matches.UnitIsTwoHit.match(u2) || Matches.UnitIsCarrier.match(u2)) {
                ++power2;
            }
        }
        if (power1 != power2) {
            return power1 - power2;
        }
        int cost1 = this.m_costs.getInt(u1.getType());
        if (cost1 != (cost2 = this.m_costs.getInt(u2.getType()))) {
            return cost1 - cost2;
        }
        int power1reverse = BattleCalculator.getUnitPowerForSorting(u1, !this.m_defending, this.m_data);
        int power2reverse = BattleCalculator.getUnitPowerForSorting(u2, !this.m_defending, this.m_data);
        if (this.m_bonus) {
            if (Matches.UnitIsTransport.match(u1) && Matches.transportIsTransporting().match(u1) || Matches.UnitIsAir.match(u1) || Matches.UnitIsTwoHit.match(u1) || Matches.UnitIsCarrier.match(u1)) {
                ++power1reverse;
            }
            if (Matches.UnitIsTransport.match(u2) && Matches.transportIsTransporting().match(u2) || Matches.UnitIsAir.match(u2) || Matches.UnitIsTwoHit.match(u2) || Matches.UnitIsCarrier.match(u2)) {
                ++power2reverse;
            }
        }
        if (power1reverse != power2reverse) {
            return power1reverse - power2reverse;
        }
        if (Matches.UnitIsTransport.match(u1) && (Matches.UnitIsNotTransport.match(u2) || Matches.transportIsNotTransporting().match(u2)) && Matches.transportIsTransporting().match(u1)) {
            return 1;
        }
        if (Matches.UnitIsTransport.match(u2) && (Matches.UnitIsNotTransport.match(u1) || Matches.transportIsNotTransporting().match(u1)) && Matches.transportIsTransporting().match(u2)) {
            return -1;
        }
        return 0;
    }
}

