/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate.dataObjects;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameDataComponent;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.net.GUID;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.dataObjects.BattleRecord;
import games.strategy.triplea.oddsCalculator.ta.BattleResults;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BattleRecords
extends GameDataComponent
implements Serializable {
    private static final long serialVersionUID = 1473664374777905497L;
    private final HashMap<PlayerID, HashMap<GUID, BattleRecord>> m_records = new HashMap();

    public BattleRecords(GameData data) {
        super(data);
    }

    public BattleRecords(BattleRecords records) {
        super(records.getData());
        for (Map.Entry<PlayerID, HashMap<GUID, BattleRecord>> entry : records.m_records.entrySet()) {
            PlayerID p = entry.getKey();
            HashMap<GUID, BattleRecord> record = entry.getValue();
            HashMap<GUID, BattleRecord> map = new HashMap<GUID, BattleRecord>();
            for (Map.Entry<GUID, BattleRecord> entry2 : record.entrySet()) {
                map.put(entry2.getKey(), new BattleRecord(entry2.getValue()));
            }
            this.m_records.put(p, map);
        }
    }

    public static Collection<BattleRecord> getAllRecords(BattleRecords brs) {
        ArrayList<BattleRecord> records = new ArrayList<BattleRecord>();
        for (HashMap<GUID, BattleRecord> playerMap : brs.m_records.values()) {
            for (BattleRecord r : playerMap.values()) {
                records.add(r);
            }
        }
        return records;
    }

    public static Collection<BattleRecord> getRecordsForPlayerID(PlayerID player, BattleRecords brs) {
        ArrayList<BattleRecord> playerRecords = new ArrayList<BattleRecord>();
        if (brs.m_records.get(player) == null) {
            return playerRecords;
        }
        for (Map.Entry<GUID, BattleRecord> entry : brs.m_records.get(player).entrySet()) {
            playerRecords.add(entry.getValue());
        }
        return playerRecords;
    }

    public static Collection<BattleRecord> getRecordsForPlayers(Collection<PlayerID> players, BattleRecords brs) {
        ArrayList<BattleRecord> playersRecords = new ArrayList<BattleRecord>();
        for (PlayerID player : players) {
            if (brs.m_records.get(player) == null) continue;
            for (Map.Entry<GUID, BattleRecord> entry : brs.m_records.get(player).entrySet()) {
                playersRecords.add(entry.getValue());
            }
        }
        return playersRecords;
    }

    public static int getLostTUVforBattleRecords(Collection<BattleRecord> brs, boolean attackerLostTUV, boolean includeNullPlayer) {
        int totalLostTUV = 0;
        for (BattleRecord br : brs) {
            if (!includeNullPlayer && (br.getDefender() == null || br.getAttacker() == null || br.getDefender().isNull() || br.getAttacker().isNull())) continue;
            if (attackerLostTUV) {
                totalLostTUV += br.getAttackerLostTUV();
                continue;
            }
            totalLostTUV += br.getDefenderLostTUV();
        }
        return totalLostTUV;
    }

    public static boolean getWereThereBattlesInTerritoriesMatching(Collection<BattleRecord> brs, PlayerID attacker, PlayerID defender, String battleType, Collection<Territory> anyOfTheseTerritories) {
        for (BattleRecord br : brs) {
            if (!anyOfTheseTerritories.contains(br.getBattleSite()) || attacker != null && !attacker.equals(br.getAttacker()) || defender != null && !defender.equals(br.getDefender()) || !battleType.equalsIgnoreCase("any")) continue;
            return true;
        }
        return false;
    }

    public void removeBattle(PlayerID currentPlayer, GUID battleID) {
        HashMap<GUID, BattleRecord> current = this.m_records.get(currentPlayer);
        if (current == null || !current.containsKey(battleID)) {
            for (Map.Entry<PlayerID, HashMap<GUID, BattleRecord>> entry : this.m_records.entrySet()) {
                if (entry.getValue() == null || !entry.getValue().containsKey(battleID)) continue;
                entry.getValue().remove(battleID);
                return;
            }
            throw new IllegalStateException("Trying to remove info from battle records that do not exist");
        }
        current.remove(battleID);
    }

    public void addRecord(BattleRecords other) {
        for (PlayerID p : other.m_records.keySet()) {
            HashMap<GUID, BattleRecord> currentRecord = this.m_records.get(p);
            if (currentRecord != null) {
                HashMap<GUID, BattleRecord> additionalRecords = other.m_records.get(p);
                for (Map.Entry<GUID, BattleRecord> entry : additionalRecords.entrySet()) {
                    GUID guid = entry.getKey();
                    BattleRecord br = entry.getValue();
                    if (currentRecord.containsKey(guid)) {
                        throw new IllegalStateException("Should not be adding battle record for player " + p.getName() + " when they are already on the record. " + "Trying to add: " + br.toString());
                    }
                    currentRecord.put(guid, br);
                }
                this.m_records.put(p, currentRecord);
                continue;
            }
            this.m_records.put(p, other.m_records.get(p));
        }
    }

    public void addBattle(PlayerID currentPlayerAndAttacker, GUID battleID, Territory battleSite, IBattle.BattleType battleType, GameData data) {
        HashMap<GUID, BattleRecord> current = this.m_records.get(currentPlayerAndAttacker);
        if (current == null) {
            current = new HashMap();
        }
        BattleRecord initial = new BattleRecord(battleSite, currentPlayerAndAttacker, battleType, data);
        current.put(battleID, initial);
        this.m_records.put(currentPlayerAndAttacker, current);
    }

    public void addResultToBattle(PlayerID currentPlayer, GUID battleID, PlayerID defender, int attackerLostTUV, int defenderLostTUV, BattleRecord.BattleResultDescription battleResultDescription, BattleResults battleResults, int bombingDamage) {
        HashMap<GUID, BattleRecord> current = this.m_records.get(currentPlayer);
        if (current == null) {
            throw new IllegalStateException("Trying to add info to battle records that do not exist");
        }
        if (!current.containsKey(battleID)) {
            throw new IllegalStateException("Trying to add info to a battle that does not exist");
        }
        BattleRecord record = current.get(battleID);
        record.setResult(defender, attackerLostTUV, defenderLostTUV, battleResultDescription, battleResults, bombingDamage);
    }

    public void clear() {
        this.m_records.clear();
    }

    public boolean isEmpty() {
        return this.m_records.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (Map.Entry<PlayerID, HashMap<GUID, BattleRecord>> entry : this.m_records.entrySet()) {
            sb.append(", ");
            sb.append(entry.getKey().getName());
            sb.append("={");
            StringBuilder sb2 = new StringBuilder("");
            for (Map.Entry<GUID, BattleRecord> entry2 : entry.getValue().entrySet()) {
                sb2.append(", ");
                String guid = entry2.getKey().toString();
                sb2.append(guid.substring(Math.max(0, Math.min(guid.length(), 7 * guid.length() / 8)), guid.length()));
                sb2.append(":");
                sb2.append(entry2.getValue().toString());
            }
            sb.append(sb2.toString().replaceFirst(", ", ""));
            sb.append("}");
        }
        sb.append("]");
        return sb.toString().replaceFirst(", ", "");
    }
}

