/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.formatter;

import games.strategy.engine.data.DefaultNamed;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.formatter.UnitOwner;
import games.strategy.util.IntegerMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyFormatter {
    private static Map<String, String> s_plural = new HashMap<String, String>();

    public static String unitsToTextNoOwner(Collection<Unit> units) {
        return MyFormatter.unitsToTextNoOwner(units, null);
    }

    public static String unitsToTextNoOwner(Collection<Unit> units, PlayerID owner) {
        Iterator<Unit> iter = units.iterator();
        IntegerMap<UnitType> map = new IntegerMap<UnitType>();
        while (iter.hasNext()) {
            Unit unit = iter.next();
            if (unit == null || unit.getUnitType() == null) {
                throw new IllegalStateException("Trying to format a unit that does not exist.  If you are using Dynamix AI, then this is being caused by switching maps with the ai (it is still thinking about the last map's units).  Try restarting TripleA every time you switch maps and wish to play with Dynamix AI.");
            }
            if (owner != null && !owner.equals(unit.getOwner())) continue;
            map.add(unit.getUnitType(), 1);
        }
        StringBuilder buf = new StringBuilder();
        ArrayList sortedList = new ArrayList(map.keySet());
        Comparator<UnitType> comp = new Comparator<UnitType>(){

            @Override
            public int compare(UnitType u1, UnitType u2) {
                return u1.getName().compareTo(u2.getName());
            }
        };
        Collections.sort(sortedList, comp);
        Iterator typeIter = sortedList.iterator();
        int count = map.keySet().size();
        while (typeIter.hasNext()) {
            UnitType type = (UnitType)typeIter.next();
            int quantity = map.getInt(type);
            buf.append(quantity);
            buf.append(" ");
            buf.append(quantity > 1 ? MyFormatter.pluralize(type.getName()) : type.getName());
            if (--count > 1) {
                buf.append(", ");
            }
            if (count != 1) continue;
            buf.append(" and ");
        }
        return buf.toString();
    }

    public static String unitsToText(Collection<Unit> units) {
        Iterator<Unit> iter = units.iterator();
        IntegerMap<UnitOwner> map = new IntegerMap<UnitOwner>();
        while (iter.hasNext()) {
            Unit unit = iter.next();
            UnitOwner owner = new UnitOwner(unit.getType(), unit.getOwner());
            map.add(owner, 1);
        }
        StringBuilder buf = new StringBuilder();
        Iterator iter2 = map.keySet().iterator();
        int count = map.keySet().size();
        while (iter2.hasNext()) {
            UnitOwner owner = (UnitOwner)iter2.next();
            int quantity = map.getInt(owner);
            buf.append(quantity);
            buf.append(" ");
            buf.append(quantity > 1 ? MyFormatter.pluralize(owner.type.getName()) : owner.type.getName());
            buf.append(" owned by the ");
            buf.append(owner.owner.getName());
            if (--count > 1) {
                buf.append(" , ");
            }
            if (count != 1) continue;
            buf.append(" and ");
        }
        return buf.toString();
    }

    public static String territoriesToText(Collection<Territory> territories) {
        return MyFormatter.territoriesToText(territories, ",");
    }

    public static String territoriesToText(Collection<Territory> territories, String seperator) {
        Iterator<Territory> iter = territories.iterator();
        StringBuilder buffer = new StringBuilder();
        while (iter.hasNext()) {
            buffer.append(iter.next().getName());
            if (!iter.hasNext()) continue;
            buffer.append(" ").append(seperator).append(" ");
        }
        return buffer.toString();
    }

    public static String pluralize(String in, int quantity) {
        if (quantity == -1 || quantity == 1) {
            return in;
        }
        return MyFormatter.pluralize(in);
    }

    public static String attachmentNameToText(String attachmentGetName) {
        String toText = attachmentGetName;
        if (attachmentGetName.startsWith("relationshipTypeAttachment")) {
            toText = attachmentGetName.replaceFirst("relationshipTypeAttachment", "Relationship Type ");
        } else if (attachmentGetName.startsWith("techAttatchment")) {
            toText = attachmentGetName.replaceFirst("techAttatchment", "Player Techs ");
        } else if (attachmentGetName.startsWith("unitAttatchment")) {
            toText = attachmentGetName.replaceFirst("unitAttatchment", "Unit Type Properties ");
        } else if (attachmentGetName.startsWith("territoryAttatchment")) {
            toText = attachmentGetName.replaceFirst("territoryAttatchment", "Territory Properties ");
        } else if (attachmentGetName.startsWith("canalAttatchment")) {
            toText = attachmentGetName.replaceFirst("canalAttatchment", "Canal ");
        } else if (attachmentGetName.startsWith("territoryEffectAttachment")) {
            toText = attachmentGetName.replaceFirst("territoryEffectAttachment", "Territory Effect ");
        } else if (attachmentGetName.startsWith("supportAttachment")) {
            toText = attachmentGetName.replaceFirst("supportAttachment", "Support ");
        } else if (attachmentGetName.startsWith("objectiveAttachment")) {
            toText = attachmentGetName.replaceFirst("objectiveAttachment", "Objective ");
        } else if (attachmentGetName.startsWith("conditionAttachment")) {
            toText = attachmentGetName.replaceFirst("conditionAttachment", "Condition ");
        } else if (attachmentGetName.startsWith("triggerAttachment")) {
            toText = attachmentGetName.replaceFirst("triggerAttachment", "Trigger ");
        } else if (attachmentGetName.startsWith("rulesAttatchment")) {
            toText = attachmentGetName.replaceFirst("rulesAttatchment", "Rules ");
        } else if (attachmentGetName.startsWith("playerAttatchment")) {
            toText = attachmentGetName.replaceFirst("playerAttatchment", "Player Properties ");
        } else if (attachmentGetName.startsWith("politicalActionAttachment")) {
            toText = attachmentGetName.replaceFirst("politicalActionAttachment", "Political Action ");
        } else if (attachmentGetName.startsWith("techAbilityAttachment")) {
            toText = attachmentGetName.replaceFirst("techAbilityAttachment", "Tech Properties ");
        }
        toText = toText.replaceAll("_", " ");
        toText = toText.replaceAll("  ", " ");
        toText = toText.trim();
        return toText;
    }

    public static String listOfArraysToString(ArrayList<String[]> listOfArrays) {
        if (listOfArrays == null) {
            return "null";
        }
        String toText = "[";
        for (Object[] objectArray : listOfArrays) {
            toText = toText + Arrays.toString(objectArray);
            toText = toText + ",";
        }
        toText = toText + "]";
        return toText;
    }

    public static String defaultNamedToString(Collection<? extends DefaultNamed> list) {
        String toText = ", ";
        for (DefaultNamed defaultNamed : list) {
            toText = toText + defaultNamed.getName();
            toText = toText + ", ";
        }
        return toText.replaceFirst(", ", "");
    }

    public static String pluralize(String in) {
        if (s_plural.containsKey(in)) {
            return s_plural.get(in);
        }
        if (in.endsWith("man")) {
            return in.substring(0, in.lastIndexOf("man")) + "men";
        }
        return in + "s";
    }

    public static String asDice(DiceRoll roll) {
        if (roll == null || roll.size() == 0) {
            return "none";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < roll.size(); ++i) {
            buf.append(roll.getDie(i).getValue() + 1);
            if (i + 1 >= roll.size()) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    public static String asDice(int[] rolls) {
        if (rolls == null || rolls.length == 0) {
            return "none";
        }
        StringBuilder buf = new StringBuilder(rolls.length * 2);
        for (int i = 0; i < rolls.length; ++i) {
            buf.append(rolls[i] + 1);
            if (i + 1 >= rolls.length) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    public static String asList(Collection<? extends DefaultNamed> collection) {
        StringBuilder buf = new StringBuilder();
        for (DefaultNamed defaultNamed : collection) {
            buf.append(", ");
            buf.append(defaultNamed.getName());
        }
        return buf.toString().replaceFirst(", ", "");
    }

    public static String integerMapToString(IntegerMap<? extends DefaultNamed> map) {
        StringBuilder buf = new StringBuilder("");
        for (Map.Entry<? extends DefaultNamed, Integer> entry : map.entrySet()) {
            buf.append(", ");
            DefaultNamed current = entry.getKey();
            int val = entry.getValue();
            buf.append(current.getName()).append(" = ").append(val);
        }
        return buf.toString().replaceFirst(", ", "");
    }

    public static String integerUnitMapToString(IntegerMap<? extends Unit> map) {
        StringBuilder buf = new StringBuilder("");
        for (Map.Entry<? extends Unit, Integer> entry : map.entrySet()) {
            buf.append(", ");
            Unit current = entry.getKey();
            int val = entry.getValue();
            buf.append(current.getType().getName()).append(" = ").append(val);
        }
        return buf.toString().replaceFirst(", ", "");
    }

    private MyFormatter() {
    }

    static {
        s_plural.put("armour", "armour");
        s_plural.put("infantry", "infantry");
        s_plural.put("Infantry", "Infantry");
        s_plural.put("artillery", "artilleries");
        s_plural.put("factory", "factories");
    }
}

