/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.oddsCalculator.ta;

import games.strategy.engine.data.Unit;
import games.strategy.triplea.ai.Dynamix_AI.DUtils;
import games.strategy.triplea.oddsCalculator.ta.BattleResults;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateResults
implements Serializable {
    private static final long serialVersionUID = -556699626060414738L;
    public List<BattleResults> m_results;
    private long m_time;

    public AggregateResults(int expectedCount) {
        this.m_results = new ArrayList<BattleResults>(expectedCount);
    }

    public void addResult(BattleResults result) {
        this.m_results.add(result);
    }

    public double getAttackerWinPercent() {
        double count = 0.0;
        for (BattleResults result : this.m_results) {
            if (!result.attackerWon()) continue;
            count += 1.0;
        }
        return count / (double)this.m_results.size();
    }

    public BattleResults GetBattleResultsClosestToAverage() {
        float closestBattleDif = 2.1474836E9f;
        BattleResults closestBattle = null;
        for (BattleResults results : this.m_results) {
            float dif = DUtils.MNN((float)((double)results.getAttackingCombatUnitsLeft() - this.getAverageAttackingUnitsLeft()));
            if (!((dif += DUtils.MNN((float)((double)results.getDefendingCombatUnitsLeft() - this.getAverageDefendingUnitsLeft()))) < closestBattleDif)) continue;
            closestBattleDif = dif;
            closestBattle = results;
        }
        return closestBattle;
    }

    public List<Unit> GetAverageAttackingUnitsRemaining() {
        return this.GetBattleResultsClosestToAverage().getRemainingAttackingUnits();
    }

    public List<Unit> GetAverageDefendingUnitsRemaining() {
        return this.GetBattleResultsClosestToAverage().getRemainingDefendingUnits();
    }

    public double getAverageAttackingUnitsLeft() {
        double count = 0.0;
        for (BattleResults result : this.m_results) {
            count += (double)result.getAttackingCombatUnitsLeft();
        }
        return count / (double)this.m_results.size();
    }

    public double getAverageDefendingUnitsLeft() {
        double count = 0.0;
        for (BattleResults result : this.m_results) {
            count += (double)result.getDefendingCombatUnitsLeft();
        }
        return count / (double)this.m_results.size();
    }

    public double getDefenderWinPercent() {
        double count = 0.0;
        for (BattleResults result : this.m_results) {
            if (!result.defenderWon()) continue;
            count += 1.0;
        }
        return count / (double)this.m_results.size();
    }

    public double getAverageBattleRoundsFought() {
        double count = 0.0;
        for (BattleResults result : this.m_results) {
            count += (double)result.getBattleRoundsFought();
        }
        if (this.m_results.isEmpty() || count == 0.0) {
            return 1.0;
        }
        return count / (double)this.m_results.size();
    }

    public double getDrawPercent() {
        double count = 0.0;
        for (BattleResults result : this.m_results) {
            if (!result.draw()) continue;
            count += 1.0;
        }
        return count / (double)this.m_results.size();
    }

    public int getRollCount() {
        return this.m_results.size();
    }

    public long getTime() {
        return this.m_time;
    }

    public void setTime(long time) {
        this.m_time = time;
    }
}

