/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.oddsCalculator.ta;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.net.GUID;
import games.strategy.triplea.ai.AIUtils;
import games.strategy.triplea.ai.AbstractAI;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.dataObjects.CasualtyDetails;
import games.strategy.triplea.delegate.dataObjects.CasualtyList;
import games.strategy.triplea.delegate.remote.IAbstractPlaceDelegate;
import games.strategy.triplea.delegate.remote.IMoveDelegate;
import games.strategy.triplea.delegate.remote.IPurchaseDelegate;
import games.strategy.triplea.delegate.remote.ITechDelegate;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DummyPlayer
extends AbstractAI {
    private final boolean m_keepAtLeastOneLand;

    public DummyPlayer(String name, String type, boolean keepAtLeastOneLand) {
        super(name, type);
        this.m_keepAtLeastOneLand = keepAtLeastOneLand;
    }

    @Override
    protected void move(boolean nonCombat, IMoveDelegate moveDel, GameData data, PlayerID player) {
    }

    @Override
    protected void place(boolean placeForBid, IAbstractPlaceDelegate placeDelegate, GameData data, PlayerID player) {
    }

    @Override
    protected void purchase(boolean purcahseForBid, int PUsToSpend, IPurchaseDelegate purchaseDelegate, GameData data, PlayerID player) {
    }

    @Override
    protected void tech(ITechDelegate techDelegate, GameData data, PlayerID player) {
    }

    @Override
    public boolean confirmMoveInFaceOfAA(Collection<Territory> aaFiringTerritories) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Unit> getNumberOfFightersToMoveToNewCarrier(Collection<Unit> fightersThatCanBeMoved, Territory from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Territory retreatQuery(GUID battleID, boolean submerge, Collection<Territory> possibleTerritories, String message) {
        return null;
    }

    @Override
    public HashMap<Territory, Collection<Unit>> scrambleUnitsQuery(Territory scrambleTo, Map<Territory, Tuple<Collection<Unit>, Collection<Unit>>> possibleScramblers) {
        return null;
    }

    @Override
    public Collection<Unit> selectUnitsQuery(Territory current, Collection<Unit> possible, String message) {
        return null;
    }

    @Override
    public CasualtyDetails selectCasualties(Collection<Unit> selectFrom, Map<Unit, Collection<Unit>> dependents, int count, String message, DiceRoll dice, PlayerID hit, CasualtyList defaultCasualties, GUID battleID) {
        ArrayList<Unit> rDamaged = new ArrayList<Unit>();
        ArrayList<Unit> rKilled = new ArrayList<Unit>();
        rDamaged.addAll(defaultCasualties.getDamaged());
        rKilled.addAll(defaultCasualties.getKilled());
        if (this.m_keepAtLeastOneLand) {
            ArrayList<Unit> notKilled = new ArrayList<Unit>(selectFrom);
            notKilled.removeAll(rKilled);
            if (!Match.someMatch(notKilled, Matches.UnitIsLand) && Match.someMatch(notKilled, Matches.UnitIsNotLand) && Match.someMatch(rKilled, Matches.UnitIsLand)) {
                List<Unit> notKilledAndNotLand = Match.getMatches(notKilled, Matches.UnitIsNotLand);
                Collections.sort(notKilledAndNotLand, AIUtils.getCostComparator());
                rKilled.remove(rKilled.size() - 1);
                rKilled.add(notKilledAndNotLand.get(0));
            }
        }
        CasualtyDetails m2 = new CasualtyDetails(rKilled, rDamaged, false);
        return m2;
    }

    @Override
    public Territory selectTerritoryForAirToLand(Collection<Territory> candidates, Territory currentTerritory, String unitMessage) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean shouldBomberBomb(Territory territory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Unit whatShouldBomberBomb(Territory territory, Collection<Unit> potentialTargets, Collection<Unit> bombers) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] selectFixedDice(int numRolls, int hitAt, boolean hitOnlyIfEquals, String message, int diceSides) {
        int[] dice = new int[numRolls];
        for (int i = 0; i < numRolls; ++i) {
            dice[i] = (int)Math.ceil(Math.random() * (double)diceSides);
        }
        return dice;
    }
}

