/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.oddsCalculator.ta;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Territory;
import games.strategy.triplea.oddsCalculator.ta.OddsCalculatorPanel;
import games.strategy.triplea.ui.TripleAFrame;
import games.strategy.triplea.ui.UIContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

public class OddsCalculatorDialog
extends JDialog {
    private static final long serialVersionUID = -7625420355087851930L;
    private final OddsCalculatorPanel m_panel;

    public static void show(final TripleAFrame taFrame, Territory t) {
        final OddsCalculatorDialog dialog = new OddsCalculatorDialog(taFrame.getGame().getData(), taFrame.getUIContext(), taFrame, t);
        dialog.pack();
        int maxHeight = 600;
        if (dialog.getHeight() > 600) {
            dialog.setSize(new Dimension(dialog.getWidth(), 600));
        }
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                if (taFrame != null && taFrame.getUIContext() != null) {
                    taFrame.getUIContext().removeShutdownWindow(dialog);
                }
            }
        });
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        AbstractAction closeAction = new AbstractAction(){
            private static final long serialVersionUID = 8426179963957717432L;

            public void actionPerformed(ActionEvent arg0) {
                dialog.setVisible(false);
            }
        };
        String key = "odds.calc.invoke.close";
        dialog.getRootPane().getActionMap().put("odds.calc.invoke.close", closeAction);
        dialog.getRootPane().getInputMap(2).put(stroke, "odds.calc.invoke.close");
        dialog.setLocationRelativeTo(taFrame);
        dialog.setVisible(true);
        taFrame.getUIContext().addShutdownWindow(dialog);
    }

    OddsCalculatorDialog(GameData data, UIContext context, JFrame parent, Territory location) {
        super((Frame)parent, "Odds Calculator");
        this.m_panel = new OddsCalculatorPanel(data, context, location, this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.m_panel, "Center");
        this.pack();
    }

    public void show() {
        super.show();
        this.m_panel.selectCalculateButton();
    }
}

