/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.oddsCalculator.zengland;

import games.strategy.triplea.oddsCalculator.zengland.OCBattle;
import games.strategy.triplea.oddsCalculator.zengland.OCUnit;
import games.strategy.triplea.oddsCalculator.zengland.UnitGroup;
import games.strategy.triplea.oddsCalculator.zengland.UnitGroupPanel;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BoxLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RollerApplet
extends Applet
implements Runnable,
ItemListener,
KeyListener,
ActionListener {
    private static final long serialVersionUID = -6537455000443362041L;
    private static String WW2V1 = "World War 2 Version 1";
    private static String WW2V2 = "World War 2 Version 2";
    private static String landBattle = "Land Zone";
    private static String seaBattle = "Sea Zone";
    private boolean reset = false;
    private String currentGameType = WW2V1;
    private Panel unitsPanel = null;
    private Panel optionsPanel = null;
    private Vector<Panel> unitGroupPanels = new Vector();
    private Vector<String> ool = null;
    private Thread battleThread = null;
    private OCBattle b = null;
    private int battles = 0;
    private float controlPercent = 0.0f;
    private int controleds = 0;
    private float airWinPercent = 0.0f;
    private int airWins = 0;
    private float clearedPercent = 0.0f;
    private int cleareds = 0;
    private float indecisivePercent = 0.0f;
    private int indecisives = 0;
    private float lossPercent = 0.0f;
    private int losses = 0;
    private Label controlPercentLabel;
    private Label airWinPercentLabel;
    private Label clearedPercentLabel;
    private Label indecisivePercentLabel;
    private Label lossPercentLabel;
    private TextField rounds;
    private Checkbox conL;
    private Checkbox hasAA;
    private Choice battleType;
    private Checkbox oolCheckbox;
    private Checkbox rollRounds;
    private Label battlesLabel;
    private Hashtable<String, Integer> totRemAtt;
    private Hashtable<String, Integer> totRemDef;
    private static String sSubsLabel = "Super Subs";
    private static String jetPLabel = "Jet Power";
    private static String hBLabel = "Heavy Bobmers";
    private static String cBLabel = "Combined Bombardment";
    private final Vector<Button> buttonsToProc = new Vector();
    private final Vector<UnitGroupPanel> ugpsToProc = new Vector();
    private final Vector<ItemSelectable> selectables = new Vector();
    private boolean clearButton;

    @Override
    public void init() {
        this.setSize(850, 550);
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout(10, 10));
        this.unitsPanel = this.createUnitsPanel(this.currentGameType);
        this.add((Component)this.unitsPanel, "West");
        this.optionsPanel = this.createOptionsPanel();
        this.add((Component)this.optionsPanel, "East");
    }

    @Override
    public void run() {
        Thread myThread = Thread.currentThread();
        while (this.battleThread == myThread) {
            if (!this.reset) {
                this.resetBattle();
                if (this.b.getNumberOfUnits(this.b.getAttackers()) != 0 && this.b.getNumberOfUnits(this.b.getDefenders()) != 0) {
                    this.b.rollBattle();
                    this.updateBattleStats();
                } else {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this.clearButton && this.buttonsToProc.size() <= 0 && this.ugpsToProc.size() <= 0 && this.selectables.size() <= 0) continue;
                this.setReset(true);
                continue;
            }
            this.processActions();
            this.resetBattle();
            this.resetStats();
            this.setReset(false);
        }
    }

    private void processActions() {
        int bSize = this.buttonsToProc.size();
        int ugpsSize = this.ugpsToProc.size();
        if (bSize != 0 && ugpsSize != 0) {
            for (int i = bSize - 1; i >= 0; --i) {
                Button b = this.buttonsToProc.elementAt(i);
                UnitGroupPanel ugp = this.ugpsToProc.elementAt(i);
                String bName = b.getName();
                int bValue = Integer.valueOf(b.getLabel());
                if (bName.startsWith("att")) {
                    if (bValue == 0) {
                        ugp.getAttUnitGroup().setNumUnits(bValue);
                        ugp.setRemAtt(bValue);
                    } else {
                        ugp.getAttUnitGroup().setNumUnits(ugp.getAttUnitGroup().getNumUnits() + bValue);
                    }
                    ugp.totalAttackers.setText(String.valueOf(ugp.getAttUnitGroup().getNumUnits()));
                } else if (bName.startsWith("def")) {
                    if (bValue == 0) {
                        ugp.getDefUnitGroup().setNumUnits(bValue);
                        ugp.setRemDef(bValue);
                    } else {
                        ugp.getDefUnitGroup().setNumUnits(ugp.getDefUnitGroup().getNumUnits() + bValue);
                    }
                    ugp.totalDefenders.setText(String.valueOf(ugp.getDefUnitGroup().getNumUnits()));
                }
                this.buttonsToProc.removeElementAt(i);
                this.ugpsToProc.removeElementAt(i);
            }
        }
        int selSize = this.selectables.size();
        for (int i = selSize - 1; i >= 0; --i) {
            Component c;
            ItemSelectable item = this.selectables.elementAt(i);
            if (item instanceof Choice) {
                c = (Choice)item;
                String cName = c.getName();
                String sel = ((Choice)c).getSelectedItem();
                if (cName.equals("gameChoice")) {
                    if (!sel.equals(this.currentGameType)) {
                        this.currentGameType = sel;
                        this.remove(this.unitsPanel);
                        this.unitsPanel = this.createUnitsPanel(sel);
                        this.add((Component)this.unitsPanel, "West");
                        this.validate();
                        this.resetStats();
                        this.resetBattle();
                    }
                } else if (cName.equals("battleType")) {
                    this.resetStats();
                }
            } else if (item instanceof Checkbox) {
                c = (Checkbox)item;
                String sel = ((Checkbox)c).getLabel();
                boolean selected = ((Checkbox)c).getState();
                if (sel.equals(sSubsLabel)) {
                    this.setSuperSubs(selected);
                } else if (sel.equals(hBLabel)) {
                    this.setHeavyBombers(selected);
                } else if (sel.equals(cBLabel)) {
                    this.setCombinedBombardment(selected);
                } else if (sel.equals(jetPLabel)) {
                    this.setJetPower(selected);
                }
                this.resetStats();
            }
            this.selectables.removeElementAt(i);
        }
        if (this.clearButton) {
            int size = this.unitGroupPanels.size();
            for (int i = 0; i < size; ++i) {
                Panel p = this.unitGroupPanels.elementAt(i);
                UnitGroupPanel ugp = (UnitGroupPanel)p.getComponent(0);
                ugp.totalAttackers.setText("0");
                ugp.totalDefenders.setText("0");
                ugp.getAttUnitGroup().setNumUnits(0);
                ugp.getDefUnitGroup().setNumUnits(0);
                ugp.setRemAtt(0);
                ugp.setRemDef(0);
                this.resetStats();
            }
            this.clearButton = false;
        }
    }

    private void updateBattleStats() {
        ++this.battles;
        if (this.b.getResultStatus() == 3) {
            ++this.cleareds;
        } else if (this.b.getResultStatus() == 1) {
            ++this.controleds;
        } else if (this.b.getResultStatus() == 2) {
            ++this.losses;
        } else if (this.b.getResultStatus() == 4) {
            ++this.indecisives;
        } else if (this.b.getResultStatus() == 5) {
            ++this.airWins;
        }
        this.controlPercent = (float)this.controleds / (float)this.battles * 100.0f;
        this.airWinPercent = (float)this.airWins / (float)this.battles * 100.0f;
        this.clearedPercent = (float)this.cleareds / (float)this.battles * 100.0f;
        this.indecisivePercent = (float)this.indecisives / (float)this.battles * 100.0f;
        this.lossPercent = (float)this.losses / (float)this.battles * 100.0f;
        this.controlPercentLabel.setText(this.formattedPercent(this.controlPercent));
        this.airWinPercentLabel.setText(this.formattedPercent(this.airWinPercent));
        this.clearedPercentLabel.setText(this.formattedPercent(this.clearedPercent));
        this.indecisivePercentLabel.setText(this.formattedPercent(this.indecisivePercent));
        this.lossPercentLabel.setText(this.formattedPercent(this.lossPercent));
        this.battlesLabel.setText(String.valueOf(this.battles));
        Vector<UnitGroup> atts = this.b.getAttackers();
        int attSize = atts.size();
        for (int i = 0; i < attSize; ++i) {
            UnitGroup curG = atts.elementAt(i);
            String name = curG.getUnit().getName();
            Integer totAtt = this.totRemAtt.get(name);
            this.totRemAtt.remove(name);
            int newTot = 0;
            newTot = totAtt + curG.getNumUnits();
            this.totRemAtt.put(name, newTot);
        }
        int size = this.unitGroupPanels.size();
        for (int j = 0; j < size; ++j) {
            Panel p = this.unitGroupPanels.elementAt(j);
            UnitGroupPanel ugp = (UnitGroupPanel)p.getComponent(0);
            int avgTot = 0;
            if (this.battles > 0) {
                avgTot = Math.round((float)this.totRemAtt.get(ugp.getAttUnitGroup().getUnit().getName()).intValue() / (float)this.battles);
            }
            if (this.lossPercent < 50.0f) {
                ugp.setRemAtt(avgTot);
                continue;
            }
            ugp.setRemAtt(0);
        }
        Vector<UnitGroup> defs = this.b.getDefenders();
        int defSize = defs.size();
        for (int i = 0; i < defSize; ++i) {
            UnitGroup curG = defs.elementAt(i);
            String name = curG.getUnit().getName();
            Integer totDef = this.totRemDef.get(name);
            this.totRemDef.remove(name);
            int newTot = 0;
            newTot = totDef + curG.getNumUnits();
            this.totRemDef.put(name, newTot);
        }
        int defPSize = this.unitGroupPanels.size();
        for (int j = 0; j < defPSize; ++j) {
            Panel p = this.unitGroupPanels.elementAt(j);
            UnitGroupPanel ugp = (UnitGroupPanel)p.getComponent(0);
            int avgTot = 0;
            if (this.battles > 0) {
                avgTot = Math.round((float)this.totRemDef.get(ugp.getDefUnitGroup().getUnit().getName()).intValue() / (float)this.battles);
            }
            if (this.lossPercent > 50.0f) {
                ugp.setRemDef(avgTot);
                continue;
            }
            ugp.setRemDef(0);
        }
    }

    @Override
    public void start() {
        if (this.battleThread == null) {
            this.battleThread = new Thread((Runnable)this, "Battle");
            this.battleThread.start();
        }
    }

    @Override
    public void stop() {
        this.reset = true;
    }

    public Panel createUnitGroupPanel(OCUnit u) {
        Panel p = new Panel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new UnitGroupPanel(u));
        return p;
    }

    public Panel createUnitsPanel(String gameType) {
        Panel unitsPanel = new Panel();
        unitsPanel.setLayout(new BoxLayout(unitsPanel, 1));
        Panel topPanel = new Panel();
        topPanel.setLayout(new GridLayout(1, 4));
        topPanel.add(new Label("Attackers"));
        Button clearButton = new Button("Clear");
        clearButton.setName("Clear");
        clearButton.addActionListener(this);
        topPanel.add(clearButton);
        topPanel.add(new Label());
        topPanel.add(new Label("Defense"));
        unitsPanel.add(topPanel);
        this.unitGroupPanels = new Vector();
        this.totRemAtt = new Hashtable();
        this.totRemDef = new Hashtable();
        if (gameType.equals(WW2V1)) {
            this.unitGroupPanels.addElement(this.createUnitGroupPanel(OCUnit.newInf()));
            this.totRemAtt.put("Infantry", 0);
            this.totRemDef.put("Infantry", 0);
            this.unitGroupPanels.addElement(this.createUnitGroupPanel(OCUnit.newArm()));
            this.totRemAtt.put("Armor", 0);
            this.totRemDef.put("Armor", 0);
            this.unitGroupPanels.addElement(this.createUnitGroupPanel(OCUnit.newBomber()));
            this.totRemAtt.put("Bomber", 0);
            this.totRemDef.put("Bomber", 0);
            this.unitGroupPanels.addElement(this.createUnitGroupPanel(OCUnit.newFighter()));
            this.totRemAtt.put("Fighter", 0);
            this.totRemDef.put("Fighter", 0);
            this.unitGroupPanels.addElement(this.createUnitGroupPanel(OCUnit.newAC()));
            this.totRemAtt.put("Aircraft Carrier", 0);
            this.totRemDef.put("Aircraft Carrier", 0);
            this.unitGroupPanels.addElement(this.createUnitGroupPanel(OCUnit.newSub()));
            this.totRemAtt.put("Submarine", 0);
            this.totRemDef.put("Submarine", 0);
            this.unitGroupPanels.addElement(this.createUnitGroupPanel(OCUnit.newTrn()));
            this.totRemAtt.put("Transport", 0);
            this.totRemDef.put("Transport", 0);
            this.unitGroupPanels.addElement(this.createUnitGroupPanel(OCUnit.newBB()));
            this.totRemAtt.put("BattleShip", 0);
            this.totRemDef.put("BattleShip", 0);
        } else if (gameType.equals(WW2V2)) {
            this.unitGroupPanels.addElement(this.createUnitGroupPanel(OCUnit.newInf()));
            this.totRemAtt.put("Infantry", 0);
            this.totRemDef.put("Infantry", 0);
            this.unitGroupPanels.addElement(this.createUnitGroupPanel(OCUnit.newArm()));
            this.totRemAtt.put("Armor", 0);
            this.totRemDef.put("Armor", 0);
            this.unitGroupPanels.addElement(this.createUnitGroupPanel(OCUnit.newRtl()));
            this.totRemAtt.put("Artillery", 0);
            this.totRemDef.put("Artillery", 0);
            this.unitGroupPanels.addElement(this.createUnitGroupPanel(OCUnit.newBomber()));
            this.totRemAtt.put("Bomber", 0);
            this.totRemDef.put("Bomber", 0);
            this.unitGroupPanels.addElement(this.createUnitGroupPanel(OCUnit.newFighter()));
            this.totRemAtt.put("Fighter", 0);
            this.totRemDef.put("Fighter", 0);
            this.unitGroupPanels.addElement(this.createUnitGroupPanel(OCUnit.newAC()));
            this.totRemAtt.put("Aircraft Carrier", 0);
            this.totRemDef.put("Aircraft Carrier", 0);
            this.unitGroupPanels.addElement(this.createUnitGroupPanel(OCUnit.newSub()));
            this.totRemAtt.put("Submarine", 0);
            this.totRemDef.put("Submarine", 0);
            this.unitGroupPanels.addElement(this.createUnitGroupPanel(OCUnit.newTrn()));
            this.totRemAtt.put("Transport", 0);
            this.totRemDef.put("Transport", 0);
            this.unitGroupPanels.addElement(this.createUnitGroupPanel(OCUnit.newBB()));
            this.totRemAtt.put("BattleShip", 0);
            this.totRemDef.put("BattleShip", 0);
            this.unitGroupPanels.addElement(this.createUnitGroupPanel(OCUnit.newDestroyer()));
            this.totRemAtt.put("Destroyer", 0);
            this.totRemDef.put("Destroyer", 0);
        }
        int size = this.unitGroupPanels.size();
        for (int i = 0; i < size; ++i) {
            unitsPanel.add(this.unitGroupPanels.elementAt(i));
        }
        return unitsPanel;
    }

    public Panel createOptionsPanel() {
        Panel optionsPanel = new Panel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        Panel gamePanel = new Panel();
        gamePanel.setLayout(new GridLayout(2, 1));
        Label gameLabel = new Label("Game type");
        gamePanel.add(gameLabel);
        Choice gameChoice = new Choice();
        gameChoice.add(WW2V1);
        gameChoice.add(WW2V2);
        gameChoice.addItemListener(this);
        gameChoice.setName("gameChoice");
        gamePanel.add(gameChoice);
        Panel techPanel = new Panel();
        techPanel.setLayout(new GridLayout(6, 1));
        techPanel.add(new Label("Techs"));
        Checkbox sSubs = new Checkbox(sSubsLabel);
        sSubs.addItemListener(this);
        Checkbox jetP = new Checkbox(jetPLabel);
        jetP.addItemListener(this);
        Checkbox hBmbs = new Checkbox(hBLabel);
        hBmbs.addItemListener(this);
        Checkbox comB = new Checkbox(cBLabel);
        comB.addItemListener(this);
        techPanel.add(sSubs);
        techPanel.add(hBmbs);
        techPanel.add(comB);
        techPanel.add(jetP);
        Panel battleInfoPanel = new Panel();
        battleInfoPanel.setLayout(new GridLayout(7, 1));
        battleInfoPanel.add(new Label("Battle options"));
        this.battleType = new Choice();
        this.battleType.add(landBattle);
        this.battleType.add(seaBattle);
        this.battleType.addItemListener(this);
        this.battleType.setName("battleType");
        battleInfoPanel.add(this.battleType);
        this.conL = new Checkbox("Conserve one land");
        this.conL.addItemListener(this);
        battleInfoPanel.add(this.conL);
        this.hasAA = new Checkbox("Anti-Air present");
        this.hasAA.addItemListener(this);
        battleInfoPanel.add(this.hasAA);
        this.oolCheckbox = new Checkbox("Use Custom OOL");
        this.oolCheckbox.addItemListener(this);
        battleInfoPanel.add(this.oolCheckbox);
        this.rollRounds = new Checkbox("Roll rounds");
        this.rollRounds.addItemListener(this);
        battleInfoPanel.add(this.rollRounds);
        this.rounds = new TextField("1");
        this.rounds.addKeyListener(this);
        battleInfoPanel.add(this.rounds);
        Panel resultsPanel = new Panel();
        resultsPanel.setLayout(new GridLayout(6, 2));
        Label controlLabel = new Label("Control");
        resultsPanel.add(controlLabel);
        this.controlPercentLabel = new Label(this.formattedPercent(this.controlPercent));
        resultsPanel.add(this.controlPercentLabel);
        Label airLabel = new Label("Air win");
        resultsPanel.add(airLabel);
        this.airWinPercentLabel = new Label(this.formattedPercent(this.airWinPercent));
        resultsPanel.add(this.airWinPercentLabel);
        Label clearedLabel = new Label("Cleared");
        resultsPanel.add(clearedLabel);
        this.clearedPercentLabel = new Label(this.formattedPercent(this.clearedPercent));
        resultsPanel.add(this.clearedPercentLabel);
        Label indecisiveLabel = new Label("Indecisive");
        resultsPanel.add(indecisiveLabel);
        this.indecisivePercentLabel = new Label(this.formattedPercent(this.indecisivePercent));
        resultsPanel.add(this.indecisivePercentLabel);
        Label lossLabel = new Label("Loss");
        resultsPanel.add(lossLabel);
        this.lossPercentLabel = new Label(this.formattedPercent(this.lossPercent));
        resultsPanel.add(this.lossPercentLabel);
        Label battlesTitleLabel = new Label("Battles rolled");
        resultsPanel.add(battlesTitleLabel);
        this.battlesLabel = new Label(String.valueOf(this.battles));
        resultsPanel.add(this.battlesLabel);
        optionsPanel.add(gamePanel);
        optionsPanel.add(techPanel);
        optionsPanel.add(battleInfoPanel);
        optionsPanel.add(resultsPanel);
        return optionsPanel;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable item = e.getItemSelectable();
        this.selectables.add(item);
        this.setReset(true);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void setJetPower(boolean state) {
        int size = this.unitGroupPanels.size();
        int change = 1;
        change = state ? 1 : -1;
        for (int i = 0; i < size; ++i) {
            Panel p = this.unitGroupPanels.elementAt(i);
            UnitGroupPanel ugp = (UnitGroupPanel)p.getComponent(0);
            UnitGroup ug = ugp.getAttUnitGroup();
            OCUnit cur = ug.getUnit();
            if (!cur.getName().equals("Fighter")) continue;
            cur.setDefendValue(cur.getDefendValue() + change);
        }
    }

    private void setCombinedBombardment(boolean state) {
        int size = this.unitGroupPanels.size();
        for (int i = 0; i < size; ++i) {
            Panel p = this.unitGroupPanels.elementAt(i);
            UnitGroupPanel ugp = (UnitGroupPanel)p.getComponent(0);
            UnitGroup ug = ugp.getAttUnitGroup();
            OCUnit cur = ug.getUnit();
            if (!cur.getName().equals("Destroyer")) continue;
            cur.setSupportShot(state);
        }
    }

    private void setHeavyBombers(boolean state) {
        int size = this.unitGroupPanels.size();
        for (int i = 0; i < size; ++i) {
            Panel p = this.unitGroupPanels.elementAt(i);
            UnitGroupPanel ugp = (UnitGroupPanel)p.getComponent(0);
            UnitGroup ug = ugp.getAttUnitGroup();
            OCUnit cur = ug.getUnit();
            if (!cur.getName().equals("Bomber")) continue;
            if (state) {
                if (this.currentGameType.equals(WW2V2)) {
                    cur.setMaxRolls(2);
                    continue;
                }
                cur.setMaxHits(3);
                continue;
            }
            if (this.currentGameType.equals(WW2V2)) {
                cur.setMaxRolls(1);
                continue;
            }
            cur.setMaxHits(1);
        }
    }

    private void setSuperSubs(boolean state) {
        int size = this.unitGroupPanels.size();
        int change = 1;
        change = state ? 1 : -1;
        for (int i = 0; i < size; ++i) {
            Panel p = this.unitGroupPanels.elementAt(i);
            UnitGroupPanel ugp = (UnitGroupPanel)p.getComponent(0);
            UnitGroup ug = ugp.getAttUnitGroup();
            OCUnit cur = ug.getUnit();
            if (!cur.getName().equals("Submarine")) continue;
            cur.setAttackValue(cur.getAttackValue() + change);
        }
    }

    public void resetStats() {
        this.reset = true;
        this.battles = 0;
        this.controleds = 0;
        this.airWins = 0;
        this.cleareds = 0;
        this.indecisives = 0;
        this.losses = 0;
        this.controlPercent = 0.0f;
        this.airWinPercent = 0.0f;
        this.clearedPercent = 0.0f;
        this.indecisivePercent = 0.0f;
        this.lossPercent = 0.0f;
        this.reset = false;
        this.controlPercentLabel.setText(this.formattedPercent(this.controlPercent));
        this.airWinPercentLabel.setText(this.formattedPercent(this.airWinPercent));
        this.clearedPercentLabel.setText(this.formattedPercent(this.clearedPercent));
        this.indecisivePercentLabel.setText(this.formattedPercent(this.indecisivePercent));
        this.lossPercentLabel.setText(this.formattedPercent(this.lossPercent));
        this.battlesLabel.setText(String.valueOf(this.battles));
        Enumeration<String> atts = this.totRemAtt.keys();
        while (atts.hasMoreElements()) {
            String name = atts.nextElement();
            this.totRemAtt.remove(name);
            this.totRemAtt.put(name, new Integer(0));
        }
        Enumeration<String> defs = this.totRemDef.keys();
        while (defs.hasMoreElements()) {
            String name = defs.nextElement();
            this.totRemDef.remove(name);
            this.totRemDef.put(name, new Integer(0));
        }
    }

    public void resetBattle() {
        this.reset = true;
        Vector<UnitGroup> attackers = null;
        Vector<UnitGroup> defenders = null;
        attackers = this.processAttUnitGroups();
        defenders = this.processDefUnitGroups();
        int roundCount = 0;
        String roundsText = this.rounds.getText();
        try {
            roundCount = Integer.parseInt(roundsText);
        }
        catch (NumberFormatException nfe) {
            roundCount = 0;
        }
        if (!this.rollRounds.getState()) {
            roundCount = 0;
        }
        boolean landB = true;
        landB = this.battleType.getSelectedItem().equals(landBattle);
        boolean rollAASep = false;
        if (this.currentGameType.equals(WW2V2)) {
            rollAASep = true;
        }
        this.resetOOL();
        this.b = new OCBattle(attackers, defenders, roundCount, this.conL.getState(), this.hasAA.getState(), landB, rollAASep, false, this.ool);
        this.reset = false;
    }

    private void resetOOL() {
        this.ool = null;
    }

    private Vector<UnitGroup> processDefUnitGroups() {
        Vector<UnitGroup> defenders = new Vector<UnitGroup>();
        int size = this.unitGroupPanels.size();
        for (int i = 0; i < size; ++i) {
            Panel p = this.unitGroupPanels.elementAt(i);
            UnitGroupPanel ugp = (UnitGroupPanel)p.getComponent(0);
            UnitGroup ug = ugp.getDefUnitGroup();
            defenders.addElement((UnitGroup)ug.clone());
        }
        return defenders;
    }

    private Vector<UnitGroup> processAttUnitGroups() {
        Vector<UnitGroup> attackers = new Vector<UnitGroup>();
        int size = this.unitGroupPanels.size();
        for (int i = 0; i < size; ++i) {
            Panel p = this.unitGroupPanels.elementAt(i);
            UnitGroupPanel ugp = (UnitGroupPanel)p.getComponent(0);
            UnitGroup ug = ugp.getAttUnitGroup();
            attackers.addElement((UnitGroup)ug.clone());
        }
        return attackers;
    }

    public String formattedPercent(float per) {
        BigDecimal bd = new BigDecimal(per);
        String res = bd.toString();
        int endSpace = 0;
        endSpace = res.indexOf(".") + 3 >= res.length() || res.indexOf(".") == -1 ? res.length() : res.indexOf(".") + 3;
        if ((res = res.substring(0, endSpace)).indexOf(".") == -1) {
            res = res + ".00";
        }
        res = res + "%";
        return res;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o instanceof Button && ((Button)o).getName().equals("Clear")) {
            this.clearButton = true;
            this.setReset(true);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean isReset() {
        return this.reset;
    }

    public void setReset(boolean reset) {
        this.reset = reset;
    }

    public void processUGPButton(UnitGroupPanel panel, Button button) {
        this.buttonsToProc.add(button);
        this.ugpsToProc.add(panel);
    }
}

