/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.printgenerator;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.UnitCollection;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.printgenerator.PrintGenerationData;
import games.strategy.util.Match;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class CountryChart {
    private Collection<Territory> m_terrCollection;
    private GameData m_data;
    private Iterator<Territory> m_terrIterator;
    private final Map<Territory, List<Map<UnitType, Integer>>> m_infoMap = new HashMap<Territory, List<Map<UnitType, Integer>>>();
    private PrintGenerationData m_printData;

    CountryChart() {
    }

    protected void saveToFile(PlayerID player, PrintGenerationData printData) {
        this.m_data = printData.getData();
        this.m_printData = printData;
        this.m_terrCollection = Match.getMatches(this.m_data.getMap().getTerritories(), Matches.territoryHasUnitsOwnedBy(player));
        this.m_terrIterator = this.m_terrCollection.iterator();
        Iterator<UnitType> availableUnits = this.m_data.getUnitTypeList().iterator();
        while (this.m_terrIterator.hasNext()) {
            Territory currentTerritory = this.m_terrIterator.next();
            UnitCollection unitsHere = currentTerritory.getUnits();
            ArrayList unitPairs = new ArrayList();
            while (availableUnits.hasNext()) {
                UnitType currentUnit = availableUnits.next();
                Integer amountHere = unitsHere.getUnitCount(currentUnit, player);
                HashMap<UnitType, Integer> innerMap = new HashMap<UnitType, Integer>();
                innerMap.put(currentUnit, amountHere);
                unitPairs.add(innerMap);
            }
            this.m_infoMap.put(currentTerritory, unitPairs);
            availableUnits = this.m_data.getUnitTypeList().iterator();
        }
        FileWriter countryFileWriter = null;
        try {
            int i;
            File outFile = new File(this.m_printData.getOutDir(), player.getName() + ".csv");
            countryFileWriter = new FileWriter(outFile, true);
            int numUnits = this.m_data.getUnitTypeList().size();
            for (i = 0; i < numUnits / 2 - 1 + numUnits % 2; ++i) {
                countryFileWriter.write(",");
            }
            countryFileWriter.write("Setup Chart for the " + player.getName());
            for (i = 0; i < numUnits / 2 - numUnits % 2; ++i) {
                countryFileWriter.write(",");
            }
            countryFileWriter.write("\r\n");
            Iterator<UnitType> unitIterator = this.m_data.getUnitTypeList().iterator();
            countryFileWriter.write(",");
            while (unitIterator.hasNext()) {
                UnitType currentType = unitIterator.next();
                countryFileWriter.write(currentType.getName() + ",");
            }
            countryFileWriter.write("\r\n");
            for (Territory currentTerritory : Match.getMatches(this.m_data.getMap().getTerritories(), Matches.territoryHasUnitsOwnedBy(player))) {
                countryFileWriter.write(currentTerritory.getName());
                List<Map<UnitType, Integer>> currentList = this.m_infoMap.get(currentTerritory);
                for (Map<UnitType, Integer> currentMap : currentList) {
                    for (UnitType uHere : currentMap.keySet()) {
                        Integer here = currentMap.get(uHere);
                        countryFileWriter.write("," + here);
                    }
                }
                countryFileWriter.write("\r\n");
            }
            countryFileWriter.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

