/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.printgenerator;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.history.HistoryNode;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.printgenerator.CountryChart;
import games.strategy.triplea.printgenerator.PUChart;
import games.strategy.triplea.printgenerator.PUInfo;
import games.strategy.triplea.printgenerator.PlayerOrder;
import games.strategy.triplea.printgenerator.PrintGenerationData;
import games.strategy.triplea.printgenerator.UnitInformation;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class InitialSetup {
    private Iterator<UnitType> m_unitTypeIterator;
    private Iterator<PlayerID> m_playerIterator;
    private final Map<UnitType, UnitAttachment> m_unitInfoMap = new HashMap<UnitType, UnitAttachment>();
    private GameData m_data;
    private PrintGenerationData m_printData;

    protected InitialSetup() {
    }

    protected void run(PrintGenerationData printData, boolean useOriginalState) {
        this.m_data = printData.getData();
        this.m_printData = printData;
        if (useOriginalState) {
            HistoryNode root = (HistoryNode)this.m_data.getHistory().getRoot();
            this.m_data.getHistory().gotoNode(root);
        }
        for (UnitType currentType : this.m_data.getUnitTypeList()) {
            UnitAttachment currentTypeUnitAttachment = UnitAttachment.get(currentType);
            this.m_unitInfoMap.put(currentType, currentTypeUnitAttachment);
        }
        new UnitInformation().saveToFile(this.m_printData, this.m_unitInfoMap);
        for (PlayerID currentPlayer : this.m_data.getPlayerList()) {
            new CountryChart().saveToFile(currentPlayer, this.m_printData);
        }
        new PUInfo().saveToFile(this.m_printData);
        try {
            new PlayerOrder().saveToFile(this.m_printData);
            new PUChart(this.m_printData).saveToFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

