/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.RepairRule;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.gamePlayer.IPlayerBridge;
import games.strategy.triplea.attatchments.PoliticalActionAttachment;
import games.strategy.triplea.delegate.AbstractMoveDelegate;
import games.strategy.triplea.delegate.dataObjects.FightBattleDetails;
import games.strategy.triplea.delegate.dataObjects.MoveDescription;
import games.strategy.triplea.delegate.dataObjects.TechRoll;
import games.strategy.triplea.delegate.remote.IPoliticsDelegate;
import games.strategy.triplea.ui.AbstractMovePanel;
import games.strategy.triplea.ui.ActionPanel;
import games.strategy.triplea.ui.Active;
import games.strategy.triplea.ui.BattlePanel;
import games.strategy.triplea.ui.EndTurnPanel;
import games.strategy.triplea.ui.MapPanel;
import games.strategy.triplea.ui.MovePanel;
import games.strategy.triplea.ui.PlaceData;
import games.strategy.triplea.ui.PlacePanel;
import games.strategy.triplea.ui.PoliticsPanel;
import games.strategy.triplea.ui.PurchasePanel;
import games.strategy.triplea.ui.RepairPanel;
import games.strategy.triplea.ui.TechPanel;
import games.strategy.triplea.ui.TripleAFrame;
import games.strategy.util.IntegerMap;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionButtons
extends JPanel {
    private static final long serialVersionUID = 2175685892863042399L;
    private final CardLayout m_layout = new CardLayout();
    private BattlePanel m_battlePanel;
    private MovePanel m_movePanel;
    private PurchasePanel m_purchasePanel;
    private RepairPanel m_repairPanel;
    private PlacePanel m_placePanel;
    private TechPanel m_techPanel;
    private EndTurnPanel m_endTurnPanel;
    private ActionPanel m_current;
    private PoliticsPanel m_politicsPanel;

    public ActionButtons(GameData data, MapPanel map, TripleAFrame parent) {
        this.m_battlePanel = new BattlePanel(data, map);
        this.m_movePanel = new MovePanel(data, map, parent);
        this.m_purchasePanel = new PurchasePanel(data, map);
        this.m_repairPanel = new RepairPanel(data, map);
        this.m_placePanel = new PlacePanel(data, map, parent);
        this.m_techPanel = new TechPanel(data, map);
        this.m_endTurnPanel = new EndTurnPanel(data, map);
        this.m_politicsPanel = new PoliticsPanel(data, map, parent);
        this.m_current = this.m_techPanel;
        this.setLayout(this.m_layout);
        this.add((Component)new JLabel(""), "");
        this.add((Component)this.m_battlePanel, this.m_battlePanel.toString());
        this.add((Component)this.m_movePanel, this.m_movePanel.toString());
        this.add((Component)this.m_repairPanel, this.m_repairPanel.toString());
        this.add((Component)this.m_purchasePanel, this.m_purchasePanel.toString());
        this.add((Component)this.m_placePanel, this.m_placePanel.toString());
        this.add((Component)this.m_techPanel, this.m_techPanel.toString());
        this.add((Component)this.m_endTurnPanel, this.m_endTurnPanel.toString());
        this.add((Component)this.m_politicsPanel, this.m_politicsPanel.toString());
        map.getUIContext().addActive(new Active(){

            public void deactivate() {
                ActionButtons.this.removeAll();
                ActionButtons.this.m_current = null;
                ActionButtons.this.m_battlePanel.removeAll();
                ActionButtons.this.m_movePanel.removeAll();
                ActionButtons.this.m_repairPanel.removeAll();
                ActionButtons.this.m_purchasePanel.removeAll();
                ActionButtons.this.m_placePanel.removeAll();
                ActionButtons.this.m_techPanel.removeAll();
                ActionButtons.this.m_endTurnPanel.removeAll();
                ActionButtons.this.m_politicsPanel.removeAll();
                ActionButtons.this.m_battlePanel = null;
                ActionButtons.this.m_movePanel = null;
                ActionButtons.this.m_repairPanel = null;
                ActionButtons.this.m_purchasePanel = null;
                ActionButtons.this.m_placePanel = null;
                ActionButtons.this.m_techPanel = null;
                ActionButtons.this.m_endTurnPanel = null;
                ActionButtons.this.m_politicsPanel = null;
            }
        });
    }

    public void changeToMove(PlayerID id, boolean nonCombat, String stepName) {
        this.m_movePanel.setNonCombat(nonCombat);
        boolean airBorne = stepName.endsWith("AirborneCombatMove");
        String displayText = airBorne ? " Airborne" : (nonCombat ? " Non" : "");
        this.m_movePanel.setDisplayText(displayText + " Combat Move");
        this.m_movePanel.setMoveType(airBorne ? AbstractMoveDelegate.MoveType.SPECIAL : AbstractMoveDelegate.MoveType.DEFAULT);
        this.changeTo(id, this.m_movePanel);
    }

    public void changeToRepair(PlayerID id) {
        this.changeTo(id, this.m_repairPanel);
    }

    public void changeToProduce(PlayerID id) {
        this.changeTo(id, this.m_purchasePanel);
    }

    public void changeToPlace(PlayerID id) {
        this.changeTo(id, this.m_placePanel);
    }

    public void changeToBattle(PlayerID id, Collection<Territory> battles, Collection<Territory> bombing) {
        this.m_battlePanel.setBattlesAndBombing(battles, bombing);
        this.changeTo(id, this.m_battlePanel);
    }

    public void changeToPolitics(PlayerID id) {
        this.changeTo(id, this.m_politicsPanel);
    }

    public void changeToTech(PlayerID id) {
        this.changeTo(id, this.m_techPanel);
    }

    public void changeToEndTurn(PlayerID id) {
        this.changeTo(id, this.m_endTurnPanel);
    }

    private void changeTo(PlayerID id, ActionPanel newCurrent) {
        this.m_current.setActive(false);
        this.m_current = newCurrent;
        this.m_current.display(id);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ActionButtons.this.m_layout.show(ActionButtons.this, ActionButtons.this.m_current.toString());
            }
        });
    }

    public IntegerMap<ProductionRule> waitForPurchase(boolean bid) {
        return this.m_purchasePanel.waitForPurchase(bid);
    }

    public HashMap<Unit, IntegerMap<RepairRule>> waitForRepair(boolean bid) {
        return this.m_repairPanel.waitForRepair(bid);
    }

    public MoveDescription waitForMove(IPlayerBridge bridge) {
        return this.m_movePanel.waitForMove(bridge);
    }

    public TechRoll waitForTech() {
        return this.m_techPanel.waitForTech();
    }

    public PoliticalActionAttachment waitForPoliticalAction(boolean firstRun, IPoliticsDelegate iPoliticsDelegate) {
        return this.m_politicsPanel.waitForPoliticalAction(firstRun, iPoliticsDelegate);
    }

    public PlaceData waitForPlace(boolean bid, IPlayerBridge bridge) {
        return this.m_placePanel.waitForPlace(bid, bridge);
    }

    public void waitForEndTurn(TripleAFrame frame, IPlayerBridge bridge) {
        this.m_endTurnPanel.waitForEndTurn(frame, bridge);
    }

    public FightBattleDetails waitForBattleSelection() {
        return this.m_battlePanel.waitForBattleSelection();
    }

    public ActionPanel getCurrent() {
        return this.m_current;
    }

    public BattlePanel getBattlePanel() {
        return this.m_battlePanel;
    }

    public AbstractMovePanel getMovePanel() {
        return this.m_movePanel;
    }

    public PlacePanel getPlacePanel() {
        return this.m_placePanel;
    }

    public PurchasePanel getPurchasePanel() {
        return this.m_purchasePanel;
    }

    public TechPanel getTechPanel() {
        return this.m_techPanel;
    }

    public EndTurnPanel getEndTurnPanel() {
        return this.m_endTurnPanel;
    }
}

