/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.debug.Console;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.engine.random.PBEMDiceRoller;
import games.strategy.net.GUID;
import games.strategy.triplea.TripleAPlayer;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.dataObjects.CasualtyDetails;
import games.strategy.triplea.delegate.dataObjects.CasualtyList;
import games.strategy.triplea.delegate.dataObjects.FightBattleDetails;
import games.strategy.triplea.ui.ActionPanel;
import games.strategy.triplea.ui.BattleDisplay;
import games.strategy.triplea.ui.DicePanel;
import games.strategy.triplea.ui.MapPanel;
import games.strategy.triplea.ui.UnitChooser;
import games.strategy.ui.Util;
import games.strategy.util.EventThreadJOptionPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BattlePanel
extends ActionPanel {
    private static final long serialVersionUID = 5304208569738042592L;
    private final JLabel m_actionLabel = new JLabel();
    private FightBattleDetails m_fightBattleMessage;
    private volatile BattleDisplay m_battleDisplay;
    private volatile GUID m_currentBattleDisplayed;
    private final JFrame m_battleFrame = new JFrame();
    Collection<Territory> m_battles;
    Collection<Territory> m_bombing;
    Territory m_oldCenteredTerritory = null;
    Timer m_CenterBattleActionTimer = null;

    public BattlePanel(GameData data, MapPanel map) {
        super(data, map);
        this.m_battleFrame.setIconImage(GameRunner.getGameIcon(this.m_battleFrame));
        this.getMap().getUIContext().addShutdownWindow(this.m_battleFrame);
        this.m_battleFrame.addWindowListener(new WindowListener(){

            public void windowActivated(WindowEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (BattlePanel.this.m_battleDisplay != null) {
                            BattlePanel.this.m_battleDisplay.takeFocus();
                        }
                    }
                });
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowOpened(WindowEvent e) {
            }
        });
    }

    public void setBattlesAndBombing(Collection<Territory> battles, Collection<Territory> bombing) {
        this.m_battles = battles;
        this.m_bombing = bombing;
    }

    @Override
    public void display(final PlayerID id) {
        super.display(id);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BattlePanel.this.removeAll();
                BattlePanel.this.m_actionLabel.setText(id.getName() + " battle");
                BattlePanel.this.setLayout(new BorderLayout());
                JPanel panel = new JPanel();
                panel.setLayout(new GridLayout(0, 1));
                panel.add(BattlePanel.this.m_actionLabel);
                Iterator<Territory> iter = BattlePanel.this.m_battles.iterator();
                while (iter.hasNext()) {
                    this.addBattleActions(panel, iter, false, IBattle.BattleType.NORMAL);
                }
                iter = BattlePanel.this.m_bombing.iterator();
                while (iter.hasNext()) {
                    this.addBattleActions(panel, iter, true, IBattle.BattleType.BOMBING_RAID);
                }
                BattlePanel.this.add((Component)panel, "North");
                SwingUtilities.invokeLater(BattlePanel.this.REFRESH);
            }

            private void addBattleActions(JPanel panel, Iterator<Territory> iter, boolean bomb, IBattle.BattleType battleType) {
                Territory next = iter.next();
                JPanel innerPanel = new JPanel();
                innerPanel.setLayout(new BorderLayout());
                innerPanel.add((Component)new JButton(new FightBattleAction(next, bomb, battleType)), "Center");
                innerPanel.add((Component)new JButton(new CenterBattleAction(next)), "East");
                panel.add(innerPanel);
            }
        });
    }

    public void notifyRetreat(final String messageShort, final String messageLong, final String step, PlayerID retreatingPlayer) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (BattlePanel.this.m_battleDisplay != null) {
                    BattlePanel.this.m_battleDisplay.battleInfo(messageShort, messageLong, step);
                }
            }
        });
    }

    public void showDice(final String messageShort, final DiceRoll dice, final String step) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (BattlePanel.this.m_battleDisplay != null) {
                    BattlePanel.this.m_battleDisplay.battleInfo(messageShort, dice, step);
                }
            }
        });
    }

    public void battleEndMessage(GUID battleId, final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (BattlePanel.this.m_battleDisplay != null) {
                    BattlePanel.this.m_battleDisplay.endBattle(message, BattlePanel.this.m_battleFrame);
                }
            }
        });
    }

    private void cleanUpBattleWindow() {
        if (this.m_battleDisplay != null) {
            this.m_currentBattleDisplayed = null;
            this.m_battleDisplay.cleanUp();
            this.m_battleFrame.getContentPane().removeAll();
            this.m_battleDisplay = null;
            PBEMDiceRoller.setFocusWindow(this.m_battleFrame);
        }
    }

    private boolean ensureBattleIsDisplayed(GUID battleID) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Wrong threads");
        }
        GUID displayed = this.m_currentBattleDisplayed;
        int count = 0;
        while (displayed == null || !battleID.equals(displayed)) {
            try {
                Thread.sleep(++count);
            }
            catch (InterruptedException e) {
                return false;
            }
            if (count > 200) {
                Console.getConsole().dumpStacks();
                new IllegalStateException("battle not displayed, looking for:" + battleID + " showing:" + this.m_currentBattleDisplayed).printStackTrace();
                return false;
            }
            displayed = this.m_currentBattleDisplayed;
        }
        return true;
    }

    protected JFrame getBattleFrame() {
        return this.m_battleFrame;
    }

    public void listBattle(final GUID battleID, final List<String> steps) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable r = new Runnable(){

                public void run() {
                    BattlePanel.this.listBattle(battleID, steps);
                }
            };
            try {
                SwingUtilities.invokeLater(r);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        this.removeAll();
        if (this.m_battleDisplay != null) {
            this.getMap().centerOn(this.m_battleDisplay.getBattleLocation());
            this.m_battleDisplay.listBattle(steps);
        }
    }

    public void showBattle(final GUID battleID, final Territory location, String battleTitle, final Collection<Unit> attackingUnits, final Collection<Unit> defendingUnits, final Collection<Unit> killedUnits, final Collection<Unit> attackingWaitingToDie, final Collection<Unit> defendingWaitingToDie, Map<Unit, Collection<Unit>> unit_dependents, final PlayerID attacker, final PlayerID defender, final IBattle.BattleType battleType) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    if (BattlePanel.this.m_battleDisplay != null) {
                        BattlePanel.this.cleanUpBattleWindow();
                        BattlePanel.this.m_currentBattleDisplayed = null;
                    }
                    if (!BattlePanel.this.getMap().getUIContext().getShowMapOnly()) {
                        BattlePanel.this.m_battleDisplay = new BattleDisplay(BattlePanel.this.getData(), location, attacker, defender, attackingUnits, defendingUnits, killedUnits, attackingWaitingToDie, defendingWaitingToDie, battleID, BattlePanel.this.getMap(), battleType);
                        BattlePanel.this.m_battleFrame.setTitle(attacker.getName() + " attacks " + defender.getName() + " in " + location.getName());
                        BattlePanel.this.m_battleFrame.getContentPane().removeAll();
                        BattlePanel.this.m_battleFrame.getContentPane().add(BattlePanel.this.m_battleDisplay);
                        BattlePanel.this.m_battleFrame.setSize(750, 540);
                        BattlePanel.this.m_battleFrame.setLocationRelativeTo(JOptionPane.getFrameForComponent(BattlePanel.this));
                        PBEMDiceRoller.setFocusWindow(BattlePanel.this.m_battleFrame);
                        boolean foundHumanInBattle = false;
                        for (IGamePlayer gamePlayer : BattlePanel.this.getMap().getUIContext().getPlayerList()) {
                            if ((!gamePlayer.getID().equals(attacker) || !(gamePlayer instanceof TripleAPlayer)) && (!gamePlayer.getID().equals(defender) || !(gamePlayer instanceof TripleAPlayer))) continue;
                            foundHumanInBattle = true;
                            break;
                        }
                        if (BattlePanel.this.getMap().getUIContext().getShowBattlesBetweenAIs() || foundHumanInBattle) {
                            BattlePanel.this.m_battleFrame.setVisible(true);
                            BattlePanel.this.m_battleFrame.validate();
                            BattlePanel.this.m_battleFrame.invalidate();
                            BattlePanel.this.m_battleFrame.repaint();
                        } else {
                            BattlePanel.this.m_battleFrame.setVisible(false);
                        }
                        BattlePanel.this.m_battleFrame.setDefaultCloseOperation(0);
                        BattlePanel.this.m_currentBattleDisplayed = battleID;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                BattlePanel.this.m_battleFrame.toFront();
                            }
                        });
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public FightBattleDetails waitForBattleSelection() {
        this.waitForRelease();
        if (this.m_fightBattleMessage != null) {
            this.getMap().centerOn(this.m_fightBattleMessage.getWhere());
        }
        return this.m_fightBattleMessage;
    }

    public Territory getBombardment(final Unit unit, final Territory unitTerritory, final Collection<Territory> territories, final boolean noneAvailable) {
        BombardComponent comp = Util.runInSwingEventThread(new Util.Task<BombardComponent>(){

            @Override
            public BombardComponent run() {
                return new BombardComponent(unit, unitTerritory, territories, noneAvailable);
            }
        });
        int option = 1;
        while (option != 0) {
            option = EventThreadJOptionPane.showConfirmDialog(this, comp, "Bombardment Territory Selection", 0);
        }
        return comp.getSelection();
    }

    public boolean getAttackSubs(Territory terr) {
        return EventThreadJOptionPane.showConfirmDialog(null, "Attack submarines in " + terr.toString() + "?", "Attack", 0) == 0;
    }

    public boolean getAttackTransports(Territory terr) {
        return EventThreadJOptionPane.showConfirmDialog(null, "Attack transports in " + terr.toString() + "?", "Attack", 0) == 0;
    }

    public boolean getAttackUnits(Territory terr) {
        return EventThreadJOptionPane.showConfirmDialog(null, "Attack units in " + terr.toString() + "?", "Attack", 0) == 0;
    }

    public boolean getShoreBombard(Territory terr) {
        return EventThreadJOptionPane.showConfirmDialog(null, "Conduct naval bombard in " + terr.toString() + "?", "Bombard", 0) == 0;
    }

    public void casualtyNotification(final String step, final DiceRoll dice, final PlayerID player, final Collection<Unit> killed, final Collection<Unit> damaged, final Map<Unit, Collection<Unit>> dependents) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (BattlePanel.this.m_battleDisplay != null) {
                    BattlePanel.this.m_battleDisplay.casualtyNotification(step, dice, player, killed, damaged, dependents);
                }
            }
        });
    }

    public void deadUnitNotification(final PlayerID player, final Collection<Unit> killed, final Map<Unit, Collection<Unit>> dependents) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (BattlePanel.this.m_battleDisplay != null) {
                    BattlePanel.this.m_battleDisplay.deadUnitNotification(player, killed, dependents);
                }
            }
        });
    }

    public void changedUnitsNotification(final PlayerID player, final Collection<Unit> removedUnits, final Collection<Unit> addedUnits, final Map<Unit, Collection<Unit>> dependents) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (BattlePanel.this.m_battleDisplay != null) {
                    BattlePanel.this.m_battleDisplay.changedUnitsNotification(player, removedUnits, addedUnits, dependents);
                }
            }
        });
    }

    public void confirmCasualties(GUID battleId, String message) {
        if (!this.ensureBattleIsDisplayed(battleId)) {
            return;
        }
        this.m_battleDisplay.waitForConfirmation(message);
    }

    public CasualtyDetails getCasualties(Collection<Unit> selectFrom, Map<Unit, Collection<Unit>> dependents, int count, String message, DiceRoll dice, PlayerID hit, CasualtyList defaultCasualties, GUID battleID) {
        if (battleID == null) {
            return this.getCasualtiesAA(selectFrom, dependents, count, message, dice, hit, defaultCasualties);
        }
        if (!this.ensureBattleIsDisplayed(battleID)) {
            return new CasualtyDetails(defaultCasualties.getKilled(), defaultCasualties.getDamaged(), true);
        }
        return this.m_battleDisplay.getCasualties(selectFrom, dependents, count, message, dice, hit, defaultCasualties);
    }

    private CasualtyDetails getCasualtiesAA(final Collection<Unit> selectFrom, final Map<Unit, Collection<Unit>> dependents, final int count, final String message, final DiceRoll dice, final PlayerID hit, final CasualtyList defaultCasualties) {
        Util.Task<CasualtyDetails> task = new Util.Task<CasualtyDetails>(){

            @Override
            public CasualtyDetails run() {
                boolean isEditMode = dice == null;
                UnitChooser chooser = new UnitChooser((Collection<Unit>)selectFrom, defaultCasualties, (Map<Unit, Collection<Unit>>)dependents, BattlePanel.this.getData(), false, BattlePanel.this.getMap().getUIContext());
                chooser.setTitle(message);
                if (isEditMode) {
                    chooser.setMax(selectFrom.size());
                } else {
                    chooser.setMax(count);
                }
                DicePanel dicePanel = new DicePanel(BattlePanel.this.getMap().getUIContext(), BattlePanel.this.getData());
                if (!isEditMode) {
                    dicePanel.setDiceRoll(dice);
                }
                JPanel panel = new JPanel();
                panel.setLayout(new BorderLayout());
                panel.add((Component)chooser, "Center");
                dicePanel.setMaximumSize(new Dimension(450, 600));
                dicePanel.setPreferredSize(new Dimension(300, (int)dicePanel.getPreferredSize().getHeight()));
                panel.add((Component)dicePanel, "South");
                Object[] options = new String[]{"OK"};
                EventThreadJOptionPane.showOptionDialog(BattlePanel.this.getRootPane(), panel, hit.getName() + " select casualties", 0, -1, null, options, null);
                List<Unit> killed = chooser.getSelected(false);
                CasualtyDetails response = new CasualtyDetails(killed, chooser.getSelectedFirstHit(), false);
                return response;
            }
        };
        return Util.runInSwingEventThread(task);
    }

    public Territory getRetreat(GUID battleID, String message, Collection<Territory> possible, boolean submerge) {
        if (!this.ensureBattleIsDisplayed(battleID)) {
            return null;
        }
        return this.m_battleDisplay.getRetreat(message, possible, submerge);
    }

    public void gotoStep(GUID battleID, final String step) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (BattlePanel.this.m_battleDisplay != null) {
                    BattlePanel.this.m_battleDisplay.setStep(step);
                }
            }
        });
    }

    public void notifyRetreat(final Collection<Unit> retreating) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (BattlePanel.this.m_battleDisplay != null) {
                    BattlePanel.this.m_battleDisplay.notifyRetreat(retreating);
                }
            }
        });
    }

    public void bombingResults(GUID battleID, final int[] dice, final int cost) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (BattlePanel.this.m_battleDisplay != null) {
                    BattlePanel.this.m_battleDisplay.bombingResults(dice, cost);
                }
            }
        });
    }

    @Override
    public String toString() {
        return "BattlePanel";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BombardComponent
    extends JPanel {
        private static final long serialVersionUID = -2388895995673156507L;
        private final JList m_list;

        BombardComponent(Unit unit, Territory unitTerritory, Collection<Territory> territories, boolean noneAvailable) {
            this.setLayout(new BorderLayout());
            String unitName = unit.getUnitType().getName() + " in " + unitTerritory;
            JLabel label = new JLabel("Which territory should " + unitName + " bombard?");
            this.add((Component)label, "North");
            Vector<Territory> listElements = new Vector<Territory>(territories);
            if (noneAvailable) {
                listElements.add(0, (Territory)((Object)"None"));
            }
            this.m_list = new JList<Territory>(listElements);
            this.m_list.setSelectionMode(0);
            if (listElements.size() >= 1) {
                this.m_list.setSelectedIndex(0);
            }
            JScrollPane scroll = new JScrollPane(this.m_list);
            this.add((Component)scroll, "Center");
        }

        public Territory getSelection() {
            Object selected = this.m_list.getSelectedValue();
            if (selected instanceof Territory) {
                return (Territory)selected;
            }
            return null;
        }
    }

    class FightBattleAction
    extends AbstractAction {
        private static final long serialVersionUID = 5510976406003707776L;
        Territory m_territory;
        boolean m_bomb;

        FightBattleAction(Territory battleSite, boolean bomb, IBattle.BattleType battleType) {
            super((bomb ? (battleType.equals((Object)IBattle.BattleType.AIR_BATTLE) ? "Air Battle in " : "Bombing raid in ") : "Battle in ") + battleSite.getName() + "...");
            this.m_territory = battleSite;
            this.m_bomb = bomb;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BattlePanel.this.m_oldCenteredTerritory != null) {
                BattlePanel.this.getMap().clearTerritoryOverlay(BattlePanel.this.m_oldCenteredTerritory);
            }
            BattlePanel.this.m_fightBattleMessage = new FightBattleDetails(this.m_bomb, this.m_territory);
            BattlePanel.this.release();
        }
    }

    class CenterBattleAction
    extends AbstractAction {
        private static final long serialVersionUID = -5071133874755970334L;
        Territory m_territory;

        CenterBattleAction(Territory battleSite) {
            super("Center");
            this.m_territory = battleSite;
        }

        public void actionPerformed(ActionEvent e) {
            if (BattlePanel.this.m_CenterBattleActionTimer != null) {
                BattlePanel.this.m_CenterBattleActionTimer.cancel();
            }
            if (BattlePanel.this.m_oldCenteredTerritory != null) {
                BattlePanel.this.getMap().clearTerritoryOverlay(BattlePanel.this.m_oldCenteredTerritory);
            }
            BattlePanel.this.getMap().centerOn(this.m_territory);
            BattlePanel.this.m_CenterBattleActionTimer = new Timer();
            BattlePanel.this.m_CenterBattleActionTimer.scheduleAtFixedRate((TimerTask)new MyTimerTask(this.m_territory, BattlePanel.this.m_CenterBattleActionTimer), 150L, 150L);
            BattlePanel.this.m_oldCenteredTerritory = this.m_territory;
        }

        class MyTimerTask
        extends TimerTask {
            Territory m_territory;
            Timer m_stopTimer;
            int m_count = 0;

            MyTimerTask(Territory battleSite, Timer stopTimer) {
                this.m_territory = battleSite;
                this.m_stopTimer = stopTimer;
            }

            public void run() {
                if (this.m_count == 5) {
                    this.m_stopTimer.cancel();
                }
                if (this.m_count % 3 == 0) {
                    BattlePanel.this.getMap().setTerritoryOverlayForBorder(this.m_territory, Color.white);
                    BattlePanel.this.getMap().paintImmediately(BattlePanel.this.getMap().getBounds());
                } else {
                    BattlePanel.this.getMap().clearTerritoryOverlay(this.m_territory);
                    BattlePanel.this.getMap().paintImmediately(BattlePanel.this.getMap().getBounds());
                }
                ++this.m_count;
            }
        }
    }
}

