/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.triplea.ui.UIContext;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.triplea.util.UnitOwner;
import games.strategy.ui.ScrollableTextField;
import games.strategy.ui.ScrollableTextFieldListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

class ChooserEntry {
    private final UnitCategory m_category;
    private ScrollableTextField m_hitText;
    private final ScrollableTextFieldListener m_hitTextFieldListener;
    private final GameData m_data;
    private final boolean m_hasSecondHit;
    private final int m_defaultValueFirstHits;
    private final int m_defaultValueSecondHits;
    private ScrollableTextField m_secondHitText;
    private JLabel m_secondHitLabel;
    private int m_leftToSelect = 0;
    private static Insets nullInsets = new Insets(0, 0, 0, 0);
    private final UIContext m_uiContext;

    ChooserEntry(UnitCategory category, ScrollableTextFieldListener listener, GameData data, boolean allowTwoHit, int defaultValue, UIContext uiContext) {
        this.m_hitTextFieldListener = listener;
        this.m_data = data;
        this.m_category = category;
        this.m_hasSecondHit = allowTwoHit && category.isTwoHit() && !category.getDamaged();
        int numUnits = category.getUnits().size();
        this.m_defaultValueFirstHits = numUnits < defaultValue ? numUnits : defaultValue;
        this.m_defaultValueSecondHits = numUnits < defaultValue ? defaultValue - numUnits : 0;
        this.m_uiContext = uiContext;
    }

    public void createComponents(JPanel panel, int yIndex) {
        panel.add((Component)new UnitChooserEntryIcon(false, this.m_uiContext), new GridBagConstraints(0, yIndex, 1, 1, 0.0, 0.0, 17, 2, nullInsets, 0, 0));
        if (this.m_category.getMovement() != -1) {
            panel.add((Component)new JLabel("mvt " + this.m_category.getMovement()), new GridBagConstraints(1, yIndex, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 4, 0, 4), 0, 0));
        }
        if (this.m_category.getTransportCost() != -1) {
            panel.add((Component)new JLabel("cst " + this.m_category.getTransportCost()), new GridBagConstraints(1, yIndex, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 4, 0, 4), 0, 0));
        }
        panel.add((Component)new JLabel("x" + this.m_category.getUnits().size()), new GridBagConstraints(2, yIndex, 1, 1, 0.0, 0.0, 17, 2, nullInsets, 0, 0));
        this.m_hitText = new ScrollableTextField(0, this.m_category.getUnits().size());
        this.m_hitText.setValue(this.m_defaultValueFirstHits);
        this.m_hitText.addChangeListener(this.m_hitTextFieldListener);
        panel.add((Component)this.m_hitText, new GridBagConstraints(3, yIndex, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 4, 0, 0), 0, 0));
        if (this.m_hasSecondHit) {
            panel.add((Component)new UnitChooserEntryIcon(true, this.m_uiContext), new GridBagConstraints(4, yIndex, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 8, 0, 0), 0, 0));
            this.m_secondHitLabel = new JLabel("x0");
            this.m_secondHitText = new ScrollableTextField(0, 0);
            this.m_secondHitText.setValue(this.m_defaultValueSecondHits);
            this.updateLeftToSelect();
            panel.add((Component)this.m_secondHitLabel, new GridBagConstraints(5, yIndex, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 4), 0, 0));
            panel.add((Component)this.m_secondHitText, new GridBagConstraints(6, yIndex, 1, 1, 0.0, 0.0, 17, 2, nullInsets, 0, 0));
            this.m_hitText.addChangeListener(new ScrollableTextFieldListener(){

                public void changedValue(ScrollableTextField field) {
                    ChooserEntry.this.m_secondHitLabel.setText("x" + field.getValue());
                    ChooserEntry.this.updateLeftToSelect();
                }
            });
            this.m_secondHitText.addChangeListener(this.m_hitTextFieldListener);
        }
    }

    public int getMax() {
        return this.m_hitText.getMax();
    }

    public void set(int value) {
        this.m_hitText.setValue(value);
    }

    public UnitCategory getCategory() {
        return this.m_category;
    }

    public void selectAll() {
        this.m_hitText.setValue(this.m_hitText.getMax());
    }

    public void selectNone() {
        this.m_hitText.setValue(0);
    }

    public void setLeftToSelect(int leftToSelect) {
        this.m_leftToSelect = leftToSelect;
        this.updateLeftToSelect();
    }

    private void updateLeftToSelect() {
        int newMax = this.m_leftToSelect + this.m_hitText.getValue();
        this.m_hitText.setMax(Math.min(newMax, this.m_category.getUnits().size()));
        if (this.m_hasSecondHit) {
            int newSecondHitMax = this.m_leftToSelect + this.m_secondHitText.getValue();
            this.m_secondHitText.setMax(Math.min(newSecondHitMax, this.m_hitText.getValue()));
        }
    }

    public int getTotalHits() {
        return this.getFirstHits() + this.getSecondHits();
    }

    public int getFirstHits() {
        return this.m_hitText.getValue();
    }

    public int getSecondHits() {
        if (!this.m_hasSecondHit) {
            return 0;
        }
        return this.m_secondHitText.getValue();
    }

    public boolean isTwoHit() {
        return this.m_hasSecondHit;
    }

    class UnitChooserEntryIcon
    extends JComponent {
        private static final long serialVersionUID = 591598594559651745L;
        private final boolean m_forceDamaged;
        private final UIContext m_uiContext;

        UnitChooserEntryIcon(boolean forceDamaged, UIContext uiContext) {
            this.m_forceDamaged = forceDamaged;
            this.m_uiContext = uiContext;
        }

        public void paint(Graphics g) {
            super.paint(g);
            g.drawImage(this.m_uiContext.getUnitImageFactory().getImage(ChooserEntry.this.m_category.getType(), ChooserEntry.this.m_category.getOwner(), ChooserEntry.this.m_data, this.m_forceDamaged || ChooserEntry.this.m_category.getDamaged(), ChooserEntry.this.m_category.getDisabled()), 0, 0, this);
            Iterator<UnitOwner> iter = ChooserEntry.this.m_category.getDependents().iterator();
            int index = 1;
            while (iter.hasNext()) {
                UnitOwner holder = iter.next();
                int x = this.m_uiContext.getUnitImageFactory().getUnitImageWidth() * index;
                Image unitImg = this.m_uiContext.getUnitImageFactory().getImage(holder.getType(), holder.getOwner(), ChooserEntry.this.m_data, false, false);
                g.drawImage(unitImg, x, 0, this);
                ++index;
            }
        }

        public int getWidth() {
            return this.m_uiContext.getUnitImageFactory().getUnitImageWidth() * (1 + ChooserEntry.this.m_category.getDependents().size());
        }

        public int getHeight() {
            return this.m_uiContext.getUnitImageFactory().getUnitImageHeight();
        }

        public Dimension getMaximumSize() {
            return this.getDimension();
        }

        public Dimension getMinimumSize() {
            return this.getDimension();
        }

        public Dimension getPreferredSize() {
            return this.getDimension();
        }

        public Dimension getDimension() {
            return new Dimension(this.getWidth(), this.getHeight());
        }
    }
}

