/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.events.GameDataChangeListener;
import games.strategy.engine.stats.IStat;
import games.strategy.triplea.ui.StatPanel;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class EconomyPanel
extends StatPanel {
    private static final long serialVersionUID = -7713792841831042952L;
    private IStat[] m_statsResource;
    private ResourceTableModel m_resourceModel;

    public EconomyPanel(GameData data) {
        super(data);
    }

    protected void initLayout() {
        this.setLayout(new GridLayout(1, 1));
        this.m_resourceModel = new ResourceTableModel();
        JTable table = new JTable(this.m_resourceModel);
        table.getTableHeader().setReorderingAllowed(false);
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(175);
        JScrollPane scroll = new JScrollPane(table);
        this.add(scroll);
    }

    public void setGameData(GameData data) {
        this.m_data = data;
        this.m_resourceModel.setGameData(data);
        this.m_resourceModel.gameDataChanged(null);
    }

    static /* synthetic */ IStat[] access$002(EconomyPanel x0, IStat[] x1) {
        x0.m_statsResource = x1;
        return x1;
    }

    class ResourceTableModel
    extends AbstractTableModel
    implements GameDataChangeListener {
        private static final long serialVersionUID = 5197895788633898324L;
        private boolean m_isDirty = true;
        private String[][] m_collectedData;

        public ResourceTableModel() {
            this.setResourceCollums();
            EconomyPanel.this.m_data.addDataChangeListener(this);
            this.m_isDirty = true;
        }

        private void setResourceCollums() {
            ArrayList<StatPanel.ResourceStat> statList = new ArrayList<StatPanel.ResourceStat>();
            for (Resource resource : EconomyPanel.this.m_data.getResourceList().getResources()) {
                if (resource.getName().equals("techTokens") || resource.getName().equals("VPs")) continue;
                statList.add(new StatPanel.ResourceStat(EconomyPanel.this, resource));
            }
            EconomyPanel.access$002(EconomyPanel.this, statList.toArray(new IStat[statList.size()]));
        }

        public synchronized Object getValueAt(int row, int col) {
            if (this.m_isDirty) {
                this.loadData();
                this.m_isDirty = false;
            }
            return this.m_collectedData[row][col];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void loadData() {
            EconomyPanel.this.m_data.acquireReadLock();
            try {
                int i;
                List<PlayerID> players = EconomyPanel.this.getPlayers();
                Collection<String> alliances = EconomyPanel.this.getAlliances();
                this.m_collectedData = new String[players.size() + alliances.size()][EconomyPanel.this.m_statsResource.length + 1];
                int row = 0;
                for (PlayerID player : players) {
                    this.m_collectedData[row][0] = player.getName();
                    for (i = 0; i < EconomyPanel.this.m_statsResource.length; ++i) {
                        this.m_collectedData[row][i + 1] = EconomyPanel.this.m_statsResource[i].getFormatter().format(EconomyPanel.this.m_statsResource[i].getValue(player, EconomyPanel.this.m_data));
                    }
                    ++row;
                }
                Iterator<String> allianceIterator = alliances.iterator();
                while (allianceIterator.hasNext()) {
                    String alliance;
                    this.m_collectedData[row][0] = alliance = allianceIterator.next();
                    for (i = 0; i < EconomyPanel.this.m_statsResource.length; ++i) {
                        this.m_collectedData[row][i + 1] = EconomyPanel.this.m_statsResource[i].getFormatter().format(EconomyPanel.this.m_statsResource[i].getValue(alliance, EconomyPanel.this.m_data));
                    }
                    ++row;
                }
            }
            finally {
                EconomyPanel.this.m_data.releaseReadLock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void gameDataChanged(Change aChange) {
            ResourceTableModel resourceTableModel = this;
            synchronized (resourceTableModel) {
                this.m_isDirty = true;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EconomyPanel.this.repaint();
                }
            });
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return "Player";
            }
            return EconomyPanel.this.m_statsResource[col - 1].getName();
        }

        public int getColumnCount() {
            return EconomyPanel.this.m_statsResource.length + 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int getRowCount() {
            if (!this.m_isDirty) {
                return this.m_collectedData.length;
            }
            EconomyPanel.this.m_data.acquireReadLock();
            try {
                int n = EconomyPanel.this.m_data.getPlayerList().size() + EconomyPanel.this.getAlliances().size();
                return n;
            }
            finally {
                EconomyPanel.this.m_data.releaseReadLock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void setGameData(GameData data) {
            ResourceTableModel resourceTableModel = this;
            synchronized (resourceTableModel) {
                EconomyPanel.this.m_data.removeDataChangeListener(this);
                EconomyPanel.this.m_data = data;
                EconomyPanel.this.m_data.addDataChangeListener(this);
                this.m_isDirty = true;
            }
            EconomyPanel.this.repaint();
        }
    }
}

