/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.gamePlayer.IPlayerBridge;
import games.strategy.engine.history.HistoryNode;
import games.strategy.engine.history.Round;
import games.strategy.engine.pbem.IEmailSender;
import games.strategy.engine.pbem.IForumPoster;
import games.strategy.engine.pbem.PBEMMessagePoster;
import games.strategy.triplea.delegate.remote.IAbstractEndTurnDelegate;
import games.strategy.triplea.ui.ActionPanel;
import games.strategy.triplea.ui.MapPanel;
import games.strategy.triplea.ui.TripleAFrame;
import games.strategy.triplea.ui.history.HistoryLog;
import games.strategy.ui.ProgressWindow;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;

public class EndTurnPanel
extends ActionPanel {
    private static final long serialVersionUID = 917277199146177235L;
    private JLabel m_actionLabel = new JLabel();
    private IPlayerBridge m_bridge;
    private PBEMMessagePoster m_poster;
    private TripleAFrame m_frame;
    private HistoryLog m_historyLog;
    private JButton m_postButton;
    private JCheckBox m_includeTerritoryCheckbox;
    private JCheckBox m_includeProductionCheckbox;
    private JCheckBox m_showDetailsCheckbox;
    private Action m_viewAction = new AbstractAction("View Turn Summary"){
        private static final long serialVersionUID = -2619980789206699839L;

        public void actionPerformed(ActionEvent event) {
            EndTurnPanel.this.m_historyLog.setVisible(true);
        }
    };
    private Action m_postAction = new AbstractAction("Post Turn Summary"){
        private static final long serialVersionUID = 8317441736305744524L;

        public void actionPerformed(ActionEvent event) {
            IEmailSender emailSender;
            String message = "";
            IForumPoster turnSummaryMsgr = EndTurnPanel.this.m_poster.getForumPoster();
            StringBuilder sb = new StringBuilder();
            if (turnSummaryMsgr != null) {
                sb.append(message).append("Post turn summary ");
                if (turnSummaryMsgr.getIncludeSaveGame()) {
                    sb.append(" and save game ");
                }
                sb.append("to ").append(turnSummaryMsgr.getDisplayName()).append("?\n");
            }
            if ((emailSender = EndTurnPanel.this.m_poster.getEmailSender()) != null) {
                sb.append("Send email to ").append(emailSender.getToAddress()).append("?\n");
            }
            message = sb.toString();
            int choice = JOptionPane.showConfirmDialog(EndTurnPanel.this.getTopLevelAncestor(), message, "Post Turn Summary?", 2, -1, null);
            if (choice != 0) {
                return;
            }
            EndTurnPanel.this.m_postButton.setEnabled(false);
            final ProgressWindow progressWindow = new ProgressWindow(EndTurnPanel.this.m_frame, "Posting Turn Summary...");
            progressWindow.setVisible(true);
            Runnable t = new Runnable(){

                public void run() {
                    boolean postOk = true;
                    IAbstractEndTurnDelegate delegate = (IAbstractEndTurnDelegate)EndTurnPanel.this.m_bridge.getRemote();
                    delegate.setHasPostedTurnSummary(true);
                    File saveGameFile = null;
                    try {
                        saveGameFile = File.createTempFile("triplea", ".tsvg");
                        if (saveGameFile != null) {
                            EndTurnPanel.this.m_frame.getGame().saveGame(saveGameFile);
                            EndTurnPanel.this.m_poster.setSaveGame(saveGameFile);
                        }
                    }
                    catch (Exception e) {
                        postOk = false;
                        e.printStackTrace();
                    }
                    EndTurnPanel.this.m_poster.setTurnSummary(EndTurnPanel.this.m_historyLog.toString());
                    try {
                        if (!delegate.postTurnSummary(EndTurnPanel.this.m_poster)) {
                            postOk = false;
                        }
                    }
                    catch (Exception e) {
                        postOk = false;
                        e.printStackTrace();
                    }
                    StringBuilder sb = new StringBuilder();
                    if (EndTurnPanel.this.m_poster.getForumPoster() != null) {
                        String saveGameRef = EndTurnPanel.this.m_poster.getSaveGameRef();
                        String turnSummaryRef = EndTurnPanel.this.m_poster.getTurnSummaryRef();
                        if (saveGameRef != null) {
                            sb.append("\nSave Game : ").append(saveGameRef);
                        }
                        if (turnSummaryRef != null) {
                            sb.append("\nSummary Text: ").append(turnSummaryRef);
                        }
                    }
                    if (EndTurnPanel.this.m_poster.getEmailSender() != null) {
                        sb.append("\nEmails: ").append(EndTurnPanel.this.m_poster.getEmailSendStatus());
                    }
                    EndTurnPanel.this.m_historyLog.getWriter().println(sb.toString());
                    if (EndTurnPanel.this.m_historyLog.isVisible()) {
                        EndTurnPanel.this.m_historyLog.setVisible(true);
                    }
                    try {
                        if (saveGameFile != null && !saveGameFile.delete()) {
                            System.err.println("couldn't delete " + saveGameFile.getCanonicalPath());
                        }
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    progressWindow.setVisible(false);
                    progressWindow.removeAll();
                    progressWindow.dispose();
                    delegate.setHasPostedTurnSummary(postOk);
                    final boolean finalPostOk = postOk;
                    final String finalMessage = sb.toString();
                    delegate.setHasPostedTurnSummary(postOk);
                    Runnable runnable = new Runnable(){

                        public void run() {
                            EndTurnPanel.this.m_postButton.setEnabled(!finalPostOk);
                            if (finalPostOk) {
                                JOptionPane.showMessageDialog(EndTurnPanel.this.m_frame, finalMessage, "Turn Summary Posted", 1);
                            } else {
                                JOptionPane.showMessageDialog(EndTurnPanel.this.m_frame, finalMessage, "Turn Summary Posted", 0);
                            }
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            };
            new Thread(t).start();
        }
    };
    private Action m_includeTerritoryAction = new AbstractAction("Include territory summary"){
        private static final long serialVersionUID = 207279881318712095L;

        public void actionPerformed(ActionEvent event) {
            EndTurnPanel.this.updateHistoryLog();
        }
    };
    private Action m_includeProductionAction = new AbstractAction("Include production summary"){
        private static final long serialVersionUID = 2298448099326090293L;

        public void actionPerformed(ActionEvent event) {
            EndTurnPanel.this.updateHistoryLog();
        }
    };
    private Action m_showDetailsAction = new AbstractAction("Show dice/battle details"){
        private static final long serialVersionUID = -4248518090232071926L;

        public void actionPerformed(ActionEvent event) {
            EndTurnPanel.this.updateHistoryLog();
        }
    };
    private Action m_doneAction = new AbstractAction("Done"){
        private static final long serialVersionUID = -3658752576117043053L;

        public void actionPerformed(ActionEvent event) {
            EndTurnPanel.this.release();
        }
    };

    public EndTurnPanel(GameData data, MapPanel map) {
        super(data, map);
        this.m_includeTerritoryCheckbox = new JCheckBox(this.m_includeTerritoryAction);
        this.m_includeProductionCheckbox = new JCheckBox(this.m_includeProductionAction);
        this.m_showDetailsCheckbox = new JCheckBox(this.m_showDetailsAction);
    }

    private int getRound() {
        TreeNode[] pathFromRoot;
        int round = 0;
        for (TreeNode pathNode : pathFromRoot = this.getData().getHistory().getLastNode().getPath()) {
            HistoryNode curNode = (HistoryNode)pathNode;
            if (!(curNode instanceof Round)) continue;
            round = ((Round)curNode).getRoundNo();
            break;
        }
        return round;
    }

    public void display(final PlayerID id) {
        super.display(id);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EndTurnPanel.this.m_actionLabel.setText(id.getName() + " Turn Summary");
            }
        });
    }

    public String toString() {
        return "EndTurnPanel";
    }

    private void updateHistoryLog() {
        this.m_historyLog.clear();
        this.m_historyLog.printFullTurn(this.getData().getHistory().getLastNode(), this.m_showDetailsCheckbox.isSelected());
        if (this.m_includeTerritoryCheckbox.isSelected()) {
            this.m_historyLog.printTerritorySummary(this.getData());
        }
        if (this.m_includeProductionCheckbox.isSelected()) {
            this.m_historyLog.printProductionSummary(this.getData());
        }
        this.m_historyLog.requestFocus();
    }

    public void waitForEndTurn(TripleAFrame frame, IPlayerBridge bridge) {
        this.m_frame = frame;
        this.m_bridge = bridge;
        this.m_poster = new PBEMMessagePoster(this.getData(), this.getCurrentPlayer(), this.getRound());
        if (!this.m_poster.hasMessengers()) {
            return;
        }
        IAbstractEndTurnDelegate delegate = (IAbstractEndTurnDelegate)this.m_bridge.getRemote();
        final boolean hasPosted = delegate.getHasPostedTurnSummary();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EndTurnPanel.this.m_historyLog = new HistoryLog();
                EndTurnPanel.this.updateHistoryLog();
                EndTurnPanel.this.removeAll();
                EndTurnPanel.this.add(EndTurnPanel.this.m_actionLabel);
                EndTurnPanel.this.add(EndTurnPanel.this.m_includeTerritoryCheckbox);
                EndTurnPanel.this.add(EndTurnPanel.this.m_includeProductionCheckbox);
                EndTurnPanel.this.add(EndTurnPanel.this.m_showDetailsCheckbox);
                EndTurnPanel.this.add(new JButton(EndTurnPanel.this.m_viewAction));
                EndTurnPanel.this.m_postButton = new JButton(EndTurnPanel.this.m_postAction);
                EndTurnPanel.this.m_postButton.setEnabled(!hasPosted);
                EndTurnPanel.this.add(EndTurnPanel.this.m_postButton);
                EndTurnPanel.this.add(new JButton(EndTurnPanel.this.m_doneAction));
                EndTurnPanel.this.validate();
            }
        });
        this.waitForRelease();
    }
}

