/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.ui.SingleUnitPanel;
import games.strategy.triplea.ui.UIContext;
import games.strategy.ui.ScrollableTextField;
import games.strategy.ui.ScrollableTextFieldListener;
import games.strategy.util.IntegerMap;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndividualUnitPanel
extends JPanel {
    private static final long serialVersionUID = -4222938655315991715L;
    private final List<SingleUnitPanel> m_entries = new ArrayList<SingleUnitPanel>();
    private final JTextArea m_title;
    private int m_max = -1;
    private final JLabel m_leftToSelect = new JLabel();
    private final GameData m_data;
    private JButton m_autoSelectButton;
    private JButton m_selectNoneButton;
    private final UIContext m_uiContext;
    private ScrollableTextField m_textFieldPurelyForListening;
    private final ScrollableTextFieldListener m_countOptionalTextFieldListener;
    private final boolean m_showSelectAll;
    private final ScrollableTextFieldListener m_textFieldListener = new ScrollableTextFieldListener(){

        public void changedValue(ScrollableTextField field) {
            IndividualUnitPanel.this.updateLeft();
        }
    };

    public IndividualUnitPanel(Collection<Unit> units, String title, GameData data, UIContext context, int max, boolean showMinAndMax, boolean showSelectAll, ScrollableTextFieldListener optionalListener) {
        this.m_data = data;
        this.m_uiContext = context;
        this.m_title = new JTextArea(title);
        this.m_title.setBackground(this.getBackground());
        this.m_title.setEditable(false);
        this.m_title.setWrapStyleWord(true);
        this.m_countOptionalTextFieldListener = optionalListener;
        this.setMaxAndShowMaxButton(max);
        this.m_showSelectAll = showSelectAll;
        for (Unit u : units) {
            this.m_entries.add(new SingleUnitPanel(u, this.m_data, this.m_uiContext, this.m_textFieldListener, this.m_max, 0, showMinAndMax));
        }
        this.layoutEntries();
    }

    private void setMaxAndShowMaxButton(int max) {
        this.m_max = max;
        this.m_textFieldPurelyForListening = new ScrollableTextField(0, 0);
        this.m_textFieldListener.changedValue(null);
        if (this.m_countOptionalTextFieldListener != null) {
            this.m_textFieldPurelyForListening.addChangeListener(this.m_countOptionalTextFieldListener);
        }
    }

    public void setTitle(String title) {
        this.m_title.setText(title);
    }

    public int getMax() {
        return this.m_max;
    }

    public void setMaxAndUpdate(int newMax) {
        this.m_max = newMax;
        this.updateLeft();
        this.m_textFieldPurelyForListening.setValue(0);
    }

    private void updateLeft() {
        if (this.m_max == -1) {
            return;
        }
        int selected = this.getSelectedCount();
        int newMax = this.m_max - selected;
        for (SingleUnitPanel entry : this.m_entries) {
            int current = entry.getCount();
            int maxForThis = current + newMax;
            entry.setMax(maxForThis);
        }
        this.m_leftToSelect.setText("Left to select:" + newMax);
        this.m_textFieldPurelyForListening.setValue(0);
    }

    protected int getSelectedCount() {
        int selected = 0;
        for (SingleUnitPanel entry : this.m_entries) {
            selected += entry.getCount();
        }
        return selected;
    }

    private void layoutEntries() {
        this.setLayout(new GridBagLayout());
        Insets nullInsets = new Insets(0, 0, 0, 0);
        Dimension buttonSize = new Dimension(80, 20);
        this.m_selectNoneButton = new JButton("None");
        this.m_selectNoneButton.setPreferredSize(buttonSize);
        this.m_autoSelectButton = new JButton("Max");
        this.m_autoSelectButton.setPreferredSize(buttonSize);
        this.add((Component)this.m_title, new GridBagConstraints(0, 0, 7, 1, 0.0, 0.5, 13, 2, nullInsets, 0, 0));
        this.m_selectNoneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IndividualUnitPanel.this.selectNone();
            }
        });
        this.m_autoSelectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IndividualUnitPanel.this.autoSelect();
            }
        });
        int yIndex = 1;
        for (SingleUnitPanel entry : this.m_entries) {
            entry.createComponents(this, yIndex);
            ++yIndex;
        }
        if (this.m_showSelectAll) {
            this.add((Component)this.m_autoSelectButton, new GridBagConstraints(0, yIndex, 7, 1, 0.0, 0.5, 13, 0, nullInsets, 0, 0));
            ++yIndex;
        }
        this.add((Component)this.m_leftToSelect, new GridBagConstraints(0, yIndex, 5, 2, 0.0, 0.5, 17, 2, nullInsets, 0, 0));
    }

    public IntegerMap<Unit> getSelected() {
        IntegerMap<Unit> selectedUnits = new IntegerMap<Unit>();
        for (SingleUnitPanel entry : this.m_entries) {
            selectedUnits.put(entry.getUnit(), entry.getCount());
        }
        return selectedUnits;
    }

    protected void selectNone() {
        for (SingleUnitPanel entry : this.m_entries) {
            entry.selectNone();
        }
    }

    protected void autoSelect() {
        if (this.m_max == -1) {
            for (SingleUnitPanel entry : this.m_entries) {
                entry.selectAll();
            }
        } else {
            int leftToSelect = this.m_max - this.getSelectedCount();
            for (SingleUnitPanel entry : this.m_entries) {
                int canSelect;
                int leftToSelectForCurrent = leftToSelect + entry.getCount();
                if (leftToSelectForCurrent >= (canSelect = entry.getMax())) {
                    entry.selectAll();
                    leftToSelect -= canSelect;
                    continue;
                }
                entry.setCount(leftToSelectForCurrent);
                leftToSelect = 0;
                break;
            }
        }
    }
}

