/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.RelationshipType;
import games.strategy.engine.data.RelationshipTypeList;
import games.strategy.triplea.attatchments.PoliticalActionAttachment;
import games.strategy.triplea.util.PlayerOrderComparator;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PoliticalActionComparator
implements Comparator<PoliticalActionAttachment> {
    private final GameData m_data;
    private final PlayerID m_player;

    public PoliticalActionComparator(PlayerID currentPlayer, GameData data) {
        this.m_data = data;
        this.m_player = currentPlayer;
    }

    @Override
    public int compare(PoliticalActionAttachment paa1, PoliticalActionAttachment paa2) {
        int order;
        PlayerID paa2OtherPlayer;
        if (paa1.equals(paa2)) {
            return 0;
        }
        String[] paa1RelationChange = paa1.getRelationshipChange().iterator().next().split(":");
        String[] paa2RelationChange = paa2.getRelationshipChange().iterator().next().split(":");
        this.m_data.acquireReadLock();
        RelationshipTypeList relationshipTypeList = this.m_data.getRelationshipTypeList();
        this.m_data.releaseReadLock();
        RelationshipType paa1NewType = relationshipTypeList.getRelationshipType(paa1RelationChange[2]);
        RelationshipType paa2NewType = relationshipTypeList.getRelationshipType(paa2RelationChange[2]);
        PlayerID paa1p1 = this.m_data.getPlayerList().getPlayerID(paa1RelationChange[0]);
        PlayerID paa1p2 = this.m_data.getPlayerList().getPlayerID(paa1RelationChange[1]);
        PlayerID paa2p1 = this.m_data.getPlayerList().getPlayerID(paa2RelationChange[0]);
        PlayerID paa2p2 = this.m_data.getPlayerList().getPlayerID(paa2RelationChange[1]);
        PlayerID paa1OtherPlayer = this.m_player.equals(paa1p1) ? paa1p2 : paa1p1;
        PlayerID playerID = paa2OtherPlayer = this.m_player.equals(paa2p1) ? paa2p2 : paa2p1;
        if (!paa1OtherPlayer.equals(paa2OtherPlayer) && (order = new PlayerOrderComparator(this.m_data).compare(paa1OtherPlayer, paa2OtherPlayer)) != 0) {
            return order;
        }
        if (!paa1NewType.equals(paa2NewType)) {
            if (paa1NewType.getRelationshipTypeAttachment().isWar() && !paa2NewType.getRelationshipTypeAttachment().isWar()) {
                return -1;
            }
            if (!paa1NewType.getRelationshipTypeAttachment().isWar() && paa2NewType.getRelationshipTypeAttachment().isWar()) {
                return 1;
            }
            if (paa1NewType.getRelationshipTypeAttachment().isNeutral() && paa2NewType.getRelationshipTypeAttachment().isAllied()) {
                return -1;
            }
            if (paa1NewType.getRelationshipTypeAttachment().isAllied() && paa2NewType.getRelationshipTypeAttachment().isNeutral()) {
                return 1;
            }
        }
        if (!paa1NewType.getName().equals(paa2NewType.getName())) {
            return paa1NewType.getName().compareTo(paa2NewType.getName());
        }
        return 0;
    }
}

