/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.RelationshipType;
import games.strategy.triplea.ui.UIContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class PoliticalStateOverview
extends JPanel {
    private static final long serialVersionUID = -8445782272897831080L;
    private final UIContext m_uic;
    private final GameData m_data;
    public static final String LABEL_SELF = "----";

    public PoliticalStateOverview(GameData data, UIContext uic) {
        this.m_uic = uic;
        this.m_data = data;
        this.drawPoliticsUI();
    }

    private void drawPoliticsUI() {
        this.setLayout(new GridBagLayout());
        int currentCell = 1;
        Insets insets = new Insets(5, 2, 5, 2);
        for (PlayerID p : this.m_data.getPlayerList()) {
            this.add((Component)this.getPlayerLabel(p), new GridBagConstraints(currentCell++, 0, 1, 1, 1.0, 1.0, 10, 1, insets, 0, 0));
        }
        currentCell = 1;
        for (PlayerID p : this.m_data.getPlayerList()) {
            this.add((Component)new JSeparator(), new GridBagConstraints(0, currentCell++, 20, 1, 0.1, 0.1, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.getPlayerLabel(p), new GridBagConstraints(0, currentCell++, 1, 1, 1.0, 1.0, 17, 1, insets, 0, 0));
        }
        int x = 1;
        int y = 2;
        for (PlayerID pVertical : this.m_data.getPlayerList()) {
            for (PlayerID pHorizontal : this.m_data.getPlayerList()) {
                if (pHorizontal.equals(pVertical)) {
                    this.add((Component)new JLabel(LABEL_SELF), new GridBagConstraints(x++, y, 1, 1, 1.0, 1.0, 10, 0, insets, 0, 0));
                    continue;
                }
                this.add((Component)this.getRelationshipLabel(pVertical, pHorizontal), new GridBagConstraints(x++, y, 1, 1, 1.0, 1.0, 10, 1, insets, 0, 0));
            }
            y += 2;
            x = 1;
        }
    }

    private JPanel getRelationshipLabel(PlayerID player1, PlayerID player2) {
        this.m_data.acquireReadLock();
        RelationshipType relType = this.m_data.getRelationshipTracker().getRelationshipType(player1, player2);
        this.m_data.releaseReadLock();
        JLabel relationshipLabel = new JLabel(relType.getName());
        JPanel relationshipLabelPanel = new JPanel();
        relationshipLabelPanel.add(relationshipLabel);
        relationshipLabelPanel.setBackground(this.getRelationshipTypeColor(relType));
        return relationshipLabelPanel;
    }

    private Color getRelationshipTypeColor(RelationshipType relType) {
        String archeType = relType.getRelationshipTypeAttachment().getArcheType();
        if (archeType.equals("allied")) {
            return Color.green;
        }
        if (archeType.equals("neutral")) {
            return Color.lightGray;
        }
        if (archeType.equals("war")) {
            return Color.red;
        }
        throw new IllegalStateException("PoliticsUI: RelationshipType: " + relType.getName() + " can only be of archeType Allied, Neutral or War");
    }

    protected JLabel getPlayerLabel(PlayerID player) {
        return new JLabel(player.getName(), new ImageIcon(this.m_uic.getFlagImageFactory().getFlag(player)), 2);
    }

    public void redrawPolitics() {
        this.removeAll();
        this.drawPoliticsUI();
        this.updateUI();
    }
}

