/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.TechnologyFrontier;
import games.strategy.triplea.attatchments.PlayerAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.TechAdvance;
import games.strategy.triplea.delegate.TechTracker;
import games.strategy.triplea.delegate.dataObjects.TechRoll;
import games.strategy.triplea.ui.ActionPanel;
import games.strategy.triplea.ui.MapPanel;
import games.strategy.triplea.ui.TechRollPanel;
import games.strategy.triplea.ui.TechTokenPanel;
import games.strategy.util.IntegerMap;
import games.strategy.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TechPanel
extends ActionPanel {
    private static final long serialVersionUID = -6477919141575138007L;
    private final JLabel m_actionLabel = new JLabel();
    private TechRoll m_techRoll;
    private int m_currTokens = 0;
    private int m_quantity;
    private IntegerMap<PlayerID> m_whoPaysHowMuch = null;
    private final Action GetTechRollsAction = new AbstractAction("Roll Tech..."){
        private static final long serialVersionUID = -5077755928034508263L;

        public void actionPerformed(ActionEvent event) {
            TechAdvance advance = null;
            if (TechPanel.this.isWW2V2() || TechPanel.this.isSelectableTechRoll() && !TechPanel.this.isWW2V3TechModel()) {
                List available = TechPanel.this.getAvailableTechs();
                if (available.isEmpty()) {
                    JOptionPane.showMessageDialog(TechPanel.this, "No more available tech advances");
                    return;
                }
                JList list = new JList(new Vector(available));
                JPanel panel = new JPanel();
                panel.setLayout(new BorderLayout());
                panel.add(list, "Center");
                panel.add((Component)new JLabel("Select the tech you want to roll for"), "North");
                list.setSelectedIndex(0);
                JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(TechPanel.this), panel, "Select advance", -1);
                advance = (TechAdvance)list.getSelectedValue();
            }
            int PUs = TechPanel.this.getCurrentPlayer().getResources().getQuantity("PUs");
            String message = "Roll Tech";
            TechRollPanel techRollPanel = new TechRollPanel(PUs, TechPanel.this.getCurrentPlayer());
            int choice = JOptionPane.showConfirmDialog(TechPanel.this.getTopLevelAncestor(), techRollPanel, "Roll Tech", 2, -1, null);
            if (choice != 0) {
                return;
            }
            int quantity = techRollPanel.getValue();
            if (advance == null) {
                TechPanel.this.m_techRoll = new TechRoll(null, quantity);
            } else {
                TechnologyFrontier front = new TechnologyFrontier("", TechPanel.this.getData());
                front.addAdvance(advance);
                TechPanel.this.m_techRoll = new TechRoll(front, quantity);
            }
            TechPanel.this.release();
        }
    };
    private final Action DontBother = new AbstractAction("Done"){
        private static final long serialVersionUID = -7065334229434684387L;

        public void actionPerformed(ActionEvent event) {
            TechPanel.this.m_techRoll = null;
            TechPanel.this.release();
        }
    };
    private final Action GetTechTokenAction = new AbstractAction("Buy Tech Tokens..."){
        private static final long serialVersionUID = 6541224254805479410L;

        public void actionPerformed(ActionEvent event) {
            PlayerID currentPlayer = TechPanel.this.getCurrentPlayer();
            TechPanel.this.m_currTokens = currentPlayer.getResources().getQuantity("techTokens");
            List techCategories = TechPanel.this.getAvailableCategories();
            if (techCategories.isEmpty()) {
                JOptionPane.showMessageDialog(TechPanel.this, "No more available tech advances");
                return;
            }
            TechnologyFrontier category = null;
            JList list = new JList(new Vector(techCategories));
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add(list, "Center");
            panel.add((Component)new JLabel("Select which tech chart you want to roll for"), "North");
            list.setSelectedIndex(0);
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(TechPanel.this), panel, "Select chart", -1);
            category = (TechnologyFrontier)list.getSelectedValue();
            int PUs = currentPlayer.getResources().getQuantity("PUs");
            String message = "Purchase Tech Tokens";
            PlayerAttachment pa = PlayerAttachment.get(currentPlayer);
            ArrayList<PlayerID> helpPay = pa != null ? pa.getHelpPayTechCost() : null;
            TechTokenPanel techTokenPanel = new TechTokenPanel(PUs, TechPanel.this.m_currTokens, currentPlayer, helpPay);
            int choice = JOptionPane.showConfirmDialog(TechPanel.this.getTopLevelAncestor(), techTokenPanel, "Purchase Tech Tokens", 2, -1, null);
            if (choice != 0) {
                return;
            }
            TechPanel.this.m_quantity = techTokenPanel.getValue();
            TechPanel.this.m_whoPaysHowMuch = techTokenPanel.getWhoPaysHowMuch();
            TechPanel.this.m_currTokens += TechPanel.this.m_quantity;
            TechPanel.this.m_techRoll = new TechRoll(category, TechPanel.this.m_currTokens, TechPanel.this.m_quantity, TechPanel.this.m_whoPaysHowMuch);
            TechPanel.this.m_techRoll.setNewTokens(TechPanel.this.m_quantity);
            TechPanel.this.release();
        }
    };
    private final Action JustRollTech = new AbstractAction("Done/Roll Current Tokens"){
        private static final long serialVersionUID = -4709625797723985960L;

        public void actionPerformed(ActionEvent event) {
            TechPanel.this.m_currTokens = TechPanel.this.getCurrentPlayer().getResources().getQuantity("techTokens");
            if (TechPanel.this.m_currTokens > 0) {
                List techCategories = TechPanel.this.getAvailableCategories();
                if (techCategories.isEmpty()) {
                    return;
                }
                TechnologyFrontier category = null;
                JList list = new JList(new Vector(techCategories));
                JPanel panel = new JPanel();
                panel.setLayout(new BorderLayout());
                panel.add(list, "Center");
                panel.add((Component)new JLabel("Select which tech chart you want to roll for"), "North");
                list.setSelectedIndex(0);
                JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(TechPanel.this), panel, "Select chart", -1);
                category = (TechnologyFrontier)list.getSelectedValue();
                TechPanel.this.m_techRoll = new TechRoll(category, TechPanel.this.m_currTokens);
            } else {
                TechPanel.this.m_techRoll = null;
            }
            TechPanel.this.release();
        }
    };

    public TechPanel(GameData data, MapPanel map) {
        super(data, map);
    }

    @Override
    public void display(final PlayerID id) {
        super.display(id);
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                TechPanel.this.removeAll();
                TechPanel.this.m_actionLabel.setText(id.getName() + " Tech Roll");
                TechPanel.this.add(TechPanel.this.m_actionLabel);
                if (TechPanel.this.isWW2V3TechModel()) {
                    TechPanel.this.add(new JButton(TechPanel.this.GetTechTokenAction));
                    TechPanel.this.add(new JButton(TechPanel.this.JustRollTech));
                } else {
                    TechPanel.this.add(new JButton(TechPanel.this.GetTechRollsAction));
                    TechPanel.this.add(new JButton(TechPanel.this.DontBother));
                }
                TechPanel.this.getData().acquireReadLock();
                try {
                    TechPanel.this.getMap().centerOn(TerritoryAttachment.getCapital(id, TechPanel.this.getData()));
                }
                finally {
                    TechPanel.this.getData().releaseReadLock();
                }
            }
        });
    }

    @Override
    public String toString() {
        return "TechPanel";
    }

    public TechRoll waitForTech() {
        if (this.getAvailableTechs().isEmpty()) {
            return null;
        }
        this.waitForRelease();
        if (this.m_techRoll == null) {
            return null;
        }
        if (this.m_techRoll.getRolls() == 0) {
            return null;
        }
        return this.m_techRoll;
    }

    private List<TechAdvance> getAvailableTechs() {
        Collection<TechAdvance> currentAdvances = TechTracker.getTechAdvances(this.getCurrentPlayer(), this.getData());
        List<TechAdvance> allAdvances = TechAdvance.getTechAdvances(this.getData(), this.getCurrentPlayer());
        return Util.difference(allAdvances, currentAdvances);
    }

    private List<TechnologyFrontier> getAvailableCategories() {
        Collection<TechnologyFrontier> currentAdvances = TechTracker.getTechCategories(this.getData(), this.getCurrentPlayer());
        List<TechnologyFrontier> allAdvances = TechAdvance.getTechCategories(this.getData(), this.getCurrentPlayer());
        return Util.difference(allAdvances, currentAdvances);
    }
}

