/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.PlayerID;
import games.strategy.triplea.delegate.TechTracker;
import games.strategy.ui.ScrollableTextField;
import games.strategy.ui.ScrollableTextFieldListener;
import games.strategy.util.IntegerMap;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TechTokenPanel
extends JPanel {
    private static final long serialVersionUID = 332026624893335993L;
    int m_PUs;
    PlayerID m_player;
    JLabel m_left = new JLabel();
    JLabel m_right = new JLabel();
    ScrollableTextField m_textField;
    HashMap<PlayerID, ScrollableTextField> m_whoPaysTextFields = null;
    private final ScrollableTextFieldListener m_listener = new ScrollableTextFieldListener(){

        public void changedValue(ScrollableTextField stf) {
            TechTokenPanel.this.setLabel(TechTokenPanel.this.m_PUs - TechTracker.getTechCost(TechTokenPanel.this.m_player) * TechTokenPanel.this.m_textField.getValue());
        }
    };

    TechTokenPanel(int PUs, int currTokens, PlayerID player, Collection<PlayerID> helpPay) {
        this.m_PUs = PUs;
        if (helpPay != null && !helpPay.isEmpty()) {
            helpPay.remove(player);
            for (PlayerID p : helpPay) {
                this.m_PUs += p.getResources().getQuantity("PUs");
            }
        }
        this.setLayout(new GridBagLayout());
        this.m_player = player;
        JLabel title = new JLabel("Select the number of tech tokens to purchase:");
        title.setBorder(new EmptyBorder(5, 5, 5, 5));
        int techCost = TechTracker.getTechCost(this.m_player);
        this.m_textField = new ScrollableTextField(0, this.m_PUs / techCost);
        this.m_textField.addChangeListener(this.m_listener);
        JLabel costLabel = new JLabel("x" + techCost);
        this.setLabel(this.m_PUs);
        this.setTokens(currTokens);
        boolean space = false;
        this.add((Component)title, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.m_textField, new GridBagConstraints(0, 1, 1, 1, 0.5, 1.0, 13, 0, new Insets(8, 10, 0, 0), 0, 0));
        this.add((Component)costLabel, new GridBagConstraints(1, 1, 1, 1, 0.5, 1.0, 17, 0, new Insets(8, 5, 0, 2), 0, 0));
        this.add((Component)this.m_left, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_right, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 17, 0, new Insets(10, 120, 0, 0), 0, 0));
        if (helpPay != null && !helpPay.isEmpty()) {
            if (this.m_whoPaysTextFields == null) {
                this.m_whoPaysTextFields = new HashMap();
            }
            helpPay.remove(player);
            int row = 3;
            this.add((Component)new JLabel(" "), new GridBagConstraints(0, row, 1, 1, 0.5, 1.0, 13, 0, new Insets(6, 6, 6, 6), 0, 0));
            this.add((Component)new JLabel("Other Nations Helping To Pay:"), new GridBagConstraints(0, ++row, 1, 1, 0.5, 1.0, 13, 0, new Insets(6, 6, 6, 6), 0, 0));
            ++row;
            for (PlayerID p : helpPay) {
                int helperPUs = p.getResources().getQuantity("PUs");
                if (helperPUs <= 0) continue;
                ScrollableTextField whoPaysTextField = new ScrollableTextField(0, helperPUs);
                this.m_whoPaysTextFields.put(p, whoPaysTextField);
                this.add((Component)new JLabel(p.getName()), new GridBagConstraints(0, row, 1, 1, 0.5, 1.0, 10, 0, new Insets(6, 6, 6, 6), 0, 0));
                this.add((Component)whoPaysTextField, new GridBagConstraints(1, row, 1, 1, 0.5, 1.0, 10, 0, new Insets(6, 6, 6, 6), 0, 0));
                this.add((Component)new JLabel("PUs"), new GridBagConstraints(2, row, 1, 1, 0.5, 1.0, 10, 0, new Insets(6, 6, 6, 6), 0, 0));
                ++row;
            }
        }
    }

    private void setLabel(int PUs) {
        this.m_left.setText("Left to spend:" + PUs);
    }

    private void setTokens(int tokens) {
        this.m_right.setText("Current token count:" + tokens);
    }

    public int getValue() {
        return this.m_textField.getValue();
    }

    public IntegerMap<PlayerID> getWhoPaysHowMuch() {
        int techCost = TechTracker.getTechCost(this.m_player);
        int numberOfTechRolls = this.getValue();
        int totalCost = numberOfTechRolls * techCost;
        IntegerMap<PlayerID> whoPaysHowMuch = new IntegerMap<PlayerID>();
        if (this.m_whoPaysTextFields == null || this.m_whoPaysTextFields.isEmpty()) {
            whoPaysHowMuch.put(this.m_player, totalCost);
        } else {
            int runningTotal = 0;
            for (Map.Entry<PlayerID, ScrollableTextField> entry : this.m_whoPaysTextFields.entrySet()) {
                int value = entry.getValue().getValue();
                whoPaysHowMuch.put(entry.getKey(), value);
                runningTotal += value;
            }
            if (!this.m_whoPaysTextFields.containsKey(this.m_player)) {
                whoPaysHowMuch.put(this.m_player, Math.max(0, totalCost - runningTotal));
            }
        }
        return whoPaysHowMuch;
    }
}

