/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui.screen;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.Unit;
import games.strategy.thread.LockUtil;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.TerritoryEffectHelper;
import games.strategy.triplea.ui.MapData;
import games.strategy.triplea.ui.UIContext;
import games.strategy.triplea.ui.screen.BaseMapDrawable;
import games.strategy.triplea.ui.screen.BattleDrawable;
import games.strategy.triplea.ui.screen.BlockadeZoneDrawable;
import games.strategy.triplea.ui.screen.CapitolMarkerDrawable;
import games.strategy.triplea.ui.screen.ConvoyZoneDrawable;
import games.strategy.triplea.ui.screen.DecoratorDrawable;
import games.strategy.triplea.ui.screen.DrawableComparator;
import games.strategy.triplea.ui.screen.IDrawable;
import games.strategy.triplea.ui.screen.KamikazeZoneDrawable;
import games.strategy.triplea.ui.screen.LandTerritoryDrawable;
import games.strategy.triplea.ui.screen.MapTileDrawable;
import games.strategy.triplea.ui.screen.ReliefMapDrawable;
import games.strategy.triplea.ui.screen.SeaZoneOutlineDrawable;
import games.strategy.triplea.ui.screen.TerritoryEffectDrawable;
import games.strategy.triplea.ui.screen.TerritoryNameDrawable;
import games.strategy.triplea.ui.screen.TerritoryOverLayDrawable;
import games.strategy.triplea.ui.screen.Tile;
import games.strategy.triplea.ui.screen.UnitsDrawer;
import games.strategy.triplea.ui.screen.VCDrawable;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.triplea.util.UnitSeperator;
import games.strategy.ui.Util;
import games.strategy.util.Tuple;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TileManager {
    private static final Logger s_logger = Logger.getLogger(TileManager.class.getName());
    public static final int TILE_SIZE = 256;
    private List<Tile> m_tiles = new ArrayList<Tile>();
    private final Lock m_lock = new ReentrantLock();
    private final Map<String, IDrawable> m_territoryOverlays = new HashMap<String, IDrawable>();
    private final Map<String, Set<IDrawable>> m_territoryDrawables = new HashMap<String, Set<IDrawable>>();
    private final Map<String, Set<Tile>> m_territoryTiles = new HashMap<String, Set<Tile>>();
    private final Collection<UnitsDrawer> m_allUnitDrawables = new ArrayList<UnitsDrawer>();
    private final UIContext m_uiContext;

    public TileManager(UIContext context) {
        this.m_uiContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tile> getTiles(Rectangle2D bounds) {
        LockUtil.acquireLock(this.m_lock);
        try {
            ArrayList<Tile> rVal = new ArrayList<Tile>();
            for (Tile tile : this.m_tiles) {
                if (!bounds.contains(tile.getBounds()) && !tile.getBounds().intersects(bounds)) continue;
                rVal.add(tile);
            }
            ArrayList<Tile> arrayList = rVal;
            return arrayList;
        }
        finally {
            LockUtil.releaseLock(this.m_lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<UnitsDrawer> getUnitDrawables() {
        LockUtil.acquireLock(this.m_lock);
        try {
            ArrayList<UnitsDrawer> arrayList = new ArrayList<UnitsDrawer>(this.m_allUnitDrawables);
            return arrayList;
        }
        finally {
            LockUtil.releaseLock(this.m_lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTiles(Rectangle bounds, GameData data, MapData mapData) {
        LockUtil.acquireLock(this.m_lock);
        try {
            this.m_tiles = new ArrayList<Tile>();
            int x = 0;
            while (x * 256 < bounds.width) {
                int y = 0;
                while (y * 256 < bounds.height) {
                    this.m_tiles.add(new Tile(new Rectangle(x * 256, y * 256, 256, 256), x, y, this.m_uiContext.getScale()));
                    ++y;
                }
                ++x;
            }
        }
        finally {
            LockUtil.releaseLock(this.m_lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTiles(GameData data, MapData mapData) {
        data.acquireReadLock();
        try {
            LockUtil.acquireLock(this.m_lock);
            try {
                for (Tile tile : this.m_tiles) {
                    tile.clear();
                    int x = tile.getBounds().x / 256;
                    int y = tile.getBounds().y / 256;
                    tile.addDrawable(new BaseMapDrawable(x, y, this.m_uiContext));
                    tile.addDrawable(new ReliefMapDrawable(x, y, this.m_uiContext));
                }
                for (Territory territory : data.getMap().getTerritories()) {
                    this.clearTerritory(territory);
                    this.drawTerritory(territory, data, mapData);
                }
                Map<Image, List<Point>> decorations = mapData.getDecorations();
                for (Image img : decorations.keySet()) {
                    for (Point p : decorations.get(img)) {
                        DecoratorDrawable drawable = new DecoratorDrawable(p, img);
                        Rectangle bounds = new Rectangle(p.x, p.y, img.getWidth(null), img.getHeight(null));
                        for (Tile t : this.getTiles(bounds)) {
                            t.addDrawable(drawable);
                        }
                    }
                }
            }
            finally {
                LockUtil.releaseLock(this.m_lock);
            }
        }
        finally {
            data.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTerritories(Collection<Territory> territories, GameData data, MapData mapData) {
        data.acquireReadLock();
        try {
            LockUtil.acquireLock(this.m_lock);
            try {
                if (territories == null) {
                    return;
                }
                for (Territory territory : territories) {
                    this.updateTerritory(territory, data, mapData);
                }
            }
            finally {
                LockUtil.releaseLock(this.m_lock);
            }
        }
        finally {
            data.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTerritory(Territory territory, GameData data, MapData mapData) {
        data.acquireReadLock();
        LockUtil.acquireLock(this.m_lock);
        try {
            s_logger.log(Level.FINER, "Updating " + territory.getName());
            this.clearTerritory(territory);
            this.drawTerritory(territory, data, mapData);
        }
        finally {
            LockUtil.releaseLock(this.m_lock);
            data.releaseReadLock();
        }
    }

    private void clearTerritory(Territory territory) {
        if (this.m_territoryTiles.get(territory.getName()) == null) {
            return;
        }
        Collection drawables = this.m_territoryDrawables.get(territory.getName());
        if (drawables == null || drawables.isEmpty()) {
            return;
        }
        for (Tile tile : this.m_territoryTiles.get(territory.getName())) {
            tile.removeDrawables(drawables);
        }
        this.m_allUnitDrawables.removeAll(drawables);
    }

    private void drawTerritory(Territory territory, GameData data, MapData mapData) {
        HashSet<Tile> drawnOn = new HashSet<Tile>();
        HashSet<IDrawable> drawing = new HashSet<IDrawable>();
        if (this.m_territoryOverlays.get(territory.getName()) != null) {
            drawing.add(this.m_territoryOverlays.get(territory.getName()));
        }
        if (this.m_uiContext.getShowTerritoryEffects()) {
            this.drawTerritoryEffects(territory, data, mapData, drawnOn, drawing);
        }
        if (this.m_uiContext.getShowUnits()) {
            this.drawUnits(territory, data, mapData, drawnOn, drawing);
        }
        drawing.add(new BattleDrawable(territory.getName()));
        if (!territory.isWater()) {
            drawing.add(new LandTerritoryDrawable(territory.getName()));
        } else {
            if (TerritoryAttachment.get(territory) != null) {
                if (TerritoryAttachment.get(territory).getKamikazeZone()) {
                    drawing.add(new KamikazeZoneDrawable(territory.getOwner(), territory, this.m_uiContext));
                }
                if (TerritoryAttachment.get(territory).getBlockadeZone()) {
                    drawing.add(new BlockadeZoneDrawable(territory, this.m_uiContext));
                }
                if (TerritoryAttachment.get(territory).getConvoyRoute()) {
                    drawing.add(new ConvoyZoneDrawable(territory.getOwner(), territory, this.m_uiContext));
                }
                if (TerritoryAttachment.get(territory).getProduction() > 0) {
                    drawing.add(new ConvoyZoneDrawable(territory.getOwner(), territory, this.m_uiContext));
                }
            }
            drawing.add(new SeaZoneOutlineDrawable(territory.getName()));
        }
        drawing.add(new TerritoryNameDrawable(territory.getName(), this.m_uiContext));
        TerritoryAttachment ta = TerritoryAttachment.get(territory);
        if (ta != null && ta.isCapital() && mapData.drawCapitolMarkers()) {
            PlayerID capitalOf = data.getPlayerList().getPlayerID(ta.getCapital());
            drawing.add(new CapitolMarkerDrawable(capitalOf, territory, this.m_uiContext));
        }
        if (ta != null && ta.getVictoryCity()) {
            drawing.add(new VCDrawable(territory));
        }
        for (Tile tile : this.getTiles(mapData.getBoundingRect(territory.getName()))) {
            drawnOn.add(tile);
            tile.addDrawables(drawing);
        }
        this.m_territoryDrawables.put(territory.getName(), drawing);
        this.m_territoryTiles.put(territory.getName(), drawnOn);
    }

    private void drawTerritoryEffects(Territory territory, GameData data, MapData mapData, Set<Tile> drawnOn, Set<IDrawable> drawing) {
        Iterator<Point> effectPoints = mapData.getTerritoryEffectPoints(territory).iterator();
        Point drawingPoint = effectPoints.next();
        for (TerritoryEffect te : TerritoryEffectHelper.getEffects(territory)) {
            drawing.add(new TerritoryEffectDrawable(te, drawingPoint));
            drawingPoint = effectPoints.hasNext() ? effectPoints.next() : drawingPoint;
        }
    }

    private void drawUnits(Territory territory, GameData data, MapData mapData, Set<Tile> drawnOn, Set<IDrawable> drawing) {
        Iterator<Point> placementPoints = mapData.getPlacementPoints(territory).iterator();
        if (placementPoints == null || !placementPoints.hasNext()) {
            throw new IllegalStateException("No where to place units:" + territory.getName());
        }
        Point lastPlace = null;
        for (UnitCategory category : UnitSeperator.categorize(territory.getUnits().getUnits())) {
            boolean overflow;
            if (placementPoints.hasNext()) {
                lastPlace = new Point(placementPoints.next());
                overflow = false;
            } else {
                lastPlace = new Point(lastPlace);
                lastPlace.x += this.m_uiContext.getUnitImageFactory().getUnitImageWidth();
                overflow = true;
            }
            UnitsDrawer drawable = new UnitsDrawer(category.getUnits().size(), category.getType().getName(), category.getOwner().getName(), lastPlace, category.getDamaged(), category.getDisabled(), overflow, territory.getName(), this.m_uiContext);
            drawing.add(drawable);
            this.m_allUnitDrawables.add(drawable);
            for (Tile tile : this.getTiles(new Rectangle(lastPlace.x, lastPlace.y, this.m_uiContext.getUnitImageFactory().getUnitImageWidth(), this.m_uiContext.getUnitImageFactory().getUnitImageHeight()))) {
                tile.addDrawable(drawable);
                drawnOn.add(tile);
            }
        }
    }

    public Image createTerritoryImage(Territory t, GameData data, MapData mapData) {
        return this.createTerritoryImage(t, t, data, mapData, true);
    }

    public Image createTerritoryImage(Territory selected, Territory focusOn, GameData data, MapData mapData) {
        return this.createTerritoryImage(selected, focusOn, data, mapData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image createTerritoryImage(Territory selected, Territory focusOn, GameData data, MapData mapData, boolean drawOutline) {
        LockUtil.acquireLock(this.m_lock);
        try {
            int move;
            Rectangle bounds = mapData.getBoundingRect(focusOn);
            if (bounds.width > bounds.height) {
                bounds.height = bounds.width;
            } else {
                bounds.width = bounds.height;
            }
            int grow = bounds.width / 4;
            bounds.x -= grow;
            bounds.y -= grow;
            bounds.width += grow * 2;
            bounds.height += grow * 2;
            if (bounds.x < 0 && !mapData.scrollWrapX()) {
                bounds.x = 0;
            }
            if (bounds.y < 0) {
                bounds.y = 0;
            }
            if (bounds.width + bounds.x > mapData.getMapDimensions().width && !mapData.scrollWrapX()) {
                move = bounds.width + bounds.x - mapData.getMapDimensions().width;
                bounds.x -= move;
            }
            if (bounds.height + bounds.y > mapData.getMapDimensions().height) {
                move = bounds.height + bounds.y - mapData.getMapDimensions().height;
                bounds.y -= move;
            }
            if (bounds.width != bounds.height) {
                throw new IllegalStateException("NOt equal");
            }
            BufferedImage rVal = Util.createImage(bounds.width, bounds.height, false);
            Graphics2D graphics = (Graphics2D)((Image)rVal).getGraphics();
            if (bounds.x < 0) {
                bounds.x += mapData.getMapDimensions().width;
                this.drawForCreate(selected, data, mapData, bounds, graphics, drawOutline);
                bounds.x -= mapData.getMapDimensions().width;
            }
            this.drawForCreate(selected, data, mapData, bounds, graphics, drawOutline);
            if (bounds.x + bounds.height > mapData.getMapDimensions().width) {
                bounds.x -= mapData.getMapDimensions().width;
                this.drawForCreate(selected, data, mapData, bounds, graphics, drawOutline);
                bounds.x += mapData.getMapDimensions().width;
            }
            graphics.dispose();
            BufferedImage bufferedImage = rVal;
            return bufferedImage;
        }
        finally {
            LockUtil.releaseLock(this.m_lock);
        }
    }

    private void drawForCreate(Territory selected, GameData data, MapData mapData, Rectangle bounds, Graphics2D graphics, boolean drawOutline) {
        IDrawable drawer;
        HashSet<IDrawable> drawablesSet = new HashSet<IDrawable>();
        List<Tile> intersectingTiles = this.getTiles(bounds);
        for (Tile tile : intersectingTiles) {
            drawablesSet.addAll(tile.getDrawables());
        }
        if (this.m_uiContext.getScale() != 1.0) {
            ArrayList<MapTileDrawable> toAdd = new ArrayList<MapTileDrawable>();
            Iterator iter = drawablesSet.iterator();
            while (iter.hasNext()) {
                IDrawable drawable = (IDrawable)iter.next();
                if (!(drawable instanceof MapTileDrawable)) continue;
                iter.remove();
                toAdd.add(((MapTileDrawable)drawable).getUnscaledCopy());
            }
            drawablesSet.addAll(toAdd);
        }
        ArrayList orderedDrawables = new ArrayList(drawablesSet);
        Collections.sort(orderedDrawables, new DrawableComparator());
        Iterator drawers = orderedDrawables.iterator();
        while (drawers.hasNext() && (drawer = (IDrawable)drawers.next()).getLevel() < 12) {
            if (drawer.getLevel() == 10) continue;
            drawer.draw(bounds, data, graphics, mapData, null, null);
        }
        if (!drawOutline) {
            Color c;
            if (selected.isWater()) {
                c = Color.RED;
            } else {
                c = mapData.getPlayerColor(selected.getOwner().getName());
                c = new Color(c.getRed() ^ c.getRed(), c.getGreen() ^ c.getGreen(), c.getRed() ^ c.getRed());
            }
            TerritoryOverLayDrawable told = new TerritoryOverLayDrawable(c, selected.getName(), 100, TerritoryOverLayDrawable.OP.FILL);
            told.draw(bounds, data, graphics, mapData, null, null);
        }
        Iterator<Polygon> iter = mapData.getPolygons(selected).iterator();
        graphics.setStroke(new BasicStroke(10.0f));
        graphics.setColor(Color.RED);
        while (iter.hasNext()) {
            Polygon poly = iter.next();
            poly = new Polygon(poly.xpoints, poly.ypoints, poly.npoints);
            poly.translate(-bounds.x, -bounds.y);
            graphics.drawPolygon(poly);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getUnitRect(List<Unit> units, GameData data) {
        if (units == null) {
            return null;
        }
        data.acquireReadLock();
        LockUtil.acquireLock(this.m_lock);
        try {
            for (UnitsDrawer drawer : this.m_allUnitDrawables) {
                List<Unit> drawerUnits = drawer.getUnits(data).getSecond();
                if (drawerUnits.isEmpty() || !units.containsAll(drawerUnits)) continue;
                Point placementPoint = drawer.getPlacementPoint();
                Rectangle rectangle = new Rectangle(placementPoint.x, placementPoint.y, this.m_uiContext.getUnitImageFactory().getUnitImageWidth(), this.m_uiContext.getUnitImageFactory().getUnitImageHeight());
                return rectangle;
            }
            Rectangle rectangle = null;
            return rectangle;
        }
        finally {
            LockUtil.releaseLock(this.m_lock);
            data.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple<Territory, List<Unit>> getUnitsAtPoint(double x, double y, GameData gameData) {
        gameData.acquireReadLock();
        LockUtil.acquireLock(this.m_lock);
        try {
            for (UnitsDrawer drawer : this.m_allUnitDrawables) {
                Point placementPoint = drawer.getPlacementPoint();
                if (!(x > (double)placementPoint.x) || !(x < (double)(placementPoint.x + this.m_uiContext.getUnitImageFactory().getUnitImageWidth())) || !(y > (double)placementPoint.y) || !(y < (double)(placementPoint.y + this.m_uiContext.getUnitImageFactory().getUnitImageHeight()))) continue;
                Tuple<Territory, List<Unit>> tuple = drawer.getUnits(gameData);
                return tuple;
            }
            Tuple<Territory, List<Unit>> tuple = null;
            return tuple;
        }
        finally {
            LockUtil.releaseLock(this.m_lock);
            gameData.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTerritoryOverlay(Territory territory, Color color, int alpha, GameData data, MapData mapData) {
        LockUtil.acquireLock(this.m_lock);
        try {
            TerritoryOverLayDrawable drawable = new TerritoryOverLayDrawable(color, territory.getName(), alpha, TerritoryOverLayDrawable.OP.DRAW);
            this.m_territoryOverlays.put(territory.getName(), drawable);
        }
        finally {
            LockUtil.releaseLock(this.m_lock);
        }
        this.updateTerritory(territory, data, mapData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTerritoryOverlayForBorder(Territory territory, Color color, GameData data, MapData mapData) {
        LockUtil.acquireLock(this.m_lock);
        try {
            TerritoryOverLayDrawable drawable = new TerritoryOverLayDrawable(color, territory.getName(), TerritoryOverLayDrawable.OP.DRAW);
            this.m_territoryOverlays.put(territory.getName(), drawable);
        }
        finally {
            LockUtil.releaseLock(this.m_lock);
        }
        this.updateTerritory(territory, data, mapData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTerritoryOverlay(Territory territory, GameData data, MapData mapData) {
        LockUtil.acquireLock(this.m_lock);
        try {
            this.m_territoryOverlays.remove(territory.getName());
        }
        finally {
            LockUtil.releaseLock(this.m_lock);
        }
        this.updateTerritory(territory, data, mapData);
    }
}

