/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.util;

import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.attatchments.UnitTypeComparator;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.util.UnitOwner;
import games.strategy.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitCategory
implements Comparable {
    private final UnitType m_type;
    private Collection<UnitOwner> m_dependents;
    private final int m_movement;
    private final int m_transportCost;
    private final Territory m_originatingTerr;
    private final PlayerID m_owner;
    private final List<Unit> m_units = new ArrayList<Unit>();
    private boolean m_damaged = false;
    private boolean m_disabled = false;

    public UnitCategory(Unit unit, boolean categorizeDependents, boolean categorizeMovement, boolean categorizeTransportcost, boolean categorizeTerritory) {
        TripleAUnit taUnit = (TripleAUnit)unit;
        this.m_type = taUnit.getType();
        this.m_owner = taUnit.getOwner();
        this.m_movement = categorizeMovement ? taUnit.getMovementLeft() : -1;
        this.m_transportCost = categorizeTransportcost ? UnitAttachment.get(unit.getUnitType()).getTransportCost() : -1;
        this.m_originatingTerr = categorizeTerritory ? taUnit.getOriginatedFrom() : null;
        this.m_damaged = taUnit.getHits() > 0;
        this.m_disabled = Matches.UnitIsDisabled().match(unit);
        if (categorizeDependents) {
            this.createDependents(taUnit.getDependents());
        } else {
            this.m_dependents = Collections.emptyList();
        }
    }

    public UnitCategory(Unit unit, Collection<Unit> dependents, int movement, int transportCost) {
        this(unit, dependents, movement, false, false, transportCost, null);
    }

    public UnitCategory(UnitType type, PlayerID owner) {
        this.m_type = type;
        this.m_dependents = Collections.emptyList();
        this.m_movement = -1;
        this.m_transportCost = -1;
        this.m_owner = owner;
        this.m_originatingTerr = null;
    }

    public UnitCategory(Unit unit, Collection<Unit> dependents, int movement, boolean damaged, boolean disabled, int transportCost, Territory t) {
        this.m_type = unit.getType();
        this.m_movement = movement;
        this.m_transportCost = transportCost;
        this.m_owner = unit.getOwner();
        this.m_damaged = damaged;
        this.m_disabled = disabled;
        this.m_units.add(unit);
        this.m_originatingTerr = t;
        this.createDependents(dependents);
    }

    public boolean getDamaged() {
        return this.m_damaged;
    }

    public boolean getDisabled() {
        return this.m_disabled;
    }

    public boolean isTwoHit() {
        return UnitAttachment.get(this.m_type).getIsTwoHit();
    }

    private void createDependents(Collection<Unit> dependents) {
        this.m_dependents = new ArrayList<UnitOwner>();
        if (dependents == null) {
            return;
        }
        for (Unit current : dependents) {
            this.m_dependents.add(new UnitOwner(current));
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof UnitCategory)) {
            return false;
        }
        UnitCategory other = (UnitCategory)o;
        boolean equalsIgnoreDamaged = this.equalsIgnoreDamaged(other);
        boolean equalsIgnoreDisabled = this.equalsIgnoreDisabled(other);
        return equalsIgnoreDamaged && equalsIgnoreDisabled && other.m_damaged == this.m_damaged && other.m_disabled == this.m_disabled;
    }

    public boolean equalsIgnoreDamaged(UnitCategory other) {
        boolean equalsIgnoreDamaged = other.m_type.equals(this.m_type) && other.m_movement == this.m_movement && other.m_owner.equals(this.m_owner) && Util.equals(this.m_dependents, other.m_dependents);
        return equalsIgnoreDamaged;
    }

    public boolean equalsIgnoreDisabled(UnitCategory other) {
        boolean equalsIgnoreDisabled = other.m_type.equals(this.m_type) && other.m_movement == this.m_movement && other.m_owner.equals(this.m_owner) && Util.equals(this.m_dependents, other.m_dependents);
        return equalsIgnoreDisabled;
    }

    public boolean equalsIgnoreMovement(UnitCategory other) {
        boolean equalsIgnoreMovement = other.m_type.equals(this.m_type) && other.m_owner.equals(this.m_owner) && other.m_damaged == this.m_damaged && other.m_disabled == this.m_disabled && Util.equals(this.m_dependents, other.m_dependents);
        return equalsIgnoreMovement;
    }

    public boolean equalsIgnoreDependents(UnitCategory other) {
        boolean equalsIgnoreDependents = other.m_type.equals(this.m_type) && other.m_owner.equals(this.m_owner) && other.m_movement == this.m_movement && other.m_damaged == this.m_damaged && other.m_disabled == this.m_disabled;
        return equalsIgnoreDependents;
    }

    public int hashCode() {
        return this.m_type.hashCode() | this.m_owner.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Entry type:").append(this.m_type.getName()).append(" owner:").append(this.m_owner.getName()).append(" damaged:").append(this.m_damaged).append(" disabled:").append(this.m_disabled).append(" dependents:").append(this.m_dependents).append(" movement:").append(this.m_movement);
        return sb.toString();
    }

    public Collection<UnitOwner> getDependents() {
        return this.m_dependents;
    }

    public List<Unit> getUnits() {
        return this.m_units;
    }

    public int getMovement() {
        return this.m_movement;
    }

    public int getTransportCost() {
        return this.m_transportCost;
    }

    public PlayerID getOwner() {
        return this.m_owner;
    }

    public void addUnit(Unit unit) {
        this.m_units.add(unit);
    }

    void removeUnit(Unit unit) {
        this.m_units.remove(unit);
    }

    public UnitType getType() {
        return this.m_type;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return -1;
        }
        UnitCategory other = (UnitCategory)o;
        if (!other.m_owner.equals(this.m_owner)) {
            return this.m_owner.getName().compareTo(other.m_owner.getName());
        }
        int typeCompare = new UnitTypeComparator().compare(this.getType(), other.getType());
        if (typeCompare != 0) {
            return typeCompare;
        }
        if (this.m_movement != other.m_movement) {
            return this.m_movement - other.m_movement;
        }
        if (!Util.equals(this.m_dependents, other.m_dependents)) {
            return this.m_dependents.toString().compareTo(other.m_dependents.toString());
        }
        if (this.m_damaged != other.m_damaged) {
            if (this.m_damaged) {
                return 1;
            }
            return -1;
        }
        if (this.m_disabled != other.m_disabled) {
            if (this.m_disabled) {
                return 1;
            }
            return -1;
        }
        return 0;
    }
}

