/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.ui;

import games.strategy.ui.ImageScrollModel;
import games.strategy.ui.ScrollListener;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ImageScrollerLargeView
extends JComponent {
    private static final long serialVersionUID = -7212817233833868483L;
    static final int NONE = 0;
    static final int LEFT = 1;
    static final int RIGHT = 2;
    static final int TOP = 4;
    static final int BOTTOM = 8;
    static final int WHEEL_SCROLL_AMOUNT = 50;
    private static final int TOLERANCE = 25;
    private static final int SCROLL_DISTANCE = 30;
    protected final ImageScrollModel m_model;
    protected double m_scale = 1.0;
    private int m_drag_scrolling_lastx;
    private int m_drag_scrolling_lasty;
    private final ActionListener m_timerAction = new ActionListener(){

        public final void actionPerformed(ActionEvent e) {
            if (JOptionPane.getFrameForComponent(ImageScrollerLargeView.this).getFocusOwner() == null) {
                ImageScrollerLargeView.this.m_insideCount = 0;
                return;
            }
            if (ImageScrollerLargeView.this.m_inside && ImageScrollerLargeView.this.m_edge != 0) {
                ImageScrollerLargeView.this.m_insideCount++;
                if (ImageScrollerLargeView.this.m_insideCount > 6) {
                    SwingUtilities.invokeLater(new Scroller());
                }
            }
        }
    };
    private final Timer m_timer = new Timer(50, this.m_timerAction);
    private boolean m_inside = false;
    private int m_insideCount = 0;
    private int m_edge = 0;
    private final List<ScrollListener> m_scrollListeners = new ArrayList<ScrollListener>();
    private final MouseAdapter MOUSE_LISTENER = new MouseAdapter(){

        public void mouseEntered(MouseEvent e) {
            ImageScrollerLargeView.this.m_timer.start();
        }

        public void mouseExited(MouseEvent e) {
            ImageScrollerLargeView.this.m_inside = false;
            ImageScrollerLargeView.this.m_timer.stop();
        }
    };
    private final ComponentListener COMPONENT_LISTENER = new ComponentAdapter(){

        public void componentResized(ComponentEvent e) {
            ImageScrollerLargeView.this.refreshBoxSize();
        }
    };
    private final MouseWheelListener MOUSE_WHEEL_LISTENER = new MouseWheelListener(){

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (!e.isAltDown()) {
                if (ImageScrollerLargeView.this.m_edge == 0) {
                    ImageScrollerLargeView.this.m_insideCount = 0;
                }
                int dx = 0;
                int dy = 0;
                if ((e.getModifiersEx() & 0x40) == 64) {
                    dx = e.getWheelRotation() * 50;
                } else {
                    dy = e.getWheelRotation() * 50;
                }
                int newX = ImageScrollerLargeView.this.m_model.getX() + dx;
                if (newX > ImageScrollerLargeView.this.m_model.getMaxWidth() - ImageScrollerLargeView.this.getWidth()) {
                    newX -= ImageScrollerLargeView.this.m_model.getMaxWidth();
                }
                if (newX < -ImageScrollerLargeView.this.getWidth()) {
                    newX += ImageScrollerLargeView.this.m_model.getMaxWidth();
                }
                int newY = ImageScrollerLargeView.this.m_model.getY() + dy;
                ImageScrollerLargeView.this.m_model.set(newX, newY);
            } else {
                double value = ImageScrollerLargeView.this.m_scale;
                int positive = 1;
                if (e.getUnitsToScroll() > 0) {
                    positive = -1;
                }
                if (positive > 0 && value == 1.0 || positive < 0 && value <= 0.21) {
                    return;
                }
                value = positive > 0 ? (value >= 0.79 ? 1.0 : (value >= 0.59 ? 0.8 : (value >= 0.39 ? 0.6 : (value >= 0.19 ? 0.4 : 0.2)))) : (value <= 0.41 ? 0.2 : (value <= 0.61 ? 0.4 : (value <= 0.81 ? 0.6 : (value <= 1.0 ? 0.8 : 1.0))));
                ImageScrollerLargeView.this.setScale(value);
            }
        }
    };
    private final MouseMotionListener MOUSE_DRAG_LISTENER = new MouseMotionAdapter(){

        public void mouseDragged(MouseEvent e) {
            if ((e.getModifiers() & 4) != 0) {
                ImageScrollerLargeView.this.m_inside = false;
                int x = e.getX();
                int y = e.getY();
                if (ImageScrollerLargeView.this.m_edge == 0) {
                    ImageScrollerLargeView.this.m_insideCount = 0;
                }
                int dx = ImageScrollerLargeView.this.m_drag_scrolling_lastx - x;
                int dy = ImageScrollerLargeView.this.m_drag_scrolling_lasty - y;
                int newX = ImageScrollerLargeView.this.m_model.getX() + dx;
                int newY = ImageScrollerLargeView.this.m_model.getY() + dy;
                ImageScrollerLargeView.this.m_model.set(newX, newY);
                ImageScrollerLargeView.this.m_drag_scrolling_lastx = e.getX();
                ImageScrollerLargeView.this.m_drag_scrolling_lasty = e.getY();
            }
        }
    };
    private final MouseAdapter MOUSE_LISTENER_DRAG_SCROLLING = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            ImageScrollerLargeView.this.m_drag_scrolling_lastx = e.getX();
            ImageScrollerLargeView.this.m_drag_scrolling_lasty = e.getY();
        }
    };
    private final MouseMotionListener MOUSE_MOTION_LISTENER = new MouseMotionAdapter(){

        public void mouseMoved(MouseEvent e) {
            ImageScrollerLargeView.this.m_inside = true;
            int x = e.getX();
            int y = e.getY();
            int height = ImageScrollerLargeView.this.getHeight();
            int width = ImageScrollerLargeView.this.getWidth();
            ImageScrollerLargeView.this.m_edge = ImageScrollerLargeView.this.getNewEdge(x, y, width, height);
            if (ImageScrollerLargeView.this.m_edge == 0) {
                ImageScrollerLargeView.this.m_insideCount = 0;
            }
        }
    };

    public ImageScrollerLargeView(Dimension dimension, ImageScrollModel model) {
        this.m_model = model;
        this.m_model.setMaxBounds((int)dimension.getWidth(), (int)dimension.getHeight());
        this.setPreferredSize(this.getImageDimensions());
        this.setMaximumSize(this.getImageDimensions());
        this.addMouseWheelListener(this.MOUSE_WHEEL_LISTENER);
        this.addMouseListener(this.MOUSE_LISTENER);
        this.addMouseListener(this.MOUSE_LISTENER_DRAG_SCROLLING);
        this.addMouseMotionListener(this.MOUSE_MOTION_LISTENER);
        this.addMouseMotionListener(this.MOUSE_DRAG_LISTENER);
        this.addComponentListener(this.COMPONENT_LISTENER);
        this.m_timer.start();
        this.m_model.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                ImageScrollerLargeView.this.repaint();
                ImageScrollerLargeView.this.notifyScollListeners();
            }
        });
    }

    protected void setTopLeft(int x, int y) {
        this.m_model.set(x, y);
    }

    protected void setTopLeftNoWrap(int x, int y) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        this.m_model.set(x, y);
    }

    public int getImageWidth() {
        return this.m_model.getMaxWidth();
    }

    public int getImageHeight() {
        return this.m_model.getMaxHeight();
    }

    public void addScrollListener(ScrollListener s) {
        this.m_scrollListeners.add(s);
    }

    public void removeScrollListener(ScrollListener s) {
        this.m_scrollListeners.remove(s);
    }

    private void notifyScollListeners() {
        for (ScrollListener element : new ArrayList<ScrollListener>(this.m_scrollListeners)) {
            element.scrolled(this.m_model.getX(), this.m_model.getY());
        }
    }

    private void scroll() {
        int dy = 0;
        if ((this.m_edge & 4) != 0) {
            dy = -30;
        } else if ((this.m_edge & 8) != 0) {
            dy = 30;
        }
        int dx = 0;
        if ((this.m_edge & 1) != 0) {
            dx = -30;
        } else if ((this.m_edge & 2) != 0) {
            dx = 30;
        }
        dx = (int)((double)dx / this.m_scale);
        dy = (int)((double)dy / this.m_scale);
        int newX = this.m_model.getX() + dx;
        int newY = this.m_model.getY() + dy;
        this.m_model.set(newX, newY);
    }

    public Dimension getImageDimensions() {
        return new Dimension(this.m_model.getMaxWidth(), this.m_model.getMaxHeight());
    }

    private int getNewEdge(int x, int y, int width, int height) {
        int newEdge = 0;
        if (x < 25) {
            ++newEdge;
        } else if (width - x < 25) {
            newEdge += 2;
        }
        if (y < 25) {
            newEdge += 4;
        } else if (height - y < 25) {
            newEdge += 8;
        }
        return newEdge;
    }

    protected void refreshBoxSize() {
        this.m_model.setBoxDimensions((int)((double)this.getWidth() / this.m_scale), (int)((double)this.getHeight() / this.m_scale));
    }

    public void setScale(double value) {
        if (value < 0.15) {
            value = 0.15;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        this.m_scale = value = (double)((int)(value * 256.0)) / 256.0;
        this.refreshBoxSize();
    }

    public int getXOffset() {
        return this.m_model.getX();
    }

    public int getYOffset() {
        return this.m_model.getY();
    }

    protected double getScaledWidth() {
        return (double)this.getWidth() / this.m_scale;
    }

    protected double getScaledHeight() {
        return (double)this.getHeight() / this.m_scale;
    }

    public void deactivate() {
        this.m_timer.stop();
        this.m_timer.removeActionListener(this.m_timerAction);
    }

    private class Scroller
    implements Runnable {
        private Scroller() {
        }

        public void run() {
            ImageScrollerLargeView.this.scroll();
        }
    }
}

