/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.ui;

import games.strategy.ui.ImageScrollModel;
import games.strategy.ui.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.border.EtchedBorder;

public class ImageScrollerSmallView
extends JComponent {
    private static final long serialVersionUID = 7010099211049677928L;
    private final ImageScrollModel m_model;
    private Image m_image;
    private long mLastUpdate = 0L;
    private final long MIN_UPDATE_DELAY = 30L;
    private final MouseMotionListener MOUSE_MOTION_LISTENER = new MouseMotionAdapter(){

        public void mouseDragged(MouseEvent e) {
            long now = System.currentTimeMillis();
            if (now < ImageScrollerSmallView.this.mLastUpdate + 30L) {
                return;
            }
            ImageScrollerSmallView.this.mLastUpdate = now;
            Rectangle bounds = (Rectangle)ImageScrollerSmallView.this.getBounds().clone();
            bounds.grow(30, 0);
            if (!bounds.contains(e.getPoint())) {
                return;
            }
            int x = (int)((double)e.getX() / ImageScrollerSmallView.this.getRatioX()) - ImageScrollerSmallView.this.m_model.getBoxWidth() / 2;
            int y = (int)((double)e.getY() / ImageScrollerSmallView.this.getRatioY()) - ImageScrollerSmallView.this.m_model.getBoxHeight() / 2;
            ImageScrollerSmallView.this.setSelection(x, y);
        }
    };
    private final MouseAdapter MOUSE_LISTENER = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            int x = (int)((double)e.getX() / ImageScrollerSmallView.this.getRatioX()) - ImageScrollerSmallView.this.m_model.getBoxWidth() / 2;
            int y = (int)((double)e.getY() / ImageScrollerSmallView.this.getRatioY()) - ImageScrollerSmallView.this.m_model.getBoxHeight() / 2;
            ImageScrollerSmallView.this.m_model.set(x, y);
        }
    };

    public ImageScrollerSmallView(Image image, ImageScrollModel model) {
        this.m_model = model;
        try {
            Util.ensureImageLoaded(image);
            this.setDoubleBuffered(false);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        this.m_image = image;
        this.setBorder(new EtchedBorder());
        int prefWidth = this.getInsetsWidth() + this.m_image.getWidth(this);
        int prefHeight = this.getInsetsHeight() + this.m_image.getHeight(this);
        Dimension prefSize = new Dimension(prefWidth, prefHeight);
        this.setPreferredSize(prefSize);
        this.setMinimumSize(prefSize);
        this.setMaximumSize(prefSize);
        this.addMouseListener(this.MOUSE_LISTENER);
        this.addMouseMotionListener(this.MOUSE_MOTION_LISTENER);
        model.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                ImageScrollerSmallView.this.repaint();
            }
        });
    }

    public void changeImage(Image image) {
        try {
            Util.ensureImageLoaded(image);
            this.setDoubleBuffered(false);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        this.m_image = image;
    }

    private int getInsetsWidth() {
        return this.getInsets().left + this.getInsets().right;
    }

    private int getInsetsHeight() {
        return this.getInsets().top + this.getInsets().bottom;
    }

    void setCoords(int x, int y) {
        this.m_model.set(x, y);
    }

    public Dimension getImageDimensions() {
        return Util.getDimension(this.m_image, this);
    }

    public void paintComponent(Graphics g) {
        g.drawImage(this.m_image, 0, 0, this);
        g.setColor(Color.white);
        this.drawViewBox((Graphics2D)g);
    }

    private void drawViewBox(Graphics2D g) {
        if (this.m_model.getBoxWidth() > this.m_model.getMaxWidth() && this.m_model.getBoxHeight() > this.m_model.getMaxHeight()) {
            return;
        }
        double ratioX = this.getRatioX();
        double ratioY = this.getRatioY();
        double x = (double)this.m_model.getX() * ratioX;
        double y = (double)this.m_model.getY() * ratioY;
        double width = (double)this.m_model.getBoxWidth() * ratioX;
        double height = (double)this.m_model.getBoxHeight() * ratioY;
        Rectangle2D.Double rect = new Rectangle2D.Double(x, y, width, height);
        g.draw(rect);
        if (this.m_model.getScrollX()) {
            double mapWidth = (double)this.m_model.getMaxWidth() * ratioX;
            rect.x += mapWidth;
            g.draw(rect);
            rect.x -= 2.0 * mapWidth;
            g.draw(rect);
        }
    }

    public Image getOffScreenImage() {
        return this.m_image;
    }

    private void setSelection(int x, int y) {
        this.m_model.set(x, y);
    }

    public double getRatioY() {
        return (double)this.m_image.getHeight(null) / (double)this.m_model.getMaxHeight();
    }

    public double getRatioX() {
        return (double)this.m_image.getWidth(null) / (double)this.m_model.getMaxWidth();
    }
}

