/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.ui;

import games.strategy.ui.ZoomableImage;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class ZoomableImageExample
extends JFrame {
    private static final long serialVersionUID = -2966214293779872824L;
    ZoomableImage panel;
    final KeyListener KEY_LISTENER = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            char key = e.getKeyChar();
            if (key == 'z') {
                ZoomableImageExample.this.ZOOM_COMMAND.actionPerformed(null);
            }
        }
    };
    private final Action ZOOM_COMMAND = new AbstractAction("save"){
        private static final long serialVersionUID = 4825071800322928852L;

        public void actionPerformed(ActionEvent e) {
            String input = JOptionPane.showInputDialog("Get Zoom Factor");
            ZoomableImageExample.this.panel.setZoom(Integer.parseInt(input));
        }
    };
    public static final WindowListener EXIT_ON_CLOSE_WINDOW_LISTENER = new WindowAdapter(){

        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    };

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Expecting first and only arg to be the name of the image file");
        }
        ZoomableImageExample frame = new ZoomableImageExample(args[0]);
        frame.setVisible(true);
    }

    public ZoomableImageExample(String imageName) {
        Image image = Toolkit.getDefaultToolkit().getImage(imageName);
        this.panel = new ZoomableImage(image);
        this.setSize(400, 400);
        this.addWindowListener(EXIT_ON_CLOSE_WINDOW_LISTENER);
        this.getContentPane().add(new JScrollPane(this.panel));
        this.addKeyListener(this.KEY_LISTENER);
    }
}

