/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.FadeTrackerCallback;
import org.jvnet.lafwidget.animation.UIThreadFadeTrackerAdapter;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.api.ColorSchemeAssociationKind;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.api.renderers.SubstanceDefaultListCellRenderer;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.utils.BackgroundPaintingUtils;
import org.jvnet.substance.painter.utils.HighlightPainterUtils;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceStripingUtils;

public class SubstanceListUI
extends BasicListUI {
    protected Set lafWidgets;
    protected Map<Integer, Object> selectedIndices;
    protected int rolledOverIndex = -1;
    protected PropertyChangeListener substancePropertyChangeListener;
    protected boolean isFileList;
    protected boolean isLeftToRight;
    protected ListSelectionListener substanceFadeSelectionListener;
    protected RolloverFadeListener substanceFadeRolloverListener;
    private Map<Integer, ComponentState> prevStateMap = new HashMap<Integer, ComponentState>();
    private Map<Integer, ComponentState> nextStateMap = new HashMap<Integer, ComponentState>();
    private ComponentListener substanceComponentListener;
    private UpdateOptimizationInfo updateInfo;

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D, jComponent);
        this.__org__jvnet__substance__SubstanceListUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceListUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceListUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstanceListUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceListUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void installListeners() {
        this.__org__jvnet__substance__SubstanceListUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void installDefaults() {
        this.__org__jvnet__substance__SubstanceListUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.__org__jvnet__substance__SubstanceListUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    @Override
    protected void uninstallDefaults() {
        this.__org__jvnet__substance__SubstanceListUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceListUI();
    }

    public SubstanceListUI() {
        this.selectedIndices = new HashMap<Integer, Object>();
    }

    protected void __org__jvnet__substance__SubstanceListUI__installDefaults() {
        super.installDefaults();
        this.isFileList = Boolean.TRUE.equals(this.list.getClientProperty("List.isFileList"));
        this.isLeftToRight = this.list.getComponentOrientation().isLeftToRight();
        if (SubstanceCoreUtilities.toDrawWatermark(this.list)) {
            this.list.setOpaque(false);
        }
        for (int i = 0; i < this.list.getModel().getSize(); ++i) {
            if (!this.list.isSelectedIndex(i)) continue;
            this.selectedIndices.put(i, this.list.getModel().getElementAt(i));
            this.prevStateMap.put(i, ComponentState.SELECTED);
        }
        this.list.putClientProperty("substancelaf.internal.highlightUse", Boolean.TRUE);
    }

    protected void __org__jvnet__substance__SubstanceListUI__uninstallDefaults() {
        this.selectedIndices.clear();
        super.uninstallDefaults();
    }

    protected void __org__jvnet__substance__SubstanceListUI__installListeners() {
        super.installListeners();
        this.substanceFadeSelectionListener = new ListSelectionListener(){

            protected void cancelFades(Set<Long> initiatedFadeSequences) {
                FadeTracker fadeTrackerInstance = FadeTracker.getInstance();
                for (long fadeId : initiatedFadeSequences) {
                    fadeTrackerInstance.cancelFadeInstance(fadeId);
                }
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (LafWidgetUtilities.hasNoFades(SubstanceListUI.this.list, FadeKind.SELECTION)) {
                    return;
                }
                if (!(SubstanceListUI.this.list.getCellRenderer() instanceof SubstanceDefaultListCellRenderer)) {
                    return;
                }
                HashSet<Long> initiatedFadeSequences = new HashSet<Long>();
                boolean fadeCanceled = false;
                FadeTracker fadeTrackerInstance = FadeTracker.getInstance();
                for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                    long fadeId;
                    if (i >= SubstanceListUI.this.list.getModel().getSize()) continue;
                    if (SubstanceListUI.this.list.isSelectedIndex(i)) {
                        if (SubstanceListUI.this.selectedIndices.containsKey(i)) continue;
                        if (!fadeCanceled) {
                            fadeId = fadeTrackerInstance.trackFadeIn(FadeKind.SELECTION, (Component)SubstanceListUI.this.list, i, false, (FadeTrackerCallback)new CellRepaintCallback(SubstanceListUI.this.list, i));
                            initiatedFadeSequences.add(fadeId);
                            if (initiatedFadeSequences.size() > 25) {
                                this.cancelFades(initiatedFadeSequences);
                                initiatedFadeSequences.clear();
                                fadeCanceled = true;
                            }
                        }
                        SubstanceListUI.this.selectedIndices.put(i, SubstanceListUI.this.list.getModel().getElementAt(i));
                        continue;
                    }
                    if (!SubstanceListUI.this.selectedIndices.containsKey(i)) continue;
                    if (SubstanceListUI.this.selectedIndices.get(i) == SubstanceListUI.this.list.getModel().getElementAt(i) && !fadeCanceled) {
                        fadeId = fadeTrackerInstance.trackFadeOut(FadeKind.SELECTION, (Component)SubstanceListUI.this.list, i, false, (FadeTrackerCallback)new CellRepaintCallback(SubstanceListUI.this.list, i));
                        initiatedFadeSequences.add(fadeId);
                        if (initiatedFadeSequences.size() > 25) {
                            this.cancelFades(initiatedFadeSequences);
                            initiatedFadeSequences.clear();
                            fadeCanceled = true;
                        }
                    }
                    SubstanceListUI.this.selectedIndices.remove(i);
                }
            }
        };
        this.list.getSelectionModel().addListSelectionListener(this.substanceFadeSelectionListener);
        this.substanceFadeRolloverListener = new RolloverFadeListener();
        this.list.addMouseMotionListener(this.substanceFadeRolloverListener);
        this.list.addMouseListener(this.substanceFadeRolloverListener);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("substancelaf.watermark.visible".equals(evt.getPropertyName())) {
                    SubstanceListUI.this.list.setOpaque(!SubstanceCoreUtilities.toDrawWatermark(SubstanceListUI.this.list));
                }
            }
        };
        this.list.addPropertyChangeListener(this.substancePropertyChangeListener);
        this.substanceComponentListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                SubstanceListUI.this.fadeOutRolloverIndication();
                SubstanceListUI.this.resetRolloverIndex();
            }
        };
        this.list.addComponentListener(this.substanceComponentListener);
    }

    protected void __org__jvnet__substance__SubstanceListUI__uninstallListeners() {
        this.list.getSelectionModel().removeListSelectionListener(this.substanceFadeSelectionListener);
        this.substanceFadeSelectionListener = null;
        this.list.removeMouseMotionListener(this.substanceFadeRolloverListener);
        this.list.removeMouseListener(this.substanceFadeRolloverListener);
        this.substanceFadeRolloverListener = null;
        this.list.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        this.list.removeComponentListener(this.substanceComponentListener);
        this.substanceComponentListener = null;
        super.uninstallListeners();
    }

    protected void paintCell(Graphics g, int row, Rectangle rowBounds, ListCellRenderer cellRenderer, ListModel dataModel, ListSelectionModel selModel, int leadIndex) {
        FadeState state;
        float endAlpha;
        Object value = dataModel.getElementAt(row);
        boolean cellHasFocus = this.list.hasFocus() && row == leadIndex;
        boolean isSelected = selModel.isSelectedIndex(row);
        Component rendererComponent = cellRenderer.getListCellRendererComponent(this.list, value, row, isSelected, cellHasFocus);
        if (!(rendererComponent instanceof SubstanceDefaultListCellRenderer)) {
            super.paintCell(g, row, rowBounds, cellRenderer, dataModel, selModel, leadIndex);
            return;
        }
        boolean isWatermarkBleed = this.updateInfo.toDrawWatermark;
        int cx = rowBounds.x;
        int cy = rowBounds.y;
        int cw = rowBounds.width;
        int ch = rowBounds.height;
        if (this.isFileList) {
            int w = Math.min(cw, rendererComponent.getPreferredSize().width + 4);
            if (!this.isLeftToRight) {
                cx += cw - w;
            }
            cw = w;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.list, g));
        if (!isWatermarkBleed) {
            Color background = rendererComponent.getBackground();
            if (background != null && (!this.list.getBackground().equals(background) || this.updateInfo.isInDecorationArea)) {
                g2d.setColor(background);
                g2d.fillRect(cx, cy, cw, ch);
            }
        } else {
            BackgroundPaintingUtils.fillAndWatermark(g2d, this.list, rendererComponent.getBackground(), new Rectangle(cx, cy, cw, ch));
        }
        ComponentState prevState = this.getPrevCellState(row);
        ComponentState currState = this.getCellState(row, rendererComponent);
        float startAlpha = this.updateInfo.getHighlightAlpha(prevState);
        float totalAlpha = endAlpha = this.updateInfo.getHighlightAlpha(currState);
        float fadeCoef = 0.0f;
        if (rendererComponent.isEnabled() && (state = SubstanceFadeUtilities.getFadeState((Component)this.list, Integer.valueOf(row), FadeKind.SELECTION, FadeKind.ROLLOVER)) != null) {
            fadeCoef = state.getFadePosition();
            totalAlpha = state.isFadingIn() ? startAlpha + (endAlpha - startAlpha) * fadeCoef : startAlpha + (endAlpha - startAlpha) * (1.0f - fadeCoef);
            if (state.isFadingIn()) {
                fadeCoef = 1.0f - fadeCoef;
            }
        }
        SubstanceColorScheme prevScheme = this.updateInfo.getHighlightColorScheme(prevState);
        SubstanceColorScheme currScheme = this.updateInfo.getHighlightColorScheme(currState);
        SubstanceColorScheme prevBorderScheme = this.updateInfo.getHighlightBorderColorScheme(prevState);
        SubstanceColorScheme currBorderScheme = this.updateInfo.getHighlightBorderColorScheme(currState);
        Rectangle cellRect = new Rectangle(cx, cy, cw, ch);
        if (totalAlpha > 0.0f) {
            g2d.setComposite(TransitionLayout.getAlphaComposite(this.list, totalAlpha, g));
            HighlightPainterUtils.paintHighlight(g2d, this.rendererPane, rendererComponent, cellRect, 0.8f, null, currScheme, prevScheme, currBorderScheme, prevBorderScheme, fadeCoef);
            g2d.setComposite(TransitionLayout.getAlphaComposite((Component)this.list, g));
        }
        this.rendererPane.paintComponent(g2d, rendererComponent, this.list, cx, cy, cw, ch, true);
        g2d.dispose();
    }

    public ComponentState getPrevCellState(int cellIndex) {
        if (this.prevStateMap.containsKey(cellIndex)) {
            return this.prevStateMap.get(cellIndex);
        }
        return this.getCellState(cellIndex, null);
    }

    public ComponentState getCellState(int cellIndex, Component rendererComponent) {
        boolean isEnabled = this.list.isEnabled();
        if (rendererComponent != null) {
            isEnabled = isEnabled && rendererComponent.isEnabled();
        }
        boolean isRollover = this.rolledOverIndex >= 0 && this.rolledOverIndex == cellIndex;
        boolean isSelected = this.list.isSelectedIndex(cellIndex);
        return ComponentState.getState(isEnabled, isRollover, isSelected);
    }

    public void resetRolloverIndex() {
        this.rolledOverIndex = -1;
    }

    private void fadeOutRolloverIndication() {
        if (this.rolledOverIndex < 0) {
            return;
        }
        FadeTracker.getInstance().trackFadeOut(FadeKind.ROLLOVER, (Component)this.list, this.rolledOverIndex, false, (FadeTrackerCallback)new CellRepaintCallback(this.list, this.rolledOverIndex));
    }

    public void __org__jvnet__substance__SubstanceListUI__update(Graphics g, JComponent c) {
        BackgroundPaintingUtils.updateIfOpaque(g, c);
        Graphics2D g2d = (Graphics2D)g.create();
        SubstanceStripingUtils.setup(c);
        this.updateInfo = new UpdateOptimizationInfo();
        this.paint(g2d, c);
        SubstanceStripingUtils.tearDown(c);
        g2d.dispose();
        this.updateInfo = null;
    }

    public SubstanceColorScheme getDefaultColorScheme() {
        if (this.updateInfo != null) {
            return this.updateInfo.defaultScheme;
        }
        return null;
    }

    public SubstanceColorScheme getHighlightColorScheme(ComponentState state) {
        if (this.updateInfo != null) {
            return this.updateInfo.getHighlightColorScheme(state);
        }
        return null;
    }

    private class UpdateOptimizationInfo {
        public boolean toDrawWatermark;
        private Map<ComponentState, SubstanceColorScheme> highlightSchemeMap;
        private Map<ComponentState, SubstanceColorScheme> borderSchemeMap;
        private Map<ComponentState, Float> highlightAlphaMap;
        public SubstanceColorScheme defaultScheme;
        public Map<Component, Boolean> opacity;
        public DecorationAreaType decorationAreaType;
        public boolean isInDecorationArea;

        public UpdateOptimizationInfo() {
            this.toDrawWatermark = SubstanceCoreUtilities.toDrawWatermark(SubstanceListUI.this.list);
            this.defaultScheme = SubstanceColorSchemeUtilities.getColorScheme(SubstanceListUI.this.list, ComponentState.DEFAULT);
            this.highlightAlphaMap = new EnumMap<ComponentState, Float>(ComponentState.class);
            this.highlightSchemeMap = new EnumMap<ComponentState, SubstanceColorScheme>(ComponentState.class);
            this.borderSchemeMap = new EnumMap<ComponentState, SubstanceColorScheme>(ComponentState.class);
            this.opacity = new HashMap<Component, Boolean>();
            this.decorationAreaType = SubstanceLookAndFeel.getDecorationType(SubstanceListUI.this.list);
            SubstanceSkin skin = SubstanceCoreUtilities.getSkin(SubstanceListUI.this.list);
            this.isInDecorationArea = this.decorationAreaType != null && skin.isRegisteredAsDecorationArea(this.decorationAreaType) && TransitionLayout.isOpaque(SubstanceListUI.this.list);
        }

        public SubstanceColorScheme getHighlightColorScheme(ComponentState state) {
            if (!this.highlightSchemeMap.containsKey((Object)state)) {
                this.highlightSchemeMap.put(state, SubstanceColorSchemeUtilities.getColorScheme(SubstanceListUI.this.list, ColorSchemeAssociationKind.HIGHLIGHT, state));
            }
            return this.highlightSchemeMap.get((Object)state);
        }

        public SubstanceColorScheme getHighlightBorderColorScheme(ComponentState state) {
            if (!this.borderSchemeMap.containsKey((Object)state)) {
                this.borderSchemeMap.put(state, SubstanceColorSchemeUtilities.getColorScheme(SubstanceListUI.this.list, ColorSchemeAssociationKind.HIGHLIGHT_BORDER, state));
            }
            return this.borderSchemeMap.get((Object)state);
        }

        public float getHighlightAlpha(ComponentState state) {
            if (!this.highlightAlphaMap.containsKey((Object)state)) {
                this.highlightAlphaMap.put(state, Float.valueOf(SubstanceColorSchemeUtilities.getHighlightAlpha(SubstanceListUI.this.list, state)));
            }
            return this.highlightAlphaMap.get((Object)state).floatValue();
        }
    }

    protected class CellRepaintCallback
    extends UIThreadFadeTrackerAdapter {
        protected JList list;
        protected int cellIndex;
        private Component rendererComponent;

        public CellRepaintCallback(JList list, int cellIndex) {
            this.list = list;
            this.cellIndex = cellIndex;
            if (cellIndex < list.getModel().getSize()) {
                this.rendererComponent = list.getCellRenderer().getListCellRendererComponent(list, list.getModel().getElementAt(cellIndex), cellIndex, list.getSelectionModel().isSelectedIndex(cellIndex), list.hasFocus() && cellIndex == list.getLeadSelectionIndex());
            }
        }

        @Override
        public void fadeEnded(FadeKind fadeKind) {
            if (SubstanceListUI.this.list == this.list && this.cellIndex < this.list.getModel().getSize()) {
                ComponentState currState = SubstanceListUI.this.getCellState(this.cellIndex, this.rendererComponent);
                if (currState == ComponentState.DEFAULT) {
                    SubstanceListUI.this.prevStateMap.remove(this.cellIndex);
                    SubstanceListUI.this.nextStateMap.remove(this.cellIndex);
                } else {
                    SubstanceListUI.this.prevStateMap.put(this.cellIndex, currState);
                    SubstanceListUI.this.nextStateMap.put(this.cellIndex, currState);
                }
            }
            this.repaintCell();
        }

        @Override
        public void fadeReversed(FadeKind fadeKind, boolean isFadingIn, float fadeCycle10) {
            if (SubstanceListUI.this.list == this.list && this.cellIndex < this.list.getModel().getSize()) {
                ComponentState nextState = (ComponentState)((Object)SubstanceListUI.this.nextStateMap.get(this.cellIndex));
                if (nextState == null) {
                    SubstanceListUI.this.prevStateMap.remove(this.cellIndex);
                } else {
                    SubstanceListUI.this.prevStateMap.put(this.cellIndex, nextState);
                }
            }
            this.repaintCell();
        }

        @Override
        public void fadePerformed(FadeKind fadeKind, float fade) {
            if (SubstanceListUI.this.list == this.list && this.cellIndex < this.list.getModel().getSize()) {
                SubstanceListUI.this.nextStateMap.put(this.cellIndex, SubstanceListUI.this.getCellState(this.cellIndex, this.rendererComponent));
            }
            this.repaintCell();
        }

        private void repaintCell() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SubstanceListUI.this.list == null) {
                        return;
                    }
                    try {
                        SubstanceListUI.this.maybeUpdateLayoutState();
                        int cellCount = CellRepaintCallback.this.list.getModel().getSize();
                        if (cellCount > 0 && CellRepaintCallback.this.cellIndex < cellCount) {
                            Rectangle rect = SubstanceListUI.this.getCellBounds(CellRepaintCallback.this.list, CellRepaintCallback.this.cellIndex, CellRepaintCallback.this.cellIndex);
                            CellRepaintCallback.this.list.repaint(rect);
                        }
                    }
                    catch (RuntimeException re) {
                        return;
                    }
                }
            });
        }
    }

    private class RolloverFadeListener
    implements MouseListener,
    MouseMotionListener {
        private RolloverFadeListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SubstanceListUI.this.fadeOutRolloverIndication();
            SubstanceListUI.this.resetRolloverIndex();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!SubstanceListUI.this.list.isEnabled()) {
                return;
            }
            this.handleMove(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!SubstanceListUI.this.list.isEnabled()) {
                return;
            }
            this.handleMove(e);
        }

        private void handleMove(MouseEvent e) {
            boolean fadeAllowed;
            boolean bl = fadeAllowed = !LafWidgetUtilities.hasNoFades(SubstanceListUI.this.list, FadeKind.ROLLOVER);
            if (!(SubstanceListUI.this.list.getCellRenderer() instanceof SubstanceDefaultListCellRenderer)) {
                fadeAllowed = false;
            }
            if (!fadeAllowed) {
                SubstanceListUI.this.fadeOutRolloverIndication();
                SubstanceListUI.this.resetRolloverIndex();
                return;
            }
            int roIndex = SubstanceListUI.this.list.locationToIndex(e.getPoint());
            if (roIndex >= 0 && roIndex < SubstanceListUI.this.list.getModel().getSize() && !SubstanceListUI.this.list.getCellBounds(roIndex, roIndex).contains(e.getPoint())) {
                roIndex = -1;
            }
            if (roIndex < 0 || roIndex >= SubstanceListUI.this.list.getModel().getSize()) {
                SubstanceListUI.this.fadeOutRolloverIndication();
                SubstanceListUI.this.resetRolloverIndex();
            } else {
                if (SubstanceListUI.this.rolledOverIndex >= 0 && SubstanceListUI.this.rolledOverIndex == roIndex) {
                    return;
                }
                SubstanceListUI.this.fadeOutRolloverIndication();
                FadeTracker.getInstance().trackFadeIn(FadeKind.ROLLOVER, (Component)SubstanceListUI.this.list, roIndex, false, (FadeTrackerCallback)new CellRepaintCallback(SubstanceListUI.this.list, roIndex));
                SubstanceListUI.this.rolledOverIndex = roIndex;
            }
        }
    }
}

