/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.text.View;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.api.ColorSchemeAssociationKind;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.painter.border.SubstanceBorderPainter;
import org.jvnet.substance.painter.gradient.SubstanceGradientPainter;
import org.jvnet.substance.painter.utils.BackgroundPaintingUtils;
import org.jvnet.substance.utils.HashMapKey;
import org.jvnet.substance.utils.LazyResettableHashMap;
import org.jvnet.substance.utils.RolloverButtonListener;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceImageCreator;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceTextUtilities;

public class SubstanceRadioButtonUI
extends BasicRadioButtonUI {
    protected Set lafWidgets;
    protected PropertyChangeListener substancePropertyListener;
    protected JToggleButton button;
    private static LazyResettableHashMap<Icon> icons = new LazyResettableHashMap("SubstanceRadioButtonUI");
    protected FadeStateListener substanceFadeStateListener;

    public void __org__jvnet__substance__SubstanceRadioButtonUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D, jComponent);
        this.__org__jvnet__substance__SubstanceRadioButtonUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceRadioButtonUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceRadioButtonUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstanceRadioButtonUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceRadioButtonUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void installListeners(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceRadioButtonUI__installListeners(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void installDefaults(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceRadioButtonUI__installDefaults(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallListeners(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceRadioButtonUI__uninstallListeners(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    protected void __org__jvnet__substance__SubstanceRadioButtonUI__uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
    }

    @Override
    protected void uninstallDefaults(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceRadioButtonUI__uninstallDefaults(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    protected void __org__jvnet__substance__SubstanceRadioButtonUI__installListeners(final AbstractButton b) {
        super.installListeners(b);
        this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), SubstanceCoreUtilities.getFadeCallback(b, false));
        this.substanceFadeStateListener.registerListeners();
        this.substancePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("model".equals(evt.getPropertyName())) {
                    if (SubstanceRadioButtonUI.this.substanceFadeStateListener != null) {
                        SubstanceRadioButtonUI.this.substanceFadeStateListener.unregisterListeners();
                    }
                    SubstanceRadioButtonUI.this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), SubstanceCoreUtilities.getFadeCallback(b, false));
                    SubstanceRadioButtonUI.this.substanceFadeStateListener.registerListeners();
                }
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            b.updateUI();
                        }
                    });
                }
            }
        };
        b.addPropertyChangeListener(this.substancePropertyListener);
    }

    protected void __org__jvnet__substance__SubstanceRadioButtonUI__installDefaults(AbstractButton b) {
        super.installDefaults(b);
        Border border = b.getBorder();
        if (border == null || border instanceof UIResource) {
            b.setBorder(SubstanceSizeUtils.getRadioButtonBorder(SubstanceSizeUtils.getComponentFontSize(b)));
        }
        this.button.setRolloverEnabled(true);
        LookAndFeel.installProperty(b, "iconTextGap", SubstanceSizeUtils.getTextIconGap(SubstanceSizeUtils.getComponentFontSize(b)));
    }

    protected void __org__jvnet__substance__SubstanceRadioButtonUI__uninstallListeners(AbstractButton b) {
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        b.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        super.uninstallListeners(b);
    }

    private static Icon getIcon(JToggleButton button, ComponentState currState, ComponentState prevState) {
        float visibility = currState.isKindActive(FadeKind.SELECTION) ? 10.0f : 0.0f;
        SubstanceColorScheme currFillColorScheme = SubstanceColorSchemeUtilities.getColorScheme(button, ColorSchemeAssociationKind.FILL, currState);
        SubstanceColorScheme prevFillColorScheme = SubstanceColorSchemeUtilities.getColorScheme(button, ColorSchemeAssociationKind.FILL, prevState);
        SubstanceColorScheme currMarkColorScheme = SubstanceColorSchemeUtilities.getColorScheme(button, ColorSchemeAssociationKind.MARK, currState);
        SubstanceColorScheme prevMarkColorScheme = SubstanceColorSchemeUtilities.getColorScheme(button, ColorSchemeAssociationKind.MARK, prevState);
        SubstanceColorScheme currBorderColorScheme = SubstanceColorSchemeUtilities.getColorScheme(button, ColorSchemeAssociationKind.BORDER, currState);
        SubstanceColorScheme prevBorderColorScheme = SubstanceColorSchemeUtilities.getColorScheme(button, ColorSchemeAssociationKind.BORDER, prevState);
        float cyclePos = 0.0f;
        FadeState fadeState = SubstanceFadeUtilities.getFadeState((Component)button, FadeKind.SELECTION, FadeKind.ROLLOVER, FadeKind.PRESS);
        if (fadeState != null) {
            cyclePos = fadeState.getFadePosition();
            if (fadeState.isFadingIn()) {
                cyclePos = 1.0f - cyclePos;
            }
            if (fadeState.fadeKind == FadeKind.SELECTION) {
                visibility = fadeState.getFadePosition();
            }
        }
        int fontSize = SubstanceSizeUtils.getComponentFontSize(button);
        int checkMarkSize = SubstanceSizeUtils.getRadioButtonMarkSize(fontSize);
        SubstanceGradientPainter fillPainter = SubstanceCoreUtilities.getGradientPainter(button);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(button);
        HashMapKey key = SubstanceCoreUtilities.getHashKey(fontSize, checkMarkSize, currState.name(), currState.name(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), currFillColorScheme.getDisplayName(), prevFillColorScheme.getDisplayName(), currMarkColorScheme.getDisplayName(), prevMarkColorScheme.getDisplayName(), currBorderColorScheme.getDisplayName(), prevBorderColorScheme.getDisplayName(), Float.valueOf(cyclePos), Float.valueOf(visibility));
        Icon result = icons.get(key);
        if (result != null) {
            return result;
        }
        result = new ImageIcon(SubstanceImageCreator.getRadioButton(button, fillPainter, borderPainter, checkMarkSize, currState, prevState, 0, currFillColorScheme, prevFillColorScheme, currMarkColorScheme, prevMarkColorScheme, currBorderColorScheme, prevBorderColorScheme, cyclePos, visibility / 10.0f));
        icons.put(key, result);
        return result;
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceRadioButtonUI((JToggleButton)comp);
    }

    public SubstanceRadioButtonUI(JToggleButton button) {
        this.button = button;
        button.setRolloverEnabled(true);
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new RolloverButtonListener(b);
    }

    @Override
    public Icon getDefaultIcon() {
        ComponentState currState = ComponentState.getState(this.button);
        ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(this.button);
        return SubstanceRadioButtonUI.getIcon(this.button, currState, prevState);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        if (TransitionLayout.isOpaque(c)) {
            BackgroundPaintingUtils.update(g, c, false);
        }
        FontMetrics fm = g.getFontMetrics();
        Insets i = b.getInsets();
        Rectangle viewRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = b.getWidth() - (i.right + viewRect.x);
        viewRect.height = b.getHeight() - (i.bottom + viewRect.y);
        textRect.height = 0;
        textRect.width = 0;
        textRect.y = 0;
        textRect.x = 0;
        iconRect.height = 0;
        iconRect.width = 0;
        iconRect.y = 0;
        iconRect.x = 0;
        Font f = b.getFont();
        g.setFont(f);
        Icon icon = SubstanceCoreUtilities.getIcon(b, this.getDefaultIcon(), null, false);
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        Graphics2D g2d = (Graphics2D)g.create();
        if (text != null && !text.equals("")) {
            View v = (View)b.getClientProperty("html");
            if (v != null) {
                v.paint(g2d, textRect);
            } else {
                this.paintButtonText(g2d, b, textRect, text);
            }
        }
        if (icon != null) {
            icon.paintIcon(c, g2d, iconRect.x, iconRect.y);
        }
        if (b.isFocusPainted() && (b.hasFocus() || FadeTracker.getInstance().isTracked(c, FadeKind.FOCUS))) {
            int focusRingPadding = SubstanceSizeUtils.getFocusRingPadding(SubstanceSizeUtils.getComponentFontSize(this.button)) / 2;
            SubstanceCoreUtilities.paintFocus(g2d, this.button, this.button, null, textRect, 1.0f, focusRingPadding);
        }
        g2d.dispose();
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceRadioButtonUI: \n");
        sb.append("\t" + icons.size() + " icons");
        return sb.toString();
    }

    protected void paintButtonText(Graphics g, AbstractButton button, Rectangle textRect, String text) {
        SubstanceTextUtilities.paintText(g, button, textRect, text, button.getDisplayedMnemonicIndex());
    }
}

