/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSliderUI;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.api.ColorSchemeAssociationKind;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.painter.border.SubstanceBorderPainter;
import org.jvnet.substance.painter.gradient.ClassicGradientPainter;
import org.jvnet.substance.painter.gradient.SubstanceGradientPainter;
import org.jvnet.substance.painter.utils.BackgroundPaintingUtils;
import org.jvnet.substance.painter.utils.SeparatorPainterUtils;
import org.jvnet.substance.utils.HashMapKey;
import org.jvnet.substance.utils.LazyResettableHashMap;
import org.jvnet.substance.utils.RolloverControlListener;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceOutlineUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.Trackable;
import org.jvnet.substance.utils.icon.SubstanceIconFactory;

public class SubstanceSliderUI
extends BasicSliderUI
implements Trackable {
    protected Set lafWidgets;
    private ButtonModel thumbModel = new DefaultButtonModel();
    private RolloverControlListener substanceRolloverListener;
    private PropertyChangeListener substancePropertyChangeListener;
    protected FadeStateListener substanceFadeStateListener;
    protected Icon horizontalIcon;
    protected Icon roundIcon;
    protected Icon verticalIcon;
    protected static final LazyResettableHashMap<BufferedImage> trackCache = new LazyResettableHashMap("SubstanceSliderUI.track");

    public void __org__jvnet__substance__SubstanceSliderUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D, jComponent);
        this.__org__jvnet__substance__SubstanceSliderUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceSliderUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceSliderUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstanceSliderUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceSliderUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void installListeners(JSlider jSlider) {
        this.__org__jvnet__substance__SubstanceSliderUI__installListeners(jSlider);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void installDefaults(JSlider jSlider) {
        this.__org__jvnet__substance__SubstanceSliderUI__installDefaults(jSlider);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallListeners(JSlider jSlider) {
        this.__org__jvnet__substance__SubstanceSliderUI__uninstallListeners(jSlider);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceSliderUI((JSlider)comp);
    }

    public SubstanceSliderUI(JSlider slider) {
        super(null);
        this.thumbModel.setArmed(false);
        this.thumbModel.setSelected(false);
        this.thumbModel.setPressed(false);
        this.thumbModel.setRollover(false);
        this.thumbModel.setEnabled(slider.isEnabled());
    }

    @Override
    protected void calculateTrackRect() {
        super.calculateTrackRect();
        if (this.slider.getOrientation() == 0) {
            this.trackRect.y = 3 + (int)Math.ceil(SubstanceSizeUtils.getFocusStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.slider))) + this.insetCache.top;
        }
    }

    private Rectangle getPaintTrackRect() {
        int trackLeft = 0;
        int trackRight = 0;
        int trackTop = 0;
        int trackBottom = 0;
        if (this.slider.getOrientation() == 0) {
            trackTop = 3 + this.insetCache.top + 2 * this.focusInsets.top;
            trackBottom = trackTop + this.getTrackWidth() - 1;
            trackRight = this.trackRect.width;
            return new Rectangle(this.trackRect.x + trackLeft, trackTop, trackRight - trackLeft, trackBottom - trackTop);
        }
        if (this.slider.getComponentOrientation().isLeftToRight()) {
            trackLeft = this.trackRect.x + this.insetCache.left + this.focusInsets.left;
            trackRight = trackLeft + this.getTrackWidth() - 1;
        } else {
            trackRight = this.trackRect.x + this.trackRect.width - this.insetCache.right - this.focusInsets.right;
            trackLeft = trackRight - this.getTrackWidth() + 1;
        }
        trackBottom = this.trackRect.height - 1;
        return new Rectangle(trackLeft, this.trackRect.y + trackTop, trackRight - trackLeft, trackBottom - trackTop);
    }

    @Override
    public void paintTrack(Graphics g) {
        Graphics2D graphics = (Graphics2D)g.create();
        boolean drawInverted = this.drawInverted();
        Rectangle paintRect = this.getPaintTrackRect();
        int width = paintRect.width;
        int height = paintRect.height;
        if (this.slider.getOrientation() == 1) {
            int temp = width;
            width = height;
            height = temp;
            AffineTransform at = graphics.getTransform();
            at.translate(paintRect.x, width + paintRect.y);
            at.rotate(-1.5707963267948966);
            graphics.setTransform(at);
        } else {
            graphics.translate(paintRect.x, paintRect.y);
        }
        ComponentState currState = ComponentState.getState(this.thumbModel, this.slider);
        ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(this.slider);
        SubstanceColorScheme trackScheme = SubstanceColorSchemeUtilities.getColorScheme(this.slider, this.slider.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED);
        this.paintSliderTrack(graphics, drawInverted, trackScheme, SubstanceColorSchemeUtilities.getColorScheme(this.slider, ColorSchemeAssociationKind.BORDER, currState), width, height);
        SubstanceColorScheme trackSchemeSelected = SubstanceColorSchemeUtilities.getColorScheme(this.slider, currState);
        SubstanceColorScheme trackBorderSchemeSelected = SubstanceColorSchemeUtilities.getColorScheme(this.slider, ColorSchemeAssociationKind.BORDER, currState);
        FadeState fadeState = SubstanceFadeUtilities.getFadeState((Component)this.slider, FadeKind.ROLLOVER, FadeKind.SELECTION, FadeKind.PRESS);
        if (fadeState != null) {
            SubstanceColorScheme prevScheme = SubstanceColorSchemeUtilities.getColorScheme(this.slider, prevState);
            SubstanceColorScheme prevBorderScheme = SubstanceColorSchemeUtilities.getColorScheme(this.slider, ColorSchemeAssociationKind.BORDER, prevState);
            float cyclePos = fadeState.getFadePosition();
            if (!fadeState.isFadingIn()) {
                cyclePos = 1.0f - cyclePos;
            }
            if (prevState != ComponentState.DEFAULT) {
                graphics.setComposite(TransitionLayout.getAlphaComposite(this.slider, 1.0f - cyclePos, g));
                this.paintSliderTrackSelected(graphics, drawInverted, paintRect, prevScheme, prevBorderScheme, width, height);
            }
            if (currState != ComponentState.DEFAULT) {
                graphics.setComposite(TransitionLayout.getAlphaComposite(this.slider, cyclePos, g));
                this.paintSliderTrackSelected(graphics, drawInverted, paintRect, trackSchemeSelected, trackBorderSchemeSelected, width, height);
            }
        } else {
            boolean hasFill;
            boolean bl = hasFill = currState.isKindActive(FadeKind.ROLLOVER) || currState.isKindActive(FadeKind.PRESS);
            if (hasFill) {
                this.paintSliderTrackSelected(graphics, drawInverted, paintRect, trackSchemeSelected, trackBorderSchemeSelected, width, height);
            }
        }
        graphics.dispose();
    }

    private void paintSliderTrack(Graphics2D graphics, boolean drawInverted, SubstanceColorScheme fillColorScheme, SubstanceColorScheme borderScheme, int width, int height) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        ClassicGradientPainter gradientPainter = ClassicGradientPainter.INSTANCE;
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(this.slider);
        int componentFontSize = SubstanceSizeUtils.getComponentFontSize(this.slider);
        int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(componentFontSize) / 2.0);
        float radius = SubstanceSizeUtils.getClassicButtonCornerRadius(componentFontSize) / 2.0f;
        int borderThickness = (int)SubstanceSizeUtils.getBorderStrokeWidth(componentFontSize);
        HashMapKey key = SubstanceCoreUtilities.getHashKey(width, height, Float.valueOf(radius), borderDelta, borderThickness, fillColorScheme.getDisplayName(), borderScheme.getDisplayName());
        if (!trackCache.containsKey(key)) {
            BufferedImage trackImage = SubstanceCoreUtilities.getBlankImage(width + 1, height + 1);
            Graphics2D cacheGraphics = trackImage.createGraphics();
            GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline(width + 1, height + 1, radius, null, borderDelta);
            gradientPainter.paintContourBackground(cacheGraphics, this.slider, width, height, contour, false, fillColorScheme, fillColorScheme, 0.0f, false, false);
            GeneralPath contourInner = SubstanceOutlineUtilities.getBaseOutline(width + 1, height + 1, radius - (float)borderThickness, null, borderThickness + borderDelta);
            borderPainter.paintBorder(cacheGraphics, this.slider, width + 1, height + 1, contour, contourInner, borderScheme, borderScheme, 0.0f, false);
            trackCache.put(key, trackImage);
            cacheGraphics.dispose();
        }
        BufferedImage cached = trackCache.get(key);
        g2d.drawImage((Image)cached, 0, 0, null);
        g2d.dispose();
    }

    private void paintSliderTrackSelected(Graphics2D graphics, boolean drawInverted, Rectangle paintRect, SubstanceColorScheme fillScheme, SubstanceColorScheme borderScheme, int width, int height) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        Insets insets = this.slider.getInsets();
        insets.top /= 2;
        insets.left /= 2;
        insets.bottom /= 2;
        insets.right /= 2;
        SubstanceGradientPainter gp = SubstanceCoreUtilities.getGradientPainter(this.slider);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(this.slider);
        float radius = SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(this.slider)) / 2.0f;
        int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.slider)) / 2.0);
        if (this.slider.isEnabled()) {
            if (this.slider.getOrientation() == 0) {
                int fillMaxX;
                int fillMinX;
                int middleOfThumb = this.thumbRect.x + this.thumbRect.width / 2 - paintRect.x;
                if (drawInverted) {
                    fillMinX = middleOfThumb;
                    fillMaxX = width;
                } else {
                    fillMinX = 0;
                    fillMaxX = middleOfThumb;
                }
                int fillWidth = fillMaxX - fillMinX;
                int fillHeight = height + 1;
                if (fillWidth > 0 && fillHeight > 0) {
                    GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline(fillWidth, fillHeight, radius, null, borderDelta);
                    g2d.translate(fillMinX, 0);
                    gp.paintContourBackground(g2d, this.slider, fillWidth, fillHeight, contour, false, fillScheme, fillScheme, 0.0f, false, false);
                    borderPainter.paintBorder(g2d, this.slider, fillWidth, fillHeight, contour, null, borderScheme, borderScheme, 0.0f, false);
                }
            } else {
                int fillMax;
                int fillMin;
                int middleOfThumb = this.thumbRect.y + this.thumbRect.height / 2 - paintRect.y;
                if (this.drawInverted()) {
                    fillMin = 0;
                    fillMax = middleOfThumb;
                    g2d.translate(width + 2 - middleOfThumb, 0);
                } else {
                    fillMin = middleOfThumb;
                    fillMax = width + 1;
                }
                int fillWidth = fillMax - fillMin;
                int fillHeight = height + 1;
                if (fillWidth > 0 && fillHeight > 0) {
                    GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline(fillWidth, fillHeight, radius, null, borderDelta);
                    gp.paintContourBackground(g2d, this.slider, fillWidth, fillHeight, contour, false, fillScheme, fillScheme, 0.0f, false, false);
                    borderPainter.paintBorder(g2d, this.slider, fillWidth, fillHeight, contour, null, borderScheme, borderScheme, 0.0f, false);
                }
            }
        }
        g2d.dispose();
    }

    @Override
    protected Dimension getThumbSize() {
        Icon thumbIcon = this.getIcon();
        return new Dimension(thumbIcon.getIconWidth(), thumbIcon.getIconHeight());
    }

    protected Icon getIcon() {
        if (this.slider.getOrientation() == 0) {
            if (this.slider.getPaintTicks() || this.slider.getPaintLabels()) {
                return this.horizontalIcon;
            }
            return this.roundIcon;
        }
        if (this.slider.getPaintTicks() || this.slider.getPaintLabels()) {
            return this.verticalIcon;
        }
        return this.roundIcon;
    }

    @Override
    public void paintThumb(Graphics g) {
        Graphics2D graphics = (Graphics2D)g.create();
        Rectangle knobBounds = this.thumbRect;
        graphics.translate(knobBounds.x, knobBounds.y);
        Icon icon = this.getIcon();
        if (this.slider.getOrientation() == 0) {
            if (icon != null) {
                icon.paintIcon(this.slider, graphics, -1, 0);
            }
        } else if (this.slider.getComponentOrientation().isLeftToRight()) {
            if (icon != null) {
                icon.paintIcon(this.slider, graphics, 0, -1);
            }
        } else if (icon != null) {
            icon.paintIcon(this.slider, graphics, 0, 1);
        }
        graphics.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        ComponentState currState = ComponentState.getState(this.thumbModel, this.slider);
        float alpha = SubstanceColorSchemeUtilities.getAlpha(this.slider, currState);
        BackgroundPaintingUtils.updateIfOpaque(graphics, c);
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        Rectangle clip = graphics.getClipBounds();
        if (!clip.intersects(this.trackRect) && this.slider.getPaintTrack()) {
            this.calculateGeometry();
        }
        graphics.setComposite(TransitionLayout.getAlphaComposite(this.slider, alpha, g));
        if (this.slider.getPaintTrack() && clip.intersects(this.trackRect)) {
            this.paintTrack(graphics);
        }
        if (this.slider.getPaintTicks() && clip.intersects(this.tickRect)) {
            this.paintTicks(graphics);
        }
        if (this.slider.hasFocus() && clip.intersects(this.focusRect)) {
            this.paintFocus(graphics);
        }
        if (clip.intersects(this.thumbRect)) {
            this.paintThumb(graphics);
        }
        graphics.setComposite(TransitionLayout.getAlphaComposite(this.slider, 1.0f, g));
        if (this.slider.getPaintLabels() && clip.intersects(this.labelRect)) {
            this.paintLabels(graphics);
        }
        if (!this.slider.hasFocus() && FadeTracker.getInstance().isTracked(c, FadeKind.FOCUS)) {
            this.paintFocus(graphics);
        }
        graphics.dispose();
    }

    public ButtonModel getButtonModel() {
        return this.thumbModel;
    }

    @Override
    public boolean isInside(MouseEvent me) {
        Rectangle thumbB = this.thumbRect;
        if (thumbB == null) {
            return false;
        }
        return thumbB.contains(me.getX(), me.getY());
    }

    protected void __org__jvnet__substance__SubstanceSliderUI__installDefaults(JSlider slider) {
        super.installDefaults(slider);
        Font f = slider.getFont();
        if (f == null || f instanceof UIResource) {
            slider.setFont(new FontUIResource(SubstanceLookAndFeel.getFontPolicy().getFontSet("Substance", null).getControlFont()));
        }
        int size = SubstanceSizeUtils.getSliderIconSize(SubstanceSizeUtils.getComponentFontSize(slider));
        this.horizontalIcon = SubstanceIconFactory.getSliderHorizontalIcon(size, false);
        this.roundIcon = SubstanceIconFactory.getSliderRoundIcon(size);
        this.verticalIcon = SubstanceIconFactory.getSliderVerticalIcon(size, false);
        int focusIns = (int)Math.ceil(2.0 * (double)SubstanceSizeUtils.getFocusStrokeWidth(SubstanceSizeUtils.getComponentFontSize(slider)));
        this.focusInsets = new Insets(focusIns, focusIns, focusIns, focusIns);
    }

    protected void __org__jvnet__substance__SubstanceSliderUI__installListeners(final JSlider slider) {
        super.installListeners(slider);
        this.substanceRolloverListener = new RolloverControlListener(this, this.thumbModel);
        slider.addMouseListener(this.substanceRolloverListener);
        slider.addMouseMotionListener(this.substanceRolloverListener);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    SubstanceSliderUI.this.thumbModel.setEnabled(slider.isEnabled());
                }
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            slider.updateUI();
                        }
                    });
                }
            }
        };
        this.slider.addPropertyChangeListener(this.substancePropertyChangeListener);
        this.substanceFadeStateListener = new FadeStateListener(this.slider, this.thumbModel, SubstanceCoreUtilities.getFadeCallback(this.slider, this.thumbModel, false, false, this.slider));
        this.substanceFadeStateListener.registerListeners(false);
    }

    protected void __org__jvnet__substance__SubstanceSliderUI__uninstallListeners(JSlider slider) {
        super.uninstallListeners(slider);
        slider.removeMouseListener(this.substanceRolloverListener);
        slider.removeMouseMotionListener(this.substanceRolloverListener);
        this.substanceRolloverListener = null;
        slider.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
    }

    @Override
    public void paintFocus(Graphics g) {
        SubstanceCoreUtilities.paintFocus(g, this.slider, this.slider, null, null, 1.0f, (int)Math.ceil(SubstanceSizeUtils.getFocusStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.slider))) / 2);
    }

    protected int getThumbOverhang() {
        return (int)(this.getThumbSize().getHeight() - (double)this.getTrackWidth()) / 2;
    }

    protected int getTrackWidth() {
        return SubstanceSizeUtils.getSliderTrackSize(SubstanceSizeUtils.getComponentFontSize(this.slider));
    }

    @Override
    protected int getTickLength() {
        return SubstanceSizeUtils.getSliderTickSize(SubstanceSizeUtils.getComponentFontSize(this.slider));
    }

    @Override
    public void paintTicks(Graphics g) {
        Rectangle tickBounds = this.tickRect;
        SubstanceColorScheme tickScheme = SubstanceColorSchemeUtilities.getColorScheme(this.slider, ColorSchemeAssociationKind.SEPARATOR, this.slider.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED);
        if (this.slider.getOrientation() == 0) {
            int value;
            int xPos = 0;
            if (this.slider.getMinorTickSpacing() > 0 && this.slider.getMajorTickSpacing() > 0) {
                ArrayList<Integer> minorXs = new ArrayList<Integer>();
                for (value = this.slider.getMinimum() + this.slider.getMinorTickSpacing(); value < this.slider.getMaximum(); value += this.slider.getMinorTickSpacing()) {
                    int delta = value - this.slider.getMinimum();
                    if (delta % this.slider.getMajorTickSpacing() == 0) continue;
                    xPos = this.xPositionForValue(value);
                    minorXs.add(xPos - 1);
                }
                SeparatorPainterUtils.paintVerticalLines(g, this.slider, tickScheme, tickBounds.y, minorXs, tickBounds.height / 2, 0.75f);
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                ArrayList<Integer> majorXs = new ArrayList<Integer>();
                for (value = this.slider.getMinimum() + this.slider.getMajorTickSpacing(); value < this.slider.getMaximum(); value += this.slider.getMajorTickSpacing()) {
                    xPos = this.xPositionForValue(value);
                    majorXs.add(xPos - 1);
                }
                SeparatorPainterUtils.paintVerticalLines(g, this.slider, tickScheme, tickBounds.y, majorXs, tickBounds.height, 0.75f);
            }
        } else {
            g.translate(tickBounds.x, 0);
            int value = this.slider.getMinimum() + this.slider.getMinorTickSpacing();
            int yPos = 0;
            boolean ltr = this.slider.getComponentOrientation().isLeftToRight();
            if (this.slider.getMinorTickSpacing() > 0) {
                ArrayList<Integer> minorYs = new ArrayList<Integer>();
                int offset = 0;
                if (!ltr) {
                    offset = tickBounds.width - tickBounds.width / 2;
                }
                while (value < this.slider.getMaximum()) {
                    yPos = this.yPositionForValue(value);
                    minorYs.add(yPos);
                    value += this.slider.getMinorTickSpacing();
                }
                SeparatorPainterUtils.paintHorizontalLines(g, this.slider, tickScheme, offset, minorYs, tickBounds.width / 2, ltr ? 0.75f : 0.25f, ltr);
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                ArrayList<Integer> majorYs = new ArrayList<Integer>();
                for (value = this.slider.getMinimum() + this.slider.getMajorTickSpacing(); value < this.slider.getMaximum(); value += this.slider.getMajorTickSpacing()) {
                    yPos = this.yPositionForValue(value);
                    majorYs.add(yPos);
                }
                SeparatorPainterUtils.paintHorizontalLines(g, this.slider, tickScheme, 0, majorYs, tickBounds.width, ltr ? 0.75f : 0.25f, ltr);
            }
            g.translate(-tickBounds.x, 0);
        }
    }

    @Override
    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y + this.trackRect.height;
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.slider.getPaintTicks() ? this.getTickLength() : 0;
        } else {
            this.tickRect.width = this.slider.getPaintTicks() ? this.getTickLength() : 0;
            this.tickRect.x = this.slider.getComponentOrientation().isLeftToRight() ? this.trackRect.x + this.trackRect.width : this.trackRect.x - this.tickRect.width;
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
        }
        if (this.slider.getPaintTicks()) {
            if (this.slider.getOrientation() == 0) {
                this.tickRect.y -= 3;
            } else {
                this.tickRect.x = this.slider.getComponentOrientation().isLeftToRight() ? (this.tickRect.x -= 2) : (this.tickRect.x += 2);
            }
        }
    }

    @Override
    protected void calculateLabelRect() {
        super.calculateLabelRect();
        if (this.slider.getOrientation() == 1 && !this.slider.getPaintTicks() && this.slider.getComponentOrientation().isLeftToRight()) {
            this.labelRect.x += 3;
        }
        if (this.slider.getOrientation() == 1) {
            this.labelRect.width = this.getHeightOfTallestLabel();
        }
    }

    @Override
    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        Rectangle trackRect = this.getPaintTrackRect();
        if (this.slider.getOrientation() == 0) {
            int valuePosition = this.xPositionForValue(this.slider.getValue());
            double centerY = (double)trackRect.y + (double)trackRect.height / 2.0;
            this.thumbRect.y = (int)(centerY - (double)this.thumbRect.height / 2.0) + 1;
            this.thumbRect.x = valuePosition - this.thumbRect.width / 2;
        } else {
            int valuePosition = this.yPositionForValue(this.slider.getValue());
            double centerX = (double)trackRect.x + (double)trackRect.width / 2.0;
            this.thumbRect.x = (int)(centerX - (double)this.thumbRect.width / 2.0) + 1;
            this.thumbRect.y = valuePosition - this.thumbRect.height / 2;
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension d;
        this.recalculateIfInsetsChanged();
        if (this.slider.getOrientation() == 1) {
            d = new Dimension(this.getPreferredVerticalSize());
            d.width = this.insetCache.left + this.insetCache.right;
            d.width += this.focusInsets.left + this.focusInsets.right;
            d.width += this.trackRect.width;
            if (this.slider.getPaintTicks()) {
                d.width += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                d.width += this.getWidthOfWidestLabel();
            }
            d.width += 3;
        } else {
            d = new Dimension(this.getPreferredHorizontalSize());
            d.height = this.insetCache.top + this.insetCache.bottom;
            d.height += this.focusInsets.top + this.focusInsets.bottom;
            d.height += this.trackRect.height;
            if (this.slider.getPaintTicks()) {
                d.height += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                d.height += this.getHeightOfTallestLabel();
            }
            d.height += 3;
        }
        return d;
    }

    @Override
    public void setThumbLocation(int x, int y) {
        super.setThumbLocation(x, y);
        this.slider.repaint();
    }

    @Override
    public Dimension getPreferredHorizontalSize() {
        return new Dimension(SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(this.slider), 200, 1, 20, false), 21);
    }

    @Override
    public Dimension getPreferredVerticalSize() {
        return new Dimension(21, SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(this.slider), 200, 1, 20, false));
    }
}

