/*
 * Decompiled with CFR 0.152.
 */
package util.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.JOptionPane;
import util.image.FileOpen;

public class ImageShrinker {
    public static void main(String[] args) throws Exception {
        File mapFile = new FileOpen("Select The Large Image").getFile();
        if (!mapFile.exists()) {
            throw new IllegalStateException(mapFile + "File does not exist");
        }
        String input = JOptionPane.showInputDialog(null, (Object)"Select scale");
        float scale = Float.parseFloat(input);
        BufferedImage baseImg = ImageIO.read(mapFile);
        int thumbWidth = (int)((float)((Image)baseImg).getWidth(null) * scale);
        int thumbHeight = (int)((float)((Image)baseImg).getHeight(null) * scale);
        BufferedImage thumbImage = new BufferedImage(thumbWidth, thumbHeight, 1);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(baseImg, 0, 0, thumbWidth, thumbHeight, null);
        File file = new File(new File(mapFile.getPath()).getParent() + File.separatorChar + "smallMap.jpeg");
        FileImageOutputStream out = new FileImageOutputStream(file);
        ImageWriter encoder = ImageIO.getImageWritersByFormatName("JPEG").next();
        JPEGImageWriteParam param = new JPEGImageWriteParam(null);
        param.setCompressionMode(2);
        param.setCompressionQuality(1.0f);
        encoder.setOutput(out);
        encoder.write(null, new IIOImage(thumbImage, null, null), param);
        out.close();
        System.out.println("Image successfully written to " + file.getPath());
        System.exit(0);
    }
}

