/*
 * Decompiled with CFR 0.152.
 */
package util.image;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import util.image.FileOpen;
import util.image.FileSave;

public class TileImageBreaker {
    private static final String SMALL_MAPS_LOCATION = new FileSave("Where to save Tile Images?", null).getPathString();
    private static JFrame observer = new JFrame();
    private boolean m_baseMap;

    public static void main(String[] args) throws Exception {
        new TileImageBreaker().createMaps();
    }

    public void createMaps() throws IOException {
        Image map = TileImageBreaker.loadImage();
        if (map == null) {
            System.out.println("You need to select a map image for this to work");
            System.out.println("Shutting down");
            System.exit(0);
            return;
        }
        int x = 0;
        while (x * 256 < map.getWidth(null)) {
            int y = 0;
            while (y * 256 < map.getHeight(null)) {
                Rectangle bounds = new Rectangle(x * 256, y * 256, 256, 256);
                GraphicsConfiguration m_localGraphicSystem = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                BufferedImage relief = m_localGraphicSystem.createCompatibleImage(256, 256, this.m_baseMap ? 2 : 3);
                relief.getGraphics().drawImage(map, 0, 0, 256, 256, bounds.x, bounds.y, bounds.x + 256, bounds.y + 256, observer);
                String outFileName = SMALL_MAPS_LOCATION + File.separator + x + "_" + y + ".png";
                ImageIO.write((RenderedImage)relief, "png", new File(outFileName));
                System.out.println("wrote " + outFileName);
                ++y;
            }
            ++x;
        }
        System.out.println("All Finished!");
        System.exit(0);
    }

    private static Image loadImage() {
        System.out.println("Select the map");
        String mapName = new FileOpen("Select The Map").getPathString();
        if (mapName != null) {
            Image img = Toolkit.getDefaultToolkit().createImage(mapName);
            MediaTracker tracker = new MediaTracker(new Panel());
            tracker.addImage(img, 1);
            try {
                tracker.waitForAll();
                return img;
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                return TileImageBreaker.loadImage();
            }
        }
        return null;
    }
}

